/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.form.FormattedFieldRenderer;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.datatype.DateTimeValue;
import com.xmlmind.xmledit.xsd.datatype.DateValue;
import com.xmlmind.xmledit.xsd.datatype.GDayValue;
import com.xmlmind.xmledit.xsd.datatype.GMonthDayValue;
import com.xmlmind.xmledit.xsd.datatype.GMonthValue;
import com.xmlmind.xmledit.xsd.datatype.GYearMonthValue;
import com.xmlmind.xmledit.xsd.datatype.GYearValue;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.TimeValue;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class DateFieldRenderer
extends FormattedFieldRenderer {
    private static final int DATE_TIME = 0;
    private static final int TIME = 1;
    private static final int DATE = 2;
    private static final int G_DAY = 3;
    private static final int G_MONTH_DAY = 4;
    private static final int G_MONTH = 5;
    private static final int G_YEAR_MONTH = 6;
    private static final int G_YEAR = 7;
    private DateFormat dateFormat = null;
    private boolean localTimeZone = false;
    private int type = -1;
    private int columnCount = -1;

    protected String getDefaultDataType() {
        return "date";
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initialize() {
        this.type = "datetime".equalsIgnoreCase(this.dataType) ? 0 : ("time".equalsIgnoreCase(this.dataType) ? 1 : ("gday".equalsIgnoreCase(this.dataType) ? 3 : ("gmonthday".equalsIgnoreCase(this.dataType) ? 4 : ("gmonth".equalsIgnoreCase(this.dataType) ? 5 : ("gyearmonth".equalsIgnoreCase(this.dataType) ? 6 : ("gyear".equalsIgnoreCase(this.dataType) ? 7 : 2))))));
        if (this.pattern == null) {
            switch (this.type) {
                case 0: {
                    this.dateFormat = DateFormat.getDateTimeInstance(3, 3, this.getLocale());
                    break;
                }
                case 1: {
                    this.dateFormat = DateFormat.getTimeInstance(3, this.getLocale());
                    break;
                }
                case 3: {
                    this.dateFormat = new SimpleDateFormat("dd", this.getLocale());
                    break;
                }
                case 4: {
                    this.dateFormat = new SimpleDateFormat("MM/dd", this.getLocale());
                    break;
                }
                case 5: {
                    this.dateFormat = new SimpleDateFormat("MM", this.getLocale());
                    break;
                }
                case 6: {
                    this.dateFormat = new SimpleDateFormat("yyyy/MM", this.getLocale());
                    break;
                }
                case 7: {
                    this.dateFormat = new SimpleDateFormat("yyyy", this.getLocale());
                    break;
                }
                default: {
                    this.dateFormat = DateFormat.getDateInstance(3, this.getLocale());
                }
            }
            this.localTimeZone = true;
        } else {
            this.dateFormat = new SimpleDateFormat(this.pattern, this.getLocale());
            this.localTimeZone = true;
            boolean bl = false;
            int n = this.pattern.length();
            int n2 = 0;
            block13: while (n2 < n) {
                switch (this.pattern.charAt(n2)) {
                    case '\'': {
                        if (n2 + 1 < n && this.pattern.charAt(n2 + 1) == '\'') {
                            ++n2;
                            break;
                        }
                        bl = !bl;
                        break;
                    }
                    case 'Z': 
                    case 'z': {
                        if (bl) break;
                        this.localTimeZone = false;
                        break block13;
                    }
                }
                ++n2;
            }
        }
        this.dateFormat.setLenient(false);
        if (this.columns == Integer.MAX_VALUE) {
            String string = this.dateFormat.format(new Date());
            this.columnCount = string.length() + 1;
            return;
        }
        this.columnCount = this.columns <= 0 ? 20 : this.columns;
    }

    protected int getColumns() {
        if (this.dateFormat == null) {
            this.initialize();
        }
        return this.columnCount;
    }

    protected String format(String string) {
        if (this.dateFormat == null) {
            this.initialize();
        }
        String string2 = XMLUtil.collapseWhiteSpace(string);
        Date date = null;
        switch (this.type) {
            case 0: {
                try {
                    DateTimeValue dateTimeValue = DateTimeValue.parseDateTime(string2);
                    date = dateTimeValue.toDate();
                }
                catch (InvalidDataException invalidDataException) {}
                break;
            }
            case 1: {
                try {
                    TimeValue timeValue = TimeValue.parseTime(string2);
                    date = timeValue.toDate();
                }
                catch (InvalidDataException invalidDataException) {}
                break;
            }
            case 3: {
                try {
                    GDayValue gDayValue = GDayValue.parseGDay(string2);
                    date = gDayValue.toDate();
                }
                catch (InvalidDataException invalidDataException) {}
                break;
            }
            case 4: {
                try {
                    GMonthDayValue gMonthDayValue = GMonthDayValue.parseGMonthDay(string2);
                    date = gMonthDayValue.toDate();
                }
                catch (InvalidDataException invalidDataException) {}
                break;
            }
            case 5: {
                try {
                    GMonthValue gMonthValue = GMonthValue.parseGMonth(string2);
                    date = gMonthValue.toDate();
                }
                catch (InvalidDataException invalidDataException) {}
                break;
            }
            case 6: {
                try {
                    GYearMonthValue gYearMonthValue = GYearMonthValue.parseGYearMonth(string2);
                    date = gYearMonthValue.toDate();
                }
                catch (InvalidDataException invalidDataException) {}
                break;
            }
            case 7: {
                try {
                    GYearValue gYearValue = GYearValue.parseGYear(string2);
                    date = gYearValue.toDate();
                }
                catch (InvalidDataException invalidDataException) {}
                break;
            }
            default: {
                try {
                    DateValue dateValue = DateValue.parseDate(string2);
                    date = dateValue.toDate();
                }
                catch (InvalidDataException invalidDataException) {}
                break;
            }
        }
        if (date != null) {
            return this.dateFormat.format(date);
        }
        return string;
    }

    protected String parse(String string) {
        if (this.dateFormat == null) {
            this.initialize();
        }
        String string2 = string;
        try {
            Date date = this.dateFormat.parse(string.trim());
            switch (this.type) {
                case 0: {
                    DateTimeValue dateTimeValue = DateTimeValue.fromDate(date, this.localTimeZone);
                    string2 = dateTimeValue.format();
                    break;
                }
                case 1: {
                    TimeValue timeValue = TimeValue.fromDate(date, this.localTimeZone);
                    string2 = timeValue.format();
                    break;
                }
                case 3: {
                    GDayValue gDayValue = GDayValue.fromDate(date, this.localTimeZone);
                    string2 = gDayValue.toString();
                    break;
                }
                case 4: {
                    GMonthDayValue gMonthDayValue = GMonthDayValue.fromDate(date, this.localTimeZone);
                    string2 = gMonthDayValue.toString();
                    break;
                }
                case 5: {
                    GMonthValue gMonthValue = GMonthValue.fromDate(date, this.localTimeZone);
                    string2 = gMonthValue.toString();
                    break;
                }
                case 6: {
                    GYearMonthValue gYearMonthValue = GYearMonthValue.fromDate(date, this.localTimeZone);
                    string2 = gYearMonthValue.toString();
                    break;
                }
                case 7: {
                    GYearValue gYearValue = GYearValue.fromDate(date, this.localTimeZone);
                    string2 = gYearValue.toString();
                    break;
                }
                default: {
                    DateValue dateValue = DateValue.fromDate(date, this.localTimeZone);
                    string2 = dateValue.format();
                    break;
                }
            }
        }
        catch (ParseException parseException) {}
        return string2;
    }
}

