/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.edit.DocumentUtil;
import com.xmlmind.xmledit.form.FormUtil;
import com.xmlmind.xmledit.form.ValueEditorRenderer;
import com.xmlmind.xmledit.form.ValueEditorVP;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.styledgadget.ComponentImageBox;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.xmlutil.Name;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public abstract class EnhancedFieldRenderer
extends ValueEditorRenderer {
    public int columns = -1;
    private JPanel template = null;

    public void setParameters(StyleValue[] styleValueArray, Style style, StyledViewFactory styledViewFactory, Element element, Name name) {
        super.setParameters(styleValueArray, style, styledViewFactory, element, name);
        int n = styleValueArray.length / 2 * 2;
        int n2 = 0;
        while (n2 < n) {
            StyleValue styleValue = styleValueArray[n2];
            if (styleValue.type != 2) {
                return;
            }
            String string = styleValue.string;
            StyleValue styleValue2 = styleValueArray[n2 + 1];
            if ("columns".equals(string)) {
                this.columns = styleValue2.intValue(element, -1);
            }
            n2 += 2;
        }
    }

    public int hashCode() {
        int n = super.hashCode();
        return n ^= this.columns;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof EnhancedFieldRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        EnhancedFieldRenderer enhancedFieldRenderer = (EnhancedFieldRenderer)object;
        return this.columns == enhancedFieldRenderer.columns;
    }

    public Component getTemplate() {
        if (this.template == null) {
            this.template = this.createPanel();
        }
        return this.template;
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        JTextField jTextField = new JTextField(this.columns <= 0 ? 20 : this.columns);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jTextField, gridBagConstraints);
        JButton jButton = new JButton(this.getButtonIcon());
        DialogUtil.setIconic(jButton);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    protected Component doCreateComponent(final ValueEditorVP valueEditorVP) {
        final JPanel jPanel = this.createPanel();
        JTextField jTextField = EnhancedFieldRenderer.getTextField(jPanel);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.needCommit();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.needCommit();
            }

            private void needCommit() {
                if (!Boolean.TRUE.equals(jPanel.getClientProperty("settingValue")) && !EnhancedFieldRenderer.this.isCommitNeeded(valueEditorVP, jPanel)) {
                    EnhancedFieldRenderer.this.setCommitNeeded(valueEditorVP, jPanel, true);
                    DocumentUtil.pendingChanges(valueEditorVP.getView().getModel().getDocument());
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        jPanel.putClientProperty("settingValue", Boolean.FALSE);
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EnhancedFieldRenderer.this.isCommitNeeded(valueEditorVP, jPanel)) {
                    EnhancedFieldRenderer.this.commit(valueEditorVP, jPanel, true);
                }
            }
        });
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (EnhancedFieldRenderer.this.isCommitNeeded(valueEditorVP, jPanel)) {
                    valueEditorVP.autoCommit(focusEvent);
                }
            }
        };
        jTextField.addFocusListener(focusAdapter);
        Keymap keymap = JTextComponent.addKeymap(null, jTextField.getKeymap());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(27, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EnhancedFieldRenderer.this.isCommitNeeded(valueEditorVP, jPanel)) {
                    EnhancedFieldRenderer.this.configure(valueEditorVP, jPanel);
                }
            }
        });
        jTextField.setKeymap(keymap);
        JButton jButton = EnhancedFieldRenderer.getButton(jPanel);
        this.activateButton(valueEditorVP, jPanel, jTextField, jButton);
        jButton.addFocusListener(focusAdapter);
        return jPanel;
    }

    protected static final JTextField getTextField(Component component) {
        return (JTextField)((JPanel)component).getComponent(0);
    }

    protected static final JButton getButton(Component component) {
        return (JButton)((JPanel)component).getComponent(1);
    }

    protected abstract Icon getButtonIcon();

    protected abstract void activateButton(ValueEditorVP var1, JPanel var2, JTextField var3, JButton var4);

    protected boolean setValue(ValueEditorVP valueEditorVP, Component component, String string) {
        JPanel jPanel = (JPanel)component;
        jPanel.putClientProperty("settingValue", Boolean.TRUE);
        EnhancedFieldRenderer.getTextField(component).setText(string == null ? "" : string);
        jPanel.putClientProperty("settingValue", Boolean.FALSE);
        return string != null;
    }

    protected String getValue(ValueEditorVP valueEditorVP, Component component) {
        return EnhancedFieldRenderer.getTextField(component).getText();
    }

    protected void showError(ValueEditorVP valueEditorVP, Component component) {
        JTextField jTextField = EnhancedFieldRenderer.getTextField(component);
        jTextField.getToolkit().beep();
        jTextField.selectAll();
        jTextField.requestFocus();
    }

    protected void setFont(ValueEditorVP valueEditorVP, Component component, Font font) {
        EnhancedFieldRenderer.getTextField(component).setFont(font);
    }

    protected void setForeground(ValueEditorVP valueEditorVP, Component component, Color color) {
        EnhancedFieldRenderer.getTextField(component).setForeground(color);
    }

    protected void setBackground(ValueEditorVP valueEditorVP, Component component, Color color) {
        EnhancedFieldRenderer.getTextField(component).setBackground(color);
    }

    protected void setOpaque(ValueEditorVP valueEditorVP, Component component, boolean bl) {
        EnhancedFieldRenderer.getTextField(component).setOpaque(bl);
    }

    public int getFirstBaseLine(ComponentImageBox componentImageBox) {
        return FormUtil.getBaseLine((ValueEditorVP)componentImageBox);
    }

    public int getLastBaseLine(ComponentImageBox componentImageBox) {
        return this.getFirstBaseLine(componentImageBox);
    }
}

