/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.form.EnhancedFieldRenderer;
import com.xmlmind.xmledit.form.Msg;
import com.xmlmind.xmledit.form.ValueEditorVP;
import com.xmlmind.xmledit.guiutil.BrowseButton;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.xmlutil.Name;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class FileNameFieldRenderer
extends EnhancedFieldRenderer {
    private boolean absoluteMode = false;
    private boolean directoryMode = false;
    private boolean saveMode = false;
    private boolean urlMode = true;
    private static ImageIcon icon = null;
    private static URL[] lastSelectedURL = new URL[1];

    public void setParameters(StyleValue[] styleValueArray, Style style, StyledViewFactory styledViewFactory, Element element, Name name) {
        super.setParameters(styleValueArray, style, styledViewFactory, element, name);
        int n = styleValueArray.length / 2 * 2;
        int n2 = 0;
        while (n2 < n) {
            StyleValue styleValue = styleValueArray[n2];
            if (styleValue.type != 2) {
                return;
            }
            String string = styleValue.string;
            StyleValue styleValue2 = styleValueArray[n2 + 1];
            if ("absolute".equals(string)) {
                this.absoluteMode = styleValue2.booleanValue(element, false);
            } else if ("directory".equals(string)) {
                this.directoryMode = styleValue2.booleanValue(element, false);
            } else if ("save".equals(string)) {
                this.saveMode = styleValue2.booleanValue(element, false);
            } else if ("url".equals(string)) {
                this.urlMode = styleValue2.booleanValue(element, false);
            }
            n2 += 2;
        }
    }

    public int hashCode() {
        int n = super.hashCode();
        n ^= this.absoluteMode ? 1 : 0;
        n ^= this.directoryMode ? 1 : 0;
        n ^= this.saveMode ? 1 : 0;
        return n ^= this.urlMode ? 1 : 0;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FileNameFieldRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        FileNameFieldRenderer fileNameFieldRenderer = (FileNameFieldRenderer)object;
        return this.absoluteMode == fileNameFieldRenderer.absoluteMode && this.directoryMode == fileNameFieldRenderer.directoryMode && this.saveMode == fileNameFieldRenderer.saveMode && this.urlMode == fileNameFieldRenderer.urlMode;
    }

    protected Icon getButtonIcon() {
        if (icon == null) {
            icon = new ImageIcon(ImageResource.get(this.getClass(), "browse.gif"));
        }
        return icon;
    }

    protected void activateButton(final ValueEditorVP valueEditorVP, final JPanel jPanel, final JTextField jTextField, JButton jButton) {
        jButton.setToolTipText(Msg.msg("browseToolTip"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = FileNameFieldRenderer.this.selectFile(valueEditorVP);
                if (string != null) {
                    jTextField.setText(string);
                    FileNameFieldRenderer.this.commit(valueEditorVP, jPanel, true);
                }
            }
        });
    }

    private String selectFile(ValueEditorVP valueEditorVP) {
        URL uRL = valueEditorVP.getElementView().getElement().getLocation();
        return BrowseButton.selectFile(valueEditorVP.getPanel(), this.absoluteMode, this.directoryMode, this.saveMode, this.urlMode, uRL, lastSelectedURL);
    }
}

