/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.doctype.ListDataType;
import com.xmlmind.xmledit.form.ListItem;
import com.xmlmind.xmledit.form.ValueEditorVP;
import com.xmlmind.xmledit.styledgadget.Icon;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.styledview.StyledViewFactoryUtil;
import com.xmlmind.xmledit.styledview.ViewParameters;
import com.xmlmind.xmledit.stylesheet.StyleSpec;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;

public class FormUtil {
    public static final Style valueListToStyle(StyledViewFactory styledViewFactory, StyleValue[] styleValueArray, Style style, Element element) {
        if (styleValueArray.length <= 1) {
            return null;
        }
        StyleSpec styleSpec = StyledViewFactoryUtil.valueListToStyleSpec(styleValueArray, 0);
        if (styleSpec == null) {
            return null;
        }
        Style style2 = style.copy();
        ViewParameters viewParameters = new ViewParameters();
        styledViewFactory.specToStyle(styleSpec, style, element, style2, viewParameters);
        return style2;
    }

    public static final int getBaseLine(ValueEditorVP valueEditorVP) {
        Font font = valueEditorVP.getStyle().font;
        FontMetrics fontMetrics = valueEditorVP.getFontMetrics(font);
        int n = fontMetrics.getAscent();
        int n2 = n + fontMetrics.getDescent();
        if (valueEditorVP.height < n2) {
            return -1;
        }
        return (valueEditorVP.height - n2) / 2 + n;
    }

    public static final int getBaseLine(ValueEditorVP valueEditorVP, int n, boolean bl) {
        if (n <= 0) {
            return -1;
        }
        int n2 = valueEditorVP.height / n;
        Font font = valueEditorVP.getStyle().font;
        FontMetrics fontMetrics = valueEditorVP.getFontMetrics(font);
        int n3 = fontMetrics.getAscent();
        int n4 = n3 + fontMetrics.getDescent();
        if (n2 < n4) {
            return -1;
        }
        int n5 = (n2 - n4) / 2 + n3;
        if (bl) {
            n5 += (n - 1) * n2;
        }
        return n5;
    }

    public static final ListItem[] parametersToItems(StyleValue[] styleValueArray, Style style, StyledViewFactory styledViewFactory, Element element, Name name) {
        Data[] dataArray;
        Object object;
        String[] stringArray = null;
        String[] stringArray2 = null;
        int n = styleValueArray.length / 2 * 2;
        int n2 = 0;
        while (n2 < n) {
            object = styleValueArray[n2];
            if (object != null) {
                if (object.type != 2) {
                    return null;
                }
                dataArray = object.string;
                StyleValue styleValue = styleValueArray[n2 + 1];
                if ("labels".equals(dataArray)) {
                    stringArray = FormUtil.parseList(styleValue, element);
                } else if ("values".equals(dataArray)) {
                    stringArray2 = FormUtil.parseList(styleValue, element);
                }
            }
            n2 += 2;
        }
        if (stringArray2 == null && (object = DocumentTypeUtil.getDataType(element, name)) != null) {
            if (object instanceof ListDataType) {
                object = ((ListDataType)object).getItemDataType();
            }
            if ((dataArray = object.getEnumeratedValues()) != null) {
                stringArray2 = new String[dataArray.length];
                int n3 = 0;
                while (n3 < dataArray.length) {
                    stringArray2[n3] = dataArray[n3].formatData(element);
                    ++n3;
                }
            }
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            return null;
        }
        object = new ListItem[stringArray2.length];
        if (stringArray != null && stringArray.length != stringArray2.length) {
            stringArray = null;
        }
        if (stringArray != null) {
            int n4 = 0;
            while (n4 < stringArray2.length) {
                object[n4] = new ListItem(stringArray[n4], stringArray2[n4]);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < stringArray2.length) {
                object[n5] = new ListItem(stringArray2[n5]);
                ++n5;
            }
        }
        return object;
    }

    private static final String[] parseList(StyleValue styleValue, Element element) {
        String string = styleValue.stringValue(element);
        if (string != null) {
            return StringUtil.split(string, '\n');
        }
        return null;
    }

    public static final URL styleValueToURL(StyleValue styleValue, Element element) {
        URL uRL = null;
        switch (styleValue.type) {
            case 22: {
                try {
                    uRL = new URL(styleValue.string);
                }
                catch (MalformedURLException malformedURLException) {}
                break;
            }
            default: {
                String string = styleValue.stringValue(element);
                if (string == null) break;
                URL uRL2 = element == null ? null : element.getLocation();
                try {
                    uRL = new URL(uRL2, string);
                }
                catch (MalformedURLException malformedURLException) {}
                break;
            }
        }
        return uRL;
    }

    public static final Image styleValueToImage(StyleValue styleValue, Element element, Style style) {
        Image image;
        block13: {
            image = null;
            URL uRL = null;
            switch (styleValue.type) {
                case 22: {
                    try {
                        uRL = new URL(styleValue.string);
                    }
                    catch (MalformedURLException malformedURLException) {}
                    break;
                }
                case 95: {
                    image = Icon.get(1, style.color, style.backgroundColor);
                    break;
                }
                case 96: {
                    image = Icon.get(2, style.color, style.backgroundColor);
                    break;
                }
                case 97: {
                    image = Icon.get(3, style.color, style.backgroundColor);
                    break;
                }
                case 28: {
                    String string;
                    if (!"icon".equals(styleValue.string) || styleValue.list.length != 1 || (string = styleValue.list[0].stringValue(element)) == null) break;
                    image = Icon.get(string, style.color, style.backgroundColor);
                    break;
                }
                default: {
                    String string = styleValue.stringValue(element);
                    if (string == null) break;
                    URL uRL2 = element == null ? null : element.getLocation();
                    try {
                        uRL = new URL(uRL2, string);
                    }
                    catch (MalformedURLException malformedURLException) {}
                    break;
                }
            }
            if (image != null || uRL == null) break block13;
            try {
                image = StyledViewFactoryUtil.fetchImage(uRL);
            }
            catch (Exception exception) {}
        }
        return image;
    }

    public static final int styleValueToPixels(StyleValue styleValue, Element element, StyledViewFactory styledViewFactory, Style style, int n) {
        int n2 = -1;
        double d = 0.0;
        switch (styleValue.type) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = styleValue.type;
                d = styleValue.number;
                break;
            }
            case 0: {
                n2 = 5;
                d = styleValue.number;
                break;
            }
            default: {
                String string = styleValue.stringValue(element);
                if (string == null) break;
                string = string.trim();
                int n3 = 2;
                if (string.endsWith("px")) {
                    n2 = 5;
                } else if (string.endsWith("in")) {
                    n2 = 6;
                } else if (string.endsWith("cm")) {
                    n2 = 7;
                } else if (string.endsWith("mm")) {
                    n2 = 8;
                } else if (string.endsWith("pt")) {
                    n2 = 9;
                } else if (string.endsWith("pc")) {
                    n2 = 10;
                } else if (string.endsWith("em")) {
                    n2 = 11;
                } else if (string.endsWith("ex")) {
                    n2 = 12;
                } else {
                    n2 = 5;
                    n3 = 0;
                }
                if (n3 > 0) {
                    string = string.substring(0, string.length() - n3);
                }
                try {
                    d = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = -1;
                }
                break;
            }
        }
        if (n2 == -1) {
            return n;
        }
        return FormUtil.lengthToPixels(n2, d, styledViewFactory, style);
    }

    public static final int lengthToPixels(int n, double d, StyledViewFactory styledViewFactory, Style style) {
        double d2;
        switch (n) {
            case 6: {
                d2 = d * styledViewFactory.getScreenResolution();
                break;
            }
            case 7: {
                d2 = d / 2.54 * styledViewFactory.getScreenResolution();
                break;
            }
            case 8: {
                d2 = d / 25.4 * styledViewFactory.getScreenResolution();
                break;
            }
            case 9: {
                d2 = d / 72.0 * styledViewFactory.getScreenResolution();
                break;
            }
            case 10: {
                d2 = d / 6.0 * styledViewFactory.getScreenResolution();
                break;
            }
            case 11: {
                FontMetrics fontMetrics = styledViewFactory.getDocumentView().getFontMetrics(style.font);
                d2 = d * (double)fontMetrics.getHeight();
                break;
            }
            case 12: {
                FontMetrics fontMetrics = styledViewFactory.getDocumentView().getFontMetrics(style.font);
                d2 = d * (double)fontMetrics.getAscent() / 2.0;
                break;
            }
            default: {
                d2 = d;
            }
        }
        return (int)Math.rint(d2);
    }
}

