/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.form.TextFieldRenderer;
import com.xmlmind.xmledit.form.ValueEditorVP;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import java.awt.Component;
import java.util.Locale;
import javax.swing.JTextField;

public abstract class FormattedFieldRenderer
extends TextFieldRenderer {
    public String pattern = null;
    public String language = null;
    public String country = null;
    public String variant = null;
    public String dataType = null;
    protected static final int AUTO = Integer.MAX_VALUE;

    public FormattedFieldRenderer() {
        this.columns = Integer.MAX_VALUE;
    }

    public void setParameters(StyleValue[] styleValueArray, Style style, StyledViewFactory styledViewFactory, Element element, Name name) {
        super.setParameters(styleValueArray, style, styledViewFactory, element, name);
        int n = styleValueArray.length / 2 * 2;
        int n2 = 0;
        while (n2 < n) {
            StyleValue styleValue = styleValueArray[n2];
            if (styleValue.type != 2) {
                return;
            }
            String string = styleValue.string;
            StyleValue styleValue2 = styleValueArray[n2 + 1];
            if ("pattern".equals(string)) {
                this.pattern = styleValue2.stringValue(element);
            } else if ("language".equals(string)) {
                this.language = styleValue2.stringValue(element);
            } else if ("country".equals(string)) {
                this.country = styleValue2.stringValue(element);
            } else if ("variant".equals(string)) {
                this.variant = styleValue2.stringValue(element);
            } else if ("data-type".equals(string)) {
                this.dataType = styleValue2.stringValue(element);
            }
            n2 += 2;
        }
        if (this.dataType == null) {
            this.dataType = this.getDefaultDataType();
        }
    }

    protected abstract String getDefaultDataType();

    public int hashCode() {
        int n = super.hashCode();
        if (this.pattern != null) {
            n ^= this.pattern.hashCode();
        }
        if (this.language != null) {
            n ^= this.language.hashCode();
        }
        if (this.country != null) {
            n ^= this.country.hashCode();
        }
        if (this.variant != null) {
            n ^= this.variant.hashCode();
        }
        if (this.dataType != null) {
            n ^= this.dataType.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FormattedFieldRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        FormattedFieldRenderer formattedFieldRenderer = (FormattedFieldRenderer)object;
        return MiscUtil.eq(this.pattern, formattedFieldRenderer.pattern) && MiscUtil.eq(this.language, formattedFieldRenderer.language) && MiscUtil.eq(this.country, formattedFieldRenderer.country) && MiscUtil.eq(this.variant, formattedFieldRenderer.variant) && MiscUtil.eq(this.dataType, formattedFieldRenderer.dataType);
    }

    protected boolean setValue(ValueEditorVP valueEditorVP, Component component, String string) {
        JTextField jTextField = (JTextField)component;
        jTextField.putClientProperty("settingValue", Boolean.TRUE);
        if (string == null) {
            string = "";
        }
        jTextField.setText(this.format(string));
        jTextField.putClientProperty("settingValue", Boolean.FALSE);
        return string != null;
    }

    protected String getValue(ValueEditorVP valueEditorVP, Component component) {
        JTextField jTextField = (JTextField)component;
        return this.parse(jTextField.getText());
    }

    protected abstract String format(String var1);

    protected abstract String parse(String var1);

    protected int getColumns() {
        return this.columns <= 0 || this.columns == Integer.MAX_VALUE ? 20 : this.columns;
    }

    protected Locale getLocale() {
        Locale locale = this.language != null ? (this.country != null ? (this.variant != null ? new Locale(this.language, this.country, this.variant) : new Locale(this.language, this.country)) : new Locale(this.language)) : Locale.getDefault();
        return locale;
    }
}

