/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.form.ImageDataTypes;
import com.xmlmind.xmledit.form.Msg;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkits;
import com.xmlmind.xmledit.styledgadget.AbstractImageViewport;
import com.xmlmind.xmledit.styledgadget.Icon;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledElementView;
import com.xmlmind.xmledit.styledview.StyledElementViewPart;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmledit.view.ElementView;
import com.xmlmind.xmledit.view.NodeView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.datatype.AnyURIType;
import com.xmlmind.xmledit.xsd.datatype.Base16;
import com.xmlmind.xmledit.xsd.datatype.Base64;
import com.xmlmind.xmledit.xsd.datatype.Base64BinaryType;
import com.xmlmind.xmledit.xsd.datatype.HexBinaryType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

public class ImageViewportVP
extends AbstractImageViewport
implements ImageDataTypes,
StyledElementViewPart {
    protected StyledElementView view;
    protected byte role;
    protected URL source = null;
    protected Name attributeName = null;
    protected int dataType = 0;
    protected Image fallbackImage = null;
    protected static final int FLAG_GZIP = 8;
    protected static final int FLAG_FALLBACK_IMAGE = 16;

    public ImageViewportVP(Style style, StyledElementView styledElementView, int n) {
        super(style);
        this.view = styledElementView;
        this.role = (byte)n;
    }

    public NodeView getView() {
        return this.view;
    }

    public ElementView getElementView() {
        return this.view;
    }

    public StyledElementView getStyledElementView() {
        return this.view;
    }

    public int getRole() {
        return this.role;
    }

    public void detachingViewFromModel(Document document, int n) {
    }

    public void setImageSource(URL uRL) {
        this.source = uRL;
    }

    public URL getImageSource() {
        return this.source;
    }

    public void setEditedAttribute(Name name) {
        this.attributeName = name;
    }

    public Name getEditedAttribute() {
        return this.attributeName;
    }

    public void setDataType(int n) {
        this.dataType = n;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setGzip(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 8) : (byte)(this.flags & 0xFFFFFFF7);
    }

    public boolean isGzip() {
        return (this.flags & 8) != 0;
    }

    public void setFallbackImage(Image image) {
        this.flags = image == null ? (byte)(this.flags & 0xFFFFFFEF) : (byte)(this.flags | 0x10);
        this.fallbackImage = image;
    }

    public Image getFallbackImage() {
        return (this.flags & 0x10) != 0 ? this.fallbackImage : null;
    }

    protected boolean isInline() {
        return this.view.isInlineView();
    }

    protected Image renderImage(double d, int n, double d2, int n2, boolean bl, boolean bl2) throws Exception {
        Image image = null;
        String string = null;
        try {
            image = this.doRenderImage(d, n, d2, n2, bl, bl2);
        }
        catch (Throwable throwable) {
            string = MiscUtil.reason(throwable);
        }
        if (image == null) {
            this.setDynamicFallbackImage(string);
        } else {
            this.unsetDynamicFallbackImage();
        }
        return image;
    }

    private Image doRenderImage(double d, int n, double d2, int n2, boolean bl, boolean bl2) throws Exception {
        if (this.source != null) {
            return ImageToolkits.createImage(this.source, d, n, d2, n2, bl, bl2, -1.0);
        }
        Element element = this.view.getElement();
        switch (this.dataType()) {
            case 1: {
                String string;
                URL uRL = null;
                String string2 = string = this.attributeName != null ? element.getAttribute(this.attributeName) : element.getText();
                if (string != null) {
                    string = string.trim();
                    try {
                        uRL = new URL(element.getLocation(), string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new RuntimeException(Msg.msg("IV.notAnURL", string));
                    }
                }
                if (uRL == null) break;
                return ImageToolkits.createImage(uRL, d, n, d2, n2, bl, bl2, -1.0);
            }
            case 2: 
            case 3: {
                String string;
                byte[] byArray = null;
                String string3 = string = this.attributeName != null ? element.getAttribute(this.attributeName) : element.getText();
                if (string != null) {
                    try {
                        byArray = this.dataType == 3 ? Base64.decode(string) : Base16.decode(string);
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw new RuntimeException(Msg.msg("IV.cannotDecode", MiscUtil.reason(invalidDataException)));
                    }
                    if (FileUtil.isGzipped(byArray)) {
                        try {
                            byArray = ImageViewportVP.unzipBytes(byArray);
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(Msg.msg("IV.cannotUngzip", MiscUtil.reason(iOException)));
                        }
                    }
                }
                if (byArray == null) break;
                return ImageToolkits.createImage(byArray, element.getLocation(), d, n, d2, n2, bl, bl2, -1.0);
            }
            case 4: {
                if (this.attributeName != null) {
                    throw new RuntimeException(Msg.msg("IV.inconsistentSpec"));
                }
                return ImageToolkits.createImage(element, d, n, d2, n2, bl, bl2, -1.0);
            }
            default: {
                throw new RuntimeException(Msg.msg("IV.noDataType"));
            }
        }
        return null;
    }

    protected int dataType() {
        if (this.dataType < 1 || this.dataType > 4) {
            this.dataType = ImageViewportVP.checkImageDataType(this.dataType, this.view.getElement(), this.attributeName);
        }
        return this.dataType;
    }

    public static final int checkImageDataType(int n, Element element, Name name) {
        if (n < 1 || n > 4) {
            DataType dataType = DocumentTypeUtil.getDataType(element, name);
            if (dataType != null) {
                if (dataType instanceof AnyURIType) {
                    n = 1;
                } else if (dataType instanceof Base64BinaryType) {
                    n = 3;
                } else if (dataType instanceof HexBinaryType) {
                    n = 2;
                }
            } else if (name == null) {
                n = 4;
            }
        }
        return n;
    }

    private static final byte[] unzipBytes(byte[] byArray) throws IOException {
        GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy(gZIPInputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void setDynamicFallbackImage(String string) {
        if ((this.flags & 0x10) != 0) {
            return;
        }
        if (string == null) {
            Object object;
            String string2 = null;
            if (this.source != null) {
                string2 = URLPathUtil.extension(this.source.toExternalForm());
            } else {
                object = this.view.getElement();
                switch (this.dataType) {
                    case 1: {
                        String string3;
                        String string4 = string3 = this.attributeName != null ? ((Element)object).getAttribute(this.attributeName) : ((Element)object).getText();
                        if (string3 == null) break;
                        string2 = URLPathUtil.extension(string3.trim());
                        break;
                    }
                    case 4: {
                        if (!((Element)object).getLocalName().endsWith("svg")) break;
                        string2 = "svg";
                    }
                }
            }
            string2 = string2 == null || string2.length() == 0 ? Msg.msg("IV.unknownFormat") : string2.toUpperCase();
            object = Icon.get("image");
            int n = ((Image)object).getWidth(null);
            int n2 = ((Image)object).getHeight(null);
            Font font = new Font("SansSerif", 3, 12);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n3 = fontMetrics.stringWidth(string2);
            int n4 = n / 2 + n3;
            int n5 = Math.max(n2, n2 / 8 + fontMetrics.getAscent() + fontMetrics.getDescent());
            this.fallbackImage = new BufferedImage(n4, n5, 2);
            Graphics2D graphics2D = (Graphics2D)this.fallbackImage.getGraphics();
            graphics2D.drawImage((Image)object, 0, n5 - n2, null);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setFont(font);
            graphics2D.setColor(Color.blue);
            graphics2D.drawString(string2, n4 - n3, n5 - n2 / 8 - fontMetrics.getDescent());
            graphics2D.dispose();
        } else {
            int n;
            Image image = Icon.get("no-image");
            int n6 = image.getWidth(null);
            int n7 = image.getHeight(null);
            Font font = new Font("SansSerif", 0, 10);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            String[] stringArray = ImageViewportVP.wordWrap(Msg.msg("IV.cannotRender", string), 40);
            int n8 = 0;
            int n9 = 0;
            while (n9 < stringArray.length) {
                n = fontMetrics.stringWidth(stringArray[n9]);
                if (n > n8) {
                    n8 = n;
                }
                ++n9;
            }
            n8 = n6 + 5 + n8;
            n = Math.max(n7, stringArray.length * fontMetrics.getHeight());
            this.fallbackImage = new BufferedImage(n8, n, 2);
            Graphics2D graphics2D = (Graphics2D)this.fallbackImage.getGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setFont(font);
            graphics2D.setColor(Color.red);
            int n10 = n6 + 5;
            int n11 = fontMetrics.getHeight();
            int n12 = n11 - fontMetrics.getDescent();
            int n13 = 0;
            while (n13 < stringArray.length) {
                graphics2D.drawString(stringArray[n13], n10, n12);
                n12 += n11;
                ++n13;
            }
            graphics2D.dispose();
        }
    }

    private static final String[] wordWrap(String string, int n) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = StringUtil.split(string, '\n');
        int n2 = 0;
        while (n2 < stringArray.length) {
            object = stringArray[n2];
            if (((String)(object = ((String)object).trim())).length() == 0) {
                arrayList.add("");
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                StringTokenizer stringTokenizer = new StringTokenizer((String)object);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    int n3 = stringBuffer.length();
                    if (n3 > 0 && n3 + string2.length() > n) {
                        arrayList.add(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        n3 = 0;
                    }
                    if (n3 > 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(string2);
                }
                if (stringBuffer.length() > 0) {
                    arrayList.add(stringBuffer.toString());
                }
            }
            ++n2;
        }
        object = new String[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    private void unsetDynamicFallbackImage() {
        if ((this.flags & 0x10) != 0) {
            return;
        }
        this.fallbackImage = null;
    }

    protected Image fallbackImage() {
        return this.fallbackImage;
    }
}

