/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.form.FormUtil;
import com.xmlmind.xmledit.form.ListItem;
import com.xmlmind.xmledit.form.ValueEditorRenderer;
import com.xmlmind.xmledit.form.ValueEditorVP;
import com.xmlmind.xmledit.styledgadget.ComponentImageBox;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class ListRenderer
extends ValueEditorRenderer {
    public ListItem[] items = new ListItem[0];
    public int rows = -1;
    public boolean multiple = false;
    public char separator = '\u0000';
    private JList template = null;
    private JScrollPane templateScroller = null;
    private static final int MAX_WIDTH = 60;

    public void setParameters(StyleValue[] styleValueArray, Style style, StyledViewFactory styledViewFactory, Element element, Name name) {
        super.setParameters(styleValueArray, style, styledViewFactory, element, name);
        this.items = FormUtil.parametersToItems(styleValueArray, style, styledViewFactory, element, name);
        if (this.items == null) {
            this.items = new ListItem[0];
        }
        int n = styleValueArray.length / 2 * 2;
        int n2 = 0;
        while (n2 < n) {
            String string;
            StyleValue styleValue = styleValueArray[n2];
            if (styleValue.type != 2) {
                return;
            }
            String string2 = styleValue.string;
            StyleValue styleValue2 = styleValueArray[n2 + 1];
            if ("rows".equals(string2)) {
                this.rows = styleValue2.intValue(element, -1);
            } else if ("selection".equals(string2)) {
                this.multiple = "multiple".equals(styleValue2.stringValue(element));
            } else if ("separator".equals(string2) && (string = styleValue2.stringValue(element)) != null && string.length() > 0) {
                this.separator = string.charAt(0);
            }
            n2 += 2;
        }
    }

    public int hashCode() {
        int n = super.hashCode();
        int n2 = 0;
        while (n2 < this.items.length) {
            n ^= this.items[n2].hashCode();
            ++n2;
        }
        n ^= this.rows;
        n ^= this.multiple ? 1 : 0;
        return n ^= this.separator;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ListRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ListRenderer listRenderer = (ListRenderer)object;
        if (this.rows != listRenderer.rows || this.multiple != listRenderer.multiple || this.separator != listRenderer.separator || this.items.length != listRenderer.items.length) {
            return false;
        }
        int n = 0;
        while (n < this.items.length) {
            if (!this.items[n].equals(listRenderer.items[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Component getTemplate() {
        if (this.template == null) {
            this.template = this.createList();
            this.templateScroller = new JScrollPane(this.template);
            this.configureScroller(this.templateScroller, this.template);
        }
        return this.templateScroller;
    }

    private JList createList() {
        CharSequence charSequence;
        JList<ListItem> jList = new JList<ListItem>(this.items);
        jList.setSelectionMode(this.multiple ? 2 : 0);
        int n = 5;
        int n2 = 0;
        while (n2 < this.items.length) {
            charSequence = this.items[n2].toString();
            int n3 = ((String)charSequence).length();
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        if (++n > 60) {
            n = 60;
        }
        charSequence = new StringBuffer();
        while (n > 0) {
            ((StringBuffer)charSequence).append('x');
            --n;
        }
        jList.setPrototypeCellValue((ListItem)((Object)((StringBuffer)charSequence).toString()));
        jList.setVisibleRowCount(this.getVisibleRowCount());
        return jList;
    }

    private int getVisibleRowCount() {
        int n = this.rows;
        if (this.rows <= 0) {
            n = this.items.length == 0 ? 3 : (this.items.length > 10 ? 10 : this.items.length);
        }
        return n;
    }

    private void configureScroller(JScrollPane jScrollPane, JList jList) {
        JScrollBar jScrollBar;
        if (((String)jList.getPrototypeCellValue()).length() < 60) {
            jScrollPane.setHorizontalScrollBarPolicy(31);
        } else {
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollBar = jScrollPane.getHorizontalScrollBar();
            jScrollBar.setFocusable(false);
        }
        if (this.items.length <= jList.getVisibleRowCount()) {
            jScrollPane.setVerticalScrollBarPolicy(21);
        } else {
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollBar = jScrollPane.getVerticalScrollBar();
            jScrollBar.setFocusable(false);
        }
    }

    protected Component doCreateComponent(final ValueEditorVP valueEditorVP) {
        final JList jList = this.createList();
        final JScrollPane jScrollPane = new JScrollPane(jList);
        this.configureScroller(jScrollPane, jList);
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!(Boolean.TRUE.equals(jScrollPane.getClientProperty("settingValue")) || listSelectionEvent.getValueIsAdjusting() || !ListRenderer.this.multiple && jList.getSelectedValue() == null)) {
                    ListRenderer.this.setCommitNeeded(valueEditorVP, jScrollPane, true);
                    ListRenderer.this.commit(valueEditorVP, jScrollPane, true);
                }
            }
        });
        jScrollPane.putClientProperty("settingValue", Boolean.FALSE);
        return jScrollPane;
    }

    protected boolean setValue(ValueEditorVP valueEditorVP, Component component, String string) {
        JScrollPane jScrollPane = (JScrollPane)component;
        JList jList = (JList)jScrollPane.getViewport().getView();
        boolean bl = false;
        if (this.items.length > 0) {
            jScrollPane.putClientProperty("settingValue", Boolean.TRUE);
            if (string == null) {
                jList.clearSelection();
                jList.ensureIndexIsVisible(0);
            } else if (this.multiple) {
                String[] stringArray = this.separator == '\u0000' ? XMLUtil.splitList(string) : StringUtil.split(string, this.separator);
                int[] nArray = new int[stringArray.length];
                int n = 0;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string2 = stringArray[n2];
                    int n3 = 0;
                    while (n3 < this.items.length) {
                        if (string2.equals(this.items[n3].getValue())) {
                            boolean bl2 = true;
                            int n4 = 0;
                            while (n4 < n) {
                                if (nArray[n4] == n3) {
                                    bl2 = false;
                                    break;
                                }
                                ++n4;
                            }
                            if (!bl2) break;
                            nArray[n++] = n3;
                            break;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                jList.clearSelection();
                boolean bl3 = bl = n == stringArray.length;
                if (bl && n > 0) {
                    jList.setSelectedIndices(nArray);
                    jList.ensureIndexIsVisible(nArray[n - 1]);
                } else {
                    jList.ensureIndexIsVisible(0);
                }
            } else {
                int n = -1;
                int n5 = 0;
                while (n5 < this.items.length) {
                    if (string.equals(this.items[n5].getValue())) {
                        n = n5;
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                if (n < 0) {
                    jList.clearSelection();
                    jList.ensureIndexIsVisible(0);
                } else {
                    jList.setSelectedIndex(n);
                    jList.ensureIndexIsVisible(n);
                }
            }
            jScrollPane.putClientProperty("settingValue", Boolean.FALSE);
        }
        return bl;
    }

    protected String getValue(ValueEditorVP valueEditorVP, Component component) {
        JList jList = (JList)((JScrollPane)component).getViewport().getView();
        if (this.multiple) {
            Object[] objectArray = jList.getSelectedValues();
            char c = this.separator == '\u0000' ? (char)' ' : (char)this.separator;
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < objectArray.length) {
                ListItem listItem = (ListItem)objectArray[n];
                if (n > 0) {
                    stringBuffer.append(c);
                }
                stringBuffer.append(listItem.getValue());
                ++n;
            }
            return stringBuffer.toString();
        }
        ListItem listItem = (ListItem)jList.getSelectedValue();
        return listItem == null ? null : listItem.getValue();
    }

    protected void showError(ValueEditorVP valueEditorVP, Component component) {
        JList jList = (JList)((JScrollPane)component).getViewport().getView();
        jList.getToolkit().beep();
        jList.requestFocus();
        this.configure(valueEditorVP, component);
    }

    protected void setFont(ValueEditorVP valueEditorVP, Component component, Font font) {
        JList jList = (JList)((JScrollPane)component).getViewport().getView();
        jList.setFont(font);
    }

    protected void setForeground(ValueEditorVP valueEditorVP, Component component, Color color) {
        JList jList = (JList)((JScrollPane)component).getViewport().getView();
        jList.setForeground(color);
    }

    protected void setBackground(ValueEditorVP valueEditorVP, Component component, Color color) {
        JList jList = (JList)((JScrollPane)component).getViewport().getView();
        jList.setBackground(color);
    }

    public int getFirstBaseLine(ComponentImageBox componentImageBox) {
        return FormUtil.getBaseLine((ValueEditorVP)componentImageBox, this.getVisibleRowCount(), false);
    }

    public int getLastBaseLine(ComponentImageBox componentImageBox) {
        return FormUtil.getBaseLine((ValueEditorVP)componentImageBox, this.getVisibleRowCount(), true);
    }
}

