/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.form.FormattedFieldRenderer;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.datatype.ByteValue;
import com.xmlmind.xmledit.xsd.datatype.DoubleValue;
import com.xmlmind.xmledit.xsd.datatype.FloatValue;
import com.xmlmind.xmledit.xsd.datatype.IntValue;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.LongValue;
import com.xmlmind.xmledit.xsd.datatype.ShortValue;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;

public final class NumberFieldRenderer
extends FormattedFieldRenderer {
    private static final int BYTE = 0;
    private static final int SHORT = 1;
    private static final int INT = 2;
    private static final int LONG = 3;
    private static final int FLOAT = 4;
    private static final int DOUBLE = 5;
    private NumberFormat numberFormat = null;
    private int type = -1;
    private int columnCount = -1;

    protected String getDefaultDataType() {
        return "double";
    }

    private void initialize() {
        this.type = "byte".equalsIgnoreCase(this.dataType) ? 0 : ("short".equalsIgnoreCase(this.dataType) ? 1 : ("int".equalsIgnoreCase(this.dataType) ? 2 : ("long".equalsIgnoreCase(this.dataType) ? 3 : ("float".equalsIgnoreCase(this.dataType) ? 4 : 5))));
        if (this.pattern == null) {
            switch (this.type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.numberFormat = NumberFormat.getIntegerInstance(this.getLocale());
                    break;
                }
                default: {
                    this.numberFormat = NumberFormat.getNumberInstance(this.getLocale());
                    break;
                }
            }
        } else {
            this.numberFormat = new DecimalFormat(this.pattern, new DecimalFormatSymbols(this.getLocale()));
        }
        this.numberFormat.setParseIntegerOnly(this.type >= 0 && this.type <= 3);
        if (this.columns == Integer.MAX_VALUE) {
            int n;
            int n2;
            switch (this.type) {
                case 0: {
                    n2 = 5;
                    n = this.numberFormat.format(0L).length();
                    break;
                }
                case 1: {
                    n2 = 8;
                    n = this.numberFormat.format(0L).length();
                    break;
                }
                case 2: {
                    n2 = 12;
                    n = this.numberFormat.format(0L).length();
                    break;
                }
                case 3: {
                    n2 = 20;
                    n = this.numberFormat.format(0L).length();
                    break;
                }
                default: {
                    n2 = 20;
                    n = this.numberFormat.format(0.0).length();
                }
            }
            this.columnCount = Math.max(n2, n);
        } else {
            this.columnCount = this.columns <= 0 ? 20 : this.columns;
        }
    }

    protected int getColumns() {
        if (this.numberFormat == null) {
            this.initialize();
        }
        return this.columnCount;
    }

    protected String format(String string) {
        if (this.numberFormat == null) {
            this.initialize();
        }
        String string2 = XMLUtil.collapseWhiteSpace(string);
        double d = 0.0;
        boolean bl = false;
        long l = 0L;
        boolean bl2 = false;
        switch (this.type) {
            case 0: {
                try {
                    ByteValue byteValue = ByteValue.parseByte(string2);
                    l = byteValue.getByte();
                    bl2 = true;
                }
                catch (InvalidDataException invalidDataException) {}
                break;
            }
            case 1: {
                try {
                    ShortValue shortValue = ShortValue.parseShort(string2);
                    l = shortValue.getShort();
                    bl2 = true;
                }
                catch (InvalidDataException invalidDataException) {}
                break;
            }
            case 2: {
                try {
                    IntValue intValue = IntValue.parseInt(string2);
                    l = intValue.getInt();
                    bl2 = true;
                }
                catch (InvalidDataException invalidDataException) {}
                break;
            }
            case 3: {
                try {
                    LongValue longValue = LongValue.parseLong(string2);
                    l = longValue.getLong();
                    bl2 = true;
                }
                catch (InvalidDataException invalidDataException) {}
                break;
            }
            case 4: {
                try {
                    FloatValue floatValue = FloatValue.parseFloat(string2);
                    d = floatValue.getFloat();
                    bl = true;
                }
                catch (InvalidDataException invalidDataException) {}
                break;
            }
            default: {
                try {
                    DoubleValue doubleValue = DoubleValue.parseDouble(string2);
                    d = doubleValue.getDouble();
                    bl = true;
                }
                catch (InvalidDataException invalidDataException) {}
                break;
            }
        }
        if (bl) {
            return this.numberFormat.format(d);
        }
        if (bl2) {
            return this.numberFormat.format(l);
        }
        return string;
    }

    protected String parse(String string) {
        if (this.numberFormat == null) {
            this.initialize();
        }
        String string2 = string;
        try {
            Number number = this.numberFormat.parse(string.trim());
            switch (this.type) {
                case 0: {
                    string2 = new ByteValue(number.byteValue()).toString();
                    break;
                }
                case 1: {
                    string2 = new ShortValue(number.shortValue()).toString();
                    break;
                }
                case 2: {
                    string2 = new IntValue(number.intValue()).toString();
                    break;
                }
                case 3: {
                    string2 = new LongValue(number.longValue()).toString();
                    break;
                }
                case 4: {
                    string2 = new FloatValue(number.floatValue()).toString();
                    break;
                }
                default: {
                    string2 = new DoubleValue(number.doubleValue()).toString();
                    break;
                }
            }
        }
        catch (ParseException parseException) {}
        return string2;
    }
}

