/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.form.FormUtil;
import com.xmlmind.xmledit.form.ListItem;
import com.xmlmind.xmledit.form.ValueEditorRenderer;
import com.xmlmind.xmledit.form.ValueEditorVP;
import com.xmlmind.xmledit.styledgadget.ComponentImageBox;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;

public final class RadioButtonsRenderer
extends ValueEditorRenderer {
    public ListItem[] items = new ListItem[0];
    public int rows = -1;
    public int columns = -1;
    public boolean multiple = false;
    public char separator = '\u0000';
    private JPanel template = null;

    public void setParameters(StyleValue[] styleValueArray, Style style, StyledViewFactory styledViewFactory, Element element, Name name) {
        super.setParameters(styleValueArray, style, styledViewFactory, element, name);
        this.items = FormUtil.parametersToItems(styleValueArray, style, styledViewFactory, element, name);
        if (this.items == null) {
            this.items = new ListItem[0];
        }
        int n = styleValueArray.length / 2 * 2;
        int n2 = 0;
        while (n2 < n) {
            String string;
            StyleValue styleValue = styleValueArray[n2];
            if (styleValue.type != 2) {
                return;
            }
            String string2 = styleValue.string;
            StyleValue styleValue2 = styleValueArray[n2 + 1];
            if ("columns".equals(string2)) {
                this.columns = styleValue2.intValue(element, -1);
            } else if ("rows".equals(string2)) {
                this.rows = styleValue2.intValue(element, -1);
            } else if ("selection".equals(string2)) {
                this.multiple = "multiple".equals(styleValue2.stringValue(element));
            } else if ("separator".equals(string2) && (string = styleValue2.stringValue(element)) != null && string.length() > 0) {
                this.separator = string.charAt(0);
            }
            n2 += 2;
        }
    }

    public int hashCode() {
        int n = super.hashCode();
        int n2 = 0;
        while (n2 < this.items.length) {
            n ^= this.items[n2].hashCode();
            ++n2;
        }
        n ^= this.columns;
        n ^= this.rows;
        n ^= this.multiple ? 1 : 0;
        return n ^= this.separator;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RadioButtonsRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RadioButtonsRenderer radioButtonsRenderer = (RadioButtonsRenderer)object;
        if (this.columns != radioButtonsRenderer.columns || this.rows != radioButtonsRenderer.rows || this.multiple != radioButtonsRenderer.multiple || this.separator != radioButtonsRenderer.separator || this.items.length != radioButtonsRenderer.items.length) {
            return false;
        }
        int n = 0;
        while (n < this.items.length) {
            if (!this.items[n].equals(radioButtonsRenderer.items[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Component getTemplate() {
        if (this.template == null) {
            this.template = this.createPanel();
        }
        return this.template;
    }

    private JPanel createPanel() {
        int n;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        if (this.columns > 0) {
            n = this.columns;
        } else if (this.rows > 0) {
            n = -1;
        } else {
            n = this.items.length;
            if (n > 10) {
                n = 10;
            }
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 1;
        gridBagConstraints.insets.left = 1;
        gridBagConstraints.insets.right = 1;
        gridBagConstraints.insets.bottom = 1;
        gridBagConstraints.anchor = 17;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.items.length) {
            ListItem listItem = this.items[n4];
            JToggleButton jToggleButton = this.multiple ? new JCheckBox(listItem.toString()) : new JRadioButton(listItem.toString());
            jToggleButton.setActionCommand(listItem.getValue());
            gridBagConstraints.gridx = n2++;
            gridBagConstraints.gridy = n3++;
            jPanel.add((Component)jToggleButton, gridBagConstraints);
            if (n > 0) {
                if (n2 == n) {
                    n2 = 0;
                }
            } else if (++n3 == this.rows) {
                ++n2;
                n3 = 0;
            }
            ++n4;
        }
        return jPanel;
    }

    protected Component doCreateComponent(final ValueEditorVP valueEditorVP) {
        final JPanel jPanel = this.createPanel();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!RadioButtonsRenderer.this.multiple) {
                    JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                    if (!jRadioButton.isSelected()) {
                        jRadioButton.setSelected(true);
                        return;
                    }
                    int n = jPanel.getComponentCount();
                    int n2 = 0;
                    while (n2 < n) {
                        JRadioButton jRadioButton2 = (JRadioButton)jPanel.getComponent(n2);
                        if (jRadioButton2 != jRadioButton && jRadioButton.isSelected()) {
                            jRadioButton2.setSelected(false);
                        }
                        ++n2;
                    }
                }
                RadioButtonsRenderer.this.setCommitNeeded(valueEditorVP, jPanel, true);
                RadioButtonsRenderer.this.commit(valueEditorVP, jPanel, true);
            }
        };
        int n = jPanel.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            AbstractButton abstractButton = (AbstractButton)jPanel.getComponent(n2);
            abstractButton.addActionListener(actionListener);
            ++n2;
        }
        return jPanel;
    }

    protected boolean setValue(ValueEditorVP valueEditorVP, Component component, String string) {
        JPanel jPanel = (JPanel)component;
        boolean bl = false;
        if (this.items.length > 0) {
            String[] stringArray;
            int n = jPanel.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                stringArray = (String[])jPanel.getComponent(n2);
                stringArray.setSelected(false);
                ++n2;
            }
            if (string != null) {
                if (this.multiple) {
                    stringArray = this.separator == '\u0000' ? XMLUtil.splitList(string) : StringUtil.split(string, this.separator);
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < stringArray.length) {
                        String string2 = stringArray[n4];
                        int n5 = 0;
                        while (n5 < n) {
                            AbstractButton abstractButton = (AbstractButton)jPanel.getComponent(n5);
                            if (string2.equals(abstractButton.getActionCommand())) {
                                if (abstractButton.isSelected()) break;
                                abstractButton.setSelected(true);
                                ++n3;
                                break;
                            }
                            ++n5;
                        }
                        ++n4;
                    }
                    bl = n3 == stringArray.length;
                } else {
                    int n6 = 0;
                    while (n6 < n) {
                        AbstractButton abstractButton = (AbstractButton)jPanel.getComponent(n6);
                        if (string.equals(abstractButton.getActionCommand())) {
                            abstractButton.setSelected(true);
                            bl = true;
                            break;
                        }
                        ++n6;
                    }
                }
            }
        }
        return bl;
    }

    protected String getValue(ValueEditorVP valueEditorVP, Component component) {
        JPanel jPanel = (JPanel)component;
        char c = this.separator == '\u0000' ? (char)' ' : (char)this.separator;
        StringBuffer stringBuffer = new StringBuffer();
        int n = jPanel.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            AbstractButton abstractButton = (AbstractButton)jPanel.getComponent(n2);
            if (abstractButton.isSelected()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(c);
                }
                stringBuffer.append(abstractButton.getActionCommand());
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected void showError(ValueEditorVP valueEditorVP, Component component) {
        JPanel jPanel = (JPanel)component;
        jPanel.getToolkit().beep();
        if (jPanel.getComponentCount() > 0) {
            jPanel.getComponent(0).requestFocus();
        }
        this.configure(valueEditorVP, component);
    }

    protected void setFont(ValueEditorVP valueEditorVP, Component component, Font font) {
        JPanel jPanel = (JPanel)component;
        int n = jPanel.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            AbstractButton abstractButton = (AbstractButton)jPanel.getComponent(n2);
            abstractButton.setFont(font);
            ++n2;
        }
    }

    protected void setForeground(ValueEditorVP valueEditorVP, Component component, Color color) {
        JPanel jPanel = (JPanel)component;
        int n = jPanel.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            AbstractButton abstractButton = (AbstractButton)jPanel.getComponent(n2);
            abstractButton.setForeground(color);
            ++n2;
        }
    }

    protected void setBackground(ValueEditorVP valueEditorVP, Component component, Color color) {
        JPanel jPanel = (JPanel)component;
        int n = jPanel.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            AbstractButton abstractButton = (AbstractButton)jPanel.getComponent(n2);
            abstractButton.setBackground(color);
            ++n2;
        }
    }

    protected void setOpaque(ValueEditorVP valueEditorVP, Component component, boolean bl) {
        JPanel jPanel = (JPanel)component;
        int n = jPanel.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            AbstractButton abstractButton = (AbstractButton)jPanel.getComponent(n2);
            abstractButton.setOpaque(bl);
            ++n2;
        }
    }

    public int getFirstBaseLine(ComponentImageBox componentImageBox) {
        return FormUtil.getBaseLine((ValueEditorVP)componentImageBox, this.getRowCount(), false);
    }

    public int getLastBaseLine(ComponentImageBox componentImageBox) {
        return FormUtil.getBaseLine((ValueEditorVP)componentImageBox, this.getRowCount(), true);
    }

    private int getRowCount() {
        if (this.columns > 0) {
            return (this.items.length + (this.columns - 1)) / this.columns;
        }
        if (this.rows > 0) {
            return Math.min(this.rows, this.items.length);
        }
        if (this.items.length == 0) {
            return 0;
        }
        int n = this.items.length;
        if (n > 10) {
            n = 10;
        }
        return (this.items.length + (n - 1)) / n;
    }
}

