/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.AttributeType;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.form.MenuButtonVP;
import com.xmlmind.xmledit.form.Msg;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.MenuSpec;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledElementView;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.datatype.IDREFSType;
import com.xmlmind.xmledit.xsd.datatype.IDREFType;
import java.util.Arrays;

public class SetAttributeButtonVP
extends MenuButtonVP {
    private Name attributeName;
    private boolean unsetAttribute;

    public SetAttributeButtonVP(Style style, StyledElementView styledElementView, int n, Name name, boolean bl) {
        super(style, styledElementView, n);
        this.attributeName = name;
        this.unsetAttribute = bl;
    }

    public MenuSpec getMenuSpec() {
        Document document;
        DocumentType documentType;
        Element element = this.view.getElement();
        if (!element.isEditable()) {
            return null;
        }
        boolean[] blArray = new boolean[1];
        AttributeType attributeType = DocumentTypeUtil.getAttributeType(element, this.attributeName, blArray);
        if (attributeType == null) {
            return null;
        }
        DataType dataType = attributeType.getAttributeDataType();
        String string = element.getAttribute(this.attributeName);
        boolean bl = this.unsetAttribute && string != null && !blArray[0];
        Object[] objectArray = null;
        Data[] dataArray = dataType.getEnumeratedValues();
        if (dataArray != null) {
            objectArray = new String[dataArray.length];
            int n = 0;
            while (n < dataArray.length) {
                objectArray[n] = dataArray[n].formatData(element);
                ++n;
            }
        } else if ((dataType instanceof IDREFType || dataType instanceof IDREFSType) && DocumentTypeUtil.isConstrainedDocumentType(documentType = (DocumentType)(document = element.getDocument()).getProperty("DOCUMENT_TYPE"))) {
            objectArray = DocumentTypeUtil.getIds(document, documentType);
        }
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        String[] stringArray = new String[2 * objectArray.length + (bl ? 4 : 0)];
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            stringArray[2 * n] = ((String)object).length() == 0 ? " " : object;
            if (((String)object).equals(string)) {
                int n2 = 2 * n;
                stringArray[n2] = stringArray[n2] + " \u2714";
            }
            stringArray[2 * n + 1] = object;
            ++n;
        }
        if (bl) {
            stringArray[2 * n] = "";
            stringArray[2 * n + 1] = "";
            stringArray[2 * ++n] = Msg.msg("remove");
            stringArray[2 * n + 1] = null;
        }
        return this.createMenuSpec(stringArray);
    }

    public Object executeCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)this.getRoot();
        if (string == null) {
            Command command = Commands.getCommand("removeAttribute");
            if (command == null) {
                return null;
            }
            String string2 = this.attributeName.toString();
            if (command.prepareCommand(documentView, string2, -1, -1)) {
                command.executeCommand(documentView, string2, -1, -1);
            }
        } else {
            Command command = Commands.getCommand("putAttribute");
            if (command == null) {
                return null;
            }
            String string3 = StringUtil.joinArguments(new String[]{this.attributeName.toString(), string});
            if (command.prepareCommand(documentView, string3, -1, -1)) {
                command.executeCommand(documentView, string3, -1, -1);
            }
        }
        return null;
    }
}

