/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.edit.DocumentUtil;
import com.xmlmind.xmledit.form.FormUtil;
import com.xmlmind.xmledit.form.ValueEditorRenderer;
import com.xmlmind.xmledit.form.ValueEditorVP;
import com.xmlmind.xmledit.styledgadget.ComponentImageBox;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public final class TextAreaRenderer
extends ValueEditorRenderer {
    public static final int WRAP_NONE = 0;
    public static final int WRAP_LINE = 1;
    public static final int WRAP_WORD = 2;
    public int columns = -1;
    public int rows = 3;
    public int wrap = 0;
    private JTextArea template = null;
    private JScrollPane templateScroller = null;

    public void setParameters(StyleValue[] styleValueArray, Style style, StyledViewFactory styledViewFactory, Element element, Name name) {
        super.setParameters(styleValueArray, style, styledViewFactory, element, name);
        int n = styleValueArray.length / 2 * 2;
        int n2 = 0;
        while (n2 < n) {
            StyleValue styleValue = styleValueArray[n2];
            if (styleValue.type != 2) {
                return;
            }
            String string = styleValue.string;
            StyleValue styleValue2 = styleValueArray[n2 + 1];
            if ("columns".equals(string)) {
                this.columns = styleValue2.intValue(element, -1);
            } else if ("rows".equals(string)) {
                this.rows = styleValue2.intValue(element, -1);
                if (this.rows <= 0) {
                    this.rows = 3;
                }
            } else if ("wrap".equals(string)) {
                String string2 = styleValue2.stringValue(element);
                if ("none".equals(string2)) {
                    this.wrap = 0;
                } else if ("line".equals(string2)) {
                    this.wrap = 1;
                } else if ("word".equals(string2)) {
                    this.wrap = 2;
                }
            }
            n2 += 2;
        }
    }

    public int hashCode() {
        int n = super.hashCode();
        n ^= this.columns;
        n ^= this.rows;
        return n ^= this.wrap;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TextAreaRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TextAreaRenderer textAreaRenderer = (TextAreaRenderer)object;
        return this.columns == textAreaRenderer.columns && this.rows == textAreaRenderer.rows && this.wrap == textAreaRenderer.wrap;
    }

    public Component getTemplate() {
        if (this.template == null) {
            this.template = this.createTextArea();
            this.templateScroller = new JScrollPane(this.template);
            this.configureScroller(this.templateScroller, this.template);
        }
        return this.templateScroller;
    }

    private JTextArea createTextArea() {
        JTextArea jTextArea = new JTextArea("", this.rows, this.columns <= 0 ? 40 : this.columns);
        switch (this.wrap) {
            case 1: {
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(false);
                break;
            }
            case 2: {
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                break;
            }
            default: {
                jTextArea.setLineWrap(false);
                jTextArea.setWrapStyleWord(false);
            }
        }
        return jTextArea;
    }

    private void configureScroller(JScrollPane jScrollPane, JTextArea jTextArea) {
        JScrollBar jScrollBar;
        if (jTextArea.getLineWrap()) {
            jScrollPane.setHorizontalScrollBarPolicy(31);
        } else {
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollBar = jScrollPane.getHorizontalScrollBar();
            jScrollBar.setFocusable(false);
        }
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollBar = jScrollPane.getVerticalScrollBar();
        jScrollBar.setFocusable(false);
    }

    protected Component doCreateComponent(final ValueEditorVP valueEditorVP) {
        JTextArea jTextArea = this.createTextArea();
        final JScrollPane jScrollPane = new JScrollPane(jTextArea);
        this.configureScroller(jScrollPane, jTextArea);
        jTextArea.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.needCommit();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.needCommit();
            }

            private void needCommit() {
                if (!Boolean.TRUE.equals(jScrollPane.getClientProperty("settingValue")) && !TextAreaRenderer.this.isCommitNeeded(valueEditorVP, jScrollPane)) {
                    TextAreaRenderer.this.setCommitNeeded(valueEditorVP, jScrollPane, true);
                    DocumentUtil.pendingChanges(valueEditorVP.getView().getModel().getDocument());
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        jScrollPane.putClientProperty("settingValue", Boolean.FALSE);
        jTextArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (TextAreaRenderer.this.isCommitNeeded(valueEditorVP, jScrollPane)) {
                    valueEditorVP.autoCommit(focusEvent);
                }
            }
        });
        int n = PlatformUtil.IS_MAC_OS ? 4 : 2;
        Keymap keymap = JTextComponent.addKeymap(null, jTextArea.getKeymap());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, n), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextAreaRenderer.this.isCommitNeeded(valueEditorVP, jScrollPane)) {
                    TextAreaRenderer.this.commit(valueEditorVP, jScrollPane, true);
                }
            }
        });
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(27, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextAreaRenderer.this.isCommitNeeded(valueEditorVP, jScrollPane)) {
                    TextAreaRenderer.this.configure(valueEditorVP, jScrollPane);
                }
            }
        });
        jTextArea.setKeymap(keymap);
        return jScrollPane;
    }

    protected boolean setValue(ValueEditorVP valueEditorVP, Component component, String string) {
        JScrollPane jScrollPane = (JScrollPane)component;
        jScrollPane.putClientProperty("settingValue", Boolean.TRUE);
        JTextArea jTextArea = (JTextArea)jScrollPane.getViewport().getView();
        jTextArea.setText(string == null ? "" : string);
        jTextArea.setCaretPosition(0);
        jScrollPane.putClientProperty("settingValue", Boolean.FALSE);
        return string != null;
    }

    protected String getValue(ValueEditorVP valueEditorVP, Component component) {
        JTextArea jTextArea = (JTextArea)((JScrollPane)component).getViewport().getView();
        return jTextArea.getText();
    }

    protected void showError(ValueEditorVP valueEditorVP, Component component) {
        JTextArea jTextArea = (JTextArea)((JScrollPane)component).getViewport().getView();
        jTextArea.getToolkit().beep();
        jTextArea.selectAll();
        jTextArea.requestFocus();
    }

    protected void setFont(ValueEditorVP valueEditorVP, Component component, Font font) {
        JTextArea jTextArea = (JTextArea)((JScrollPane)component).getViewport().getView();
        jTextArea.setFont(font);
    }

    protected void setForeground(ValueEditorVP valueEditorVP, Component component, Color color) {
        JTextArea jTextArea = (JTextArea)((JScrollPane)component).getViewport().getView();
        jTextArea.setForeground(color);
    }

    protected void setBackground(ValueEditorVP valueEditorVP, Component component, Color color) {
        JTextArea jTextArea = (JTextArea)((JScrollPane)component).getViewport().getView();
        jTextArea.setBackground(color);
    }

    public int getFirstBaseLine(ComponentImageBox componentImageBox) {
        return FormUtil.getBaseLine((ValueEditorVP)componentImageBox, this.rows, false);
    }

    public int getLastBaseLine(ComponentImageBox componentImageBox) {
        return FormUtil.getBaseLine((ValueEditorVP)componentImageBox, this.rows, true);
    }
}

