/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.edit.DocumentUtil;
import com.xmlmind.xmledit.form.FormUtil;
import com.xmlmind.xmledit.form.ValueEditorRenderer;
import com.xmlmind.xmledit.form.ValueEditorVP;
import com.xmlmind.xmledit.styledgadget.ComponentImageBox;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.xmlutil.Name;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class TextFieldRenderer
extends ValueEditorRenderer {
    public int columns = -1;
    protected JTextField template = null;

    public void setParameters(StyleValue[] styleValueArray, Style style, StyledViewFactory styledViewFactory, Element element, Name name) {
        super.setParameters(styleValueArray, style, styledViewFactory, element, name);
        int n = styleValueArray.length / 2 * 2;
        int n2 = 0;
        while (n2 < n) {
            StyleValue styleValue = styleValueArray[n2];
            if (styleValue.type != 2) {
                return;
            }
            String string = styleValue.string;
            StyleValue styleValue2 = styleValueArray[n2 + 1];
            if ("columns".equals(string)) {
                this.columns = styleValue2.intValue(element, -1);
            }
            n2 += 2;
        }
    }

    public int hashCode() {
        int n = super.hashCode();
        return n ^= this.columns;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TextFieldRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TextFieldRenderer textFieldRenderer = (TextFieldRenderer)object;
        return this.columns == textFieldRenderer.columns;
    }

    public Component getTemplate() {
        if (this.template == null) {
            this.template = this.createTextField();
        }
        return this.template;
    }

    private JTextField createTextField() {
        return new JTextField(this.getColumns());
    }

    protected int getColumns() {
        return this.columns <= 0 ? 20 : this.columns;
    }

    protected Component doCreateComponent(final ValueEditorVP valueEditorVP) {
        final JTextField jTextField = this.createTextField();
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.needCommit();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.needCommit();
            }

            private void needCommit() {
                if (!Boolean.TRUE.equals(jTextField.getClientProperty("settingValue")) && !TextFieldRenderer.this.isCommitNeeded(valueEditorVP, jTextField)) {
                    TextFieldRenderer.this.setCommitNeeded(valueEditorVP, jTextField, true);
                    DocumentUtil.pendingChanges(valueEditorVP.getView().getModel().getDocument());
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        jTextField.putClientProperty("settingValue", Boolean.FALSE);
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextFieldRenderer.this.isCommitNeeded(valueEditorVP, jTextField)) {
                    TextFieldRenderer.this.commit(valueEditorVP, jTextField, true);
                }
            }
        });
        jTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (TextFieldRenderer.this.isCommitNeeded(valueEditorVP, jTextField)) {
                    valueEditorVP.autoCommit(focusEvent);
                }
            }
        });
        Keymap keymap = JTextComponent.addKeymap(null, jTextField.getKeymap());
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(27, 0), new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TextFieldRenderer.this.isCommitNeeded(valueEditorVP, jTextField)) {
                    TextFieldRenderer.this.configure(valueEditorVP, jTextField);
                }
            }
        });
        jTextField.setKeymap(keymap);
        return jTextField;
    }

    protected boolean setValue(ValueEditorVP valueEditorVP, Component component, String string) {
        JTextField jTextField = (JTextField)component;
        jTextField.putClientProperty("settingValue", Boolean.TRUE);
        jTextField.setText(string == null ? "" : string);
        jTextField.putClientProperty("settingValue", Boolean.FALSE);
        return string != null;
    }

    protected String getValue(ValueEditorVP valueEditorVP, Component component) {
        return ((JTextField)component).getText();
    }

    protected void showError(ValueEditorVP valueEditorVP, Component component) {
        super.showError(valueEditorVP, component);
        ((JTextField)component).selectAll();
    }

    public int getFirstBaseLine(ComponentImageBox componentImageBox) {
        return FormUtil.getBaseLine((ValueEditorVP)componentImageBox);
    }

    public int getLastBaseLine(ComponentImageBox componentImageBox) {
        return this.getFirstBaseLine(componentImageBox);
    }
}

