/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.form;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.edit.EditUtil;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.NodeMark;
import com.xmlmind.xmledit.form.ValueEditorVP;
import com.xmlmind.xmledit.gadget.ComponentImage;
import com.xmlmind.xmledit.styledgadget.ComponentImageBox;
import com.xmlmind.xmledit.styledgadget.ComponentImageBoxRenderer;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JComponent;

public abstract class ValueEditorRenderer
implements ComponentImageBoxRenderer {
    public static Color defaultMissingForeground = new Color(0, 128, 128);
    public static Color defaultMissingBackground = null;
    public static Color defaultErrorForeground = new Color(128, 0, 0);
    public static Color defaultErrorBackground = null;
    public Color missingForeground = defaultMissingForeground;
    public Color missingBackground = defaultMissingBackground;
    public Color errorForeground = defaultErrorForeground;
    public Color errorBackground = defaultErrorBackground;

    public void setParameters(StyleValue[] styleValueArray, Style style, StyledViewFactory styledViewFactory, Element element, Name name) {
        int n = styleValueArray.length / 2 * 2;
        int n2 = 0;
        while (n2 < n) {
            StyleValue styleValue = styleValueArray[n2];
            if (styleValue.type != 2) {
                return;
            }
            String string = styleValue.string;
            StyleValue styleValue2 = styleValueArray[n2 + 1];
            if ("missing-color".equals(string)) {
                this.missingForeground = styleValue2.colorValue(element);
            } else if ("missing-background-color".equals(string)) {
                this.missingBackground = styleValue2.colorValue(element);
            } else if ("error-color".equals(string)) {
                this.errorForeground = styleValue2.colorValue(element);
            } else if ("error-background-color".equals(string)) {
                this.errorBackground = styleValue2.colorValue(element);
            }
            n2 += 2;
        }
    }

    public int hashCode() {
        int n = 0;
        if (this.missingForeground != null) {
            n ^= this.missingForeground.hashCode();
        }
        if (this.missingBackground != null) {
            n ^= this.missingBackground.hashCode();
        }
        if (this.errorForeground != null) {
            n ^= this.errorForeground.hashCode();
        }
        if (this.errorBackground != null) {
            n ^= this.errorBackground.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ValueEditorRenderer)) {
            return false;
        }
        ValueEditorRenderer valueEditorRenderer = (ValueEditorRenderer)object;
        return MiscUtil.eq(this.missingForeground, valueEditorRenderer.missingForeground) && MiscUtil.eq(this.missingBackground, valueEditorRenderer.missingBackground) && MiscUtil.eq(this.errorForeground, valueEditorRenderer.errorForeground) && MiscUtil.eq(this.errorBackground, valueEditorRenderer.errorBackground);
    }

    public Component getTemplate(ComponentImage componentImage) {
        ValueEditorVP valueEditorVP = (ValueEditorVP)componentImage;
        Component component = this.getTemplate();
        this.configure(valueEditorVP, component);
        return component;
    }

    public Component createComponent(ComponentImage componentImage) {
        ValueEditorVP valueEditorVP = (ValueEditorVP)componentImage;
        Component component = this.doCreateComponent(valueEditorVP);
        this.configure(valueEditorVP, component);
        final Element element = valueEditorVP.getElementView().getElement();
        final DocumentView documentView = (DocumentView)valueEditorVP.getRoot();
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                if (focusEvent.isTemporary()) {
                    return;
                }
                if (element.getDocument() == null) {
                    return;
                }
                MarkManager markManager = documentView.getMarkManager();
                if (markManager == null) {
                    return;
                }
                NodeMark nodeMark = markManager.getSelected();
                if (nodeMark == null || nodeMark.getNode() != element) {
                    markManager.beginBatchMarking();
                    markManager.remove("SELECTED2");
                    markManager.remove("MARK");
                    markManager.set("SELECTED", element);
                    documentView.ensureDotIsInside(element);
                    markManager.endBatchMarking();
                }
            }
        };
        ValueEditorRenderer.addFocusAdapter(component, focusAdapter);
        return component;
    }

    private static final void addFocusAdapter(Component component, FocusAdapter focusAdapter) {
        component.addFocusListener(focusAdapter);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                ValueEditorRenderer.addFocusAdapter(container.getComponent(n2), focusAdapter);
                ++n2;
            }
        }
    }

    protected void configure(ValueEditorVP valueEditorVP, Component component) {
        Color color;
        Color color2;
        String string;
        Element element = valueEditorVP.getElementView().getElement();
        Name name = valueEditorVP.getEditedAttributeName();
        boolean bl = false;
        boolean bl2 = false;
        if (name != null) {
            string = element.getAttribute(name);
            if (string == null) {
                bl = true;
            }
        } else {
            string = element.getText();
            if (string == null) {
                bl2 = true;
            } else if (string.length() == 0) {
                bl = true;
                string = null;
            }
        }
        boolean bl3 = false;
        if (string == null) {
            string = DocumentTypeUtil.getDefaultValue(element, name);
            bl3 = true;
        }
        if (string == null) {
            this.setValue(valueEditorVP, component, null);
        } else if (!this.setValue(valueEditorVP, component, string)) {
            bl2 = true;
            if (!bl3) {
                string = DocumentTypeUtil.getDefaultValue(element, name);
                this.setValue(valueEditorVP, component, string);
            }
        }
        this.setCommitNeeded(valueEditorVP, component, false);
        Style style = valueEditorVP.getStyle();
        this.setFont(valueEditorVP, component, style.font);
        if (bl2) {
            color2 = this.errorForeground;
            color = this.errorBackground;
        } else if (bl) {
            color2 = this.missingForeground;
            color = this.missingBackground;
        } else {
            color2 = null;
            color = null;
        }
        if (color2 == null) {
            color2 = style.color;
        }
        this.setForeground(valueEditorVP, component, color2);
        if (color == null) {
            color = style.backgroundColor;
        }
        this.setOpaque(valueEditorVP, component, color != null);
        if (color != null) {
            this.setBackground(valueEditorVP, component, color);
        }
    }

    public boolean commit(ComponentImage componentImage, Component component, boolean bl) {
        ValueEditorVP valueEditorVP = (ValueEditorVP)componentImage;
        if (!this.isCommitNeeded(valueEditorVP, component)) {
            return true;
        }
        Element element = valueEditorVP.getElementView().getElement();
        Name name = valueEditorVP.getEditedAttributeName();
        String string = this.getValue(valueEditorVP, component);
        if (bl) {
            boolean bl2 = false;
            ElementEditor elementEditor = null;
            if (string == null) {
                bl2 = true;
            } else {
                elementEditor = ((DocumentView)valueEditorVP.getRoot()).getElementEditor();
                elementEditor.editElement(element);
                if (name != null) {
                    if (!elementEditor.canPutAttribute(name, string)) {
                        bl2 = true;
                    }
                } else if (!elementEditor.canSetText(string)) {
                    bl2 = true;
                }
            }
            if (bl2) {
                this.showError(valueEditorVP, component);
                return false;
            }
            if (name != null) {
                elementEditor.putAttribute(name, string);
            } else {
                elementEditor.setText(string);
            }
        } else if (string != null && element.isEditable()) {
            if (name != null) {
                element.putAttribute(name, string);
            } else {
                EditUtil.setText(element, string);
            }
        }
        return true;
    }

    protected abstract Component doCreateComponent(ValueEditorVP var1);

    protected abstract boolean setValue(ValueEditorVP var1, Component var2, String var3);

    protected abstract String getValue(ValueEditorVP var1, Component var2);

    protected void setCommitNeeded(ValueEditorVP valueEditorVP, Component component, boolean bl) {
        component.setName(bl ? "true" : "false");
    }

    protected boolean isCommitNeeded(ValueEditorVP valueEditorVP, Component component) {
        return "true".equals(component.getName());
    }

    protected void showError(ValueEditorVP valueEditorVP, Component component) {
        component.getToolkit().beep();
        component.requestFocus();
    }

    protected void setFont(ValueEditorVP valueEditorVP, Component component, Font font) {
        component.setFont(font);
    }

    protected void setForeground(ValueEditorVP valueEditorVP, Component component, Color color) {
        component.setForeground(color);
    }

    protected void setBackground(ValueEditorVP valueEditorVP, Component component, Color color) {
        component.setBackground(color);
    }

    protected void setOpaque(ValueEditorVP valueEditorVP, Component component, boolean bl) {
        if (component instanceof JComponent) {
            ((JComponent)component).setOpaque(bl);
        }
    }

    protected boolean removeValue(ValueEditorVP valueEditorVP, Component component) {
        Element element = valueEditorVP.getElementView().getElement();
        Name name = valueEditorVP.getEditedAttributeName();
        ElementEditor elementEditor = ((DocumentView)valueEditorVP.getRoot()).getElementEditor();
        boolean bl = false;
        elementEditor.editElement(element);
        if (name != null) {
            if (!elementEditor.canRemoveAttribute(name)) {
                bl = true;
            }
        } else if (!elementEditor.canSetText("")) {
            bl = true;
        }
        if (bl) {
            this.showError(valueEditorVP, component);
            return false;
        }
        if (name != null) {
            elementEditor.removeAttribute(name);
        } else {
            elementEditor.setText("");
        }
        return true;
    }

    public int getFirstBaseLine(ComponentImageBox componentImageBox) {
        return -1;
    }

    public int getLastBaseLine(ComponentImageBox componentImageBox) {
        return -1;
    }

    public void attributeValueChanged(ValueEditorVP valueEditorVP, Component component) {
        if (component == null) {
            valueEditorVP.refresh();
        } else {
            this.configure(valueEditorVP, component);
        }
    }

    public void elementValueChanged(ValueEditorVP valueEditorVP, Component component) {
        if (component == null) {
            valueEditorVP.refresh();
        } else {
            this.configure(valueEditorVP, component);
        }
    }
}

