/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.gadget;

import com.xmlmind.xmledit.util.StringUtil;
import java.awt.Point;
import java.util.EventObject;

public class AppEvent
extends EventObject {
    protected static final Info[] NO_INFO = new Info[0];
    protected String name;
    protected int x;
    protected int y;
    protected boolean hasPoint;

    public AppEvent(Object object, String string) {
        super(object);
        this.name = string;
        this.y = -1;
        this.x = -1;
        this.hasPoint = false;
    }

    public AppEvent(Object object, String string, int n, int n2) {
        super(object);
        this.name = string;
        this.setPoint(n, n2);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasPoint() {
        return this.hasPoint;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean getPoint(Point point) {
        if (this.hasPoint) {
            point.x = this.x;
            point.y = this.y;
            return true;
        }
        point.y = -1;
        point.x = -1;
        return false;
    }

    public Point getPoint() {
        return this.hasPoint ? new Point(this.x, this.y) : null;
    }

    public void setPoint(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.hasPoint = true;
    }

    public void translatePoint(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public Info[] getInfo() {
        return NO_INFO;
    }

    public String substituteVariables(String string) {
        if (string.indexOf("%{") >= 0) {
            Info[] infoArray = this.getInfo();
            int n = 0;
            while (n < infoArray.length) {
                Info info = infoArray[n];
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("%{");
                stringBuffer.append(info.getKey());
                stringBuffer.append('}');
                string = StringUtil.replaceAll(string, stringBuffer.toString(), info.getValue().toString());
                ++n;
            }
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[source=");
        stringBuffer.append(this.source);
        stringBuffer.append(",name=");
        stringBuffer.append(this.name);
        if (this.hasPoint) {
            stringBuffer.append(",x=");
            stringBuffer.append(this.x);
            stringBuffer.append(",y=");
            stringBuffer.append(this.y);
        }
        Info[] infoArray = this.getInfo();
        int n = 0;
        while (n < infoArray.length) {
            Info info = infoArray[n];
            stringBuffer.append(",\"");
            stringBuffer.append(info.getKey());
            stringBuffer.append("\"=");
            stringBuffer.append(info.getValue());
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static class Info {
        private String key;
        private Object value;

        public Info(String string, Object object) {
            this.key = string;
            this.value = object;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

