/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.gadget;

import com.xmlmind.xmledit.gadget.UserInput;

public abstract class BindingBase {
    protected UserInput[] userInputs;
    protected String appEventName;

    protected BindingBase(UserInput[] userInputArray) {
        this.userInputs = userInputArray;
        this.appEventName = null;
    }

    protected BindingBase(String string) {
        this.appEventName = string;
        this.userInputs = null;
    }

    protected void check() throws IllegalArgumentException {
        if (this.userInputs == null) {
            if (this.appEventName == null || this.appEventName.length() == 0) {
                throw new IllegalArgumentException("missing or empty app. event name");
            }
        } else {
            if (this.userInputs.length == 0) {
                throw new IllegalArgumentException("empty user input sequence");
            }
            if (this.userInputs[0].getMouseEventId() != 508) {
                if (this.userInputs.length > 1) {
                    throw new IllegalArgumentException("cannot bind an action to a sequence of mouse inputs");
                }
            } else {
                int n = 0;
                while (n < this.userInputs.length) {
                    if (this.userInputs[n].getMouseEventId() != 508) {
                        throw new IllegalArgumentException("cannot mix mouse and keyboard inputs in the same sequence");
                    }
                    ++n;
                }
            }
        }
    }

    public UserInput[] getUserInputs() {
        return this.userInputs;
    }

    public String getAppEventName() {
        return this.appEventName;
    }

    public boolean isAppEventBinding() {
        return this.appEventName != null;
    }

    public boolean isKeyBinding() {
        return this.userInputs != null && this.userInputs[0].getMouseEventId() == 508;
    }

    public boolean isMouseBinding() {
        return this.userInputs != null && this.userInputs[0].getMouseEventId() != 508;
    }

    public int hashCode() {
        return this.userInputs == null ? this.appEventName.hashCode() : BindingBase.hashCode(this.userInputs);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BindingBase)) {
            return false;
        }
        BindingBase bindingBase = (BindingBase)object;
        return this.hasSameTrigger(bindingBase);
    }

    public boolean hasSameTrigger(BindingBase bindingBase) {
        if (this.userInputs == null) {
            if (bindingBase.appEventName == null) {
                return false;
            }
            return this.appEventName.equals(bindingBase.appEventName);
        }
        if (bindingBase.userInputs == null) {
            return false;
        }
        return BindingBase.equals(this.userInputs, bindingBase.userInputs);
    }

    public String triggerToString() {
        String string = this.userInputs == null ? this.appEventName : BindingBase.toString(this.userInputs);
        return string;
    }

    public static int hashCode(UserInput[] userInputArray) {
        int n = 0;
        if (userInputArray != null) {
            int n2 = 0;
            while (n2 < userInputArray.length) {
                n ^= userInputArray[n2].hashCode();
                ++n2;
            }
        }
        return n;
    }

    public static boolean equals(UserInput[] userInputArray, UserInput[] userInputArray2) {
        if (userInputArray == null) {
            return userInputArray2 == null;
        }
        if (userInputArray2 == null) {
            return false;
        }
        if (userInputArray.length != userInputArray2.length) {
            return false;
        }
        int n = 0;
        while (n < userInputArray.length) {
            if (!userInputArray[n].equals(userInputArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String toString(UserInput[] userInputArray) {
        if (userInputArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < userInputArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            userInputArray[n].toString(stringBuffer);
            ++n;
        }
        return stringBuffer.toString();
    }
}

