/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.gadget;

import com.xmlmind.xmledit.gadget.AppEvent;
import com.xmlmind.xmledit.gadget.Binding;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.MenuSpec;
import com.xmlmind.xmledit.gadget.UserInput;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;

public final class Bindings {
    private static BindingCompare bindingCompare = new BindingCompare();
    private Gadget gadget;
    private Binding[] bindings;
    private MouseBindingInfo[] mouseBindings;
    private HashMap keyBindings;
    private AppEventBindingInfo[] appEventBindings;
    private MouseBindingInfo activeMouseBinding = null;
    private int state = -1;
    private int consumeKeyReleased = 0;
    private boolean consumeKeyTyped = false;
    private StateInfo pendingAcceptingStateInfo = null;
    private KeyBindingInfo probe = new KeyBindingInfo();

    public Bindings(Gadget gadget, Binding[] bindingArray) {
        this.gadget = gadget;
        this.bindings = bindingArray;
        this.compileMouseBindings(bindingArray);
        this.compileKeyboardBindings(bindingArray);
        this.compileAppEventBindings(bindingArray);
    }

    public Gadget getGadget() {
        return this.gadget;
    }

    public Binding[] getAll() {
        return this.bindings;
    }

    private void compileMouseBindings(Binding[] bindingArray) {
        HashMap<MouseBindingInfo, MouseBindingInfo> hashMap = new HashMap<MouseBindingInfo, MouseBindingInfo>();
        MouseBindingInfo mouseBindingInfo = new MouseBindingInfo();
        int n = 0;
        while (n < bindingArray.length) {
            UserInput userInput;
            Binding binding = bindingArray[n];
            UserInput[] userInputArray = binding.getUserInputs();
            if (userInputArray != null && (userInput = userInputArray[0]).getMouseEventId() != 508) {
                mouseBindingInfo.mouseButtonWithModifiers = userInput.getMouseButton() | userInput.getModifiers();
                MouseBindingInfo mouseBindingInfo2 = (MouseBindingInfo)hashMap.get(mouseBindingInfo);
                if (mouseBindingInfo2 == null) {
                    mouseBindingInfo2 = new MouseBindingInfo(binding);
                    hashMap.put(mouseBindingInfo2, mouseBindingInfo2);
                } else {
                    mouseBindingInfo2.addAction(binding);
                }
            }
            ++n;
        }
        this.mouseBindings = new MouseBindingInfo[hashMap.size()];
        hashMap.values().toArray(this.mouseBindings);
    }

    private void compileKeyboardBindings(Binding[] bindingArray) {
        this.keyBindings = new HashMap();
        HashMap<StateInfoKey, StateInfo> hashMap = new HashMap<StateInfoKey, StateInfo>();
        StateInfoKey stateInfoKey = new StateInfoKey();
        int n = 0;
        bindingArray = (Binding[])bindingArray.clone();
        Arrays.sort(bindingArray, bindingCompare);
        int n2 = 0;
        while (n2 < bindingArray.length) {
            Binding binding = bindingArray[n2];
            UserInput[] userInputArray = binding.getUserInputs();
            if (userInputArray != null && userInputArray[0].getMouseEventId() == 508) {
                int n3 = -1;
                int n4 = 0;
                while (n4 < userInputArray.length) {
                    UserInput userInput = userInputArray[n4];
                    stateInfoKey.state = n3;
                    stateInfoKey.userInput = userInput;
                    StateInfo stateInfo = (StateInfo)hashMap.get(stateInfoKey);
                    if (stateInfo == null) {
                        boolean bl = userInput.getKeyChar() != '\uffff';
                        stateInfo = new StateInfo();
                        stateInfo.state = n3;
                        stateInfo.nextState = n;
                        if (n4 == userInputArray.length - 1) {
                            stateInfo.isAccepting = true;
                            stateInfo.onKeyTyped = bl;
                            stateInfo.command = binding.getCommand();
                            stateInfo.parameter = binding.getParameter();
                        }
                        hashMap.put(new StateInfoKey(n3, userInput), stateInfo);
                        this.probe.keyCharOrCode = bl ? (long)userInput.getKeyChar() << 48 : (long)userInput.getKeyCode() << 32 | (long)userInput.getModifiers();
                        KeyBindingInfo keyBindingInfo = (KeyBindingInfo)this.keyBindings.get(this.probe);
                        if (keyBindingInfo == null) {
                            keyBindingInfo = new KeyBindingInfo(this.probe.keyCharOrCode, stateInfo);
                            this.keyBindings.put(keyBindingInfo, keyBindingInfo);
                        } else {
                            keyBindingInfo.addState(stateInfo);
                        }
                        n3 = n++;
                    } else {
                        n3 = stateInfo.nextState;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void compileAppEventBindings(Binding[] bindingArray) {
        HashMap<String, AppEventBindingInfo> hashMap = new HashMap<String, AppEventBindingInfo>();
        int n = 0;
        while (n < bindingArray.length) {
            Binding binding = bindingArray[n];
            String string = binding.getAppEventName();
            if (string != null) {
                hashMap.put(string, new AppEventBindingInfo(binding));
            }
            ++n;
        }
        this.appEventBindings = new AppEventBindingInfo[hashMap.size()];
        hashMap.values().toArray(this.appEventBindings);
    }

    public boolean grabsMouseButton(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        this.activeMouseBinding = null;
        int n2 = 0;
        while (n2 < this.mouseBindings.length) {
            if (this.mouseBindings[n2].mouseButtonWithModifiers == n) {
                this.activeMouseBinding = this.mouseBindings[n2];
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void handleMouseEvent(MouseEvent mouseEvent) {
        int n;
        MouseActionInfo mouseActionInfo = null;
        if (this.activeMouseBinding != null) {
            MouseActionInfo[] mouseActionInfoArray = this.activeMouseBinding.actions;
            n = mouseEvent.getID();
            int n2 = mouseEvent.getClickCount();
            int n3 = 0;
            while (n3 < mouseActionInfoArray.length) {
                MouseActionInfo mouseActionInfo2 = mouseActionInfoArray[n3];
                if (mouseActionInfo2.mouseEventId == n) {
                    if (n != 500) {
                        mouseActionInfo = mouseActionInfo2;
                        break;
                    }
                    if (mouseActionInfo2.mouseClickCount == n2) {
                        mouseActionInfo = mouseActionInfo2;
                        break;
                    }
                }
                ++n3;
            }
        }
        if (mouseActionInfo == null) {
            return;
        }
        int n4 = mouseEvent.getX();
        n = mouseEvent.getY();
        if (mouseActionInfo.menuSpec == null) {
            Command command = mouseActionInfo.command;
            if (command == null) {
                command = this.gadget;
            }
            this.executeCommand(mouseEvent, command, mouseActionInfo.parameter, n4, n);
        } else {
            this.gadget.showMenu(mouseActionInfo.menuSpec, n4, n);
        }
    }

    private void executeCommand(EventObject eventObject, Command command, String string, int n, int n2) {
        try {
            if (command.prepareCommand(this.gadget, string, n, n2)) {
                command.executeCommand(this.gadget, string, n, n2);
            }
        }
        catch (Exception exception) {
            Bindings.reportCommandError(exception, command, string);
        }
    }

    public static final void reportCommandError(Exception exception, Command command, String string) {
        String string2 = string == null ? "no parameter" : "parameter '" + string + "'";
        System.err.println("Execution of command " + command.getClass().getName() + "\n" + "with " + string2 + "\n" + "has thrown a " + exception.getClass().getName() + " exception.");
        System.err.println("----------------------------------------");
        exception.printStackTrace();
        System.err.println("----------------------------------------");
    }

    public boolean handleKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 157: 
            case 65406: {
                return false;
            }
        }
        boolean bl = false;
        switch (keyEvent.getID()) {
            case 401: {
                int n2;
                StateInfo stateInfo = null;
                this.probe.keyCharOrCode = (long)n << 32 | (long)keyEvent.getModifiers();
                KeyBindingInfo keyBindingInfo = (KeyBindingInfo)this.keyBindings.get(this.probe);
                if (keyBindingInfo != null) {
                    StateInfo[] stateInfoArray = keyBindingInfo.states;
                    int n3 = this.state;
                    n2 = 0;
                    while (n2 < stateInfoArray.length) {
                        if (stateInfoArray[n2].state == n3) {
                            stateInfo = stateInfoArray[n2];
                            break;
                        }
                        ++n2;
                    }
                }
                if (stateInfo == null) {
                    char c = keyEvent.getKeyChar();
                    if (c != '\uffff') {
                        this.probe.keyCharOrCode = (long)c << 48;
                        keyBindingInfo = (KeyBindingInfo)this.keyBindings.get(this.probe);
                    } else {
                        keyBindingInfo = null;
                    }
                    if (keyBindingInfo != null) {
                        StateInfo[] stateInfoArray = keyBindingInfo.states;
                        n2 = this.state;
                        int n4 = 0;
                        while (n4 < stateInfoArray.length) {
                            if (stateInfoArray[n4].state == n2) {
                                stateInfo = stateInfoArray[n4];
                                break;
                            }
                            ++n4;
                        }
                    }
                }
                if (stateInfo == null) {
                    this.state = -1;
                    this.consumeKeyReleased = 0;
                    this.consumeKeyTyped = false;
                    this.pendingAcceptingStateInfo = null;
                    break;
                }
                if (stateInfo.isAccepting) {
                    this.state = -1;
                    if (stateInfo.onKeyTyped) {
                        this.pendingAcceptingStateInfo = stateInfo;
                    } else {
                        this.executeCommand(keyEvent, stateInfo);
                    }
                } else {
                    this.state = stateInfo.nextState;
                }
                ++this.consumeKeyReleased;
                if (keyEvent.getKeyChar() != '\uffff') {
                    this.consumeKeyTyped = true;
                }
                bl = true;
                break;
            }
            case 400: {
                if (!this.consumeKeyTyped) break;
                this.consumeKeyTyped = false;
                bl = true;
                if (this.pendingAcceptingStateInfo == null) break;
                StateInfo stateInfo = this.pendingAcceptingStateInfo;
                this.pendingAcceptingStateInfo = null;
                this.executeCommand(keyEvent, stateInfo);
                break;
            }
            case 402: {
                if (this.consumeKeyReleased <= 0) break;
                --this.consumeKeyReleased;
                bl = true;
            }
        }
        return bl;
    }

    private void executeCommand(EventObject eventObject, StateInfo stateInfo) {
        Command command = stateInfo.command;
        if (command == null) {
            command = this.gadget;
        }
        this.executeCommand(eventObject, command, stateInfo.parameter, -1, -1);
    }

    public boolean isAppEventHandler(AppEvent appEvent) {
        String string = appEvent.getName();
        int n = 0;
        while (n < this.appEventBindings.length) {
            if (this.appEventBindings[n].appEventName.equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void handleAppEvent(AppEvent appEvent) {
        String string;
        AppEventBindingInfo appEventBindingInfo = null;
        String string2 = appEvent.getName();
        int n = 0;
        while (n < this.appEventBindings.length) {
            if (this.appEventBindings[n].appEventName.equals(string2)) {
                appEventBindingInfo = this.appEventBindings[n];
                break;
            }
            ++n;
        }
        if (appEventBindingInfo == null) {
            return;
        }
        Command command = appEventBindingInfo.command;
        if (command == null) {
            command = this.gadget;
        }
        if ((string = appEventBindingInfo.parameter) != null) {
            string = appEvent.substituteVariables(string);
        }
        int n2 = appEvent.getX();
        int n3 = appEvent.getY();
        this.executeCommand(appEvent, command, string, n2, n3);
    }

    private static final class AppEventBindingInfo {
        public String appEventName;
        public Command command;
        public String parameter;

        public AppEventBindingInfo(Binding binding) {
            this.appEventName = binding.getAppEventName();
            this.command = binding.getCommand();
            this.parameter = binding.getParameter();
        }
    }

    private static class BindingCompare
    implements Comparator {
        private BindingCompare() {
        }

        public int compare(Object object, Object object2) {
            UserInput[] userInputArray = ((Binding)object).getUserInputs();
            UserInput[] userInputArray2 = ((Binding)object2).getUserInputs();
            int n = userInputArray == null ? 0 : userInputArray.length;
            int n2 = userInputArray2 == null ? 0 : userInputArray2.length;
            return -(n - n2);
        }
    }

    private static final class KeyBindingInfo {
        public long keyCharOrCode;
        public StateInfo[] states;

        public KeyBindingInfo() {
        }

        public KeyBindingInfo(long l, StateInfo stateInfo) {
            this.keyCharOrCode = l;
            this.states = new StateInfo[]{stateInfo};
        }

        public void addState(StateInfo stateInfo) {
            StateInfo[] stateInfoArray = new StateInfo[this.states.length + 1];
            System.arraycopy(this.states, 0, stateInfoArray, 0, this.states.length);
            stateInfoArray[this.states.length] = stateInfo;
            this.states = stateInfoArray;
        }

        public int hashCode() {
            return (int)this.keyCharOrCode;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof KeyBindingInfo)) {
                return false;
            }
            return this.keyCharOrCode == ((KeyBindingInfo)object).keyCharOrCode;
        }
    }

    private static final class StateInfo {
        public int state;
        public int nextState;
        public boolean isAccepting;
        public boolean onKeyTyped;
        public Command command;
        public String parameter;

        private StateInfo() {
        }
    }

    private static final class StateInfoKey {
        public int state;
        public UserInput userInput;

        public StateInfoKey() {
        }

        public StateInfoKey(int n, UserInput userInput) {
            this.state = n;
            this.userInput = userInput;
        }

        public int hashCode() {
            return this.state ^ this.userInput.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof StateInfoKey)) {
                return false;
            }
            StateInfoKey stateInfoKey = (StateInfoKey)object;
            return this.state == stateInfoKey.state && this.userInput.equals(stateInfoKey.userInput);
        }
    }

    private static final class MouseBindingInfo {
        public int mouseButtonWithModifiers;
        public MouseActionInfo[] actions;

        public MouseBindingInfo() {
        }

        public MouseBindingInfo(Binding binding) {
            UserInput userInput = binding.getUserInputs()[0];
            this.mouseButtonWithModifiers = userInput.getMouseButton() | userInput.getModifiers();
            this.actions = new MouseActionInfo[]{new MouseActionInfo(binding)};
        }

        public void addAction(Binding binding) {
            MouseActionInfo[] mouseActionInfoArray;
            UserInput userInput = binding.getUserInputs()[0];
            int n = userInput.getMouseEventId();
            int n2 = userInput.getMouseClickCount();
            boolean bl = false;
            int n3 = 0;
            while (n3 < this.actions.length) {
                mouseActionInfoArray = this.actions[n3];
                if (mouseActionInfoArray.mouseEventId == n && mouseActionInfoArray.mouseClickCount == n2) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                mouseActionInfoArray = new MouseActionInfo[this.actions.length + 1];
                System.arraycopy(this.actions, 0, mouseActionInfoArray, 0, this.actions.length);
                mouseActionInfoArray[this.actions.length] = new MouseActionInfo(binding);
                this.actions = mouseActionInfoArray;
            }
        }

        public int hashCode() {
            return this.mouseButtonWithModifiers;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof MouseBindingInfo)) {
                return false;
            }
            return this.mouseButtonWithModifiers == ((MouseBindingInfo)object).mouseButtonWithModifiers;
        }
    }

    private static final class MouseActionInfo {
        public int mouseEventId;
        public int mouseClickCount;
        public Command command;
        public String parameter;
        public MenuSpec menuSpec;

        public MouseActionInfo(Binding binding) {
            UserInput userInput = binding.getUserInputs()[0];
            this.mouseEventId = userInput.getMouseEventId();
            this.mouseClickCount = userInput.getMouseClickCount();
            this.command = binding.getCommand();
            this.parameter = binding.getParameter();
            this.menuSpec = binding.getMenuSpec();
        }
    }
}

