/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.gadget;

import com.xmlmind.xmledit.gadget.ComponentImageRenderer;
import com.xmlmind.xmledit.gadget.EventDispatcher;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetHost;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.SwingUtilities;

public abstract class ComponentImage
extends Gadget {
    protected static final int STRETCH_X_MASK = 1;
    protected static final int STRETCH_Y_MASK = 2;
    protected ComponentImageRenderer renderer;
    protected byte stretch;

    protected ComponentImage(ComponentImageRenderer componentImageRenderer) {
        this.initialize(componentImageRenderer);
        this.relayout();
    }

    protected ComponentImage() {
    }

    protected void initialize(ComponentImageRenderer componentImageRenderer) {
        this.renderer = componentImageRenderer;
        this.stretch = 0;
    }

    public ComponentImageRenderer getRenderer() {
        return this.renderer;
    }

    public void setXStretchable(boolean bl) {
        this.stretch = bl ? (byte)((this.stretch | 1) & 0xFF) : (byte)(this.stretch & 0xFFFFFFFE & 0xFF);
    }

    public boolean isXStretchable() {
        return (this.stretch & 1) != 0;
    }

    public void setYStretchable(boolean bl) {
        this.stretch = bl ? (byte)((this.stretch | 2) & 0xFF) : (byte)(this.stretch & 0xFFFFFFFD & 0xFF);
    }

    public boolean isYStretchable() {
        return (this.stretch & 2) != 0;
    }

    public boolean isActive() {
        GadgetHost gadgetHost = (GadgetHost)((Object)this.getPanel());
        return gadgetHost != null && gadgetHost.getActiveComponentImage() == this;
    }

    public void activate() {
        GadgetHost gadgetHost = (GadgetHost)((Object)this.getPanel());
        if (gadgetHost == null || gadgetHost.getActiveComponentImage() == this) {
            return;
        }
        ComponentImage componentImage = gadgetHost.getActiveComponentImage();
        if (componentImage != null) {
            componentImage.passivate();
        }
        Component component = this.getComponent(true);
        gadgetHost.setActiveComponentImage(this, component);
        this.updateActiveComponentLocation(component);
        this.refresh();
    }

    private Component getComponent(boolean bl) {
        Serializable serializable;
        int n = -1;
        int n2 = -1;
        if (this.stretch != 0) {
            serializable = new Dimension();
            this.parent.getSizeConstraints(this, (Dimension)serializable);
            n = serializable.width;
            n2 = serializable.height;
        }
        serializable = bl ? this.renderer.createComponent(this) : this.renderer.getTemplate(this);
        this.layoutComponent((Component)serializable, n, n2);
        return serializable;
    }

    public void passivate() {
        GadgetHost gadgetHost = (GadgetHost)((Object)this.getPanel());
        if (gadgetHost == null || gadgetHost.getActiveComponentImage() != this) {
            return;
        }
        gadgetHost.setActiveComponentImage(null, null);
        this.refresh();
    }

    public Component getTemplate() {
        return this.getComponent(false);
    }

    public boolean commit(boolean bl) {
        GadgetHost gadgetHost = (GadgetHost)((Object)this.getPanel());
        if (gadgetHost == null || gadgetHost.getActiveComponentImage() != this) {
            return true;
        }
        return this.renderer.commit(this, gadgetHost.getActiveComponent(), bl);
    }

    public void autoCommit(FocusEvent focusEvent) {
        if (focusEvent.getID() != 1005 || focusEvent.isTemporary()) {
            return;
        }
        GadgetHost gadgetHost = (GadgetHost)((Object)this.getPanel());
        if (gadgetHost == null || gadgetHost.getActiveComponentImage() != this) {
            return;
        }
        Component component = gadgetHost.getActiveComponent();
        boolean bl = false;
        Component component2 = (Component)focusEvent.getSource();
        while (component2 != null) {
            if (component2 == component) {
                bl = true;
                break;
            }
            component2 = component2.getParent();
        }
        if (!bl) {
            return;
        }
        component2 = focusEvent.getOppositeComponent();
        while (component2 != null) {
            if (component2 == component) break;
            if (component2 == gadgetHost) {
                this.commit(true);
                break;
            }
            if (component2 instanceof Window || component2 instanceof Applet && component2.getParent() == null) {
                this.commit(false);
                this.passivate();
                break;
            }
            component2 = component2.getParent();
        }
    }

    public void relayout(boolean bl) {
        if (this.stretch != 0) {
            super.relayout(bl);
        } else {
            this.layout(-1, -1, bl);
        }
    }

    public void layout(int n, int n2, boolean bl) {
        GadgetHost gadgetHost = (GadgetHost)((Object)this.getPanel());
        Component component = gadgetHost == null || gadgetHost.getActiveComponentImage() != this ? this.renderer.getTemplate(this) : gadgetHost.getActiveComponent();
        this.layoutComponent(component, n, n2);
        this.width = component.getWidth() + this.getRightMargin() + this.getLeftMargin();
        this.height = component.getHeight() + this.getTopMargin() + this.getBottomMargin();
    }

    protected int getTopMargin() {
        return 0;
    }

    protected int getRightMargin() {
        return 0;
    }

    protected int getBottomMargin() {
        return 0;
    }

    protected int getLeftMargin() {
        return 0;
    }

    private void layoutComponent(Component component, int n, int n2) {
        Dimension dimension = component.getPreferredSize();
        if (this.isXStretchable() && n > 0) {
            if ((n -= this.getRightMargin() + this.getLeftMargin()) <= 0) {
                n = 1;
            }
            if (dimension.width < n) {
                dimension.width = n;
            }
        }
        if (this.isYStretchable() && n2 > 0) {
            if ((n2 -= this.getTopMargin() + this.getBottomMargin()) <= 0) {
                n2 = 1;
            }
            if (dimension.height < n2) {
                dimension.height = n2;
            }
        }
        component.setSize(dimension.width, dimension.height);
        component.validate();
    }

    public void paint(Graphics graphics) {
        GadgetHost gadgetHost = (GadgetHost)((Object)this.getPanel());
        if (gadgetHost == null) {
            return;
        }
        this.paintBackground(graphics);
        if (gadgetHost.getActiveComponentImage() == this) {
            this.updateActiveComponentLocation(gadgetHost.getActiveComponent());
        } else {
            Component component = this.getComponent(false);
            gadgetHost.renderPassiveComponent(graphics, component, this.getLeftMargin(), this.getTopMargin());
        }
    }

    protected void paintBackground(Graphics graphics) {
    }

    public final void updateActiveComponentLocation(Component component) {
        Point point = component.getLocation();
        int n = point.x;
        int n2 = point.y;
        point.x = this.getLeftMargin();
        point.y = this.getTopMargin();
        this.gadgetToPanel(point);
        if (point.y != n2 || point.x != n) {
            component.setLocation(point.x, point.y);
        }
    }

    public boolean grabsMouseButton(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        return n >= this.getLeftMargin() && n <= this.width - this.getRightMargin() && n2 >= this.getTopMargin() && n2 <= this.height - this.getBottomMargin();
    }

    public void handleMouseEvent(MouseEvent mouseEvent) {
        GadgetHost gadgetHost = (GadgetHost)((Object)this.getPanel());
        if (gadgetHost == null) {
            return;
        }
        ComponentImage componentImage = gadgetHost.getActiveComponentImage();
        if (mouseEvent.getID() == 501 && componentImage != this) {
            if (componentImage != null) {
                if (!componentImage.commit(true)) {
                    return;
                }
                componentImage.passivate();
            }
            this.activate();
            componentImage = gadgetHost.getActiveComponentImage();
        }
        if (componentImage == this) {
            Component component = gadgetHost.getActiveComponent();
            Point point = new Point();
            point.x = mouseEvent.getX() - this.getLeftMargin();
            point.y = mouseEvent.getY() - this.getTopMargin();
            Component component2 = null;
            if (component instanceof Container) {
                component2 = ((Container)component).findComponentAt(point);
                if (component2 == null) {
                    return;
                }
                if (component2 != component) {
                    point = SwingUtilities.convertPoint(component, point, component2);
                }
            } else {
                if (!component.contains(point.x, point.y)) {
                    return;
                }
                component2 = component;
            }
            MouseEvent mouseEvent2 = new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            component2.dispatchEvent(mouseEvent2);
            if (mouseEvent.getID() == 502 && mouseEvent.getClickCount() == 1) {
                point.x = mouseEvent.getX();
                point.y = mouseEvent.getY();
                this.gadgetToPanel(point);
                MouseEvent mouseEvent3 = new MouseEvent((Component)mouseEvent.getSource(), 500, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, 1, false);
                EventDispatcher eventDispatcher = this.getEventDispatcher();
                if (eventDispatcher != null) {
                    eventDispatcher.dispatchEvent(mouseEvent3);
                }
            }
        }
    }
}

