/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.gadget;

import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.WrappedComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

public class ComponentWrapper
extends Gadget {
    protected static final int STRETCH_X_MASK = 1;
    protected static final int STRETCH_Y_MASK = 2;
    protected Component component;
    protected byte stretch;

    public ComponentWrapper(Component component) {
        this.initialize(component);
        this.relayout();
    }

    protected ComponentWrapper() {
    }

    protected void initialize(Component component) {
        this.component = component;
        this.stretch = 0;
        if (component instanceof WrappedComponent) {
            ((WrappedComponent)((Object)component)).setComponentWrapper(this);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public void setXStretchable(boolean bl) {
        this.stretch = bl ? (byte)((this.stretch | 1) & 0xFF) : (byte)(this.stretch & 0xFFFFFFFE & 0xFF);
    }

    public boolean isXStretchable() {
        return (this.stretch & 1) != 0;
    }

    public void setYStretchable(boolean bl) {
        this.stretch = bl ? (byte)((this.stretch | 2) & 0xFF) : (byte)(this.stretch & 0xFFFFFFFD & 0xFF);
    }

    public boolean isYStretchable() {
        return (this.stretch & 2) != 0;
    }

    public void relayout(boolean bl) {
        if (this.stretch != 0) {
            super.relayout(bl);
        } else {
            this.layout(-1, -1, bl);
        }
    }

    public void layout(int n, int n2, boolean bl) {
        int n3 = this.getRightMargin() + this.getLeftMargin();
        int n4 = this.getTopMargin() + this.getBottomMargin();
        Dimension dimension = this.component.getPreferredSize();
        if (this.isXStretchable() && n > 0) {
            if ((n -= n3) <= 0) {
                n = 1;
            }
            if (dimension.width < n) {
                dimension.width = n;
            }
        }
        if (this.isYStretchable() && n2 > 0) {
            if ((n2 -= n4) <= 0) {
                n2 = 1;
            }
            if (dimension.height < n2) {
                dimension.height = n2;
            }
        }
        this.component.setSize(dimension.width, dimension.height);
        this.component.validate();
        this.width = dimension.width + n3;
        this.height = dimension.height + n4;
    }

    protected int getTopMargin() {
        return 0;
    }

    protected int getRightMargin() {
        return 0;
    }

    protected int getBottomMargin() {
        return 0;
    }

    protected int getLeftMargin() {
        return 0;
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        this.updateComponentLocation();
    }

    protected void paintBackground(Graphics graphics) {
    }

    public final void updateComponentLocation() {
        Point point = this.component.getLocation();
        int n = point.x;
        int n2 = point.y;
        point.x = this.getLeftMargin();
        point.y = this.getTopMargin();
        this.gadgetToPanel(point);
        if (point.y != n2 || point.x != n) {
            this.component.setLocation(point.x, point.y);
        }
    }
}

