/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.gadget;

import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetContainer;
import com.xmlmind.xmledit.gadget.RootGadget;
import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class EventDispatcher {
    private static final int FOCUS_LOST = 0;
    private static final int FOCUS_REQUESTED = 1;
    private static final int FOCUS_GAINED = 2;
    protected RootGadget root;
    private int focusState = 0;
    private Gadget focusGadget = null;
    private MouseEventTargets mousePressedTargets = new MouseEventTargets();
    private MouseEventTargets mouseReleasedTargets = new MouseEventTargets();
    private MouseEvent lastMouseEvent = null;
    private boolean mouseDragged = false;
    private Point point = new Point();

    public EventDispatcher(RootGadget rootGadget) {
        this.root = rootGadget;
    }

    public boolean hasFocus() {
        return this.focusState == 2;
    }

    public void setFocusGadget(Gadget gadget) {
        if (gadget == this.focusGadget) {
            if (this.focusGadget != null && this.focusState != 2) {
                this.focusState = 1;
                this.root.getPanel().requestFocus();
            }
        } else {
            if (this.focusGadget != null) {
                if (this.focusState == 2) {
                    this.focusGadget.focusLost();
                }
                this.focusGadget = null;
            }
            if (gadget != null) {
                this.focusGadget = gadget;
                if (this.focusState == 2) {
                    this.focusGadget.focusGained();
                } else {
                    this.focusState = 1;
                    this.root.getPanel().requestFocus();
                }
            }
        }
    }

    public Gadget getFocusGadget() {
        return this.focusGadget;
    }

    public void gadgetRemoved(Gadget gadget) {
        if (this.focusGadget == null) {
            return;
        }
        if (gadget == this.focusGadget || gadget instanceof GadgetContainer && ((GadgetContainer)gadget).isAncestorOf(this.focusGadget)) {
            this.setFocusGadget(null);
        }
    }

    public void dispatchEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 1004: {
                this.focusState = 2;
                if (this.focusGadget == null) break;
                this.focusGadget.focusGained();
                break;
            }
            case 1005: {
                this.focusState = 0;
                if (this.focusGadget == null) break;
                this.focusGadget.focusLost();
                break;
            }
            case 400: 
            case 401: 
            case 402: {
                KeyEvent keyEvent;
                if (this.focusGadget == null || !this.focusGadget.handleKeyEvent(keyEvent = (KeyEvent)aWTEvent)) break;
                keyEvent.consume();
                break;
            }
            case 501: {
                if (this.mousePressedTargets.size() > 0) {
                    this.mousePressedTargets.popAll();
                }
                if (this.mouseReleasedTargets.size() > 0) {
                    this.mouseReleasedTargets.popAll();
                }
                this.lastMouseEvent = null;
                this.mouseDragged = false;
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                this.pushMouseEventTargets(mouseEvent, this.mousePressedTargets);
                if (this.mousePressedTargets.size() <= 0) break;
                this.dispatchMouseEvent(mouseEvent, this.mousePressedTargets);
                this.lastMouseEvent = mouseEvent;
                break;
            }
            case 506: {
                if (this.mousePressedTargets.size() <= 0) break;
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                this.handleMouseEvent(mouseEvent, this.mousePressedTargets);
                this.lastMouseEvent = mouseEvent;
                this.mouseDragged = true;
                break;
            }
            case 502: {
                if (this.mousePressedTargets.size() <= 0) break;
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (this.mouseDragged || mouseEvent.getModifiers() != this.lastMouseEvent.getModifiers()) {
                    this.mouseReleasedTargets.popAll();
                } else {
                    this.pushMouseEventTargets(mouseEvent, this.mouseReleasedTargets);
                    Gadget gadget = this.mousePressedTargets.top().gadget;
                    while (this.mouseReleasedTargets.size() > 0) {
                        if (this.mouseReleasedTargets.top().gadget == gadget) break;
                        this.mouseReleasedTargets.pop();
                    }
                }
                this.lastMouseEvent = null;
                this.mouseDragged = false;
                this.handleMouseEvent(mouseEvent, this.mousePressedTargets);
                this.mousePressedTargets.popAll();
                break;
            }
            case 500: {
                if (this.mouseReleasedTargets.size() <= 0) break;
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                this.handleMouseEvent(mouseEvent, this.mouseReleasedTargets);
                this.mouseReleasedTargets.popAll();
            }
        }
    }

    private void pushMouseEventTargets(MouseEvent mouseEvent, MouseEventTargets mouseEventTargets) {
        mouseEventTargets.popAll();
        this.point.x = mouseEvent.getX();
        this.point.y = mouseEvent.getY();
        this.root.panelToGadget(this.point);
        int n = this.point.x;
        int n2 = this.point.y;
        if (n < 0 || n >= this.root.width || n2 < 0 || n2 >= this.root.height) {
            return;
        }
        GadgetContainer gadgetContainer = this.root;
        mouseEventTargets.push(this.root, n, n2);
        block0: while (true) {
            Gadget[] gadgetArray = gadgetContainer.children;
            int n3 = 0;
            while (n3 < gadgetArray.length) {
                Gadget gadget = gadgetArray[n3];
                if (n >= gadget.x && n < gadget.x + gadget.width && n2 >= gadget.y && n2 < gadget.y + gadget.height) {
                    mouseEventTargets.push(gadget, n -= gadget.x, n2 -= gadget.y);
                    if (!(gadget instanceof GadgetContainer)) break block0;
                    gadgetContainer = (GadgetContainer)gadget;
                    continue block0;
                }
                ++n3;
            }
            break;
        }
    }

    private void dispatchMouseEvent(MouseEvent mouseEvent, MouseEventTargets mouseEventTargets) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        while (mouseEventTargets.size() > 0) {
            this.point.x = n;
            this.point.y = n2;
            mouseEventTargets.panelToGadget(this.point);
            mouseEvent.translatePoint(this.point.x - n, this.point.y - n2);
            Gadget gadget = mouseEventTargets.top().gadget;
            try {
                if (gadget.grabsMouseButton(mouseEvent)) {
                    gadget.handleMouseEvent(mouseEvent);
                    mouseEvent.consume();
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            mouseEvent.translatePoint(n - this.point.x, n2 - this.point.y);
            mouseEventTargets.pop();
        }
    }

    private void handleMouseEvent(MouseEvent mouseEvent, MouseEventTargets mouseEventTargets) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.point.x = n;
        this.point.y = n2;
        mouseEventTargets.panelToGadget(this.point);
        mouseEvent.translatePoint(this.point.x - n, this.point.y - n2);
        Gadget gadget = mouseEventTargets.top().gadget;
        if (gadget.getRoot() != null) {
            try {
                gadget.handleMouseEvent(mouseEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        mouseEvent.translatePoint(n - this.point.x, n2 - this.point.y);
        mouseEvent.consume();
    }

    private static final class MouseEventTargets {
        private MouseEventTarget[] stack = new MouseEventTarget[0];
        private int pushed = 0;

        private MouseEventTargets() {
        }

        public void push(Gadget gadget, int n, int n2) {
            Object object;
            if (this.pushed == this.stack.length) {
                object = new MouseEventTarget[Math.max(10, 2 * this.stack.length)];
                if (this.pushed > 0) {
                    System.arraycopy(this.stack, 0, object, 0, this.pushed);
                }
                int n3 = this.pushed;
                while (n3 < ((MouseEventTarget[])object).length) {
                    object[n3] = new MouseEventTarget();
                    ++n3;
                }
                this.stack = object;
            }
            object = this.stack[this.pushed++];
            object.gadget = gadget;
            object.eventX = n;
            object.eventY = n2;
        }

        public int size() {
            return this.pushed;
        }

        public MouseEventTarget top() {
            return this.pushed > 0 ? this.stack[this.pushed - 1] : null;
        }

        public void pop() {
            if (this.pushed > 0) {
                --this.pushed;
                this.stack[this.pushed - 1].gadget = null;
            }
        }

        public void popAll() {
            int n = 0;
            while (n < this.pushed) {
                this.stack[n].gadget = null;
                ++n;
            }
            this.pushed = 0;
        }

        public void panelToGadget(Point point) {
            if (this.pushed == 0) {
                return;
            }
            ((RootGadget)this.stack[0].gadget).panelToGadget(point);
            int n = point.x;
            int n2 = point.y;
            int n3 = 1;
            while (n3 < this.pushed) {
                Gadget gadget = this.stack[n3].gadget;
                n -= gadget.x;
                n2 -= gadget.y;
                ++n3;
            }
            point.x = n;
            point.y = n2;
        }
    }

    private static final class MouseEventTarget {
        public Gadget gadget;
        public int eventX;
        public int eventY;

        private MouseEventTarget() {
        }
    }
}

