/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.gadget;

import com.xmlmind.xmledit.gadget.AppEvent;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.EventDispatcher;
import com.xmlmind.xmledit.gadget.GadgetContainer;
import com.xmlmind.xmledit.gadget.MenuSpec;
import com.xmlmind.xmledit.gadget.PaintUtil;
import com.xmlmind.xmledit.gadget.RootGadget;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public abstract class Gadget
implements Command {
    public GadgetContainer parent = null;
    public int x = 0;
    public int y = 0;
    public int width = 1;
    public int height = 1;

    public Point getLocation() {
        Point point = new Point();
        this.getLocation(point);
        return point;
    }

    public void getLocation(Point point) {
        point.x = this.x;
        point.y = this.y;
    }

    public Dimension getSize() {
        Dimension dimension = new Dimension();
        this.getSize(dimension);
        return dimension;
    }

    public void getSize(Dimension dimension) {
        dimension.width = this.width;
        dimension.height = this.height;
    }

    public Rectangle getBounds() {
        Rectangle rectangle = new Rectangle();
        this.getBounds(rectangle);
        return rectangle;
    }

    public void getBounds(Rectangle rectangle) {
        rectangle.x = this.x;
        rectangle.y = this.y;
        rectangle.width = this.width;
        rectangle.height = this.height;
    }

    public RootGadget getRoot() {
        Gadget gadget = this;
        while (gadget.parent != null) {
            gadget = gadget.parent;
        }
        return gadget instanceof RootGadget ? (RootGadget)gadget : null;
    }

    public EventDispatcher getEventDispatcher() {
        RootGadget rootGadget = this.getRoot();
        return rootGadget == null ? null : rootGadget.getEventDispatcher();
    }

    public Container getPanel() {
        RootGadget rootGadget = this.getRoot();
        return rootGadget == null ? null : rootGadget.getPanel();
    }

    public FontMetrics getFontMetrics(Font font) {
        return PaintUtil.getFontMetrics(font, this.getPanel());
    }

    public Toolkit getToolkit() {
        Container container = this.getPanel();
        return container == null ? Toolkit.getDefaultToolkit() : container.getToolkit();
    }

    public Gadget[] getAncestors() {
        int n = 0;
        GadgetContainer gadgetContainer = this.parent;
        while (gadgetContainer != null) {
            ++n;
            gadgetContainer = gadgetContainer.parent;
        }
        Gadget[] gadgetArray = new Gadget[n];
        gadgetContainer = this.parent;
        while (gadgetContainer != null) {
            gadgetArray[--n] = gadgetContainer;
            gadgetContainer = gadgetContainer.parent;
        }
        return gadgetArray;
    }

    public Gadget gadgetToRoot(Point point) {
        int n = point.x;
        int n2 = point.y;
        Gadget gadget = this;
        while (gadget.parent != null) {
            n += gadget.x;
            n2 += gadget.y;
            gadget = gadget.parent;
        }
        point.x = n;
        point.y = n2;
        return gadget;
    }

    public void gadgetToPanel(Point point) {
        Gadget gadget = this.gadgetToRoot(point);
        if (gadget instanceof RootGadget) {
            ((RootGadget)gadget).gadgetToPanel(point);
        }
    }

    public void panelToGadget(Point point) {
        Gadget[] gadgetArray = this.getAncestors();
        if (gadgetArray.length == 0) {
            return;
        }
        int n = 0;
        if (gadgetArray[0] instanceof RootGadget) {
            ((RootGadget)gadgetArray[0]).panelToGadget(point);
            n = 1;
        }
        int n2 = point.x;
        int n3 = point.y;
        while (n < gadgetArray.length) {
            Gadget gadget = gadgetArray[n];
            n2 -= gadget.x;
            n3 -= gadget.y;
            ++n;
        }
        point.x = n2 - this.x;
        point.y = n3 - this.y;
    }

    public void makeRectangleVisible(Rectangle rectangle) {
        this.makeRectangleVisible(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void makeRectangleVisible(int n, int n2, int n3, int n4) {
        Gadget gadget = this;
        while (gadget.parent != null) {
            n += gadget.x;
            n2 += gadget.y;
            gadget = gadget.parent;
        }
        if (gadget instanceof RootGadget) {
            ((RootGadget)gadget).makeRectangleVisible(n, n2, n3, n4);
        }
    }

    public void refresh() {
        int n = this.width;
        int n2 = this.height;
        this.relayout(true);
        if (this.width == n && this.height == n2) {
            this.repaint(0, 0, this.width, this.height);
        } else if (this.parent != null) {
            this.parent.paintRelayout(this, n, n2, 0, -1);
        }
    }

    public void relayout() {
        this.relayout(true);
    }

    public void relayout(boolean bl) {
        if (this.parent != null) {
            Dimension dimension = new Dimension();
            this.parent.getSizeConstraints(this, dimension);
            this.layout(dimension.width, dimension.height, bl);
        }
    }

    public void layout(int n, int n2) {
        this.layout(n, n2, true);
    }

    public abstract void layout(int var1, int var2, boolean var3);

    public void repaint() {
        this.repaint(0, 0, this.width, this.height);
    }

    public void repaint(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        Gadget gadget = this;
        while (gadget.parent != null) {
            n5 += gadget.x;
            n6 += gadget.y;
            gadget = gadget.parent;
        }
        if (gadget instanceof RootGadget) {
            ((RootGadget)gadget).repaint(n5, n6, this.width, n4);
        }
    }

    public abstract void paint(Graphics var1);

    public Graphics getGraphics() {
        int n = 0;
        int n2 = 0;
        Gadget gadget = this;
        while (gadget.parent != null) {
            n += gadget.x;
            n2 += gadget.y;
            gadget = gadget.parent;
        }
        Graphics graphics = null;
        if (gadget instanceof RootGadget) {
            graphics = ((RootGadget)gadget).getGraphics();
            graphics.translate(n, n2);
            graphics.clipRect(0, 0, this.width, this.height);
        }
        return graphics;
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public int[] getNonBreakableVerticalRanges() {
        return new int[]{0, this.height - 1};
    }

    public boolean hasFocus() {
        EventDispatcher eventDispatcher = this.getEventDispatcher();
        return eventDispatcher != null && eventDispatcher.hasFocus() && eventDispatcher.getFocusGadget() == this;
    }

    public void requestFocus() {
        EventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.setFocusGadget(this);
        }
    }

    public void focusGained() {
    }

    public void focusLost() {
    }

    public boolean handleKeyEvent(KeyEvent keyEvent) {
        return false;
    }

    public boolean grabsMouseButton(MouseEvent mouseEvent) {
        return false;
    }

    public void handleMouseEvent(MouseEvent mouseEvent) {
    }

    public boolean isAppEventHandler(AppEvent appEvent) {
        return false;
    }

    public void handleAppEvent(AppEvent appEvent) {
    }

    public void showMenu(MenuSpec menuSpec, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Gadget gadget = this;
        while (gadget.parent != null) {
            n3 += gadget.x;
            n4 += gadget.y;
            gadget = gadget.parent;
        }
        if (gadget instanceof RootGadget) {
            ((RootGadget)gadget).showMenu(menuSpec, n3, n4, this);
        }
    }

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        return true;
    }

    public Object executeCommand(Gadget gadget, String string, int n, int n2) {
        return null;
    }
}

