/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.gadget;

import com.xmlmind.xmledit.gadget.EventDispatcher;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetHost;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class GadgetContainer
extends Gadget {
    public static final int NO_SIDE = 0;
    public static final int TOP_SIDE = 1;
    public static final int BOTTOM_SIDE = 2;
    public static final int LEFT_SIDE = 3;
    public static final int RIGHT_SIDE = 4;
    protected Gadget[] children = new Gadget[0];

    public void addChild(Gadget gadget) {
        this.insertChild(this.children.length, gadget);
    }

    public void insertChild(int n, Gadget gadget) {
        int n2;
        Gadget[] gadgetArray = new Gadget[this.children.length + 1];
        if (n > 0) {
            System.arraycopy(this.children, 0, gadgetArray, 0, n);
        }
        if ((n2 = this.children.length - n) > 0) {
            System.arraycopy(this.children, n, gadgetArray, n + 1, n2);
        }
        gadgetArray[n] = gadget;
        this.children = gadgetArray;
        gadget.parent = this;
        Container container = this.getPanel();
        if (container != null) {
            ((GadgetHost)((Object)container)).gadgetAdded(gadget);
        }
    }

    public void removeChild(Gadget gadget) {
        int n = this.indexOfChild(gadget);
        if (n >= 0) {
            this.removeChild(n);
        }
    }

    public void removeChild(int n) {
        Container container;
        int n2;
        int n3;
        Gadget gadget = this.children[n];
        Gadget[] gadgetArray = new Gadget[this.children.length - 1];
        if (n > 0) {
            System.arraycopy(this.children, 0, gadgetArray, 0, n);
        }
        if ((n3 = this.children.length - (n2 = n + 1)) > 0) {
            System.arraycopy(this.children, n2, gadgetArray, n, n3);
        }
        this.children = gadgetArray;
        gadget.parent = null;
        EventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.gadgetRemoved(gadget);
        }
        if ((container = this.getPanel()) != null) {
            ((GadgetHost)((Object)container)).gadgetRemoved(gadget);
        }
    }

    public void replaceChild(Gadget gadget, Gadget gadget2) {
        this.replaceChild(this.indexOfChild(gadget), gadget2);
    }

    public void replaceChild(int n, Gadget gadget) {
        GadgetHost gadgetHost;
        Gadget gadget2 = this.children[n];
        this.children[n] = gadget;
        gadget2.parent = null;
        gadget.parent = this;
        EventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null) {
            eventDispatcher.gadgetRemoved(gadget2);
        }
        if ((gadgetHost = (GadgetHost)((Object)this.getPanel())) != null) {
            gadgetHost.gadgetRemoved(gadget2);
            gadgetHost.gadgetAdded(gadget);
        }
    }

    public Gadget[] getChildren() {
        return this.children;
    }

    public int indexOfChild(Gadget gadget) {
        int n = 0;
        while (n < this.children.length) {
            if (this.children[n] == gadget) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Gadget getChild(int n) {
        return this.children[n];
    }

    public int getChildCount() {
        return this.children.length;
    }

    public boolean isAncestorOf(Gadget gadget) {
        int n = 0;
        while (n < this.children.length) {
            Gadget gadget2 = this.children[n];
            if (gadget2 == gadget || gadget2 instanceof GadgetContainer && ((GadgetContainer)gadget2).isAncestorOf(gadget)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int indexOfChildAt(int n, int n2) {
        int n3 = 0;
        while (n3 < this.children.length) {
            Gadget gadget = this.children[n3];
            if (n >= gadget.x && n < gadget.x + gadget.width && n2 >= gadget.y && n2 < gadget.y + gadget.height) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public Gadget findGadgetAt(Point point) {
        int n = point.x;
        int n2 = point.y;
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return null;
        }
        Gadget gadget = this;
        GadgetContainer gadgetContainer = this;
        block0: while (true) {
            Gadget[] gadgetArray = gadgetContainer.children;
            int n3 = 0;
            while (n3 < gadgetArray.length) {
                Gadget gadget2 = gadgetArray[n3];
                if (n >= gadget2.x && n < gadget2.x + gadget2.width && n2 >= gadget2.y && n2 < gadget2.y + gadget2.height) {
                    n -= gadget2.x;
                    n2 -= gadget2.y;
                    gadget = gadget2;
                    if (!(gadget2 instanceof GadgetContainer)) break block0;
                    gadgetContainer = (GadgetContainer)gadget2;
                    continue block0;
                }
                ++n3;
            }
            break;
        }
        point.x = n;
        point.y = n2;
        return gadget;
    }

    public abstract void getSizeConstraints(Gadget var1, Dimension var2);

    public void paintRelayout(Gadget gadget, int n, int n2) {
        this.paintRelayout(gadget, n, n2, 0, -1);
    }

    public void paintRelayout(Gadget gadget, int n, int n2, int n3, int n4) {
        int n5 = this.width;
        int n6 = this.height;
        this.relayout(false);
        if (this.width == n5 && this.height == n6) {
            this.repaint(0, 0, this.width, this.height);
        } else if (this.parent != null) {
            this.parent.paintRelayout(this, n5, n6, 0, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Gadget gadget = this.children[n2];
            if (rectangle == null || gadget.x < rectangle.x + rectangle.width && gadget.y < rectangle.y + rectangle.height && gadget.x + gadget.width > rectangle.x && gadget.y + gadget.height > rectangle.y) {
                Object var8_7;
                Graphics graphics2 = graphics.create(gadget.x, gadget.y, gadget.width, gadget.height);
                try {
                    gadget.paint(graphics2);
                    var8_7 = null;
                    graphics2.dispose();
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    graphics2.dispose();
                    throw throwable;
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            Gadget gadget = this.children[n2];
            if (rectangle == null || gadget.x < rectangle.x + rectangle.width && gadget.y < rectangle.y + rectangle.height && gadget.x + gadget.width > rectangle.x && gadget.y + gadget.height > rectangle.y) {
                Object var8_7;
                Graphics graphics2 = graphics.create(gadget.x, gadget.y, gadget.width, gadget.height);
                try {
                    gadget.print(graphics2);
                    var8_7 = null;
                    graphics2.dispose();
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    graphics2.dispose();
                    throw throwable;
                }
            }
            ++n2;
        }
    }

    public int[] getNonBreakableVerticalRanges() {
        return null;
    }
}

