/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.gadget;

import com.xmlmind.xmledit.gadget.AppEvent;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.ComponentImage;
import com.xmlmind.xmledit.gadget.ComponentWrapper;
import com.xmlmind.xmledit.gadget.EventDispatcher;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetContainer;
import com.xmlmind.xmledit.gadget.GadgetHost;
import com.xmlmind.xmledit.gadget.MenuItemSpec;
import com.xmlmind.xmledit.gadget.MenuSpec;
import com.xmlmind.xmledit.gadget.RootGadget;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import javax.swing.CellRendererPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class GadgetPanel
extends JPanel
implements GadgetHost {
    protected RootGadget root;
    protected EventDispatcher eventDispatcher;
    private boolean dispatchEvents = true;
    private ComponentWrapper[] componentWrappers = new ComponentWrapper[0];
    private ComponentImage activeComponentImage = null;
    private Component activeComponent = null;
    public CellRendererPane cellRendererPane = null;
    private JPopupMenu popupMenu = null;
    private boolean popupMenuPopped = false;
    private boolean popupMenuHidden = true;
    private Insets insets = new Insets(0, 0, 0, 0);
    private Rectangle rect = new Rectangle();
    private Point point = new Point();

    public GadgetPanel() {
        super(null, true);
        this.setBackground(Color.lightGray);
        this.root = this.createRootGadget();
        this.eventDispatcher = this.root.getEventDispatcher();
        this.enableEvents(60L);
    }

    protected RootGadget createRootGadget() {
        return new RootGadget(this);
    }

    public RootGadget getRoot() {
        return this.root;
    }

    public Gadget findGadgetAt(int n, int n2) {
        this.point.x = n;
        this.point.y = n2;
        return this.findGadgetAt(this.point);
    }

    public Gadget findGadgetAt(Point point) {
        Insets insets = this.getInsets();
        point.x -= insets.left;
        point.y -= insets.top;
        return this.root.findGadgetAt(point);
    }

    public boolean handleAppEvent(AppEvent appEvent) {
        Gadget gadget = this.findAppEventHandler(appEvent);
        if (gadget == null) {
            return false;
        }
        gadget.handleAppEvent(appEvent);
        return true;
    }

    public Gadget findAppEventHandler(AppEvent appEvent) {
        Gadget gadget = null;
        if (!appEvent.hasPoint()) {
            if (this.root.isAppEventHandler(appEvent)) {
                gadget = this.root;
            }
        } else {
            int n = appEvent.getX();
            int n2 = appEvent.getY();
            Insets insets = this.getInsets();
            if (n < insets.left || n >= this.getWidth() - insets.right || n2 < insets.top || n2 >= this.getHeight() - insets.bottom) {
                int n3 = n < insets.left ? insets.left : (n >= this.getWidth() - insets.right ? this.getWidth() - insets.right - 1 : n);
                int n4 = n2 < insets.top ? insets.top : (n2 >= this.getHeight() - insets.bottom ? this.getHeight() - insets.bottom - 1 : n2);
                appEvent.setPoint(n3 - insets.left, n4 - insets.top);
                if (this.root.isAppEventHandler(appEvent)) {
                    gadget = this.root;
                } else {
                    appEvent.setPoint(n, n2);
                }
            } else {
                gadget = this.findAppEventHandlerAt(appEvent);
            }
        }
        return gadget;
    }

    private Gadget findAppEventHandlerAt(AppEvent appEvent) {
        int n = appEvent.getX();
        int n2 = appEvent.getY();
        this.point.x = n;
        this.point.y = n2;
        Gadget gadget = this.findGadgetAt(this.point);
        if (gadget != null) {
            appEvent.setPoint(this.point.x, this.point.y);
            while (gadget != null) {
                if (gadget.isAppEventHandler(appEvent)) {
                    return gadget;
                }
                appEvent.translatePoint(gadget.x, gadget.y);
                gadget = gadget.parent;
            }
        }
        appEvent.setPoint(n, n2);
        return null;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.dispatchEvents = bl;
    }

    public Insets getInsets() {
        return super.getInsets(this.insets);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        this.root.getSize(dimension);
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        graphics.translate(insets.left, insets.top);
        this.root.paint(graphics);
        graphics.translate(-insets.left, -insets.top);
    }

    protected void printComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        graphics.translate(insets.left, insets.top);
        this.root.print(graphics);
        graphics.translate(-insets.left, -insets.top);
    }

    protected void paintChildren(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.componentWrappers.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentWrapper componentWrapper = this.componentWrappers[n2];
            componentWrapper.getComponent().getBounds(this.rect);
            if (rectangle == null || this.rect.x < rectangle.x + rectangle.width && this.rect.y < rectangle.y + rectangle.height && this.rect.x + this.rect.width > rectangle.x && this.rect.y + this.rect.height > rectangle.y) {
                componentWrapper.updateComponentLocation();
            }
            ++n2;
        }
        if (this.activeComponent != null) {
            this.activeComponent.getBounds(this.rect);
            if (rectangle == null || this.rect.x < rectangle.x + rectangle.width && this.rect.y < rectangle.y + rectangle.height && this.rect.x + this.rect.width > rectangle.x && this.rect.y + this.rect.height > rectangle.y) {
                this.activeComponentImage.updateActiveComponentLocation(this.activeComponent);
            }
        }
        super.paintChildren(graphics);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (this.dispatchEvents && (this.popupMenuHidden || !(aWTEvent instanceof InputEvent))) {
            this.eventDispatcher.dispatchEvent(aWTEvent);
        }
        if (this.popupMenuPopped) {
            this.popupMenuPopped = false;
        } else {
            super.processEvent(aWTEvent);
        }
    }

    public void gadgetAdded(Gadget gadget) {
        if (gadget instanceof ComponentImage) {
            CellRendererPane cellRendererPane = this.getCellRendererPane();
            Component component = ((ComponentImage)gadget).getRenderer().getTemplate();
            if (component.getParent() != cellRendererPane) {
                cellRendererPane.add(component);
            }
            return;
        }
        if (gadget instanceof ComponentWrapper) {
            this.addComponentWrapper((ComponentWrapper)gadget);
            return;
        }
        if (gadget instanceof GadgetContainer) {
            Gadget[] gadgetArray = ((GadgetContainer)gadget).getChildren();
            int n = 0;
            while (n < gadgetArray.length) {
                this.gadgetAdded(gadgetArray[n]);
                ++n;
            }
        }
    }

    private CellRendererPane getCellRendererPane() {
        if (this.cellRendererPane == null) {
            this.cellRendererPane = new CellRendererPane();
            this.add(this.cellRendererPane);
        }
        return this.cellRendererPane;
    }

    private void addComponentWrapper(ComponentWrapper componentWrapper) {
        ComponentWrapper[] componentWrapperArray = new ComponentWrapper[this.componentWrappers.length + 1];
        if (this.componentWrappers.length > 0) {
            System.arraycopy(this.componentWrappers, 0, componentWrapperArray, 0, this.componentWrappers.length);
        }
        componentWrapperArray[this.componentWrappers.length] = componentWrapper;
        this.componentWrappers = componentWrapperArray;
        this.add(componentWrapper.getComponent());
    }

    public void gadgetRemoved(Gadget gadget) {
        this.doGadgetRemoved(gadget);
        if (this.root.getChildCount() == 0) {
            this.resetActiveComponentHelpers();
        }
    }

    private void resetActiveComponentHelpers() {
        if (this.cellRendererPane != null) {
            this.remove(this.cellRendererPane);
            this.cellRendererPane = null;
        }
    }

    private void doGadgetRemoved(Gadget gadget) {
        if (gadget == this.activeComponentImage) {
            Component component = this.activeComponent;
            this.activeComponentImage = null;
            this.activeComponent = null;
            this.remove(component);
            return;
        }
        if (gadget instanceof ComponentWrapper) {
            this.removeComponentWrapper((ComponentWrapper)gadget);
            return;
        }
        if (gadget instanceof GadgetContainer) {
            Gadget[] gadgetArray = ((GadgetContainer)gadget).getChildren();
            int n = 0;
            while (n < gadgetArray.length) {
                this.doGadgetRemoved(gadgetArray[n]);
                ++n;
            }
        }
    }

    private void removeComponentWrapper(ComponentWrapper componentWrapper) {
        int n;
        int n2;
        int n3 = 0;
        while (n3 < this.componentWrappers.length) {
            if (this.componentWrappers[n3] == componentWrapper) break;
            ++n3;
        }
        if (n3 == this.componentWrappers.length) {
            return;
        }
        ComponentWrapper[] componentWrapperArray = new ComponentWrapper[this.componentWrappers.length - 1];
        if (n3 > 0) {
            System.arraycopy(this.componentWrappers, 0, componentWrapperArray, 0, n3);
        }
        if ((n2 = this.componentWrappers.length - (n = n3 + 1)) > 0) {
            System.arraycopy(this.componentWrappers, n, componentWrapperArray, n3, n2);
        }
        this.componentWrappers = componentWrapperArray;
        this.remove(componentWrapper.getComponent());
    }

    public ComponentWrapper[] getComponentWrappers() {
        return this.componentWrappers;
    }

    public void getVisibleRectangle(Rectangle rectangle) {
        this.computeVisibleRect(rectangle);
    }

    public void makeRectangleVisible(int n, int n2, int n3, int n4) {
        this.rect.x = n;
        this.rect.y = n2;
        this.rect.width = n3;
        this.rect.height = n4;
        this.scrollRectToVisible(this.rect);
    }

    public void showMenu(MenuSpec menuSpec, int n, int n2, Gadget gadget) {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        if (menuSpec.label != null) {
            jPopupMenu.setLabel(menuSpec.label);
        }
        Point point = new Point(n, n2);
        gadget.panelToGadget(point);
        GadgetPanel.addMenuItems(jPopupMenu, null, menuSpec, gadget, point);
        this.showPopupMenu(n, n2);
    }

    private static void addMenuItems(JPopupMenu jPopupMenu, JMenu jMenu, MenuSpec menuSpec, final Gadget gadget, final Point point) {
        MenuItemSpec[] menuItemSpecArray = menuSpec.items;
        int n = 0;
        while (n < menuItemSpecArray.length) {
            JMenuItem jMenuItem;
            final MenuItemSpec menuItemSpec = menuItemSpecArray[n];
            if (menuItemSpec instanceof MenuSpec) {
                jMenuItem = new JMenu(menuItemSpec.label);
                if (jPopupMenu == null) {
                    jMenu.add(jMenuItem);
                } else {
                    jPopupMenu.add(jMenuItem);
                }
                GadgetPanel.addMenuItems(null, (JMenu)jMenuItem, (MenuSpec)menuItemSpec, gadget, point);
            } else if (menuItemSpec.label == null) {
                if (jPopupMenu == null) {
                    jMenu.addSeparator();
                } else {
                    jPopupMenu.addSeparator();
                }
            } else {
                String string = GadgetPanel.menuItemLabel(menuItemSpec);
                jMenuItem = jPopupMenu == null ? jMenu.add(string) : jPopupMenu.add(string);
                Command command = menuItemSpec.command;
                if (command == null) {
                    command = gadget;
                }
                boolean bl = command.prepareCommand(gadget, menuItemSpec.parameter, point.x, point.y);
                jMenuItem.setEnabled(bl);
                if (bl) {
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Command command = menuItemSpec.command;
                            if (command == null) {
                                command = gadget;
                            }
                            if (command.prepareCommand(gadget, menuItemSpec.parameter, point.x, point.y)) {
                                command.executeCommand(gadget, menuItemSpec.parameter, point.x, point.y);
                            }
                        }
                    });
                }
            }
            ++n;
        }
    }

    private static final String menuItemLabel(MenuItemSpec menuItemSpec) {
        if (menuItemSpec.shortcut == null) {
            return menuItemSpec.label;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(menuItemSpec.label);
        stringBuffer.append(" [");
        stringBuffer.append(menuItemSpec.shortcut);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    GadgetPanel.this.popupMenuHidden = false;
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    GadgetPanel.this.popupMenuHidden = true;
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
        } else {
            this.popupMenu.removeAll();
            this.popupMenu.setLabel(null);
        }
        return this.popupMenu;
    }

    protected void showPopupMenu(int n, int n2) {
        this.popupMenu.show(this, n, n2);
        this.popupMenuPopped = true;
    }

    public void setActiveComponentImage(ComponentImage componentImage, Component component) {
        if (this.activeComponentImage != null) {
            Component component2 = this.activeComponent;
            this.activeComponentImage = null;
            this.activeComponent = null;
            this.remove(component2);
        }
        if (componentImage != null) {
            this.add(component);
            this.activeComponent = component;
            this.activeComponentImage = componentImage;
        }
    }

    public ComponentImage getActiveComponentImage() {
        return this.activeComponentImage;
    }

    public Component getActiveComponent() {
        return this.activeComponent;
    }

    public void renderPassiveComponent(Graphics graphics, Component component, int n, int n2) {
        this.getCellRendererPane().paintComponent(graphics, component, this, n, n2, component.getWidth(), component.getHeight(), false);
    }
}

