/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.gadget;

import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetContainer;
import com.xmlmind.xmledit.gadget.GadgetHost;
import com.xmlmind.xmledit.gadget.PaintUtil;
import com.xmlmind.xmledit.gadget.PrintCanceledException;
import com.xmlmind.xmledit.gadget.PrintInvoker;
import com.xmlmind.xmledit.gadget.RootGadget;
import com.xmlmind.xmledit.util.StringUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public class GadgetPrinter
implements Printable {
    private double screenResolution = -1.0;
    private PrintInvoker invoker = null;
    private String headerBegin = null;
    private String headerMiddle = null;
    private String headerEnd = null;
    private Font headerFont = new Font("SansSerif", 0, 12);
    private Color headerColor = Color.black;
    private boolean underlineHeader = false;
    private int headerGap = -1;
    private String footerBegin = null;
    private String footerMiddle = null;
    private String footerEnd = null;
    private Font footerFont = this.headerFont;
    private Color footerColor = this.headerColor;
    private boolean overlineFooter = false;
    private int footerGap = -1;
    private Gadget printedGadget;
    private Container gadgetPanel;
    private double pageLeft;
    private double pageTop;
    private int pageWidth;
    private int pageHeight;
    private boolean firstPage;
    private Dimension savedConstraints = new Dimension();
    private int printedLeft;
    private int printedTop;
    private int printedWidth;
    private int printedHeight;
    private double bodyTop;
    private int bodyMaxHeight;
    private int[] boundaries;
    private static AtomCompare atomCompare = new AtomCompare();
    private static final char[] VAR_NAMES = new char[]{'I', 'C'};

    public void setInvoker(PrintInvoker printInvoker) {
        this.invoker = printInvoker;
    }

    public PrintInvoker getInvoker() {
        return this.invoker;
    }

    public void setScreenResolution(double d) {
        this.screenResolution = d;
    }

    public double getScreenResolution() {
        return this.screenResolution;
    }

    public void setHeaderBegin(String string) {
        this.headerBegin = string;
    }

    public String getHeaderBegin() {
        return this.headerBegin;
    }

    public void setHeaderMiddle(String string) {
        this.headerMiddle = string;
    }

    public String getHeaderMiddle() {
        return this.headerMiddle;
    }

    public void setHeaderEnd(String string) {
        this.headerEnd = string;
    }

    public String getHeaderEnd() {
        return this.headerEnd;
    }

    public void setHeaderFont(Font font) {
        this.headerFont = font;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public void setHeaderColor(Color color) {
        this.headerColor = color;
    }

    public Color getHeaderColor() {
        return this.headerColor;
    }

    public void setHeaderUnderlined(boolean bl) {
        this.underlineHeader = bl;
    }

    public boolean isHeaderUnderlined() {
        return this.underlineHeader;
    }

    public void setHeaderGap(int n) {
        this.headerGap = n;
    }

    public int getHeaderGap() {
        return this.headerGap;
    }

    public void setFooterBegin(String string) {
        this.footerBegin = string;
    }

    public String getFooterBegin() {
        return this.footerBegin;
    }

    public void setFooterMiddle(String string) {
        this.footerMiddle = string;
    }

    public String getFooterMiddle() {
        return this.footerMiddle;
    }

    public void setFooterEnd(String string) {
        this.footerEnd = string;
    }

    public String getFooterEnd() {
        return this.footerEnd;
    }

    public void setFooterFont(Font font) {
        this.footerFont = font;
    }

    public Font getFooterFont() {
        return this.footerFont;
    }

    public void setFooterColor(Color color) {
        this.footerColor = color;
    }

    public Color getFooterColor() {
        return this.footerColor;
    }

    public void setFooterOverlined(boolean bl) {
        this.overlineFooter = bl;
    }

    public boolean isFooterOverlined() {
        return this.overlineFooter;
    }

    public void setFooterGap(int n) {
        this.footerGap = n;
    }

    public int getFooterGap() {
        return this.footerGap;
    }

    public void begin(Gadget gadget, PageFormat pageFormat) {
        this.printedGadget = gadget;
        this.gadgetPanel = gadget.getPanel();
        if (this.screenResolution <= 0.0) {
            this.screenResolution = this.gadgetPanel.getToolkit().getScreenResolution();
        }
        this.pageLeft = pageFormat.getImageableX() * this.screenResolution / 72.0;
        this.pageTop = pageFormat.getImageableY() * this.screenResolution / 72.0;
        this.pageWidth = (int)(pageFormat.getImageableWidth() * this.screenResolution / 72.0);
        this.pageHeight = (int)(pageFormat.getImageableHeight() * this.screenResolution / 72.0);
        this.firstPage = true;
    }

    private void beginPrinting(Graphics graphics) {
        Cloneable cloneable;
        PaintUtil.setPrintGraphics(graphics);
        RootGadget rootGadget = ((GadgetHost)((Object)this.gadgetPanel)).getRoot();
        if (rootGadget.getChildCount() > 0) {
            rootGadget.getSizeConstraints(rootGadget.getChild(0), this.savedConstraints);
            cloneable = this.gadgetPanel.getInsets();
            if (this.savedConstraints.width > 0) {
                this.savedConstraints.width += cloneable.left + cloneable.right;
            }
            if (this.savedConstraints.height > 0) {
                this.savedConstraints.height += cloneable.top + cloneable.bottom;
            }
            rootGadget.layout(this.pageWidth + (cloneable.left + cloneable.right), -1);
        }
        this.printedWidth = this.printedGadget.width;
        this.printedHeight = this.printedGadget.height;
        cloneable = new Point(0, 0);
        this.printedGadget.gadgetToPanel((Point)cloneable);
        this.printedLeft = ((Point)cloneable).x;
        this.printedTop = ((Point)cloneable).y;
        this.splitInPages();
    }

    private void splitInPages() {
        int n;
        FontMetrics fontMetrics;
        this.bodyTop = this.pageTop;
        this.bodyMaxHeight = this.pageHeight;
        if (this.headerBegin != null || this.headerMiddle != null || this.headerEnd != null) {
            fontMetrics = PaintUtil.getFontMetrics(this.headerFont, this.gadgetPanel);
            n = GadgetPrinter.lineHeight(fontMetrics);
            this.bodyMaxHeight -= n;
            this.bodyTop += (double)n;
            if (this.headerGap <= 0) {
                this.headerGap = n;
            }
            this.bodyMaxHeight -= this.headerGap;
            this.bodyTop += (double)this.headerGap;
        }
        if (this.footerBegin != null || this.footerMiddle != null || this.footerEnd != null) {
            fontMetrics = PaintUtil.getFontMetrics(this.footerFont, this.gadgetPanel);
            n = GadgetPrinter.lineHeight(fontMetrics);
            this.bodyMaxHeight -= n;
            if (this.footerGap <= 0) {
                this.footerGap = n;
            }
            this.bodyMaxHeight -= this.footerGap;
        }
        this.computeBoundaries();
    }

    private static final int lineHeight(FontMetrics fontMetrics) {
        return (int)Math.rint((double)fontMetrics.getHeight() * 1.5);
    }

    private void computeBoundaries() {
        Atom[] atomArray = GadgetPrinter.groupAtoms(this.listAtoms());
        int[] nArray = new int[100];
        int n = 0;
        int n2 = this.printedTop;
        int n3 = this.printedTop + this.printedHeight;
        do {
            nArray = GadgetPrinter.addInt(nArray, n, n2);
            ++n;
            int n4 = n2 + this.bodyMaxHeight;
            if (n4 >= n3) {
                n2 = n3;
                continue;
            }
            if ((n2 = GadgetPrinter.checkBoundary(n4, atomArray, n2)) >= 0) continue;
            n2 = n4;
        } while (n2 < n3);
        this.boundaries = new int[n];
        System.arraycopy(nArray, 0, this.boundaries, 0, n);
    }

    private static final int checkBoundary(int n, Atom[] atomArray, int n2) {
        Atom atom = GadgetPrinter.findSplitAtom(atomArray, n);
        if (atom == null) {
            return n;
        }
        n = atom.y1;
        if (n <= n2) {
            return -1;
        }
        return n;
    }

    private static final Atom findSplitAtom(Atom[] atomArray, int n) {
        int n2 = atomArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Atom atom = atomArray[n3];
            if (atom.y1 >= n) {
                return null;
            }
            if (n > atom.y1 && n <= atom.y2) {
                return atom;
            }
            ++n3;
        }
        return null;
    }

    private static final int[] addInt(int[] nArray, int n, int n2) {
        if (n >= nArray.length) {
            int[] nArray2 = new int[Math.max(10, 2 * nArray.length)];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            nArray = nArray2;
        }
        nArray[n] = n2;
        return nArray;
    }

    private Atom[] listAtoms() {
        Vector vector = new Vector();
        GadgetPrinter.listAtoms(this.printedGadget, this.printedTop, vector);
        Object[] objectArray = new Atom[vector.size()];
        vector.copyInto(objectArray);
        Arrays.sort(objectArray, atomCompare);
        return objectArray;
    }

    private static final void listAtoms(Gadget gadget, int n, Vector vector) {
        int n2;
        int[] nArray = gadget.getNonBreakableVerticalRanges();
        if (nArray != null) {
            int n3 = nArray.length / 2 * 2;
            n2 = 0;
            while (n2 < n3) {
                int n4 = nArray[n2 + 1];
                int n5 = nArray[n2];
                if (n4 >= n5) {
                    vector.addElement(new Atom(n + n5, n + n4));
                }
                n2 += 2;
            }
        }
        if (gadget instanceof GadgetContainer) {
            Gadget[] gadgetArray = ((GadgetContainer)gadget).getChildren();
            n2 = 0;
            while (n2 < gadgetArray.length) {
                Gadget gadget2 = gadgetArray[n2];
                GadgetPrinter.listAtoms(gadget2, n + gadget2.y, vector);
                ++n2;
            }
        }
    }

    private static final Atom[] groupAtoms(Atom[] atomArray) {
        Object[] objectArray;
        Vector<Atom> vector = new Vector<Atom>();
        Atom atom = null;
        int n = 0;
        while (n < atomArray.length) {
            objectArray = atomArray[n];
            if (atom == null || objectArray.y1 > atom.y2) {
                atom = new Atom(objectArray.y1, objectArray.y2);
                vector.addElement(atom);
            } else {
                atom.y2 = Math.max(objectArray.y2, atom.y2);
            }
            ++n;
        }
        objectArray = new Atom[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        String string;
        String string2;
        String string3;
        int n2;
        int n3;
        FontMetrics fontMetrics;
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = 72.0 / this.screenResolution;
        graphics2D.scale(d, d);
        if (this.firstPage) {
            this.firstPage = false;
            this.beginPrinting(graphics2D);
        }
        if (n >= this.boundaries.length) {
            return 1;
        }
        if (this.invoker != null && !this.invoker.printingPage(this, n, this.boundaries.length)) {
            throw new PrintCanceledException(this);
        }
        graphics2D.clipRect((int)this.pageLeft, (int)this.pageTop, this.pageWidth, this.pageHeight);
        graphics2D.translate(this.pageLeft, 0.0);
        if (this.headerBegin != null || this.headerMiddle != null || this.headerEnd != null) {
            graphics2D.setColor(this.headerColor);
            graphics2D.setFont(this.headerFont);
            fontMetrics = graphics2D.getFontMetrics();
            n3 = GadgetPrinter.lineHeight(fontMetrics);
            n2 = fontMetrics.getAscent();
            graphics2D.translate(0.0, this.pageTop);
            string3 = null;
            string2 = null;
            string = null;
            if (this.headerBegin != null) {
                string3 = GadgetPrinter.substituteVars(this.headerBegin, n, this.boundaries.length);
            }
            if (this.headerMiddle != null) {
                string2 = GadgetPrinter.substituteVars(this.headerMiddle, n, this.boundaries.length);
            }
            if (this.headerEnd != null) {
                string = GadgetPrinter.substituteVars(this.headerEnd, n, this.boundaries.length);
            }
            GadgetPrinter.drawHeader(graphics2D, string3, string2, string, fontMetrics, n2, this.pageWidth, n3);
            if (this.underlineHeader) {
                int n4 = n3 - 1;
                graphics2D.drawLine(0, n4, this.pageWidth - 1, n4);
            }
            graphics2D.translate(0.0, -this.pageTop);
        }
        if (this.footerBegin != null || this.footerMiddle != null || this.footerEnd != null) {
            graphics2D.setColor(this.footerColor);
            graphics2D.setFont(this.footerFont);
            fontMetrics = graphics2D.getFontMetrics();
            n3 = GadgetPrinter.lineHeight(fontMetrics);
            n2 = n3 - fontMetrics.getDescent();
            graphics2D.translate(0.0, this.pageTop + (double)this.pageHeight - (double)n3);
            if (this.overlineFooter) {
                graphics2D.drawLine(0, 0, this.pageWidth - 1, 0);
            }
            string3 = null;
            string2 = null;
            string = null;
            if (this.footerBegin != null) {
                string3 = GadgetPrinter.substituteVars(this.footerBegin, n, this.boundaries.length);
            }
            if (this.footerMiddle != null) {
                string2 = GadgetPrinter.substituteVars(this.footerMiddle, n, this.boundaries.length);
            }
            if (this.footerEnd != null) {
                string = GadgetPrinter.substituteVars(this.footerEnd, n, this.boundaries.length);
            }
            GadgetPrinter.drawHeader(graphics2D, string3, string2, string, fontMetrics, n2, this.pageWidth, n3);
            graphics2D.translate(0.0, -(this.pageTop + (double)this.pageHeight - (double)n3));
        }
        int n5 = this.boundaries[n];
        graphics2D.translate((double)(-this.printedLeft), this.bodyTop - (double)n5);
        n3 = n + 1 < this.boundaries.length ? this.boundaries[n + 1] - n5 : this.printedTop + this.printedHeight - n5;
        graphics.clipRect(this.printedLeft, n5, this.printedWidth, n3);
        this.gadgetPanel.print(graphics);
        return 0;
    }

    private static final String substituteVars(String string, int n, int n2) {
        if (string.indexOf(37) < 0) {
            return string;
        }
        Object[] objectArray = new Object[]{new Integer(1 + n), new Integer(n2)};
        return StringUtil.substituteVars(string, VAR_NAMES, objectArray);
    }

    private static final void drawHeader(Graphics2D graphics2D, String string, String string2, String string3, FontMetrics fontMetrics, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 2 * fontMetrics.charWidth('x');
        if (string2 == null) {
            if (string == null) {
                n9 = 0;
                n10 = n2;
            } else if (string3 == null) {
                n5 = 0;
                n6 = n2;
            } else {
                n4 = (n2 - n11) / 2;
                n5 = 0;
                n6 = n4;
                n9 = n4 + n11;
                n10 = n4;
            }
        } else if (string == null && string3 == null) {
            n7 = 0;
            n8 = n2;
        } else {
            n4 = (n2 - 2 * n11) / 3;
            n5 = 0;
            n6 = n4;
            n7 = n4 + n11;
            n8 = n4;
            n9 = 2 * (n4 + n11);
            n10 = n4;
        }
        if (string != null && n6 > 0) {
            if (n6 == n2) {
                graphics2D.drawString(string, 0, n);
            } else {
                Graphics graphics = graphics2D.create(n5, 0, n6, n3);
                graphics.drawString(string, 0, n);
                graphics.dispose();
            }
        }
        if (string2 != null && n8 > 0) {
            if (n8 == n2) {
                graphics2D.drawString(string2, (n2 - fontMetrics.stringWidth(string2)) / 2, n);
            } else {
                Graphics graphics = graphics2D.create(n7, 0, n8, n3);
                graphics.drawString(string2, (n8 - fontMetrics.stringWidth(string2)) / 2, n);
                graphics.dispose();
            }
        }
        if (string3 != null && n10 > 0) {
            if (n10 == n2) {
                graphics2D.drawString(string3, n2 - fontMetrics.stringWidth(string3), n);
            } else {
                Graphics graphics = graphics2D.create(n9, 0, n10, n3);
                graphics.drawString(string3, n10 - fontMetrics.stringWidth(string3), n);
                graphics.dispose();
            }
        }
    }

    public void end() {
        this.firstPage = false;
        PaintUtil.setPrintGraphics(null);
        RootGadget rootGadget = ((GadgetHost)((Object)this.gadgetPanel)).getRoot();
        if (rootGadget.getChildCount() > 0) {
            rootGadget.layout(this.savedConstraints.width, this.savedConstraints.height);
            rootGadget.repaint();
        }
        if (this.invoker != null) {
            this.invoker.printingPage(this, this.boundaries.length, this.boundaries.length);
        }
        this.boundaries = null;
    }

    private static class AtomCompare
    implements Comparator {
        private AtomCompare() {
        }

        public int compare(Object object, Object object2) {
            return ((Atom)object).y1 - ((Atom)object2).y1;
        }
    }

    public static final class Atom {
        public int y1;
        public int y2;

        public Atom(int n, int n2) {
            this.y1 = n;
            this.y2 = n2;
        }
    }
}

