/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.gadget;

import com.xmlmind.xmledit.util.JavaVersion;
import com.xmlmind.xmledit.util.PlatformUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.print.PrinterGraphics;
import javax.swing.JLabel;

public final class PaintUtil {
    private static Graphics printGraphics = null;
    private static Component anyComponent = null;
    private static final boolean FORCE_ANTIALIAS_OFF = PaintUtil.forceAntialiasOff();

    public static void setPrintGraphics(Graphics graphics) {
        printGraphics = graphics;
    }

    public static Graphics getPrintGraphics() {
        return printGraphics;
    }

    public static FontMetrics getFontMetrics(Font font, Component component) {
        if (printGraphics == null) {
            if (component == null) {
                if (anyComponent == null) {
                    anyComponent = new JLabel();
                }
                component = anyComponent;
            }
            return component.getFontMetrics(font);
        }
        return printGraphics.getFontMetrics(font);
    }

    private static final boolean forceAntialiasOff() {
        if (PlatformUtil.IS_MAC_OS) {
            return JavaVersion.get().compareTo(new JavaVersion(1, 4, 2, 5)) < 0;
        }
        return false;
    }

    public static final void configureTextRendering(Graphics graphics) {
        if (FORCE_ANTIALIAS_OFF && !(graphics instanceof PrinterGraphics)) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
    }

    public static final int defaultCharWidth(FontMetrics fontMetrics) {
        return fontMetrics.charWidth('x');
    }

    public static final int charWidth(FontMetrics fontMetrics, char c) {
        int n = fontMetrics.charWidth(c);
        if (n == 0) {
            n = fontMetrics.charWidth('x');
        }
        return n;
    }

    public static final int charsWidth(FontMetrics fontMetrics, char[] cArray, int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = n;
        int n7 = 0;
        int n8 = 0;
        int n9 = n + n2;
        int n10 = n;
        while (n10 < n9) {
            switch (cArray[n10]) {
                case '\t': 
                case '\r': {
                    if (n3 < 0) {
                        n3 = fontMetrics.charWidth('x');
                        n4 = fontMetrics.getAscent();
                        n5 = fontMetrics.getDescent();
                    }
                    if (n7 > 0) {
                        n8 += fontMetrics.charsWidth(cArray, n6, n7);
                    }
                    n8 += n3;
                    n6 = n10 + 1;
                    n7 = 0;
                    break;
                }
                default: {
                    ++n7;
                }
            }
            ++n10;
        }
        if (n7 > 0) {
            n8 += fontMetrics.charsWidth(cArray, n6, n7);
        }
        return n8;
    }

    public static final void drawChars(Graphics graphics, FontMetrics fontMetrics, char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = n;
        int n9 = 0;
        int n10 = n + n2;
        int n11 = n;
        while (n11 < n10) {
            switch (cArray[n11]) {
                case '\t': 
                case '\r': 
                case '\u00a0': {
                    if (n5 < 0) {
                        n5 = fontMetrics.charWidth('x');
                        n6 = fontMetrics.getAscent();
                        n7 = fontMetrics.getDescent();
                    }
                    if (n9 > 0) {
                        graphics.drawChars(cArray, n8, n9, n3, n4);
                        n3 += fontMetrics.charsWidth(cArray, n8, n9);
                    }
                    if (cArray[n11] == '\u00a0') {
                        int n12 = fontMetrics.charWidth('\u00a0');
                        int n13 = n3 + n12 / 2;
                        int n14 = n4 + (n7 - n6) / 2;
                        graphics.drawLine(n13, n14, n13, n14);
                        n3 += n12;
                    } else {
                        graphics.drawRect(n3, n4 - n6, n5 - 1, n6 + n7 - 1);
                        n3 += n5;
                    }
                    n8 = n11 + 1;
                    n9 = 0;
                    break;
                }
                default: {
                    ++n9;
                }
            }
            ++n11;
        }
        if (n9 > 0) {
            graphics.drawChars(cArray, n8, n9, n3, n4);
        }
    }

    public static final void drawChars2(Graphics graphics, FontMetrics fontMetrics, char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = n;
        int n9 = 0;
        int n10 = n + n2;
        int n11 = n;
        while (n11 < n10) {
            switch (cArray[n11]) {
                case '\t': 
                case '\r': 
                case '\u00a0': {
                    if (n5 < 0) {
                        n5 = fontMetrics.charWidth('x');
                        n6 = fontMetrics.getAscent();
                        n7 = fontMetrics.getDescent();
                    }
                    if (n9 > 0) {
                        graphics.drawChars(cArray, n8, n9, n3, n4);
                        n3 += n9 * n5;
                    }
                    if (cArray[n11] == '\u00a0') {
                        int n12 = n3 + n5 / 2;
                        int n13 = n4 + (n7 - n6) / 2;
                        graphics.drawLine(n12, n13, n12, n13);
                    } else {
                        graphics.drawRect(n3, n4 - n6, n5 - 1, n6 + n7 - 1);
                    }
                    n3 += n5;
                    n8 = n11 + 1;
                    n9 = 0;
                    break;
                }
                default: {
                    ++n9;
                }
            }
            ++n11;
        }
        if (n9 > 0) {
            graphics.drawChars(cArray, n8, n9, n3, n4);
        }
    }
}

