/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.gadget;

import com.xmlmind.xmledit.gadget.EventDispatcher;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetContainer;
import com.xmlmind.xmledit.gadget.GadgetHost;
import com.xmlmind.xmledit.gadget.MenuSpec;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

public class RootGadget
extends GadgetContainer {
    protected Container panel;
    protected EventDispatcher eventDispatcher;
    protected int constrainedWidth = -1;
    protected int constrainedHeight = -1;
    private Rectangle r1 = new Rectangle();
    private Rectangle r2 = new Rectangle();
    private Rectangle r3 = new Rectangle();

    public RootGadget(Container container) {
        this.panel = container;
        this.eventDispatcher = this.createEventDispatcher();
    }

    protected EventDispatcher createEventDispatcher() {
        return new EventDispatcher(this);
    }

    public Container getPanel() {
        return this.panel;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public void gadgetToPanel(Point point) {
        Insets insets = this.panel.getInsets();
        point.x += insets.left;
        point.y += insets.top;
    }

    public void panelToGadget(Point point) {
        Insets insets = this.panel.getInsets();
        point.x -= insets.left;
        point.y -= insets.top;
    }

    public Rectangle getVisibleRectangle() {
        ((GadgetHost)((Object)this.panel)).getVisibleRectangle(this.r1);
        Insets insets = this.panel.getInsets();
        this.r1.x -= insets.left;
        this.r1.y -= insets.top;
        this.r2.x = 0;
        this.r2.y = 0;
        this.r2.width = this.width;
        this.r2.height = this.height;
        RootGadget.intersection(this.r1, this.r2, this.r3);
        return this.r3;
    }

    public void makeRectangleVisible(int n, int n2, int n3, int n4) {
        Insets insets = this.panel.getInsets();
        ((GadgetHost)((Object)this.panel)).makeRectangleVisible(n + insets.left, n2 + insets.top, n3, n4);
    }

    public void insertChild(int n, Gadget gadget) {
        if (this.children.length > 0) {
            this.removeChild(0);
        }
        super.insertChild(0, gadget);
    }

    public void refresh() {
        int n = this.width;
        int n2 = this.height;
        this.layout(this.constrainedWidth, this.constrainedHeight, true);
        int n3 = this.width > n ? this.width : n;
        int n4 = this.height > n2 ? this.height : n2;
        this.repaint(0, 0, n3, n4);
    }

    public void relayout(boolean bl) {
        this.layout(this.constrainedWidth, this.constrainedHeight, bl);
    }

    public void getSizeConstraints(Gadget gadget, Dimension dimension) {
        Insets insets = this.panel.getInsets();
        dimension.width = this.constrainedWidth > 0 ? this.constrainedWidth - (insets.left + insets.right) : -1;
        dimension.height = this.constrainedHeight > 0 ? this.constrainedHeight - (insets.top + insets.bottom) : -1;
    }

    public void layout(int n, int n2, boolean bl) {
        int n3 = this.width;
        int n4 = this.height;
        this.constrainedWidth = n;
        this.constrainedHeight = n2;
        if (this.children.length == 0) {
            this.width = 1;
            this.height = 1;
        } else {
            Gadget gadget = this.children[0];
            if (bl) {
                Insets insets = this.panel.getInsets();
                if (n > 0) {
                    n -= insets.left + insets.right;
                }
                if (n2 > 0) {
                    n2 -= insets.top + insets.bottom;
                }
                gadget.layout(n, n2, true);
            }
            this.width = gadget.width;
            this.height = gadget.height;
            gadget.y = 0;
            gadget.x = 0;
        }
        if (this.width != n3 || this.height != n4) {
            ((GadgetHost)((Object)this.panel)).revalidate();
        }
    }

    public void paintRelayout(Gadget gadget, int n, int n2, int n3, int n4) {
        int n5 = this.width;
        int n6 = this.height;
        this.width = gadget.width;
        this.height = gadget.height;
        ((GadgetHost)((Object)this.panel)).revalidate();
        int n7 = this.width > n5 ? this.width : n5;
        int n8 = this.height > n6 ? this.height : n6;
        switch (n3) {
            case 4: {
                this.repaint(this.width - n4, 0, n4 + (n7 - this.width), n8);
                break;
            }
            case 2: {
                this.repaint(0, this.height - n4, n7, n4 + (n8 - this.height));
                break;
            }
            default: {
                this.repaint(0, 0, n7, n8);
            }
        }
    }

    public void repaint(int n, int n2, int n3, int n4) {
        Insets insets = this.panel.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        this.r1.x = n5 + n;
        this.r1.y = n6 + n2;
        this.r1.width = n3;
        this.r1.height = n4;
        ((GadgetHost)((Object)this.panel)).getVisibleRectangle(this.r2);
        RootGadget.intersection(this.r1, this.r2, this.r3);
        if (this.r3.width > 0) {
            this.panel.repaint(this.r3.x, this.r3.y, this.r3.width, this.r3.height);
        }
    }

    protected static final void intersection(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n = Math.max(rectangle.x, rectangle2.x);
        int n2 = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
        int n3 = Math.max(rectangle.y, rectangle2.y);
        int n4 = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
        if (n2 - n < 0 || n4 - n3 < 0) {
            rectangle3.x = 0;
            rectangle3.y = 0;
            rectangle3.width = 0;
            rectangle3.height = 0;
        } else {
            rectangle3.x = n;
            rectangle3.y = n3;
            rectangle3.width = n2 - n;
            rectangle3.height = n4 - n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (this.children.length > 0) {
            Gadget gadget = this.children[0];
            Graphics graphics2 = graphics.create(0, 0, this.width, this.height);
            try {
                gadget.paint(graphics2);
                Object var5_4 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Graphics graphics) {
        if (this.children.length > 0) {
            Gadget gadget = this.children[0];
            Graphics graphics2 = graphics.create(0, 0, this.width, this.height);
            try {
                gadget.print(graphics2);
                Object var5_4 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                graphics2.dispose();
                throw throwable;
            }
        }
    }

    public Graphics getGraphics() {
        Insets insets = this.panel.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        Graphics graphics = this.panel.getGraphics();
        if (graphics != null) {
            graphics.translate(n, n2);
            graphics.clipRect(0, 0, this.width, this.height);
        }
        return graphics;
    }

    void showMenu(MenuSpec menuSpec, int n, int n2, Gadget gadget) {
        Insets insets = this.panel.getInsets();
        int n3 = insets.left;
        int n4 = insets.top;
        ((GadgetHost)((Object)this.panel)).showMenu(menuSpec, n3 + n, n4 + n2, gadget);
    }
}

