/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.gadget;

import java.awt.event.KeyEvent;
import java.util.Hashtable;

public final class UserInput {
    public static final int NOT_A_MOUSE_EVENT = 508;
    private int mouseButton;
    private char keyChar;
    private int keyCode;
    private int modifiers;
    private int mouseEventId;
    private int mouseClickCount;
    private static Hashtable userInputs = new Hashtable();
    private static UserInput probe = new UserInput();
    private static final int BUTTONS_MASK = 28;
    private static final int MODIFIERS_MASK = 47;

    public static UserInput get(int n, int n2, int n3) {
        return UserInput.get(n, n2, n3, n3 == 500 ? 1 : 0);
    }

    public static UserInput get(int n, int n2, int n3, int n4) {
        probe.init(n, n2, n3, n4);
        UserInput userInput = (UserInput)userInputs.get(probe);
        if (userInput == null) {
            userInput = new UserInput(n, n2, n3, n4);
            userInputs.put(userInput, userInput);
        }
        return userInput;
    }

    private UserInput(int n, int n2, int n3, int n4) {
        this.init(n, n2, n3, n4);
    }

    private void init(int n, int n2, int n3, int n4) {
        this.mouseButton = n & 0x1C;
        this.modifiers = n2 & 0x2F;
        this.mouseEventId = n3;
        this.mouseClickCount = n4;
        this.keyChar = (char)65535;
        this.keyCode = 0;
    }

    public static UserInput get(int n, int n2) {
        probe.init(n, n2);
        UserInput userInput = (UserInput)userInputs.get(probe);
        if (userInput == null) {
            userInput = new UserInput(n, n2);
            userInputs.put(userInput, userInput);
        }
        return userInput;
    }

    private UserInput(int n, int n2) {
        this.init(n, n2);
    }

    private void init(int n, int n2) {
        this.keyCode = n;
        this.modifiers = n2 & 0x2F;
        this.keyChar = (char)65535;
        this.mouseButton = -1;
        this.mouseEventId = 508;
        this.mouseClickCount = -1;
    }

    public static UserInput get(char c) {
        probe.init(c);
        UserInput userInput = (UserInput)userInputs.get(probe);
        if (userInput == null) {
            userInput = new UserInput(c);
            userInputs.put(userInput, userInput);
        }
        return userInput;
    }

    private UserInput(char c) {
        this.init(c);
    }

    private void init(char c) {
        this.keyChar = c;
        this.keyCode = 0;
        this.modifiers = 0;
        this.mouseButton = -1;
        this.mouseEventId = 508;
        this.mouseClickCount = -1;
    }

    private UserInput() {
    }

    public int getMouseButton() {
        return this.mouseButton;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public int getMouseEventId() {
        return this.mouseEventId;
    }

    public int getMouseClickCount() {
        return this.mouseClickCount;
    }

    public char getKeyChar() {
        return this.keyChar;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int hashCode() {
        int n = this.mouseButton;
        n ^= this.keyChar;
        n ^= this.keyCode;
        n ^= this.modifiers;
        n ^= this.mouseEventId;
        return n ^= this.mouseClickCount;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof UserInput)) {
            return false;
        }
        UserInput userInput = (UserInput)object;
        return this.mouseButton == userInput.mouseButton && this.keyChar == userInput.keyChar && this.keyCode == userInput.keyCode && this.modifiers == userInput.modifiers && this.mouseEventId == userInput.mouseEventId && this.mouseClickCount == userInput.mouseClickCount;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
        if (this.modifiers != 0) {
            stringBuffer.append(KeyEvent.getKeyModifiersText(this.modifiers));
            stringBuffer.append('-');
        }
        if (this.mouseEventId != 508) {
            block0 : switch (this.mouseEventId) {
                case 501: {
                    stringBuffer.append("Press-");
                    break;
                }
                case 506: {
                    stringBuffer.append("Drag-");
                    break;
                }
                case 502: {
                    stringBuffer.append("Release-");
                    break;
                }
                case 500: {
                    switch (this.mouseClickCount) {
                        case 1: {
                            stringBuffer.append("Click-");
                            break block0;
                        }
                        case 2: {
                            stringBuffer.append("Double-Click-");
                            break block0;
                        }
                        case 3: {
                            stringBuffer.append("Triple-Click-");
                            break block0;
                        }
                        case 4: {
                            stringBuffer.append("Quadruple-Click-");
                            break block0;
                        }
                    }
                    stringBuffer.append(this.mouseClickCount);
                    stringBuffer.append("-Click-");
                }
            }
            switch (this.mouseButton) {
                case 16: {
                    stringBuffer.append(1);
                    break;
                }
                case 8: {
                    stringBuffer.append(2);
                    break;
                }
                case 4: {
                    stringBuffer.append(3);
                }
            }
        } else if (this.keyChar != '\uffff') {
            stringBuffer.append(this.keyChar);
        } else {
            stringBuffer.append(KeyEvent.getKeyText(this.keyCode));
        }
    }
}

