/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.guiutil;

import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.Msg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.html.HTMLEditorKit;

public final class Alert {
    private static final String errorLabel = Msg.msg("error");
    private static final String warningLabel = Msg.msg("warning");
    private static final String infoLabel = Msg.msg("info");

    public static void showError(Component component, String string) {
        Alert.showAlert(component, string, 0);
    }

    public static void showWarning(Component component, String string) {
        Alert.showAlert(component, string, 2);
    }

    public static void showInfo(Component component, String string) {
        Alert.showAlert(component, string, 1);
    }

    private static void showAlert(Component component, Object object, int n) {
        String string;
        switch (n) {
            case 1: {
                string = infoLabel;
                break;
            }
            case 2: {
                string = warningLabel;
                break;
            }
            default: {
                string = errorLabel;
            }
        }
        JOptionPane.showMessageDialog(AWTUtil.getDialogAnchor(component), object, string, n);
    }

    public static void showError(Component component, String string, String[] stringArray) {
        Alert.showError(component, string, Alert.concatLines(stringArray), true, 25, 80);
    }

    public static void showWarning(Component component, String string, String[] stringArray) {
        Alert.showWarning(component, string, Alert.concatLines(stringArray), true, 25, 80);
    }

    public static void showInfo(Component component, String string, String[] stringArray) {
        Alert.showInfo(component, string, Alert.concatLines(stringArray), true, 25, 80);
    }

    private static final String concatLines(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            stringBuffer.append("\n\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void showError(Component component, String string, String string2, boolean bl, int n, int n2) {
        Object[] objectArray = Alert.createTextContent(string, string2, bl, n, n2);
        Alert.showAlert(component, objectArray, 0);
    }

    public static void showWarning(Component component, String string, String string2, boolean bl, int n, int n2) {
        Object[] objectArray = Alert.createTextContent(string, string2, bl, n, n2);
        Alert.showAlert(component, objectArray, 2);
    }

    public static void showInfo(Component component, String string, String string2, boolean bl, int n, int n2) {
        Object[] objectArray = Alert.createTextContent(string, string2, bl, n, n2);
        Alert.showAlert(component, objectArray, 1);
    }

    public static Object[] createTextContent(String string, String string2, boolean bl, int n, int n2) {
        JTextArea jTextArea = new JTextArea(string2, n, n2);
        Font font = jTextArea.getFont();
        String string3 = bl ? font.getFamily() : "Monospaced";
        jTextArea.setFont(new Font(string3, 0, Math.max(12, font.getSize() - 2)));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(bl);
        jTextArea.setWrapStyleWord(bl);
        return new Object[]{string, new JScrollPane(jTextArea)};
    }

    public static void showErrorHTML(Component component, String string, String string2, int n, int n2) {
        Object[] objectArray = Alert.createHTMLContent(string, string2, n, n2);
        Alert.showAlert(component, objectArray, 0);
    }

    public static void showWarningHTML(Component component, String string, String string2, int n, int n2) {
        Object[] objectArray = Alert.createHTMLContent(string, string2, n, n2);
        Alert.showAlert(component, objectArray, 2);
    }

    public static void showInfoHTML(Component component, String string, String string2, int n, int n2) {
        Object[] objectArray = Alert.createHTMLContent(string, string2, n, n2);
        Alert.showAlert(component, objectArray, 1);
    }

    public static Object[] createHTMLContent(String string, String string2, int n, int n2) {
        JEditorPane jEditorPane = new JEditorPane();
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)jEditorPane.getEditorKitForContentType("text/html");
        hTMLEditorKit.getStyleSheet().addRule("body { font-family: sans-serif; font-size: 12pt; }");
        jEditorPane.setEditorKit(hTMLEditorKit);
        jEditorPane.setEditable(false);
        try {
            jEditorPane.read(new StringReader(string2), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setPreferredSize(new Dimension(n, n2));
        jEditorPane.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
        return new Object[]{string, jScrollPane};
    }
}

