/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.guiutil;

import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.util.PlatformUtil;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AutoCompletion
implements FocusListener,
ComponentListener,
HierarchyBoundsListener,
DocumentListener,
KeyListener,
ActionListener,
Runnable {
    public static final ChoiceRenderer choiceRenderer = new ChoiceRenderer();
    public static final int AUTO_SUGGEST_UNSPECIFIED = 0;
    public static final int AUTO_SUGGEST_YES = 1;
    public static final int AUTO_SUGGEST_NO = 2;
    public static final int APPEND_MODE_UNSPECIFIED = 0;
    public static final int APPEND_MODE_AUTO = 1;
    public static final int APPEND_MODE_MANUAL = 2;
    public static final int APPEND_MODE_NONE = 3;
    private static boolean preferMinimalChoices = false;
    private static int defaultAutoSuggest = 1;
    private static int defaultAppendMode = 2;
    private static AWTKeyStroke[] defaultAppendKeyStrokes = new AWTKeyStroke[]{AWTKeyStroke.getAWTKeyStroke(112, 0)};
    private static int defaultVisibleSuggestionCount = 5;
    private static final int FIRST_KEY_CHAR1 = 32;
    private static final int LAST_KEY_CHAR1 = 126;
    private static final int FIRST_KEY_CHAR2 = 160;
    private static final int LAST_KEY_CHAR2 = 55295;
    private static final Object[] NO_DATA = new Object[0];
    private JTextField entry;
    private JList listbox;
    private Choices choices;
    private int autoSuggest;
    private int appendMode;
    private AWTKeyStroke[] appendKeyStrokes;
    private int visibleSuggestionCount;
    private ChoiceList choiceList = new ChoiceList();
    private boolean working = false;
    private Popup popup = null;
    private JScrollPane popupScrollPane = null;
    private JList popupList = null;

    public static final String toString(Object object) {
        return object == null || object instanceof PossibleChoice && !((PossibleChoice)object).isPossibleChoice() ? null : object.toString();
    }

    public static void setPreferMinimalChoices(boolean bl) {
        preferMinimalChoices = bl;
    }

    public static boolean getPreferMinimalChoices() {
        return preferMinimalChoices;
    }

    public static void setDefaultAutoSuggest(int n) {
        if (n < 1 || n > 2) {
            n = 2;
        }
        defaultAutoSuggest = n;
    }

    public static int getDefaultAutoSuggest() {
        return defaultAutoSuggest;
    }

    public static void setDefaultAppendMode(int n) {
        if (n < 1 || n > 3) {
            n = 3;
        }
        defaultAppendMode = n;
    }

    public static int getDefaultAppendMode() {
        return defaultAppendMode;
    }

    public static void setDefaultAppendKeyStrokes(AWTKeyStroke[] aWTKeyStrokeArray) {
        if (aWTKeyStrokeArray == null) {
            aWTKeyStrokeArray = new AWTKeyStroke[]{};
        }
        defaultAppendKeyStrokes = aWTKeyStrokeArray;
    }

    public static AWTKeyStroke[] getDefaultAppendKeyStrokes() {
        return defaultAppendKeyStrokes;
    }

    public static void setDefaultVisibleSuggestionCount(int n) {
        if (n < 2) {
            n = 2;
        }
        defaultVisibleSuggestionCount = n;
    }

    public static int getDefaultVisibleSuggestionCount() {
        return defaultVisibleSuggestionCount;
    }

    public AutoCompletion() {
        this(null);
    }

    public AutoCompletion(JTextField jTextField) {
        this.setTextField(jTextField);
    }

    public void setTextField(JTextField jTextField) {
        this.destroyPopup();
        if (this.entry != null) {
            this.entry.removeActionListener(this);
            this.entry.removeFocusListener(this);
            this.entry.removeComponentListener(this);
            this.entry.removeHierarchyBoundsListener(this);
            this.entry.getDocument().removeDocumentListener(this);
            this.entry.removeKeyListener(this);
            this.entry = null;
        }
        if (jTextField != null) {
            this.entry = jTextField;
            this.entry.addActionListener(this);
            this.entry.addFocusListener(this);
            this.entry.addComponentListener(this);
            this.entry.addHierarchyBoundsListener(this);
            this.entry.getDocument().addDocumentListener(this);
            this.entry.addKeyListener(this);
        }
    }

    private void destroyPopup() {
        this.hidePopup();
        if (this.popupList != null) {
            this.popupList = null;
            this.popupScrollPane = null;
        }
    }

    private void hidePopup() {
        if (this.popup != null) {
            if (this.popupList != null) {
                this.popupList.setListData(NO_DATA);
                AutoCompletion.ensureIndexIsVisible(this.popupList, 0);
            }
            this.popup.hide();
            this.popup = null;
        }
    }

    public JTextField getTextField() {
        return this.entry;
    }

    public static final void ensureIndexIsVisible(JList jList, int n) {
        jList.ensureIndexIsVisible(n + 1);
        jList.ensureIndexIsVisible(n);
    }

    public void setList(JList jList) {
        this.destroyPopup();
        this.listbox = jList;
    }

    public JList getList() {
        return this.listbox;
    }

    public void setChoices(Choices choices) {
        if (this.listbox != null) {
            this.listbox.setListData(NO_DATA);
            AutoCompletion.ensureIndexIsVisible(this.listbox, 0);
        } else {
            this.destroyPopup();
        }
        this.choices = choices;
    }

    public Choices getChoices() {
        return this.choices;
    }

    public void setAutoSuggest(int n) {
        this.destroyPopup();
        if (n < 0 || n > 2) {
            n = 0;
        }
        this.autoSuggest = n;
    }

    public int getAutoSuggest() {
        return this.autoSuggest;
    }

    private int autoSuggest() {
        return this.autoSuggest == 0 ? defaultAutoSuggest : this.autoSuggest;
    }

    public void setAppendMode(int n) {
        this.destroyPopup();
        if (n < 0 || n > 3) {
            n = 0;
        }
        this.appendMode = n;
    }

    public int getAppendMode() {
        return this.appendMode;
    }

    private int appendMode() {
        return this.appendMode == 0 ? defaultAppendMode : this.appendMode;
    }

    public void setAppendKeyStrokes(AWTKeyStroke[] aWTKeyStrokeArray) {
        this.destroyPopup();
        this.appendKeyStrokes = aWTKeyStrokeArray;
    }

    public AWTKeyStroke[] getAppendKeyStrokes() {
        return this.appendKeyStrokes;
    }

    private AWTKeyStroke[] appendKeyStrokes() {
        return this.appendKeyStrokes == null ? defaultAppendKeyStrokes : this.appendKeyStrokes;
    }

    public void setVisibleSuggestionCount(int n) {
        this.destroyPopup();
        this.visibleSuggestionCount = n;
    }

    public int getVisibleSuggestionCount() {
        return this.visibleSuggestionCount;
    }

    private int visibleSuggestionCount() {
        return this.visibleSuggestionCount <= 0 ? defaultVisibleSuggestionCount : this.visibleSuggestionCount;
    }

    public void setEntry(String string) {
        this.working = true;
        this.entry.setText(string);
        this.entry.setCaretPosition(string.length());
        this.working = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.hidePopup();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hidePopup();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.destroyPopup();
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.destroyPopup();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.destroyPopup();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.destroyPopup();
    }

    public void ancestorMoved(HierarchyEvent hierarchyEvent) {
        this.destroyPopup();
    }

    public void ancestorResized(HierarchyEvent hierarchyEvent) {
        this.destroyPopup();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.choices != null && this.autoSuggest() == 1 && !this.working) {
            this.suggest();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.choices != null && this.autoSuggest() == 1 && !this.working) {
            this.suggest();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void suggest() {
        String string = this.entry.getText();
        this.choices.getChoices(string, this.choiceList);
        if (this.choiceList.first < 0 && string.length() > 0 && this.listbox == null) {
            this.hidePopup();
            return;
        }
        JList jList = this.listbox();
        if (this.choices.choiceListDependsOnPrefix() || jList.getModel().getSize() != this.choiceList.list.length) {
            jList.setListData(this.choiceList.list);
        }
        if (this.choiceList.first < 0) {
            AutoCompletion.ensureIndexIsVisible(jList, 0);
            jList.clearSelection();
        } else {
            AutoCompletion.ensureIndexIsVisible(jList, this.choiceList.first);
            jList.setSelectedIndex(this.choiceList.first);
        }
    }

    private JList listbox() {
        Object object;
        if (this.listbox != null) {
            return this.listbox;
        }
        if (this.popupList == null) {
            this.popupList = new JList();
            this.popupList.setSelectionMode(0);
            this.popupList.setVisibleRowCount(this.visibleSuggestionCount());
            this.popupList.setCellRenderer(choiceRenderer);
            this.popupList.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    Object e;
                    String string;
                    int n;
                    if (mouseEvent.getClickCount() == 1 && (n = AutoCompletion.this.popupList.locationToIndex(mouseEvent.getPoint())) >= 0 && (string = AutoCompletion.toString(e = AutoCompletion.this.popupList.getModel().getElementAt(n))) != null) {
                        AutoCompletion.this.setEntry(string);
                        AutoCompletion.this.hidePopup();
                    }
                }
            });
            this.popupScrollPane = new JScrollPane(this.popupList);
            object = this.popupScrollPane.getPreferredSize();
            ((Dimension)object).width = this.entry.getWidth();
            this.popupScrollPane.setPreferredSize((Dimension)object);
            AWTUtil.setFocusable(this.popupScrollPane, false);
        }
        if (this.popup == null) {
            object = PopupFactory.getSharedInstance();
            Point point = this.entry.getLocationOnScreen();
            this.popup = ((PopupFactory)object).getPopup(this.entry, this.popupScrollPane, point.x, point.y + this.entry.getHeight());
            this.popup.show();
        }
        return this.popupList;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.choices != null) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 27: {
                    if (this.popup == null) break;
                    keyEvent.consume();
                    this.hidePopup();
                    break;
                }
                case 38: 
                case 40: {
                    if (this.autoSuggest() != 1) break;
                    keyEvent.consume();
                    this.selectFromList(n == 38);
                    break;
                }
                default: {
                    if (this.appendMode() != 2 || !this.isAppendKeyStroke(keyEvent)) break;
                    keyEvent.consume();
                    this.manualAppend();
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.choices != null && this.appendMode() == 2 && this.isAppendKeyStroke(keyEvent)) {
            keyEvent.consume();
            this.manualAppend();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.choices != null) {
            switch (this.appendMode()) {
                case 2: {
                    if (!this.isAppendKeyStroke(keyEvent)) break;
                    keyEvent.consume();
                    this.manualAppend();
                    break;
                }
                case 1: {
                    char c;
                    int n = keyEvent.getModifiers();
                    if ((PlatformUtil.IS_MAC_OS || (n & 8) != (n & 2)) && (!PlatformUtil.IS_MAC_OS || (n & 6) != 0) || !((c = keyEvent.getKeyChar()) >= ' ' && c <= '~' || c >= '\u00a0' && c <= '\ud7ff') && (c < '\ue000' || c > '\ufffd')) break;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }

    private boolean isAppendKeyStroke(KeyEvent keyEvent) {
        AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent);
        AWTKeyStroke[] aWTKeyStrokeArray = this.appendKeyStrokes();
        int n = 0;
        while (n < aWTKeyStrokeArray.length) {
            if (aWTKeyStroke.equals(aWTKeyStrokeArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void selectFromList(boolean bl) {
        JList jList = this.listbox();
        String string = this.entry.getText();
        ListModel listModel = jList.getModel();
        int n = listModel.getSize();
        if (n == 0) {
            this.choices.getChoices(string, this.choiceList);
            jList.setListData(this.choiceList.list);
            int n2 = this.choiceList.first >= 0 ? this.choiceList.first : 0;
            AutoCompletion.ensureIndexIsVisible(jList, n2);
            jList.setSelectedIndex(n2);
            return;
        }
        int n3 = jList.getSelectedIndex();
        if (n3 < 0) {
            AutoCompletion.ensureIndexIsVisible(jList, 0);
            jList.setSelectedIndex(0);
            return;
        }
        Object e = listModel.getElementAt(n3);
        String string2 = AutoCompletion.toString(e);
        if (string2 == null || string.equals(string2)) {
            n3 = bl ? --n3 : ++n3;
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 >= n) {
                n3 = n - 1;
            }
            e = listModel.getElementAt(n3);
            jList.setSelectedIndex(n3);
        }
        AutoCompletion.ensureIndexIsVisible(jList, n3);
        string2 = AutoCompletion.toString(e);
        if (string2 != null) {
            this.setEntry(string2);
            this.entry.selectAll();
        }
    }

    private void manualAppend() {
        String string;
        String string2 = this.entry.getText();
        this.choices.getChoices(string2, this.choiceList);
        if (this.choiceList.first < 0 || this.choiceList.list.length == 0) {
            return;
        }
        String[] stringArray = new String[this.choiceList.list.length];
        int n = 0;
        int n2 = this.choiceList.first;
        while (n2 < this.choiceList.list.length) {
            string = AutoCompletion.toString(this.choiceList.list[n2]);
            if (string != null && string.startsWith(string2)) {
                stringArray[n++] = string;
            }
            ++n2;
        }
        if (n == 0) {
            return;
        }
        string = string2;
        int n3 = string2.length();
        String string3 = stringArray[0];
        int n4 = string3.length();
        int n5 = n3;
        block1: while (n5 < n4) {
            String string4 = string + string3.charAt(n5);
            int n6 = 1;
            while (n6 < n) {
                if (!stringArray[n6].startsWith(string4)) break block1;
                ++n6;
            }
            string = string4;
            ++n5;
        }
        if (string.length() > n3) {
            this.setEntry(string);
        }
    }

    public void run() {
        String string = this.entry.getText();
        int n = string.length();
        if (n == 0 || this.entry.getCaretPosition() != n) {
            return;
        }
        this.choices.getChoices(string, this.choiceList);
        if (this.choiceList.first < 0 || this.choiceList.list.length == 0) {
            return;
        }
        String string2 = null;
        int n2 = this.choiceList.first;
        while (n2 < this.choiceList.list.length) {
            String string3 = AutoCompletion.toString(this.choiceList.list[n2]);
            if (string3 != null && string3.startsWith(string) && string3.length() > n) {
                string2 = string3;
                break;
            }
            ++n2;
        }
        if (string2 != null) {
            this.setEntry(string2);
            this.entry.moveCaretPosition(n);
        }
    }

    public static final class ChoiceRenderer
    extends DefaultListCellRenderer {
        private Font normalFont = null;
        private Font boldFont = null;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            boolean bl3 = !(object instanceof PossibleChoice) || ((PossibleChoice)object).isPossibleChoice();
            this.setEnabled(bl3);
            if (this.normalFont == null) {
                Font font = jList.getFont();
                this.normalFont = new Font(font.getFamily(), 0, font.getSize());
                this.boldFont = new Font(font.getFamily(), 1, font.getSize());
            }
            if (bl3) {
                this.setFont(this.normalFont);
            } else {
                this.setFont(this.boldFont);
            }
            return this;
        }
    }

    public static class MinimalChoices
    extends ChoicesBase {
        public MinimalChoices(Object[] objectArray) {
            super(objectArray);
        }

        public void getChoices(String string, ChoiceList choiceList) {
            Object[] objectArray;
            Object[] objectArray2 = this.getAll();
            if (string.length() == 0) {
                choiceList.list = objectArray2;
                choiceList.first = -1;
                return;
            }
            Object[] objectArray3 = new Object[objectArray2.length];
            int n = 0;
            int n2 = 0;
            while (n2 < objectArray2.length) {
                objectArray = objectArray2[n2].toString();
                if (objectArray.startsWith(string)) {
                    objectArray3[n++] = objectArray2[n2];
                }
                ++n2;
            }
            if (n != objectArray3.length) {
                objectArray = new Object[n];
                System.arraycopy(objectArray3, 0, objectArray, 0, n);
                objectArray3 = objectArray;
            }
            choiceList.list = objectArray3;
            choiceList.first = n > 0 ? 0 : -1;
        }

        public boolean choiceListDependsOnPrefix() {
            return true;
        }
    }

    public static class SimpleChoices
    extends ChoicesBase {
        public SimpleChoices(Object[] objectArray) {
            super(objectArray);
        }

        public void getChoices(String string, ChoiceList choiceList) {
            Object[] objectArray = this.getAll();
            choiceList.list = objectArray;
            choiceList.first = -1;
            if (string.length() == 0) {
                return;
            }
            int n = 0;
            while (n < objectArray.length) {
                String string2 = objectArray[n].toString();
                if (string2.startsWith(string)) {
                    choiceList.first = n;
                    return;
                }
                ++n;
            }
        }

        public boolean choiceListDependsOnPrefix() {
            return false;
        }
    }

    public static abstract class ChoicesBase
    implements Choices {
        protected Object[] list;

        protected ChoicesBase(Object[] objectArray) {
            this.list = objectArray;
        }

        public Object[] getAll() {
            return this.list;
        }
    }

    public static interface Choices {
        public void getChoices(String var1, ChoiceList var2);

        public boolean choiceListDependsOnPrefix();
    }

    public static final class ChoiceList {
        public Object[] list;
        public int first;
    }

    public static interface PossibleChoice {
        public boolean isPossibleChoice();
    }
}

