/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.guiutil;

import com.xmlmind.xmledit.guiutil.ChooseURL;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.guiutil.Msg;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.URLUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public class BrowseButton
extends JButton {
    private boolean absoluteMode = false;
    private boolean directoryMode = false;
    private boolean saveMode = false;
    private boolean urlMode = true;
    private JPopupMenu optionMenu = null;
    private ButtonGroup saveGroup = null;
    private ButtonGroup directoryGroup = null;
    private ButtonGroup absoluteGroup = null;
    private ButtonGroup urlGroup = null;
    private URL[] lastSelectedURL = new URL[1];
    static /* synthetic */ Class class$com$xmlmind$xmledit$guiutil$BrowseButton;

    public BrowseButton() {
        this.setIcon(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$guiutil$BrowseButton == null ? (class$com$xmlmind$xmledit$guiutil$BrowseButton = BrowseButton.class$("com.xmlmind.xmledit.guiutil.BrowseButton")) : class$com$xmlmind$xmledit$guiutil$BrowseButton, "browsecombo.gif")));
        DialogUtil.setIconic(this);
        this.setToolTipText(Msg.msg("BB.browseToolTip"));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showMenu(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showMenu(mouseEvent);
            }

            public void showMenu(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = BrowseButton.this.getOptionMenu();
                    DialogUtil.showMenu(jPopupMenu, BrowseButton.this);
                }
            }
        });
    }

    private JPopupMenu getOptionMenu() {
        if (this.optionMenu == null) {
            this.optionMenu = new JPopupMenu();
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("save")) {
                        BrowseButton.this.saveMode = true;
                    } else if (string.equals("open")) {
                        BrowseButton.this.saveMode = false;
                    } else if (string.equals("directory")) {
                        BrowseButton.this.directoryMode = true;
                    } else if (string.equals("file")) {
                        BrowseButton.this.directoryMode = false;
                    } else if (string.equals("absolute")) {
                        BrowseButton.this.absoluteMode = true;
                    } else if (string.equals("relative")) {
                        BrowseButton.this.absoluteMode = false;
                    } else if (string.equals("url")) {
                        BrowseButton.this.urlMode = true;
                    } else if (string.equals("fileName")) {
                        BrowseButton.this.urlMode = false;
                    }
                }
            };
            this.saveGroup = new ButtonGroup();
            this.directoryGroup = new ButtonGroup();
            this.absoluteGroup = new ButtonGroup();
            this.urlGroup = new ButtonGroup();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.save"));
            jRadioButtonMenuItem.setSelected(this.saveMode);
            jRadioButtonMenuItem.addActionListener(actionListener);
            jRadioButtonMenuItem.setActionCommand("save");
            this.optionMenu.add(jRadioButtonMenuItem);
            this.saveGroup.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.open"));
            jRadioButtonMenuItem.setSelected(!this.saveMode);
            jRadioButtonMenuItem.addActionListener(actionListener);
            jRadioButtonMenuItem.setActionCommand("open");
            this.optionMenu.add(jRadioButtonMenuItem);
            this.saveGroup.add(jRadioButtonMenuItem);
            this.optionMenu.addSeparator();
            jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.directory"));
            jRadioButtonMenuItem.setSelected(this.directoryMode);
            jRadioButtonMenuItem.addActionListener(actionListener);
            jRadioButtonMenuItem.setActionCommand("directory");
            this.optionMenu.add(jRadioButtonMenuItem);
            this.directoryGroup.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.file"));
            jRadioButtonMenuItem.setSelected(!this.directoryMode);
            jRadioButtonMenuItem.addActionListener(actionListener);
            jRadioButtonMenuItem.setActionCommand("file");
            this.optionMenu.add(jRadioButtonMenuItem);
            this.directoryGroup.add(jRadioButtonMenuItem);
            this.optionMenu.addSeparator();
            jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.absolute"));
            jRadioButtonMenuItem.setSelected(this.absoluteMode);
            jRadioButtonMenuItem.addActionListener(actionListener);
            jRadioButtonMenuItem.setActionCommand("absolute");
            this.optionMenu.add(jRadioButtonMenuItem);
            this.absoluteGroup.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.relative"));
            jRadioButtonMenuItem.setSelected(!this.absoluteMode);
            jRadioButtonMenuItem.addActionListener(actionListener);
            jRadioButtonMenuItem.setActionCommand("relative");
            this.optionMenu.add(jRadioButtonMenuItem);
            this.absoluteGroup.add(jRadioButtonMenuItem);
            this.optionMenu.addSeparator();
            jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.url"));
            jRadioButtonMenuItem.setSelected(this.urlMode);
            jRadioButtonMenuItem.addActionListener(actionListener);
            jRadioButtonMenuItem.setActionCommand("url");
            this.optionMenu.add(jRadioButtonMenuItem);
            this.urlGroup.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("BB.fileName"));
            jRadioButtonMenuItem.setSelected(!this.urlMode);
            jRadioButtonMenuItem.addActionListener(actionListener);
            jRadioButtonMenuItem.setActionCommand("fileName");
            this.optionMenu.add(jRadioButtonMenuItem);
            this.urlGroup.add(jRadioButtonMenuItem);
        }
        return this.optionMenu;
    }

    public String getSelection(Component component, URL uRL) {
        return BrowseButton.selectFile(component, this.absoluteMode, this.directoryMode, this.saveMode, this.urlMode, uRL, this.lastSelectedURL);
    }

    public static final String selectFile(Component component, boolean bl, boolean bl2, boolean bl3, boolean bl4, URL uRL, URL[] uRLArray) {
        URL uRL2 = uRLArray[0];
        if (uRL2 == null) {
            uRL2 = uRL;
        }
        URL uRL3 = bl2 ? (bl3 ? (bl4 ? ChooseURL.chooseSaveDirectoryURL(component, uRL2) : ChooseURL.defaultChooseSaveDirectoryURL(component, uRL2)) : (bl4 ? ChooseURL.chooseOpenDirectoryURL(component, uRL2) : ChooseURL.defaultChooseOpenDirectoryURL(component, uRL2))) : (bl3 ? (bl4 ? ChooseURL.chooseSaveFileURL(component, uRL2) : ChooseURL.defaultChooseSaveFileURL(component, uRL2)) : (bl4 ? ChooseURL.chooseOpenFileURL(component, uRL2) : ChooseURL.defaultChooseOpenFileURL(component, uRL2)));
        if (uRL3 == null) {
            return null;
        }
        uRLArray[0] = uRL3;
        String string = null;
        if (!bl) {
            if (bl4) {
                if (uRL != null && URLUtil.getRoot(uRL3, true).equals(URLUtil.getRoot(uRL, true))) {
                    string = URLUtil.getRelativeRawPath(uRL3, uRL);
                }
            } else if (uRL != null && URLUtil.getRoot(uRL3, true).equals(URLUtil.getRoot(uRL, true)) && uRL3.getProtocol().equals("file")) {
                File file = FileUtil.urlToFile(uRL3);
                File file2 = FileUtil.urlToFile(uRL);
                string = FileUtil.getRelativePath(file, file2);
            }
        }
        if (string == null) {
            string = bl4 ? uRL3.toExternalForm() : FileUtil.urlToFileName(uRL3);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

