/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.guiutil;

import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class DialogBase
extends JDialog
implements ActionListener {
    protected static final int STYLE_MODAL = 1;
    protected static final int STYLE_RESIZABLE = 2;
    protected static final int STYLE_FORM_MARGINS = 4;
    protected static final int STYLE_BUTTONS_VGAP = 8;
    protected static final int STYLE_OK_CANCEL_BUTTONS = 16;
    protected static final int STYLE_CLOSE_BUTTON = 32;
    protected static final int STYLE_HELP_BUTTON = 64;
    protected static final int STYLE_BUTTONS_AT_RIGHT = 128;
    protected Component dialogAnchor;
    protected JButton[] dialogButtons;
    private static final Class[] NO_PARAMETER_TYPES = new Class[0];
    private static final Object[] NO_ARGUMENTS = new Object[0];

    protected DialogBase(Dialog dialog, String string, int n) {
        this(dialog, string, (n & 1) != 0);
        this.initialize(dialog, n);
    }

    protected DialogBase(Component component, String string, int n) {
        this(component, string, (n & 1) != 0);
        this.initialize(component, n);
    }

    protected DialogBase(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
    }

    protected DialogBase(Component component, String string, boolean bl) {
        super(AWTUtil.getFrame(component), string, bl);
    }

    protected void initialize(Component component, final int n) {
        this.dialogAnchor = AWTUtil.getDialogAnchor(component);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if ((n & 0x20) != 0) {
                    DialogBase.this.close();
                } else {
                    DialogBase.this.cancel();
                }
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        jPanel.registerKeyboardAction(this, (n & 0x20) != 0 ? "close" : "cancel", KeyStroke.getKeyStroke(27, 0), 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if ((n & 4) != 0) {
            gridBagConstraints.insets.top = 5;
            gridBagConstraints.insets.bottom = 5;
            gridBagConstraints.insets.left = 5;
            gridBagConstraints.insets.right = 5;
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add(this.createForm(), gridBagConstraints);
        int n2 = (n & 0x20) != 0 ? 1 : 2;
        this.dialogButtons = new JButton[n2];
        int n3 = n2;
        if ((n & 0x40) != 0) {
            ++n3;
        }
        int n4 = (n & 0x80) != 0 ? 5 : 10;
        JPanel jPanel2 = new JPanel(new GridLayout(1, n3, n4, 0));
        gridBagConstraints.insets.top = (n & 8) != 0 ? 15 : 0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        if ((n & 0x80) != 0) {
            gridBagConstraints.anchor = 13;
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        int n5 = 0;
        if ((n & 0x10) != 0) {
            this.dialogButtons[n5] = new JButton();
            DialogUtil.setOKText(this.dialogButtons[n5]);
            this.dialogButtons[n5].setActionCommand("ok");
            this.dialogButtons[n5].addActionListener(this);
            jPanel2.add(this.dialogButtons[n5]);
            ++n5;
        }
        if ((n & 0x40) != 0) {
            JButton jButton = new JButton();
            DialogUtil.setHelpText(jButton);
            jPanel2.add(jButton);
            DialogUtil.setHelpButton(jButton, this.getClass().getName());
        }
        this.dialogButtons[n5] = new JButton();
        if ((n & 0x10) != 0) {
            DialogUtil.setCancelText(this.dialogButtons[n5]);
            this.dialogButtons[n5].setActionCommand("cancel");
        } else {
            DialogUtil.setCloseText(this.dialogButtons[n5]);
            this.dialogButtons[n5].setActionCommand("close");
        }
        this.dialogButtons[n5].addActionListener(this);
        jPanel2.add(this.dialogButtons[n5]);
        this.pack();
        this.setResizable((n & 2) != 0);
    }

    protected abstract Component createForm();

    public void actionPerformed(ActionEvent actionEvent) {
        block3: {
            String string = actionEvent.getActionCommand();
            if (string == null || string.length() <= 0) break block3;
            try {
                Method method = this.getClass().getMethod(string, NO_PARAMETER_TYPES);
                method.invoke((Object)this, NO_ARGUMENTS);
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (exception instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)exception).getCause();
                }
                System.err.println("Dialog box " + this.getClass().getName() + ": cannot invoke command '" + string + "':");
                System.err.println("Caught " + throwable.getClass().getName());
                System.err.println("---");
                System.err.println(MiscUtil.detailedReason(throwable));
                System.err.println("---");
            }
        }
    }

    public void ok() {
        throw new RuntimeException("ok() must be implemented by subclass");
    }

    public void cancel() {
        throw new RuntimeException("cancel() must be implemented by subclass");
    }

    public void close() {
        throw new RuntimeException("close() must be implemented by subclass");
    }
}

