/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.guiutil;

import com.xmlmind.xmledit.guiutil.Msg;
import com.xmlmind.xmledit.util.PlatformUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.help.HelpBroker;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public final class DialogUtil {
    public static final char NO_MNEMONIC = '\u0000';
    private static boolean addMnemonics = !PlatformUtil.IS_MAC_OS;
    private static final Insets iconicInsets = new Insets(1, 1, 1, 1);
    private static final Insets toolbarInsets = new Insets(0, 0, 0, 0);
    private static HelpBroker helpBroker = null;

    public static void setAddingMnemonics(boolean bl) {
        addMnemonics = bl;
    }

    public static boolean isAddingMnemonics() {
        return addMnemonics;
    }

    public static String buttonLabel(String string) {
        int n = string.indexOf(95);
        if (n >= 0) {
            string = new StringBuffer(string).deleteCharAt(n).toString();
        }
        return string;
    }

    public static char buttonMnemonic(String string) {
        if (!addMnemonics) {
            return '\u0000';
        }
        int n = string.indexOf(95);
        if (n >= 0) {
            return string.charAt(n + 1);
        }
        return '\u0000';
    }

    public static int buttonMnemonicIndex(String string) {
        if (!addMnemonics) {
            return -1;
        }
        int n = string.indexOf(95);
        if (n >= 0) {
            return n;
        }
        return -1;
    }

    public static void setMnemonic(AbstractButton abstractButton, String string) {
        char c = DialogUtil.buttonMnemonic(string);
        if (c != '\u0000') {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(DialogUtil.buttonMnemonicIndex(string));
        }
    }

    public static void setDisplayedMnemonic(JLabel jLabel, String string) {
        char c = DialogUtil.buttonMnemonic(string);
        if (c != '\u0000') {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(DialogUtil.buttonMnemonicIndex(string));
        }
    }

    public static void setDisplayedMnemonic(JTabbedPane jTabbedPane, int n, String string) {
        char c = DialogUtil.buttonMnemonic(string);
        if (c != '\u0000') {
            jTabbedPane.setMnemonicAt(n, c);
            jTabbedPane.setDisplayedMnemonicIndexAt(n, DialogUtil.buttonMnemonicIndex(string));
        }
    }

    public static void setOKText(AbstractButton abstractButton) {
        DialogUtil.setButtonText(abstractButton, "ok");
    }

    public static void setHelpText(AbstractButton abstractButton) {
        DialogUtil.setButtonText(abstractButton, "help");
    }

    public static void setCancelText(AbstractButton abstractButton) {
        DialogUtil.setButtonText(abstractButton, "cancel");
    }

    public static void setCloseText(AbstractButton abstractButton) {
        DialogUtil.setButtonText(abstractButton, "close");
    }

    private static void setButtonText(AbstractButton abstractButton, String string) {
        String string2 = Msg.msg(string);
        abstractButton.setText(DialogUtil.buttonLabel(string2));
        DialogUtil.setMnemonic(abstractButton, string2);
    }

    public static void setIconic(AbstractButton abstractButton) {
        if (!PlatformUtil.IS_MAC_OS) {
            abstractButton.setMargin(iconicInsets);
        }
    }

    public static void configureToolBar(JToolBar jToolBar) {
        jToolBar.setFocusable(false);
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        if (!PlatformUtil.IS_MAC_OS) {
            jToolBar.setMargin(toolbarInsets);
        }
        int n = jToolBar.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = jToolBar.getComponentAtIndex(n2);
            if (component instanceof AbstractButton) {
                DialogUtil.configureToolBarButton((AbstractButton)component);
            } else {
                component.setFocusable(false);
            }
            ++n2;
        }
    }

    public static void configureToolBarButton(AbstractButton abstractButton) {
        abstractButton.setFocusable(false);
        abstractButton.setText(null);
        abstractButton.setMnemonic(0);
        if (!PlatformUtil.IS_MAC_OS) {
            abstractButton.setMargin(toolbarInsets);
        }
    }

    public static void showMenu(JPopupMenu jPopupMenu, AbstractButton abstractButton) {
        Dimension dimension = jPopupMenu.getPreferredSize();
        jPopupMenu.show(abstractButton, abstractButton.getWidth() - dimension.width, abstractButton.getHeight());
    }

    public static void setHelpBroker(HelpBroker helpBroker) {
        DialogUtil.helpBroker = helpBroker;
    }

    public static HelpBroker getHelpBroker() {
        return helpBroker;
    }

    public static void setHelpButton(AbstractButton abstractButton, String string) {
        if (helpBroker == null) {
            abstractButton.setEnabled(false);
        } else {
            helpBroker.enableHelpOnButton((Component)abstractButton, string, null);
        }
    }

    public static void badField(JTextField jTextField) {
        jTextField.getToolkit().beep();
        jTextField.selectAll();
        jTextField.requestFocus();
    }
}

