/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.guiutil;

import com.xmlmind.xmledit.guiutil.Msg;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLUtil;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import javax.swing.filechooser.FileFilter;

public final class FilterByExtension
extends FileFilter {
    private String[] suffixes;

    public static FilterByExtension create(URL uRL) {
        String string = URIUtil.unescape(URLUtil.getRawExtension(uRL));
        if (string.length() > 0) {
            return new FilterByExtension(string);
        }
        return null;
    }

    public static FilterByExtension create(File file) {
        String string = FileUtil.fileExtension(file.getPath());
        if (string.length() > 0) {
            return new FilterByExtension(string);
        }
        return null;
    }

    public FilterByExtension(String string) {
        this(new String[]{string});
    }

    public FilterByExtension(String[] stringArray) {
        this.suffixes = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.suffixes[n] = "." + stringArray[n].toLowerCase();
            ++n;
        }
        Arrays.sort(this.suffixes);
    }

    public String getFileNameSuffix() {
        return this.suffixes[0];
    }

    public String[] getFileNameSuffixes() {
        return this.suffixes;
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = file.getName().toLowerCase();
        int n = 0;
        while (n < this.suffixes.length) {
            if (string.endsWith(this.suffixes[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String getDescription() {
        String[] stringArray = new String[this.suffixes.length];
        int n = 0;
        while (n < this.suffixes.length) {
            stringArray[n] = this.suffixes[n].substring(1).toUpperCase();
            ++n;
        }
        return Msg.msg("FBE.fileWithExtension", StringUtil.join(stringArray, ","));
    }

    public String toString() {
        return this.getDescription();
    }

    public int hashCode() {
        int n = this.suffixes[0].hashCode();
        int n2 = 1;
        while (n2 < this.suffixes.length) {
            n ^= this.suffixes[n2].hashCode();
            ++n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FilterByExtension)) {
            return false;
        }
        FilterByExtension filterByExtension = (FilterByExtension)object;
        if (this.suffixes.length != filterByExtension.suffixes.length) {
            return false;
        }
        int n = 0;
        while (n < this.suffixes.length) {
            if (!this.suffixes[n].equals(filterByExtension.suffixes[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

