/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.guiutil;

import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.LabeledValue;
import com.xmlmind.xmledit.guiutil.Msg;
import com.xmlmind.xmledit.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FontChooserPane
extends JPanel {
    public static final int FONT_MIN_SIZE = 6;
    public static final int FONT_MAX_SIZE = 72;
    public static final int SHOW_MINIMAL_FONTS = 1;
    public static final int SHOW_LOGICAL_FONTS = 2;
    public static final int SHOW_ALL_FONTS = 4;
    private int options;
    private String[] families;
    private JComboBox fontFamily;
    private LabeledValue[] styles;
    private JComboBox fontStyle;
    private SpinnerNumberModel fontSizeModel;
    private JSpinner fontSize;
    private JTextArea preview;
    private static String[] allFontFamilies = null;

    public FontChooserPane() {
        this(4);
    }

    public FontChooserPane(int n) {
        super(new GridBagLayout());
        this.options = n;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        String string = Msg.msg("FCP.fontFamily");
        JLabel jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)jLabel, gridBagConstraints);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontChooserPane.this.updatePreview();
            }
        };
        this.families = (n & 4) != 0 ? FontChooserPane.getAllFontFamilies() : ((n & 2) != 0 ? new String[]{"SansSerif", "Serif", "Monospaced", "Dialog", "DialogInput"} : new String[]{"SansSerif", "Serif", "Monospaced"});
        this.fontFamily = new JComboBox<String>(this.families);
        this.fontFamily.addActionListener(actionListener);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 2;
        this.add((Component)this.fontFamily, gridBagConstraints);
        jLabel.setLabelFor(this.fontFamily);
        string = Msg.msg("FCP.fontStyle");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.top = 5;
        this.add((Component)jLabel, gridBagConstraints);
        this.styles = new LabeledValue[]{new LabeledValue(Msg.msg("FCP.plain"), 0), new LabeledValue(Msg.msg("FCP.bold"), 1), new LabeledValue(Msg.msg("FCP.italic"), 2), new LabeledValue(Msg.msg("FCP.boldItalic"), 3)};
        this.fontStyle = new JComboBox<LabeledValue>(this.styles);
        this.fontStyle.addActionListener(actionListener);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 2;
        this.add((Component)this.fontStyle, gridBagConstraints);
        jLabel.setLabelFor(this.fontStyle);
        string = Msg.msg("FCP.fontSize");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.right = 5;
        this.add((Component)jLabel, gridBagConstraints);
        this.fontSizeModel = new SpinnerNumberModel(12, 6, 72, 1);
        this.fontSize = new JSpinner(this.fontSizeModel);
        this.fontSize.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FontChooserPane.this.updatePreview();
            }
        });
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 2;
        this.add((Component)this.fontSize, gridBagConstraints);
        jLabel.setLabelFor(this.fontSize);
        String string2 = Msg.msg("FCP.samplePhrase");
        this.preview = new JTextArea(string2);
        this.preview.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5)));
        Font font = new Font("Monospaced", 3, 24);
        this.preview.setFont(font);
        this.preview.setForeground(Color.black);
        this.preview.setBackground(Color.white);
        this.preview.setEditable(false);
        this.preview.setFocusable(false);
        this.preview.setLineWrap(true);
        this.preview.setWrapStyleWord(true);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        this.add((Component)this.preview, gridBagConstraints);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n2 = fontMetrics.stringWidth(string2);
        int n3 = fontMetrics.getHeight();
        if ((n2 /= 3) < 250) {
            n2 = 250;
        }
        this.preview.setPreferredSize(new Dimension(n2, n3 *= 4));
    }

    public static final String[] getAllFontFamilies() {
        block2: {
            if (allFontFamilies != null) break block2;
            try {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                allFontFamilies = graphicsEnvironment.getAvailableFontFamilyNames();
            }
            catch (Exception exception) {
                allFontFamilies = new String[]{"SansSerif", "Serif", "Monospaced", "Dialog", "DialogInput"};
            }
        }
        return allFontFamilies;
    }

    public void setSelectedFont(Font font) {
        int n = StringUtil.indexOf(this.families, font.getFamily());
        if (n < 0) {
            this.fontFamily.setSelectedItem("SansSerif");
        } else {
            this.fontFamily.setSelectedIndex(n);
        }
        n = LabeledValue.indexOfValue(this.styles, font.getStyle());
        if (n < 0) {
            this.fontStyle.setSelectedIndex(0);
        } else {
            this.fontStyle.setSelectedIndex(n);
        }
        int n2 = font.getSize();
        if (n2 < 6) {
            n2 = 6;
        } else if (n2 > 72) {
            n2 = 72;
        }
        this.fontSizeModel.setValue(new Integer(n2));
        this.updatePreview();
    }

    public Font getSelectedFont() {
        String string = (String)this.fontFamily.getSelectedItem();
        int n = ((LabeledValue)this.fontStyle.getSelectedItem()).intValue();
        int n2 = this.fontSizeModel.getNumber().intValue();
        return new Font(string, n, n2);
    }

    private void updatePreview() {
        Font font = this.getSelectedFont();
        this.preview.setFont(font);
    }

    public void focusForm() {
        this.fontFamily.requestFocus();
    }
}

