/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.guiutil;

import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.guiutil.Msg;
import com.xmlmind.xmledit.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ItemsSelector
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final int FIRST = 0;
    private static final int PREVIOUS = 1;
    private static final int NEXT = 2;
    private static final int LAST = 3;
    private JList unselectedList;
    private JButton selectButton;
    private JButton unselectButton;
    private JList selectedList;
    private JButton firstButton;
    private JButton previousButton;
    private JButton nextButton;
    private JButton lastButton;
    private ItemCompare itemCompare = new ItemCompare();
    static /* synthetic */ Class class$com$xmlmind$xmledit$guiutil$ItemsSelector;

    public ItemsSelector(int n, int n2) {
        this(n, n2, Msg.msg("IS.unselected"), Msg.msg("IS.selected"));
    }

    public ItemsSelector(int n, int n2, String string, String string2) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new BorderLayout(0, 2));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel = new JLabel(string);
        jPanel.add((Component)jLabel, "North");
        this.unselectedList = new JList();
        this.unselectedList.setSelectionMode(2);
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 > 0) {
            stringBuffer.append('x');
            --n2;
        }
        this.unselectedList.setPrototypeCellValue(stringBuffer.toString());
        this.unselectedList.setVisibleRowCount(n);
        this.unselectedList.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.unselectedList);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel = new JPanel(new GridLayout(2, 1, 0, 10));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        this.add((Component)jPanel, gridBagConstraints);
        this.selectButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$guiutil$ItemsSelector == null ? (class$com$xmlmind$xmledit$guiutil$ItemsSelector = ItemsSelector.class$("com.xmlmind.xmledit.guiutil.ItemsSelector")) : class$com$xmlmind$xmledit$guiutil$ItemsSelector, "select.gif")));
        DialogUtil.setIconic(this.selectButton);
        this.selectButton.setToolTipText(Msg.msg("IS.select"));
        this.selectButton.setActionCommand("select");
        this.selectButton.addActionListener(this);
        jPanel.add(this.selectButton);
        this.unselectButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$guiutil$ItemsSelector == null ? (class$com$xmlmind$xmledit$guiutil$ItemsSelector = ItemsSelector.class$("com.xmlmind.xmledit.guiutil.ItemsSelector")) : class$com$xmlmind$xmledit$guiutil$ItemsSelector, "unselect.gif")));
        DialogUtil.setIconic(this.unselectButton);
        this.unselectButton.setToolTipText(Msg.msg("IS.unselect"));
        this.unselectButton.setActionCommand("unselect");
        this.unselectButton.addActionListener(this);
        jPanel.add(this.unselectButton);
        jPanel = new JPanel(new BorderLayout(0, 2));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 0;
        this.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel2 = new JLabel(string2);
        jPanel.add((Component)jLabel2, "North");
        this.selectedList = new JList();
        this.selectedList.setSelectionMode(2);
        this.selectedList.setPrototypeCellValue(this.unselectedList.getPrototypeCellValue());
        this.selectedList.setVisibleRowCount(Math.max(n - 2, 5));
        this.selectedList.addListSelectionListener(this);
        jScrollPane = new JScrollPane(this.selectedList);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 2, 0));
        jPanel.add((Component)jPanel2, "South");
        this.firstButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$guiutil$ItemsSelector == null ? (class$com$xmlmind$xmledit$guiutil$ItemsSelector = ItemsSelector.class$("com.xmlmind.xmledit.guiutil.ItemsSelector")) : class$com$xmlmind$xmledit$guiutil$ItemsSelector, "first.gif")));
        DialogUtil.setIconic(this.firstButton);
        this.firstButton.setToolTipText(Msg.msg("IS.first"));
        this.firstButton.setActionCommand("first");
        this.firstButton.addActionListener(this);
        jPanel2.add(this.firstButton);
        this.previousButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$guiutil$ItemsSelector == null ? (class$com$xmlmind$xmledit$guiutil$ItemsSelector = ItemsSelector.class$("com.xmlmind.xmledit.guiutil.ItemsSelector")) : class$com$xmlmind$xmledit$guiutil$ItemsSelector, "previous.gif")));
        DialogUtil.setIconic(this.previousButton);
        this.previousButton.setToolTipText(Msg.msg("IS.previous"));
        this.previousButton.setActionCommand("previous");
        this.previousButton.addActionListener(this);
        jPanel2.add(this.previousButton);
        this.nextButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$guiutil$ItemsSelector == null ? (class$com$xmlmind$xmledit$guiutil$ItemsSelector = ItemsSelector.class$("com.xmlmind.xmledit.guiutil.ItemsSelector")) : class$com$xmlmind$xmledit$guiutil$ItemsSelector, "next.gif")));
        DialogUtil.setIconic(this.nextButton);
        this.nextButton.setToolTipText(Msg.msg("IS.next"));
        this.nextButton.setActionCommand("next");
        this.nextButton.addActionListener(this);
        jPanel2.add(this.nextButton);
        this.lastButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$guiutil$ItemsSelector == null ? (class$com$xmlmind$xmledit$guiutil$ItemsSelector = ItemsSelector.class$("com.xmlmind.xmledit.guiutil.ItemsSelector")) : class$com$xmlmind$xmledit$guiutil$ItemsSelector, "last.gif")));
        DialogUtil.setIconic(this.lastButton);
        this.lastButton.setToolTipText(Msg.msg("IS.last"));
        this.lastButton.setActionCommand("last");
        this.lastButton.addActionListener(this);
        jPanel2.add(this.lastButton);
    }

    public void setItems(String[] objectArray, boolean bl, String[] stringArray) {
        Object[] objectArray2;
        if (bl && objectArray.length > 1) {
            objectArray2 = new String[objectArray.length];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            Arrays.sort(objectArray2);
            objectArray = objectArray2;
        }
        objectArray2 = new Hashtable();
        int n = 0;
        while (n < objectArray.length) {
            objectArray2.put(objectArray[n], new Integer(n));
            ++n;
        }
        this.itemCompare.setItemOrder((Hashtable)objectArray2);
        String[] stringArray2 = ItemsSelector.remove((String[])objectArray, stringArray);
        if (stringArray2.length > 1) {
            Arrays.sort(stringArray2, this.itemCompare);
        }
        this.unselectedList.setListData(stringArray2);
        this.unselectedList.ensureIndexIsVisible(0);
        this.selectedList.setListData(stringArray);
        this.selectedList.ensureIndexIsVisible(0);
        this.cancelSelectable();
        this.cancelUnselectable();
    }

    private static String[] remove(String[] stringArray, String[] stringArray2) {
        String[] stringArray3;
        String[] stringArray4 = new String[stringArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray3 = stringArray[n2];
            boolean bl = false;
            int n3 = 0;
            while (n3 < stringArray2.length) {
                if (stringArray3.equals(stringArray2[n3])) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                stringArray4[n++] = stringArray3;
            }
            ++n2;
        }
        if (n != stringArray.length) {
            stringArray3 = new String[n];
            System.arraycopy(stringArray4, 0, stringArray3, 0, n);
            stringArray4 = stringArray3;
        }
        return stringArray4;
    }

    private static String[] append(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    private void cancelUnselectable() {
        this.selectedList.clearSelection();
        this.itemsUnselectable(null);
    }

    private void cancelSelectable() {
        this.unselectedList.clearSelection();
        this.itemsSelectable(null);
    }

    private void itemsSelectable(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            this.selectButton.setEnabled(false);
        } else {
            this.selectButton.setEnabled(true);
            this.cancelUnselectable();
        }
    }

    private void itemsUnselectable(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            this.unselectButton.setEnabled(false);
            this.firstButton.setEnabled(false);
            this.previousButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.lastButton.setEnabled(false);
        } else {
            this.unselectButton.setEnabled(true);
            this.cancelSelectable();
            if (nArray.length == 1) {
                int n = nArray[0];
                ListModel listModel = this.selectedList.getModel();
                int n2 = listModel.getSize() - 1;
                this.firstButton.setEnabled(n > 0);
                this.previousButton.setEnabled(n > 0);
                this.nextButton.setEnabled(n < n2);
                this.lastButton.setEnabled(n < n2);
            } else {
                this.firstButton.setEnabled(false);
                this.previousButton.setEnabled(false);
                this.nextButton.setEnabled(false);
                this.lastButton.setEnabled(false);
            }
        }
    }

    public String[] getItems() {
        return ItemsSelector.getListData(this.selectedList);
    }

    private static String[] getListData(JList jList) {
        ListModel listModel = jList.getModel();
        String[] stringArray = new String[listModel.getSize()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)listModel.getElementAt(n);
            ++n;
        }
        return stringArray;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.unselectedList) {
            this.itemsSelectable(this.unselectedList.getSelectedIndices());
        } else if (listSelectionEvent.getSource() == this.selectedList) {
            this.itemsUnselectable(this.selectedList.getSelectedIndices());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("select")) {
            this.select();
        } else if (string.equals("unselect")) {
            this.unselect();
        } else if (string.equals("first")) {
            this.move(0);
        } else if (string.equals("previous")) {
            this.move(1);
        } else if (string.equals("next")) {
            this.move(2);
        } else if (string.equals("last")) {
            this.move(3);
        }
    }

    private void select() {
        int[] nArray = this.unselectedList.getSelectedIndices();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        String[] stringArray = ItemsSelector.getListData(this.unselectedList, nArray);
        String[] stringArray2 = ItemsSelector.getListData(this.unselectedList);
        stringArray2 = ItemsSelector.remove(stringArray2, stringArray);
        this.unselectedList.setListData(stringArray2);
        stringArray2 = ItemsSelector.getListData(this.selectedList);
        stringArray2 = ItemsSelector.append(stringArray2, stringArray);
        this.selectedList.setListData(stringArray2);
        this.selectedList.ensureIndexIsVisible(stringArray2.length - 1);
        this.cancelSelectable();
    }

    private static String[] getListData(JList jList, int[] nArray) {
        ListModel listModel = jList.getModel();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = (String)listModel.getElementAt(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    private void unselect() {
        int[] nArray = this.selectedList.getSelectedIndices();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        String[] stringArray = ItemsSelector.getListData(this.selectedList, nArray);
        String[] stringArray2 = ItemsSelector.getListData(this.selectedList);
        stringArray2 = ItemsSelector.remove(stringArray2, stringArray);
        this.selectedList.setListData(stringArray2);
        stringArray2 = ItemsSelector.getListData(this.unselectedList);
        stringArray2 = ItemsSelector.append(stringArray2, stringArray);
        Arrays.sort(stringArray2, this.itemCompare);
        this.unselectedList.setListData(stringArray2);
        this.unselectedList.ensureIndexIsVisible(StringUtil.indexOf(stringArray2, stringArray[stringArray.length - 1]));
        this.cancelUnselectable();
    }

    private void move(int n) {
        int n2 = this.selectedList.getSelectedIndex();
        if (n2 < 0) {
            return;
        }
        String[] stringArray = this.getItems();
        if (n2 >= stringArray.length) {
            return;
        }
        int n3 = n2;
        switch (n) {
            case 0: {
                n3 = 0;
                break;
            }
            case 1: {
                n3 = n2 - 1;
                if (n3 >= 0) break;
                n3 = 0;
                break;
            }
            case 2: {
                n3 = n2 + 1;
                if (n3 < stringArray.length) break;
                n3 = stringArray.length - 1;
                break;
            }
            case 3: {
                n3 = stringArray.length - 1;
            }
        }
        if (n3 != n2) {
            ItemsSelector.move(stringArray, n2, n3);
            this.selectedList.setListData(stringArray);
        }
        this.selectedList.setSelectedIndex(n3);
        this.selectedList.ensureIndexIsVisible(n3);
    }

    private static void move(String[] stringArray, int n, int n2) {
        if (n2 < n) {
            String string = stringArray[n];
            int n3 = n - 1;
            while (n3 >= n2) {
                stringArray[n3 + 1] = stringArray[n3];
                --n3;
            }
            stringArray[n2] = string;
        } else if (n2 > n) {
            String string = stringArray[n];
            int n4 = n + 1;
            while (n4 <= n2) {
                stringArray[n4 - 1] = stringArray[n4];
                ++n4;
            }
            stringArray[n2] = string;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ItemCompare
    implements Comparator {
        private Hashtable itemOrder = null;

        private ItemCompare() {
        }

        public void setItemOrder(Hashtable hashtable) {
            this.itemOrder = hashtable;
        }

        public int compare(Object object, Object object2) {
            Integer n = (Integer)this.itemOrder.get(object);
            int n2 = n == null ? Integer.MAX_VALUE : n;
            n = (Integer)this.itemOrder.get(object2);
            int n3 = n == null ? Integer.MAX_VALUE : n;
            return n2 - n3;
        }
    }
}

