/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.guiutil;

import com.xmlmind.xmledit.guiutil.ImageResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public class MultiSplitPane
extends JComponent {
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;
    public static final int LEFT = 4;
    private Constraints[] constraints = new Constraints[0];
    private int availableWidth;
    private int availableHeight;
    private Rectangle topSeparator = new Rectangle();
    private Rectangle rightSeparator = new Rectangle();
    private Rectangle bottomSeparator = new Rectangle();
    private Rectangle leftSeparator = new Rectangle();
    private boolean hasSeparators;
    private static Cursor normalCursor = null;
    private static Cursor verticalResizeCursor = null;
    private static Cursor horizontalResizeCursor = null;
    private static final int SEPARATOR_THICKNESS = 5;
    private static final int STRICT_MINIMUM = 0;
    private static final int MINIMUM = 1;
    private static final int PREFERRED = 2;
    static /* synthetic */ Class class$com$xmlmind$xmledit$guiutil$MultiSplitPane;

    public static final String getPositionName(int n) {
        switch (n) {
            case 0: {
                return "CENTER";
            }
            case 1: {
                return "TOP";
            }
            case 2: {
                return "RIGHT";
            }
            case 3: {
                return "BOTTOM";
            }
            case 4: {
                return "LEFT";
            }
        }
        return "(" + Integer.toString(n) + ", unknown position)";
    }

    public MultiSplitPane() {
        Object object;
        this.setLayout(new Layout());
        if (normalCursor == null) {
            normalCursor = Cursor.getDefaultCursor();
            object = this.getToolkit();
            Dimension dimension = ((Toolkit)object).getBestCursorSize(16, 16);
            if (dimension.width == 16 && dimension.height == 16) {
                Image image = ImageResource.get(class$com$xmlmind$xmledit$guiutil$MultiSplitPane == null ? (class$com$xmlmind$xmledit$guiutil$MultiSplitPane = MultiSplitPane.class$("com.xmlmind.xmledit.guiutil.MultiSplitPane")) : class$com$xmlmind$xmledit$guiutil$MultiSplitPane, "verticalResizeCursor.gif");
                Point point = new Point(7, 7);
                verticalResizeCursor = ((Toolkit)object).createCustomCursor(image, point, "verticalResizeMultiSplitPane");
                image = ImageResource.get(class$com$xmlmind$xmledit$guiutil$MultiSplitPane == null ? (class$com$xmlmind$xmledit$guiutil$MultiSplitPane = MultiSplitPane.class$("com.xmlmind.xmledit.guiutil.MultiSplitPane")) : class$com$xmlmind$xmledit$guiutil$MultiSplitPane, "horizontalResizeCursor.gif");
                horizontalResizeCursor = ((Toolkit)object).createCustomCursor(image, point, "horizontalResizeMultiSplitPane");
            } else {
                verticalResizeCursor = Cursor.getPredefinedCursor(11);
                horizontalResizeCursor = Cursor.getPredefinedCursor(8);
            }
        }
        this.setCursor(normalCursor);
        object = new MouseHandler();
        this.addMouseListener((MouseListener)object);
        this.addMouseMotionListener((MouseMotionListener)object);
    }

    protected void addImpl(Component component, Object object, int n) {
        int n2;
        if (n < 0) {
            n = this.getComponentCount();
        }
        if (n >= 5) {
            throw new IllegalArgumentException(Integer.toString(n) + ", bad index: a MultiSplitPane" + " can contain at most 5 components");
        }
        Constraints constraints = (Constraints)object;
        constraints = constraints == null ? new Constraints() : constraints.copy();
        int n3 = 0;
        while (n3 < this.constraints.length) {
            if (constraints.position == this.constraints[n3].position) {
                throw new IllegalArgumentException("there is already a Component at " + MultiSplitPane.getPositionName(constraints.position));
            }
            ++n3;
        }
        Constraints[] constraintsArray = new Constraints[this.constraints.length + 1];
        if (n > 0) {
            System.arraycopy(this.constraints, 0, constraintsArray, 0, n);
        }
        if ((n2 = this.constraints.length - n) > 0) {
            System.arraycopy(this.constraints, n, constraintsArray, n + 1, n2);
        }
        constraintsArray[n] = constraints;
        this.constraints = constraintsArray;
        super.addImpl(component, object, n);
    }

    public void remove(int n) {
        int n2;
        int n3;
        Constraints[] constraintsArray = new Constraints[this.constraints.length - 1];
        if (n > 0) {
            System.arraycopy(this.constraints, 0, constraintsArray, 0, n);
        }
        if ((n3 = this.constraints.length - (n2 = n + 1)) > 0) {
            System.arraycopy(this.constraints, n2, constraintsArray, n, n3);
        }
        this.constraints = constraintsArray;
        super.remove(n);
    }

    public void removeAll() {
        if (this.getComponentCount() > 0) {
            this.constraints = new Constraints[0];
            super.removeAll();
        }
    }

    public Constraints getConstraints(Component component) {
        int n = this.indexOfComponent(component);
        if (n < 0) {
            return null;
        }
        return this.getConstraints(n);
    }

    public int indexOfComponent(Component component) {
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getComponent(n2) == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Constraints getConstraints(int n) {
        return this.constraints[n];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class MouseHandler
    extends MouseInputAdapter {
        private Component resizedComponent;
        private Constraints resizedConstraints;
        private int dragX = -1;
        private int dragY = -1;

        private MouseHandler() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (MultiSplitPane.this.hasSeparators) {
                this.updateCursor(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (MultiSplitPane.this.hasSeparators && MultiSplitPane.this.getCursor() != normalCursor) {
                MultiSplitPane.this.setCursor(normalCursor);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (MultiSplitPane.this.hasSeparators) {
                this.updateCursor(mouseEvent);
            }
        }

        private void updateCursor(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Cursor cursor = ((MultiSplitPane)MultiSplitPane.this).topSeparator.width > 0 && n >= ((MultiSplitPane)MultiSplitPane.this).topSeparator.x && n < ((MultiSplitPane)MultiSplitPane.this).topSeparator.x + ((MultiSplitPane)MultiSplitPane.this).topSeparator.width && n2 >= ((MultiSplitPane)MultiSplitPane.this).topSeparator.y && n2 < ((MultiSplitPane)MultiSplitPane.this).topSeparator.y + ((MultiSplitPane)MultiSplitPane.this).topSeparator.height ? horizontalResizeCursor : (((MultiSplitPane)MultiSplitPane.this).rightSeparator.width > 0 && n >= ((MultiSplitPane)MultiSplitPane.this).rightSeparator.x && n < ((MultiSplitPane)MultiSplitPane.this).rightSeparator.x + ((MultiSplitPane)MultiSplitPane.this).rightSeparator.width && n2 >= ((MultiSplitPane)MultiSplitPane.this).rightSeparator.y && n2 < ((MultiSplitPane)MultiSplitPane.this).rightSeparator.y + ((MultiSplitPane)MultiSplitPane.this).rightSeparator.height ? verticalResizeCursor : (((MultiSplitPane)MultiSplitPane.this).bottomSeparator.width > 0 && n >= ((MultiSplitPane)MultiSplitPane.this).bottomSeparator.x && n < ((MultiSplitPane)MultiSplitPane.this).bottomSeparator.x + ((MultiSplitPane)MultiSplitPane.this).bottomSeparator.width && n2 >= ((MultiSplitPane)MultiSplitPane.this).bottomSeparator.y && n2 < ((MultiSplitPane)MultiSplitPane.this).bottomSeparator.y + ((MultiSplitPane)MultiSplitPane.this).bottomSeparator.height ? horizontalResizeCursor : (((MultiSplitPane)MultiSplitPane.this).leftSeparator.width > 0 && n >= ((MultiSplitPane)MultiSplitPane.this).leftSeparator.x && n < ((MultiSplitPane)MultiSplitPane.this).leftSeparator.x + ((MultiSplitPane)MultiSplitPane.this).leftSeparator.width && n2 >= ((MultiSplitPane)MultiSplitPane.this).leftSeparator.y && n2 < ((MultiSplitPane)MultiSplitPane.this).leftSeparator.y + ((MultiSplitPane)MultiSplitPane.this).leftSeparator.height ? verticalResizeCursor : normalCursor)));
            if (MultiSplitPane.this.getCursor() != cursor) {
                MultiSplitPane.this.setCursor(cursor);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (MultiSplitPane.this.hasSeparators) {
                this.startDrag(mouseEvent);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.resizedComponent != null) {
                this.doDrag(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.resizedComponent != null) {
                this.endDrag(mouseEvent);
            }
        }

        private void startDrag(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = -1;
            if (((MultiSplitPane)MultiSplitPane.this).topSeparator.width > 0 && n >= ((MultiSplitPane)MultiSplitPane.this).topSeparator.x && n < ((MultiSplitPane)MultiSplitPane.this).topSeparator.x + ((MultiSplitPane)MultiSplitPane.this).topSeparator.width && n2 >= ((MultiSplitPane)MultiSplitPane.this).topSeparator.y && n2 < ((MultiSplitPane)MultiSplitPane.this).topSeparator.y + ((MultiSplitPane)MultiSplitPane.this).topSeparator.height) {
                n3 = this.indexOfPosition(1);
            } else if (((MultiSplitPane)MultiSplitPane.this).rightSeparator.width > 0 && n >= ((MultiSplitPane)MultiSplitPane.this).rightSeparator.x && n < ((MultiSplitPane)MultiSplitPane.this).rightSeparator.x + ((MultiSplitPane)MultiSplitPane.this).rightSeparator.width && n2 >= ((MultiSplitPane)MultiSplitPane.this).rightSeparator.y && n2 < ((MultiSplitPane)MultiSplitPane.this).rightSeparator.y + ((MultiSplitPane)MultiSplitPane.this).rightSeparator.height) {
                n3 = this.indexOfPosition(2);
            } else if (((MultiSplitPane)MultiSplitPane.this).bottomSeparator.width > 0 && n >= ((MultiSplitPane)MultiSplitPane.this).bottomSeparator.x && n < ((MultiSplitPane)MultiSplitPane.this).bottomSeparator.x + ((MultiSplitPane)MultiSplitPane.this).bottomSeparator.width && n2 >= ((MultiSplitPane)MultiSplitPane.this).bottomSeparator.y && n2 < ((MultiSplitPane)MultiSplitPane.this).bottomSeparator.y + ((MultiSplitPane)MultiSplitPane.this).bottomSeparator.height) {
                n3 = this.indexOfPosition(3);
            } else if (((MultiSplitPane)MultiSplitPane.this).leftSeparator.width > 0 && n >= ((MultiSplitPane)MultiSplitPane.this).leftSeparator.x && n < ((MultiSplitPane)MultiSplitPane.this).leftSeparator.x + ((MultiSplitPane)MultiSplitPane.this).leftSeparator.width && n2 >= ((MultiSplitPane)MultiSplitPane.this).leftSeparator.y && n2 < ((MultiSplitPane)MultiSplitPane.this).leftSeparator.y + ((MultiSplitPane)MultiSplitPane.this).leftSeparator.height) {
                n3 = this.indexOfPosition(4);
            }
            if (n3 >= 0) {
                this.resizedComponent = MultiSplitPane.this.getComponent(n3);
                this.resizedConstraints = MultiSplitPane.this.constraints[n3];
                this.dragX = n;
                this.dragY = n2;
            }
        }

        private int indexOfPosition(int n) {
            int n2 = 0;
            while (n2 < MultiSplitPane.this.constraints.length) {
                if (((MultiSplitPane)MultiSplitPane.this).constraints[n2].position == n) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        private void doDrag(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = n - this.dragX;
            int n4 = n2 - this.dragY;
            this.dragX = n;
            this.dragY = n2;
            double d = 0.0;
            switch (this.resizedConstraints.position) {
                case 1: {
                    d = (double)(this.resizedComponent.getHeight() + n4) / (double)MultiSplitPane.this.availableHeight;
                    break;
                }
                case 2: {
                    d = (double)(this.resizedComponent.getWidth() - n3) / (double)MultiSplitPane.this.availableWidth;
                    break;
                }
                case 3: {
                    d = (double)(this.resizedComponent.getHeight() - n4) / (double)MultiSplitPane.this.availableHeight;
                    break;
                }
                case 4: {
                    d = (double)(this.resizedComponent.getWidth() + n3) / (double)MultiSplitPane.this.availableWidth;
                }
            }
            if (d <= 0.0) {
                d = 0.001;
            } else if (d > 1.0) {
                d = 0.999;
            }
            if (this.resizedConstraints.size != d) {
                this.resizedConstraints.size = d;
                MultiSplitPane.this.revalidate();
                MultiSplitPane.this.repaint();
            }
        }

        private void endDrag(MouseEvent mouseEvent) {
            this.resizedComponent = null;
            this.resizedConstraints = null;
            this.dragY = -1;
            this.dragX = -1;
        }
    }

    private static final class Layout
    implements LayoutManager {
        private LayoutInfo[] infos = new LayoutInfo[5];
        private int infoCount;
        private boolean hasCenter;
        private boolean hasTop;
        private boolean hasRight;
        private boolean hasBottom;
        private boolean hasLeft;
        private boolean hasTopSepar;
        private boolean hasRightSepar;
        private boolean hasBottomSepar;
        private boolean hasLeftSepar;

        public Layout() {
            int n = 0;
            while (n < 5) {
                this.infos[n] = new LayoutInfo();
                ++n;
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.layoutSize((MultiSplitPane)container, 1);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.layoutSize((MultiSplitPane)container, 2);
        }

        private Dimension layoutSize(MultiSplitPane multiSplitPane, int n) {
            Dimension dimension;
            this.compileInfo(multiSplitPane);
            block0 : switch (this.infoCount) {
                case 0: {
                    dimension = new Dimension(0, 0);
                    break;
                }
                case 1: {
                    switch (n) {
                        case 1: {
                            dimension = this.infos[0].component.getMinimumSize();
                            break block0;
                        }
                        case 2: {
                            dimension = this.infos[0].component.getPreferredSize();
                            break block0;
                        }
                    }
                    dimension = new Dimension(1, 1);
                    break;
                }
                default: {
                    dimension = this.doLayoutSize(multiSplitPane, n);
                }
            }
            Insets insets = multiSplitPane.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            if (dimension.width < 1) {
                dimension.width = 1;
            }
            if (dimension.height < 1) {
                dimension.height = 1;
            }
            return dimension;
        }

        private void compileInfo(MultiSplitPane multiSplitPane) {
            this.infoCount = 0;
            this.hasCenter = false;
            this.hasTop = false;
            this.hasRight = false;
            this.hasBottom = false;
            this.hasLeft = false;
            this.hasTopSepar = false;
            this.hasRightSepar = false;
            this.hasBottomSepar = false;
            this.hasLeftSepar = false;
            LayoutInfo layoutInfo = null;
            LayoutInfo layoutInfo2 = null;
            LayoutInfo layoutInfo3 = null;
            LayoutInfo layoutInfo4 = null;
            Component[] componentArray = multiSplitPane.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                Component component = componentArray[n];
                Constraints constraints = multiSplitPane.constraints[n];
                if (component.isVisible() && (constraints.size > 0.0 || constraints.position == 0)) {
                    LayoutInfo layoutInfo5 = this.infos[this.infoCount++];
                    layoutInfo5.component = component;
                    layoutInfo5.index = n;
                    layoutInfo5.position = constraints.position;
                    layoutInfo5.size = constraints.size;
                    switch (layoutInfo5.position) {
                        case 0: {
                            this.hasCenter = true;
                            break;
                        }
                        case 1: {
                            this.hasTop = true;
                            layoutInfo = layoutInfo5;
                            break;
                        }
                        case 2: {
                            this.hasRight = true;
                            layoutInfo2 = layoutInfo5;
                            break;
                        }
                        case 3: {
                            this.hasBottom = true;
                            layoutInfo3 = layoutInfo5;
                            break;
                        }
                        case 4: {
                            this.hasLeft = true;
                            layoutInfo4 = layoutInfo5;
                        }
                    }
                }
                ++n;
            }
            this.hasTopSepar = this.hasTop && (this.hasCenter || this.hasRight && layoutInfo2.index > layoutInfo.index || this.hasBottom && layoutInfo3.index > layoutInfo.index || this.hasLeft && layoutInfo4.index > layoutInfo.index);
            this.hasRightSepar = this.hasRight && (this.hasCenter || this.hasTop && layoutInfo.index > layoutInfo2.index || this.hasBottom && layoutInfo3.index > layoutInfo2.index || this.hasLeft && layoutInfo4.index > layoutInfo2.index);
            this.hasBottomSepar = this.hasBottom && (this.hasCenter || this.hasTop && layoutInfo.index > layoutInfo3.index || this.hasRight && layoutInfo2.index > layoutInfo3.index || this.hasLeft && layoutInfo4.index > layoutInfo3.index);
            boolean bl = this.hasLeftSepar = this.hasLeft && (this.hasCenter || this.hasTop && layoutInfo.index > layoutInfo4.index || this.hasRight && layoutInfo2.index > layoutInfo4.index || this.hasBottom && layoutInfo3.index > layoutInfo4.index);
            if (this.infoCount > 1) {
                Arrays.sort(this.infos, 0, this.infoCount);
            }
        }

        private Dimension doLayoutSize(MultiSplitPane multiSplitPane, int n) {
            Dimension dimension;
            int n2 = this.infoCount - 1;
            if (this.hasCenter) {
                switch (n) {
                    case 1: {
                        dimension = this.infos[n2].component.getMinimumSize();
                        break;
                    }
                    case 2: {
                        dimension = this.infos[n2].component.getPreferredSize();
                        break;
                    }
                    default: {
                        dimension = new Dimension(1, 1);
                    }
                }
                --n2;
            } else {
                dimension = new Dimension(0, 0);
            }
            while (n2 >= 0) {
                Dimension dimension2;
                LayoutInfo layoutInfo = this.infos[n2];
                switch (n) {
                    case 1: {
                        dimension2 = layoutInfo.component.getMinimumSize();
                        break;
                    }
                    case 2: {
                        dimension2 = layoutInfo.component.getPreferredSize();
                        break;
                    }
                    default: {
                        dimension2 = new Dimension(1, 1);
                    }
                }
                switch (layoutInfo.position) {
                    case 1: 
                    case 3: {
                        dimension.width = Math.max(dimension2.width, dimension.width);
                        dimension.height += dimension2.height;
                        if (!this.hasTopSepar && !this.hasBottomSepar) break;
                        dimension.width = Math.max(5, dimension.width);
                        dimension.height += 5;
                        break;
                    }
                    case 2: 
                    case 4: {
                        dimension.width += dimension2.width;
                        dimension.height = Math.max(dimension2.height, dimension.height);
                        if (!this.hasLeftSepar && !this.hasRightSepar) break;
                        dimension.width += 5;
                        dimension.height = Math.max(5, dimension.height);
                    }
                }
                --n2;
            }
            return dimension;
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            LayoutInfo layoutInfo;
            MultiSplitPane multiSplitPane = (MultiSplitPane)container;
            Insets insets = multiSplitPane.getInsets();
            int n3 = insets.left;
            int n4 = insets.top;
            int n5 = multiSplitPane.getWidth() - n3 - insets.right;
            int n6 = multiSplitPane.getHeight() - n4 - insets.bottom;
            multiSplitPane.availableWidth = n5;
            multiSplitPane.availableHeight = n6;
            Rectangle rectangle = multiSplitPane.topSeparator;
            Rectangle rectangle2 = multiSplitPane.rightSeparator;
            Rectangle rectangle3 = multiSplitPane.bottomSeparator;
            Rectangle rectangle4 = multiSplitPane.leftSeparator;
            rectangle.width = -1;
            rectangle2.width = -1;
            rectangle3.width = -1;
            rectangle4.width = -1;
            multiSplitPane.hasSeparators = false;
            Component[] componentArray = multiSplitPane.getComponents();
            int n7 = 0;
            while (n7 < componentArray.length) {
                componentArray[n7].setBounds(-1, -1, 1, 1);
                ++n7;
            }
            this.compileInfo(multiSplitPane);
            switch (this.infoCount) {
                case 0: {
                    return;
                }
                case 1: {
                    this.infos[0].component.setBounds(n3, n4, n5, n6);
                    return;
                }
            }
            Dimension dimension = this.doLayoutSize(multiSplitPane, 0);
            if (n5 < dimension.width) {
                n5 = dimension.width;
            }
            if (n6 < dimension.height) {
                n6 = dimension.height;
            }
            int n8 = n5;
            if (this.hasLeft) {
                --n8;
            }
            if (this.hasCenter) {
                --n8;
            }
            if (this.hasRight) {
                --n8;
            }
            if (this.hasLeftSepar) {
                n8 -= 5;
            }
            if (this.hasRightSepar) {
                n8 -= 5;
            }
            int n9 = n6;
            if (this.hasTop) {
                --n9;
            }
            if (this.hasCenter) {
                --n9;
            }
            if (this.hasBottom) {
                --n9;
            }
            if (this.hasTopSepar) {
                n9 -= 5;
            }
            if (this.hasBottomSepar) {
                n9 -= 5;
            }
            multiSplitPane.availableWidth = n8;
            multiSplitPane.availableHeight = n9;
            int n10 = this.infoCount;
            if (this.hasCenter) {
                --n10;
            } else {
                LayoutInfo layoutInfo2 = null;
                LayoutInfo layoutInfo3 = null;
                LayoutInfo layoutInfo4 = null;
                layoutInfo = null;
                n2 = 0;
                while (n2 < n10) {
                    LayoutInfo layoutInfo5 = this.infos[n2];
                    switch (layoutInfo5.position) {
                        case 1: {
                            layoutInfo2 = layoutInfo5;
                            break;
                        }
                        case 2: {
                            layoutInfo3 = layoutInfo5;
                            break;
                        }
                        case 3: {
                            layoutInfo4 = layoutInfo5;
                            break;
                        }
                        case 4: {
                            layoutInfo = layoutInfo5;
                        }
                    }
                    ++n2;
                }
                n = n10 - 1;
                block22: while (n >= 0) {
                    switch (this.infos[n].position) {
                        case 1: 
                        case 3: {
                            double d;
                            if (this.hasTop) {
                                if (this.hasBottom) {
                                    d = 1.0 - layoutInfo2.size - layoutInfo4.size;
                                    if (!(d > 0.0)) break block22;
                                    layoutInfo2.size += d / 2.0 * (layoutInfo2.size / layoutInfo4.size);
                                    layoutInfo4.size = 1.0 - layoutInfo2.size;
                                    break block22;
                                }
                                layoutInfo2.size = 1.0;
                                break block22;
                            }
                            if (!this.hasBottom) break block22;
                            layoutInfo4.size = 1.0;
                            break block22;
                        }
                        case 2: 
                        case 4: {
                            double d;
                            if (this.hasLeft) {
                                if (this.hasRight) {
                                    d = 1.0 - layoutInfo.size - layoutInfo3.size;
                                    if (!(d > 0.0)) break block22;
                                    layoutInfo.size += d / 2.0 * (layoutInfo.size / layoutInfo3.size);
                                    layoutInfo3.size = 1.0 - layoutInfo.size;
                                    break block22;
                                }
                                layoutInfo.size = 1.0;
                                break block22;
                            }
                            if (!this.hasRight) break block22;
                            layoutInfo3.size = 1.0;
                            break block22;
                        }
                        default: {
                            --n;
                        }
                    }
                }
            }
            int n11 = n8;
            int n12 = n9;
            int n13 = 0;
            while (n13 < n10) {
                layoutInfo = this.infos[n13];
                switch (layoutInfo.position) {
                    case 1: {
                        int n14 = (int)Math.rint(layoutInfo.size * (double)n9);
                        if (n14 > n12) {
                            n14 = n12;
                        }
                        if (n14 < 1) {
                            n14 = 1;
                        }
                        layoutInfo.component.setBounds(n3, n4, n5, n14);
                        n6 -= n14;
                        n4 += n14;
                        n12 -= n14;
                        if (!this.hasTopSepar) break;
                        rectangle.x = n3;
                        rectangle.y = n4;
                        rectangle.width = n5;
                        rectangle.height = 5;
                        n6 -= 5;
                        n4 += 5;
                        n12 -= 5;
                        break;
                    }
                    case 3: {
                        int n14 = (int)Math.rint(layoutInfo.size * (double)n9);
                        if (n14 > n12) {
                            n14 = n12;
                        }
                        if (n14 < 1) {
                            n14 = 1;
                        }
                        n = n4 + n6 - n14;
                        layoutInfo.component.setBounds(n3, n, n5, n14);
                        n6 -= n14;
                        n12 -= n14;
                        if (!this.hasBottomSepar) break;
                        rectangle3.x = n3;
                        rectangle3.y = n - 5;
                        rectangle3.width = n5;
                        rectangle3.height = 5;
                        n6 -= 5;
                        n12 -= 5;
                        break;
                    }
                    case 4: {
                        int n15 = (int)Math.rint(layoutInfo.size * (double)n8);
                        if (n15 > n11) {
                            n15 = n11;
                        }
                        if (n15 < 1) {
                            n15 = 1;
                        }
                        layoutInfo.component.setBounds(n3, n4, n15, n6);
                        n5 -= n15;
                        n3 += n15;
                        n11 -= n15;
                        if (!this.hasLeftSepar) break;
                        rectangle4.x = n3;
                        rectangle4.y = n4;
                        rectangle4.width = 5;
                        rectangle4.height = n6;
                        n5 -= 5;
                        n3 += 5;
                        n11 -= 5;
                        break;
                    }
                    case 2: {
                        int n16 = (int)Math.rint(layoutInfo.size * (double)n8);
                        if (n16 > n11) {
                            n16 = n11;
                        }
                        if (n16 < 1) {
                            n16 = 1;
                        }
                        n2 = n3 + n5 - n16;
                        layoutInfo.component.setBounds(n2, n4, n16, n6);
                        n5 -= n16;
                        n11 -= n16;
                        if (!this.hasRightSepar) break;
                        rectangle2.x = n2 - 5;
                        rectangle2.y = n4;
                        rectangle2.width = 5;
                        rectangle2.height = n6;
                        n5 -= 5;
                        n11 -= 5;
                    }
                }
                ++n13;
            }
            if (this.hasCenter) {
                this.infos[n10].component.setBounds(n3, n4, n5, n6);
            }
            multiSplitPane.hasSeparators = rectangle.width > 0 || rectangle2.width > 0 || rectangle3.width > 0 || rectangle4.width > 0;
        }
    }

    private static final class LayoutInfo
    implements Comparable {
        public Component component;
        public int index;
        public int position;
        public double size;

        private LayoutInfo() {
        }

        public int compareTo(Object object) {
            LayoutInfo layoutInfo = (LayoutInfo)object;
            if (this.position == 0) {
                return Integer.MAX_VALUE;
            }
            if (layoutInfo.position == 0) {
                return Integer.MIN_VALUE;
            }
            return this.index - layoutInfo.index;
        }
    }

    public static final class Constraints
    implements Cloneable {
        public int position;
        public double size;

        public Constraints() {
            this(0, 0.25);
        }

        public Constraints(int n, double d) {
            if (n < 0 || n > 4) {
                n = 0;
            }
            this.position = n;
            if (d < 0.0) {
                d = 0.0;
            } else if (d > 1.0) {
                d = 1.0;
            }
            this.size = d;
        }

        public Constraints copy() {
            try {
                return (Constraints)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

