/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.guiutil;

import com.xmlmind.xmledit.guiutil.BrowseButton;
import com.xmlmind.xmledit.guiutil.DialogBase;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PromptDialog
extends DialogBase {
    private JLabel promptLabel;
    private JTextField valueField;
    private BrowseButton browseButton;
    private URL baseURL;
    private boolean allowEmptyString;
    private String result = null;

    public PromptDialog(Dialog dialog) {
        this(dialog, false);
    }

    public PromptDialog(Dialog dialog, boolean bl) {
        super(dialog, "", true);
        this.initialize((Component)dialog, bl);
    }

    public PromptDialog(Component component) {
        this(component, false);
    }

    public PromptDialog(Component component, boolean bl) {
        super(component, "", true);
        this.initialize(component, bl);
    }

    protected void initialize(Component component, boolean bl) {
        int n = 26;
        if (bl) {
            n |= 0x40;
        }
        super.initialize(component, n);
    }

    protected Component createForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.promptLabel = new JLabel("???");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        jPanel.add((Component)this.promptLabel, gridBagConstraints);
        this.valueField = new JTextField(60);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 1;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)this.valueField, gridBagConstraints);
        this.browseButton = new BrowseButton();
        this.browseButton.setActionCommand("browse");
        this.browseButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.browseButton, gridBagConstraints);
        return jPanel;
    }

    public void ok() {
        this.result = this.valueField.getText().trim();
        if (this.result.length() == 0 && !this.allowEmptyString) {
            DialogUtil.badField(this.valueField);
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    public void cancel() {
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    public void browse() {
        String string = this.browseButton.getSelection(this, this.baseURL);
        if (string == null) {
            return;
        }
        this.valueField.setText(string);
    }

    public String getValue(String string, String string2, String string3, URL uRL, boolean bl) {
        this.baseURL = uRL;
        this.allowEmptyString = bl;
        if (string != null) {
            this.setTitle(string);
        }
        this.promptLabel.setText(string2);
        this.valueField.setText(string3 == null ? "" : string3);
        this.valueField.selectAll();
        this.getRootPane().setDefaultButton(this.dialogButtons[0]);
        this.setLocationRelativeTo(this.dialogAnchor);
        this.pack();
        this.valueField.requestFocus();
        this.setVisible(true);
        return this.result;
    }
}

