/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.guiutil;

import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.AutoCompletion;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.guiutil.Msg;
import com.xmlmind.xmledit.util.StringUtil;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class StringChooserDialog
extends JDialog
implements ActionListener,
MouseListener {
    private Component dialogAnchor;
    private JButton okButton;
    private JTextField field;
    private JList list;
    private AutoCompletion autoCompletion;
    private boolean singleClick;
    private boolean pressSpaceToAppend;
    private boolean allowAny;
    private String result;
    static /* synthetic */ Class class$com$xmlmind$xmledit$guiutil$StringChooserDialog;

    public StringChooserDialog(Dialog dialog, String string, int n, int n2) {
        super(dialog, string, true);
        this.initialize(dialog, n, n2);
    }

    public StringChooserDialog(Component component, String string, int n, int n2) {
        super(AWTUtil.getFrame(component), string, true);
        this.initialize(component, n, n2);
    }

    public void setSingleClick(boolean bl) {
        this.singleClick = bl;
    }

    public boolean isSingleClick() {
        return this.singleClick;
    }

    public void setPressSpaceToAppend(boolean bl) {
        this.pressSpaceToAppend = bl;
        AWTKeyStroke[] aWTKeyStrokeArray = bl ? new AWTKeyStroke[]{AWTKeyStroke.getAWTKeyStroke(32, 2), AWTKeyStroke.getAWTKeyStroke(' ')} : new AWTKeyStroke[]{AWTKeyStroke.getAWTKeyStroke(32, 2)};
        this.autoCompletion.setAppendKeyStrokes(aWTKeyStrokeArray);
    }

    public boolean getPressSpaceToAppend() {
        return this.pressSpaceToAppend;
    }

    private void initialize(Component component, int n, int n2) {
        this.dialogAnchor = AWTUtil.getDialogAnchor(component);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StringChooserDialog.this.cancel();
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        jPanel.registerKeyboardAction(this, "cancel", KeyStroke.getKeyStroke(27, 0), 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JButton jButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$guiutil$StringChooserDialog == null ? (class$com$xmlmind$xmledit$guiutil$StringChooserDialog = StringChooserDialog.class$("com.xmlmind.xmledit.guiutil.StringChooserDialog")) : class$com$xmlmind$xmledit$guiutil$StringChooserDialog, "cancel.gif")));
        jButton.setToolTipText(DialogUtil.buttonLabel(Msg.msg("cancel")));
        DialogUtil.setIconic(jButton);
        jButton.setActionCommand("cancel");
        jButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        jPanel.add((Component)jButton, gridBagConstraints);
        this.okButton = new JButton(new ImageIcon(ImageResource.get(class$com$xmlmind$xmledit$guiutil$StringChooserDialog == null ? (class$com$xmlmind$xmledit$guiutil$StringChooserDialog = StringChooserDialog.class$("com.xmlmind.xmledit.guiutil.StringChooserDialog")) : class$com$xmlmind$xmledit$guiutil$StringChooserDialog, "ok.gif")));
        this.okButton.setToolTipText(DialogUtil.buttonLabel(Msg.msg("ok")));
        DialogUtil.setIconic(this.okButton);
        this.okButton.setActionCommand("ok");
        this.okButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 2;
        jPanel.add((Component)this.okButton, gridBagConstraints);
        this.field = new JTextField(n2);
        this.field.setActionCommand("ok");
        this.field.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)this.field, gridBagConstraints);
        this.list = new JList();
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(n);
        this.list.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        AWTUtil.setFocusable(jScrollPane, false);
        this.autoCompletion = new AutoCompletion(this.field);
        this.autoCompletion.setList(this.list);
        this.setPressSpaceToAppend(false);
        this.pack();
        this.setResizable(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok".equals(string)) {
            this.ok();
        } else if ("cancel".equals(string)) {
            this.cancel();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getClickCount();
        if (n2 == 1 && (n = this.list.locationToIndex(mouseEvent.getPoint())) >= 0) {
            String string = (String)this.list.getModel().getElementAt(n);
            this.autoCompletion.setEntry(string);
        }
        if (n2 == (this.singleClick ? 1 : 2)) {
            this.ok();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void ok() {
        AutoCompletion.ChoicesBase choicesBase = (AutoCompletion.ChoicesBase)this.autoCompletion.getChoices();
        String[] stringArray = (String[])choicesBase.getAll();
        String string = this.field.getText().trim();
        if (string.length() == 0 || !this.allowAny && !StringUtil.contains(stringArray, string)) {
            this.field.selectAll();
            this.field.requestFocus();
            return;
        }
        this.result = string;
        this.setVisible(false);
        this.dispose();
    }

    public void cancel() {
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    public String chooseItem(String[] stringArray, boolean bl, String string) {
        this.allowAny = bl;
        if (stringArray.length > 1) {
            stringArray = (String[])stringArray.clone();
            Arrays.sort(stringArray);
        }
        AutoCompletion.ChoicesBase choicesBase = AutoCompletion.getPreferMinimalChoices() ? new AutoCompletion.MinimalChoices(stringArray) : new AutoCompletion.SimpleChoices(stringArray);
        this.autoCompletion.setChoices(choicesBase);
        if (string == null) {
            string = "";
        }
        this.autoCompletion.setEntry(string);
        this.field.selectAll();
        this.autoCompletion.suggest();
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.field.requestFocus();
        this.result = null;
        this.setVisible(true);
        return this.result;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

