/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.guiutil;

import com.xmlmind.xmledit.guiutil.TabConstants;
import com.xmlmind.xmledit.guiutil.TabbedSplitPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;

public abstract class Tab
implements TabConstants,
MouseListener {
    protected Component component;
    protected boolean atStart;
    protected boolean selected;
    protected TabbedSplitPane pane;
    protected int side;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    private static float[] hsb1 = new float[3];
    private static float[] hsb2 = new float[3];

    protected Tab(Component component, boolean bl) {
        this.component = component;
        this.atStart = bl;
        this.selected = false;
    }

    public Component getComponent() {
        return this.component;
    }

    public boolean isAtStart() {
        return this.atStart;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public TabbedSplitPane getPane() {
        return this.pane;
    }

    public abstract String getLabel();

    public abstract Icon getIcon();

    public abstract String getToolTip();

    public abstract Dimension getIntrinsicSize();

    public abstract void paint(Graphics var1, Color var2, Color var3, Color var4, Color var5, Color var6);

    protected void paintSimpleTab(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5) {
        Color color6;
        if (this.selected) {
            color6 = color;
        } else {
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb1);
            Color.RGBtoHSB(color4.getRed(), color4.getGreen(), color4.getBlue(), hsb2);
            Tab.hsb1[0] = (hsb1[0] + hsb2[0]) / 2.0f;
            Tab.hsb1[1] = (hsb1[1] + hsb2[1]) / 2.0f;
            Tab.hsb1[2] = hsb2[2] + (hsb1[2] - hsb2[2]) / 2.0f;
            color6 = Color.getHSBColor(hsb1[0], hsb1[1], hsb1[2]);
        }
        graphics.setColor(color6);
        switch (this.side) {
            case 1: {
                graphics.fillRect(this.x - 2, this.y + 2, this.width + 2, this.height - 2);
                break;
            }
            case 3: {
                graphics.fillRect(this.x, this.y + 2, this.width + 2, this.height - 2);
                break;
            }
            case 2: {
                graphics.fillRect(this.x + 2, this.y - 2, this.width - 2, this.height + 2);
                break;
            }
            default: {
                graphics.fillRect(this.x + 2, this.y, this.width - 2, this.height + 2);
            }
        }
        int n = this.x;
        int n2 = this.y;
        int n3 = this.x + this.width - 1;
        int n4 = this.y + this.height - 1;
        graphics.setColor(color2);
        switch (this.side) {
            case 1: {
                graphics.drawLine(n - 1, n2, n3, n2);
                graphics.drawLine(n3, n2, n3, n4);
                graphics.drawLine(n3, n4, n - 1, n4);
                break;
            }
            case 3: {
                graphics.drawLine(n3 + 1, n2, n, n2);
                graphics.drawLine(n, n2, n, n4);
                graphics.drawLine(n, n4, n3 + 1, n4);
                break;
            }
            case 2: {
                graphics.drawLine(n, n2 - 1, n, n4);
                graphics.drawLine(n, n4, n3, n4);
                graphics.drawLine(n3, n4, n3, n2 - 1);
                break;
            }
            default: {
                graphics.drawLine(n, n4 + 1, n, n2);
                graphics.drawLine(n, n2, n3, n2);
                graphics.drawLine(n3, n2, n3, n4 + 1);
            }
        }
        ++n;
        ++n2;
        --n3;
        --n4;
        graphics.setColor(color4);
        switch (this.side) {
            case 1: {
                graphics.drawLine(n3, n2, n3, n4);
                graphics.drawLine(n3, n4, n - 2, n4);
                break;
            }
            case 3: {
                graphics.drawLine(n, n4, n3 + 2, n4);
                break;
            }
            case 2: {
                graphics.drawLine(n, n4, n3, n4);
                graphics.drawLine(n3, n4, n3, n2 - 2);
                break;
            }
            default: {
                graphics.drawLine(n3, n2, n3, n4 + 2);
            }
        }
        graphics.setColor(color3);
        switch (this.side) {
            case 1: {
                graphics.drawLine(n - 2, n2, n3, n2);
                break;
            }
            case 3: {
                graphics.drawLine(n3 + 2, n2, n, n2);
                graphics.drawLine(n, n2, n, n4);
                break;
            }
            case 2: {
                graphics.drawLine(n, n2 - 2, n, n4);
                break;
            }
            default: {
                graphics.drawLine(n, n4 + 2, n, n2);
                graphics.drawLine(n, n2, n3, n2);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("[atStart=");
        stringBuffer.append(this.atStart);
        stringBuffer.append(",selected=");
        stringBuffer.append(this.selected);
        stringBuffer.append(",side=");
        stringBuffer.append(this.side);
        stringBuffer.append(",x=");
        stringBuffer.append(this.x);
        stringBuffer.append(",y=");
        stringBuffer.append(this.y);
        stringBuffer.append(",width=");
        stringBuffer.append(this.width);
        stringBuffer.append(",height=");
        stringBuffer.append(this.height);
        stringBuffer.append(",component=");
        stringBuffer.append(this.component);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.selected) {
            this.pane.selectTab(this);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

