/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.guiutil;

import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.guiutil.Tab;
import com.xmlmind.xmledit.guiutil.TabConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class TabbedSplitPane
extends JComponent
implements ItemSelectable,
TabConstants {
    private Tab[] tabs;
    private int tabPlacement = 0;
    private boolean verticalSplit = false;
    private double horizontalRatio = 0.5;
    private double verticalRatio = 0.5;
    private boolean endTabAtOppositeSide = true;
    private EventListenerList listenerList = new EventListenerList();
    private int startTabAreaX;
    private int startTabAreaY;
    private int startTabAreaW;
    private int startTabAreaH;
    private int startButtonX;
    private int startButtonY;
    private int startButtonW;
    private int startButtonH;
    private int startFrameX;
    private int startFrameY;
    private int startFrameW;
    private int startFrameH;
    private int separatorX;
    private int separatorY;
    private int separatorW;
    private int separatorH;
    private int endTabAreaX;
    private int endTabAreaY;
    private int endTabAreaW;
    private int endTabAreaH;
    private int endButtonX;
    private int endButtonY;
    private int endButtonW;
    private int endButtonH;
    private int endFrameX;
    private int endFrameY;
    private int endFrameW;
    private int endFrameH;
    private static Cursor normalCursor = null;
    private static Cursor verticalResizeCursor = null;
    private static Cursor horizontalResizeCursor = null;
    private static final int BUTTON_GAP = 5;
    private static final int BUTTON_WIDTH = 15;
    private static final int BUTTON_HEIGHT = 15;
    private static final int COMPONENT_MARGIN = 3;
    private static final int SEPARATOR_THICKNESS = 5;
    static /* synthetic */ Class class$com$xmlmind$xmledit$guiutil$TabbedSplitPane;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public TabbedSplitPane() {
        Object object;
        this.tabs = new Tab[0];
        this.setLayout(new Layout());
        this.setFont(UIManager.getFont("TabbedPane.font"));
        this.setToolTipText("(dynamic)");
        if (normalCursor == null) {
            normalCursor = Cursor.getDefaultCursor();
            object = this.getToolkit();
            Dimension dimension = ((Toolkit)object).getBestCursorSize(16, 16);
            if (dimension.width == 16 && dimension.height == 16) {
                Image image = ImageResource.get(class$com$xmlmind$xmledit$guiutil$TabbedSplitPane == null ? (class$com$xmlmind$xmledit$guiutil$TabbedSplitPane = TabbedSplitPane.class$("com.xmlmind.xmledit.guiutil.TabbedSplitPane")) : class$com$xmlmind$xmledit$guiutil$TabbedSplitPane, "verticalResizeCursor.gif");
                Point point = new Point(7, 7);
                verticalResizeCursor = ((Toolkit)object).createCustomCursor(image, point, "verticalResizeTabbedSplitPane");
                image = ImageResource.get(class$com$xmlmind$xmledit$guiutil$TabbedSplitPane == null ? (class$com$xmlmind$xmledit$guiutil$TabbedSplitPane = TabbedSplitPane.class$("com.xmlmind.xmledit.guiutil.TabbedSplitPane")) : class$com$xmlmind$xmledit$guiutil$TabbedSplitPane, "horizontalResizeCursor.gif");
                horizontalResizeCursor = ((Toolkit)object).createCustomCursor(image, point, "horizontalResizeTabbedSplitPane");
            } else {
                verticalResizeCursor = Cursor.getPredefinedCursor(11);
                horizontalResizeCursor = Cursor.getPredefinedCursor(8);
            }
        }
        this.setCursor(normalCursor);
        object = new MouseHandler();
        this.addMouseListener((MouseListener)object);
        this.addMouseMotionListener((MouseMotionListener)object);
    }

    public void setTabPlacement(int n) {
        if (this.tabPlacement != n) {
            this.tabPlacement = n;
            this.refresh();
        }
    }

    private void refresh() {
        this.updateTabSides();
        this.revalidate();
        this.repaint();
    }

    private void updateTabSides() {
        int n = 0;
        while (n < this.tabs.length) {
            Tab tab = this.tabs[n];
            tab.side = this.tabSide(tab.atStart);
            ++n;
        }
    }

    private int tabSide(boolean bl) {
        boolean bl2 = this.isSplit();
        if (this.endTabAtOppositeSide) {
            switch (this.tabPlacement) {
                case 1: {
                    if (this.verticalSplit || !bl2) {
                        if (bl) {
                            return 1;
                        }
                        return 3;
                    }
                    return 1;
                }
                case 3: {
                    if (this.verticalSplit || !bl2) {
                        if (bl) {
                            return 3;
                        }
                        return 1;
                    }
                    return 3;
                }
                case 2: {
                    if (!this.verticalSplit || !bl2) {
                        if (bl) {
                            return 2;
                        }
                        return 0;
                    }
                    return 2;
                }
            }
            if (!this.verticalSplit || !bl2) {
                if (bl) {
                    return 0;
                }
                return 2;
            }
            return 0;
        }
        switch (this.tabPlacement) {
            case 1: {
                if (bl2 && this.verticalSplit) {
                    if (bl) {
                        return 1;
                    }
                    return 3;
                }
                return 1;
            }
            case 3: {
                if (bl2 && this.verticalSplit) {
                    if (bl) {
                        return 3;
                    }
                    return 1;
                }
                return 3;
            }
            case 2: {
                if (bl2 && !this.verticalSplit) {
                    if (bl) {
                        return 2;
                    }
                    return 0;
                }
                return 2;
            }
        }
        if (bl2 && !this.verticalSplit) {
            if (bl) {
                return 0;
            }
            return 2;
        }
        return 0;
    }

    public boolean isSplit() {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < this.tabs.length) {
            Tab tab = this.tabs[n];
            if (tab.atStart) {
                bl = true;
            } else {
                bl2 = true;
            }
            ++n;
        }
        return bl && bl2;
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public boolean isVerticalTabPlacement() {
        switch (this.tabPlacement) {
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void setVerticalSplit(boolean bl) {
        if (this.verticalSplit != bl) {
            this.verticalSplit = bl;
            this.refresh();
        }
    }

    public boolean isVerticalSplit() {
        return this.verticalSplit;
    }

    public void setHorizontalRatio(double d) {
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        if (this.horizontalRatio != d) {
            this.horizontalRatio = d;
            this.revalidate();
            this.repaint();
        }
    }

    public double getHorizontalRatio() {
        return this.horizontalRatio;
    }

    public void setVerticalRatio(double d) {
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        if (this.verticalRatio != d) {
            this.verticalRatio = d;
            this.revalidate();
            this.repaint();
        }
    }

    public double getVerticalRatio() {
        return this.verticalRatio;
    }

    public void setEndTabAtOppositeSide(boolean bl) {
        if (bl != this.endTabAtOppositeSide) {
            this.endTabAtOppositeSide = bl;
            this.refresh();
        }
    }

    public boolean isEndTabAtOppositeSide() {
        return this.endTabAtOppositeSide;
    }

    public void addTab(Tab tab) {
        this.addTab(tab, this.tabs.length);
    }

    public void addTab(Tab tab, int n) {
        int n2;
        Tab[] tabArray = new Tab[this.tabs.length + 1];
        if (n > 0) {
            System.arraycopy(this.tabs, 0, tabArray, 0, n);
        }
        if ((n2 = this.tabs.length - n) > 0) {
            System.arraycopy(this.tabs, n, tabArray, n + 1, n2);
        }
        tabArray[n] = tab;
        tab.pane = this;
        tab.selected = false;
        tab.component.setVisible(false);
        this.tabs = tabArray;
        super.addImpl(tab.component, null, n);
        this.tabsChanged();
    }

    private void tabsChanged() {
        this.checkSelected();
        this.refresh();
    }

    private void checkSelected() {
        Tab tab = null;
        Tab tab2 = null;
        Tab tab3 = null;
        Tab tab4 = null;
        int n = 0;
        while (n < this.tabs.length) {
            Tab tab5 = this.tabs[n];
            if (tab5.atStart) {
                if (tab == null) {
                    tab = tab5;
                }
                if (tab5.selected) {
                    if (tab2 == null) {
                        tab2 = tab5;
                    } else {
                        tab5.selected = false;
                        tab5.component.setVisible(false);
                        this.tabDeselected(tab5);
                    }
                }
            } else {
                if (tab3 == null) {
                    tab3 = tab5;
                }
                if (tab5.selected) {
                    if (tab4 == null) {
                        tab4 = tab5;
                    } else {
                        tab5.selected = false;
                        tab5.component.setVisible(false);
                        this.tabDeselected(tab5);
                    }
                }
            }
            ++n;
        }
        if (tab != null && tab2 == null) {
            tab.selected = true;
            tab.component.setVisible(true);
            this.tabSelected(tab);
        }
        if (tab3 != null && tab4 == null) {
            tab3.selected = true;
            tab3.component.setVisible(true);
            this.tabSelected(tab3);
        }
    }

    public void removeTab(Tab tab) {
        int n = this.indexOfTab(tab);
        if (n < 0) {
            return;
        }
        this.removeTab(n);
    }

    public int indexOfTab(Tab tab) {
        int n = 0;
        while (n < this.tabs.length) {
            if (tab == this.tabs[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Tab removeTab(int n) {
        int n2;
        int n3;
        Tab tab = this.tabs[n];
        tab.pane = null;
        Tab[] tabArray = new Tab[this.tabs.length - 1];
        if (n > 0) {
            System.arraycopy(this.tabs, 0, tabArray, 0, n);
        }
        if ((n3 = this.tabs.length - (n2 = n + 1)) > 0) {
            System.arraycopy(this.tabs, n2, tabArray, n, n3);
        }
        this.tabs = tabArray;
        this.remove(n);
        this.tabsChanged();
        return tab;
    }

    public void removeAllTabs() {
        if (this.tabs.length == 0) {
            return;
        }
        this.tabs = new Tab[0];
        this.removeAll();
        this.revalidate();
        this.repaint();
    }

    public int getTabCount() {
        return this.tabs.length;
    }

    public Tab getTab(int n) {
        return this.tabs[n];
    }

    public Tab[] getAllTabs() {
        return this.tabs;
    }

    public Tab selectTab(int n) {
        Tab tab = this.tabs[n];
        if (!tab.selected) {
            tab.selected = true;
            tab.component.setVisible(true);
            this.tabSelected(tab);
            int n2 = 0;
            while (n2 < this.tabs.length) {
                Tab tab2 = this.tabs[n2];
                if (tab2 != tab && tab2.selected && tab2.atStart == tab.atStart) {
                    tab2.selected = false;
                    tab2.component.setVisible(false);
                    this.tabDeselected(tab2);
                }
                ++n2;
            }
            if (this.isShowing()) {
                ((Layout)this.getLayout()).relayoutTabs(this, tab.atStart);
            } else {
                this.revalidate();
            }
            this.repaint();
        }
        return tab;
    }

    public void selectTab(Tab tab) {
        int n = this.indexOfTab(tab);
        if (n < 0) {
            return;
        }
        this.selectTab(n);
    }

    public Tab[] getSelectedTabs() {
        Object object;
        Tab[] tabArray = new Tab[2];
        int n = 0;
        int n2 = 0;
        while (n2 < this.tabs.length) {
            object = this.tabs[n2];
            if (object.selected) {
                tabArray[n++] = object;
            }
            ++n2;
        }
        if (n != 2) {
            object = new Tab[n];
            System.arraycopy(tabArray, 0, object, 0, n);
            tabArray = object;
        } else if (!tabArray[0].atStart) {
            object = tabArray[0];
            tabArray[0] = tabArray[1];
            tabArray[1] = object;
        }
        return tabArray;
    }

    public Tab moveTab(int n, boolean bl) {
        Tab tab = this.tabs[n];
        if (tab.atStart != bl) {
            tab.atStart = bl;
            boolean bl2 = tab.selected;
            tab.selected = false;
            tab.component.setVisible(false);
            if (bl2) {
                this.tabDeselected(tab);
            }
            this.tabsChanged();
        }
        return tab;
    }

    public void moveTab(Tab tab, boolean bl) {
        int n = this.indexOfTab(tab);
        if (n < 0) {
            return;
        }
        this.moveTab(n, bl);
    }

    public boolean isVisibleTab(Tab tab) {
        if (tab.atStart) {
            if (this.isVerticalTabPlacement()) {
                return tab.y >= this.startTabAreaY && tab.y + tab.height <= this.startTabAreaY + this.startTabAreaH;
            }
            return tab.x >= this.startTabAreaX && tab.x + tab.width <= this.startTabAreaX + this.startTabAreaW;
        }
        if (this.isVerticalTabPlacement()) {
            return tab.y >= this.endTabAreaY && tab.y + tab.height <= this.endTabAreaY + this.endTabAreaH;
        }
        return tab.x >= this.endTabAreaX && tab.x + tab.width <= this.endTabAreaX + this.endTabAreaW;
    }

    public void repaintTab(Tab tab) {
        if (this.isVisibleTab(tab)) {
            this.repaint(tab.x, tab.y, tab.width, tab.height);
        }
    }

    public void repaintAllTabs() {
        if (this.startTabAreaW > 0 && this.startTabAreaH > 0) {
            this.repaint(this.startTabAreaX, this.startTabAreaY, this.startTabAreaW, this.startTabAreaH);
        }
        if (this.endTabAreaW > 0 && this.endTabAreaH > 0) {
            this.repaint(this.endTabAreaX, this.endTabAreaY, this.endTabAreaW, this.endTabAreaH);
        }
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedTabs();
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = TabbedSplitPane.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = TabbedSplitPane.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    private void tabSelected(Tab tab) {
        this.fireItemStateChanged(tab, 1);
    }

    private void tabDeselected(Tab tab) {
        this.fireItemStateChanged(tab, 2);
    }

    private void fireItemStateChanged(Tab tab, int n) {
        Object[] objectArray = this.listenerList.getListenerList();
        if (objectArray.length == 0) {
            return;
        }
        ItemEvent itemEvent = new ItemEvent(this, 701, tab, n);
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$java$awt$event$ItemListener == null ? TabbedSplitPane.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) {
                ((ItemListener)objectArray[n2 + 1]).itemStateChanged(itemEvent);
            }
            n2 -= 2;
        }
    }

    public Component add(Component component) {
        throw new UnsupportedOperationException("use addTab");
    }

    public Component add(String string, Component component) {
        throw new UnsupportedOperationException("use addTab");
    }

    public Component add(Component component, int n) {
        throw new UnsupportedOperationException("use addTab");
    }

    public void add(Component component, Object object) {
        throw new UnsupportedOperationException("use addTab");
    }

    public void add(Component component, Object object, int n) {
        throw new UnsupportedOperationException("use addTab");
    }

    public void remove(Component component) {
        throw new UnsupportedOperationException("use removeTab");
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = 0;
        while (n3 < this.tabs.length) {
            Tab tab = this.tabs[n3];
            if (n >= tab.x && n < tab.x + tab.width && n2 >= tab.y && n2 < tab.y + tab.height) {
                return tab.getToolTip();
            }
            ++n3;
        }
        return null;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics = graphics.create();
        this.doPaintComponent(graphics);
        graphics.dispose();
    }

    private void doPaintComponent(Graphics graphics) {
        Color color = this.getBackground();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        Color color4 = color3.darker();
        Color color5 = this.getForeground();
        int n = 0;
        while (n < this.tabs.length) {
            Tab tab = this.tabs[n];
            if (!tab.selected && this.isVisibleTab(tab)) {
                tab.paint(graphics, color, color4, color2, color3, color5);
            }
            ++n;
        }
        if (this.startFrameW > 0 && this.startFrameH > 0) {
            this.paintFrame(graphics, color, color4, color2, color3, color5, this.startFrameX, this.startFrameY, this.startFrameW, this.startFrameH);
        }
        if (this.endFrameW > 0 && this.endFrameH > 0) {
            this.paintFrame(graphics, color, color4, color2, color3, color5, this.endFrameX, this.endFrameY, this.endFrameW, this.endFrameH);
        }
        if (this.separatorW > 0 && this.separatorH > 0) {
            this.paintSeparator(graphics, color, color4, color2, color3, color5, this.separatorX, this.separatorY, this.separatorW, this.separatorH);
        }
        int n2 = 0;
        while (n2 < this.tabs.length) {
            Tab tab = this.tabs[n2];
            if (tab.selected && this.isVisibleTab(tab)) {
                tab.paint(graphics, color, color4, color2, color3, color5);
            }
            ++n2;
        }
        if (this.startButtonW > 0 && this.startButtonH > 0) {
            this.paintButton(graphics, color, color4, color2, color3, color5, this.startButtonX, this.startButtonY, this.startButtonW, this.startButtonH, this.tabSide(true));
        }
        if (this.endButtonW > 0 && this.endButtonH > 0) {
            this.paintButton(graphics, color, color4, color2, color3, color5, this.endButtonX, this.endButtonY, this.endButtonW, this.endButtonH, this.tabSide(false));
        }
    }

    private void paintFrame(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(color2);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        graphics.setColor(color4);
        graphics.drawLine(--n5, ++n2, n5, --n6);
        graphics.drawLine(n5, n6, ++n, n6);
        graphics.setColor(color3);
        graphics.drawLine(n5, n2, n, n2);
        graphics.drawLine(n, n2, n, n6);
    }

    private void paintSeparator(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5, int n, int n2, int n3, int n4) {
        this.paintFrame(graphics, color, color2, color3, color4, color5, n, n2, n3, n4);
    }

    private void paintButton(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5, int n, int n2, int n3, int n4, int n5) {
        graphics.setColor(color4);
        graphics.drawRect(n, n2, n3 - 2, n4 - 2);
        graphics.setColor(color3);
        graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        n += 2;
        n2 += 2;
        int n6 = Math.min((n3 -= 4) / 2, (n4 -= 4) / 2);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        switch (n5) {
            case 1: 
            case 3: {
                nArray[0] = n += (n3 - (2 * n6 + 1)) / 2;
                nArray2[0] = n2 += 1 + (n4 - (n6 + 1)) / 2;
                nArray[1] = n + n6;
                nArray2[1] = n2 + n6;
                nArray[2] = n + 2 * n6;
                nArray2[2] = n2;
                break;
            }
            default: {
                nArray[0] = n += 1 + (n3 - (n6 + 1)) / 2;
                nArray2[0] = n2 += (n4 - (2 * n6 + 1)) / 2;
                nArray[1] = n + n6;
                nArray2[1] = n2 + n6;
                nArray[2] = n;
                nArray2[2] = n2 + 2 * n6;
            }
        }
        graphics.setColor(color5);
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class MouseHandler
    extends MouseInputAdapter {
        private boolean dragging = false;
        private int dragX = -1;
        private int dragY = -1;

        private MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.forwardToTab(mouseEvent)) {
                return;
            }
            if (this.popupMenu(mouseEvent)) {
                return;
            }
            this.startDrag(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.forwardToTab(mouseEvent)) {
                return;
            }
            this.endDrag(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.forwardToTab(mouseEvent)) {
                return;
            }
        }

        private boolean forwardToTab(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = 0;
            while (n3 < TabbedSplitPane.this.tabs.length) {
                Tab tab = TabbedSplitPane.this.tabs[n3];
                if (n >= tab.x && n < tab.x + tab.width && n2 >= tab.y && n2 < tab.y + tab.height && TabbedSplitPane.this.isVisibleTab(tab)) {
                    switch (mouseEvent.getID()) {
                        case 501: {
                            tab.mousePressed(mouseEvent);
                            break;
                        }
                        case 502: {
                            tab.mouseReleased(mouseEvent);
                            break;
                        }
                        default: {
                            tab.mouseClicked(mouseEvent);
                        }
                    }
                    return true;
                }
                ++n3;
            }
            return false;
        }

        private boolean popupMenu(MouseEvent mouseEvent) {
            int n;
            int n2;
            boolean bl;
            int n3 = mouseEvent.getX();
            int n4 = mouseEvent.getY();
            if (TabbedSplitPane.this.startButtonW > 0 && n3 >= TabbedSplitPane.this.startButtonX && n3 < TabbedSplitPane.this.startButtonX + TabbedSplitPane.this.startButtonW && n4 >= TabbedSplitPane.this.startButtonY && n4 < TabbedSplitPane.this.startButtonY + TabbedSplitPane.this.startButtonH) {
                bl = true;
                n2 = TabbedSplitPane.this.startButtonX;
                n = TabbedSplitPane.this.startButtonY + TabbedSplitPane.this.startButtonH;
            } else if (TabbedSplitPane.this.endButtonW > 0 && n3 >= TabbedSplitPane.this.endButtonX && n3 < TabbedSplitPane.this.endButtonX + TabbedSplitPane.this.endButtonW && n4 >= TabbedSplitPane.this.endButtonY && n4 < TabbedSplitPane.this.endButtonY + TabbedSplitPane.this.endButtonH) {
                bl = false;
                n2 = TabbedSplitPane.this.endButtonX;
                n = TabbedSplitPane.this.endButtonY + TabbedSplitPane.this.endButtonH;
            } else {
                return false;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            MenuHandler menuHandler = new MenuHandler();
            int n5 = 0;
            while (n5 < TabbedSplitPane.this.tabs.length) {
                Tab tab = TabbedSplitPane.this.tabs[n5];
                if (tab.atStart == bl) {
                    String string = tab.getLabel();
                    if (string == null) {
                        string = "#" + Integer.toString(1 + n5);
                    }
                    Icon icon = tab.getIcon();
                    JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, icon, tab.selected);
                    jCheckBoxMenuItem.addActionListener(menuHandler);
                    jCheckBoxMenuItem.setActionCommand(Integer.toString(n5));
                    jPopupMenu.add(jCheckBoxMenuItem);
                }
                ++n5;
            }
            jPopupMenu.show(TabbedSplitPane.this, n2, n);
            return true;
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (TabbedSplitPane.this.separatorW > 0) {
                this.updateCursor(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (TabbedSplitPane.this.separatorW > 0 && TabbedSplitPane.this.getCursor() != normalCursor) {
                TabbedSplitPane.this.setCursor(normalCursor);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (TabbedSplitPane.this.separatorW > 0) {
                this.updateCursor(mouseEvent);
            }
        }

        private void updateCursor(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Cursor cursor = n >= TabbedSplitPane.this.separatorX && n < TabbedSplitPane.this.separatorX + TabbedSplitPane.this.separatorW && n2 >= TabbedSplitPane.this.separatorY && n2 < TabbedSplitPane.this.separatorY + TabbedSplitPane.this.separatorH ? (TabbedSplitPane.this.verticalSplit ? verticalResizeCursor : horizontalResizeCursor) : normalCursor;
            if (TabbedSplitPane.this.getCursor() != cursor) {
                TabbedSplitPane.this.setCursor(cursor);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.dragging) {
                this.doDrag(mouseEvent);
            }
        }

        private void startDrag(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n >= TabbedSplitPane.this.separatorX && n < TabbedSplitPane.this.separatorX + TabbedSplitPane.this.separatorW && n2 >= TabbedSplitPane.this.separatorY && n2 < TabbedSplitPane.this.separatorY + TabbedSplitPane.this.separatorH) {
                this.dragging = true;
                this.dragX = n;
                this.dragY = n2;
            }
        }

        private void doDrag(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = n - this.dragX;
            int n4 = n2 - this.dragY;
            this.dragX = n;
            this.dragY = n2;
            if (TabbedSplitPane.this.verticalSplit) {
                int n5;
                boolean bl;
                boolean bl2 = bl = TabbedSplitPane.this.tabPlacement != 1;
                if (!bl) {
                    n3 = -n3;
                }
                int n6 = 7;
                if (!TabbedSplitPane.this.isVerticalTabPlacement()) {
                    n6 = Math.max(n6, 20);
                }
                if ((n5 = TabbedSplitPane.this.startFrameW + n3) < n6) {
                    return;
                }
                int n7 = TabbedSplitPane.this.endFrameW - n3;
                if (n7 < n6) {
                    return;
                }
                double d = (double)n5 * TabbedSplitPane.this.verticalRatio / (double)TabbedSplitPane.this.startFrameW;
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > 1.0) {
                    d = 1.0;
                }
                if (d != TabbedSplitPane.this.verticalRatio) {
                    TabbedSplitPane.this.setVerticalRatio(d);
                }
            } else {
                int n8;
                boolean bl;
                boolean bl3 = bl = TabbedSplitPane.this.tabPlacement != 2;
                if (!bl) {
                    n4 = -n4;
                }
                int n9 = 7;
                if (TabbedSplitPane.this.isVerticalTabPlacement()) {
                    n9 = Math.max(n9, 20);
                }
                if ((n8 = TabbedSplitPane.this.startFrameH + n4) < n9) {
                    return;
                }
                int n10 = TabbedSplitPane.this.endFrameH - n4;
                if (n10 < n9) {
                    return;
                }
                double d = (double)n8 * TabbedSplitPane.this.horizontalRatio / (double)TabbedSplitPane.this.startFrameH;
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > 1.0) {
                    d = 1.0;
                }
                if (d != TabbedSplitPane.this.horizontalRatio) {
                    TabbedSplitPane.this.setHorizontalRatio(d);
                }
            }
        }

        private void endDrag(MouseEvent mouseEvent) {
            if (this.dragging) {
                this.dragY = -1;
                this.dragX = -1;
                this.dragging = false;
            }
        }

        private final class MenuHandler
        implements ActionListener {
            private MenuHandler() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                TabbedSplitPane.this.selectTab(Integer.parseInt(string));
            }
        }
    }

    private static final class Layout
    implements LayoutManager {
        private Layout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.layoutSize((TabbedSplitPane)container, true);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.layoutSize((TabbedSplitPane)container, false);
        }

        private Dimension layoutSize(TabbedSplitPane tabbedSplitPane, boolean bl) {
            int n;
            int n2;
            Tab tab;
            int n3;
            Tab[] tabArray = tabbedSplitPane.tabs;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            if (bl) {
                n3 = 0;
                while (n3 < tabArray.length) {
                    tab = tabArray[n3];
                    if (tab.atStart) {
                        n5 = 1;
                        n4 = 1;
                    } else {
                        n7 = 1;
                        n6 = 1;
                    }
                    ++n3;
                }
            } else {
                n3 = 0;
                while (n3 < tabArray.length) {
                    tab = tabArray[n3];
                    Dimension dimension = tab.component.getPreferredSize();
                    if (dimension.width < 1) {
                        dimension.width = 1;
                    }
                    if (dimension.height < 1) {
                        dimension.height = 1;
                    }
                    if (tab.atStart) {
                        n4 = Math.max(n4, dimension.width);
                        n5 = Math.max(n5, dimension.height);
                    } else {
                        n6 = Math.max(n6, dimension.width);
                        n7 = Math.max(n7, dimension.height);
                    }
                    ++n3;
                }
            }
            if (n4 > 0) {
                n4 += 6;
                n5 += 6;
            }
            if (n6 > 0) {
                n6 += 6;
                n7 += 6;
            }
            n3 = 0;
            while (n3 < 2) {
                boolean bl2 = n3 == 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                int n15 = 0;
                int n16 = 0;
                while (n16 < tabArray.length) {
                    Tab tab2 = tabArray[n16];
                    if (tab2.atStart == bl2) {
                        if (bl) {
                            switch (tab2.side) {
                                case 1: {
                                    n10 = 1;
                                    n11 = 1;
                                    break;
                                }
                                case 3: {
                                    n14 = 1;
                                    n15 = 1;
                                    break;
                                }
                                case 2: {
                                    n12 = 1;
                                    n13 = 1;
                                    break;
                                }
                                default: {
                                    n8 = 1;
                                    n9 = 1;
                                    break;
                                }
                            }
                        } else {
                            Dimension dimension = tab2.getIntrinsicSize();
                            switch (tab2.side) {
                                case 1: {
                                    n10 = Math.max(n10, dimension.width);
                                    n11 += dimension.height;
                                    break;
                                }
                                case 3: {
                                    n14 = Math.max(n14, dimension.width);
                                    n15 += dimension.height;
                                    break;
                                }
                                case 2: {
                                    n12 += dimension.width;
                                    n13 = Math.max(n13, dimension.height);
                                    break;
                                }
                                default: {
                                    n8 += dimension.width;
                                    n9 = Math.max(n9, dimension.height);
                                }
                            }
                        }
                    }
                    ++n16;
                }
                if (n10 > 0) {
                    n10 = Math.max(n10, 15);
                    n11 = Math.max(n11, 20);
                }
                if (n14 > 0) {
                    n14 = Math.max(n14, 15);
                    n15 = Math.max(n15, 20);
                }
                if (n12 > 0) {
                    n12 = Math.max(n12, 20);
                    n13 = Math.max(n13, 15);
                }
                if (n8 > 0) {
                    n8 = Math.max(n8, 20);
                    n9 = Math.max(n9, 15);
                }
                if (bl2) {
                    n4 = Math.max(n4, Math.max(n8, n12)) + n14 + n10;
                    n5 = Math.max(n5, Math.max(n15, n11)) + n9 + n13;
                } else {
                    n6 = Math.max(n6, Math.max(n8, n12)) + n14 + n10;
                    n7 = Math.max(n7, Math.max(n15, n11)) + n9 + n13;
                }
                ++n3;
            }
            if (n4 > 0) {
                if (n6 > 0) {
                    if (tabbedSplitPane.verticalSplit) {
                        n2 = n4 + 5 + n6;
                        n = Math.max(n5, Math.max(5, n7));
                    } else {
                        n2 = Math.max(n4, Math.max(5, n6));
                        n = n5 + 5 + n7;
                    }
                } else {
                    n2 = n4;
                    n = n5;
                }
            } else {
                n2 = n6;
                n = n7;
            }
            Insets insets = tabbedSplitPane.getInsets();
            n += insets.top + insets.bottom;
            if ((n2 += insets.left + insets.right) < 1) {
                n2 = 1;
            }
            if (n < 1) {
                n = 1;
            }
            return new Dimension(n2, n);
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            boolean bl;
            TabbedSplitPane tabbedSplitPane = (TabbedSplitPane)container;
            Tab[] tabArray = tabbedSplitPane.tabs;
            tabbedSplitPane.startTabAreaX = (tabbedSplitPane.startTabAreaY = (tabbedSplitPane.startTabAreaW = (tabbedSplitPane.startTabAreaH = 0)));
            tabbedSplitPane.startButtonX = (tabbedSplitPane.startButtonY = (tabbedSplitPane.startButtonW = (tabbedSplitPane.startButtonH = 0)));
            tabbedSplitPane.startFrameX = (tabbedSplitPane.startFrameY = (tabbedSplitPane.startFrameW = (tabbedSplitPane.startFrameH = 0)));
            tabbedSplitPane.separatorX = (tabbedSplitPane.separatorY = (tabbedSplitPane.separatorW = (tabbedSplitPane.separatorH = 0)));
            tabbedSplitPane.endTabAreaX = (tabbedSplitPane.endTabAreaY = (tabbedSplitPane.endTabAreaW = (tabbedSplitPane.endTabAreaH = 0)));
            tabbedSplitPane.endButtonX = (tabbedSplitPane.endButtonY = (tabbedSplitPane.endButtonW = (tabbedSplitPane.endButtonH = 0)));
            tabbedSplitPane.endFrameX = (tabbedSplitPane.endFrameY = (tabbedSplitPane.endFrameW = (tabbedSplitPane.endFrameH = 0)));
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            int n11 = 0;
            while (n11 < tabArray.length) {
                Tab tab = tabArray[n11];
                Dimension dimension = tab.getIntrinsicSize();
                tab.width = dimension.width;
                tab.height = dimension.height;
                switch (tab.side) {
                    case 1: {
                        n10 = Math.max(n10, tab.width);
                        break;
                    }
                    case 3: {
                        n9 = Math.max(n9, tab.width);
                        break;
                    }
                    case 2: {
                        n8 = Math.max(n8, tab.height);
                        break;
                    }
                    default: {
                        n7 = Math.max(n7, tab.height);
                    }
                }
                if (tab.atStart) {
                    bl2 = true;
                } else {
                    bl3 = true;
                }
                ++n11;
            }
            if (n10 > 0) {
                n10 = Math.max(n10, 15);
            }
            if (n9 > 0) {
                n9 = Math.max(n9, 15);
            }
            if (n8 > 0) {
                n8 = Math.max(n8, 15);
            }
            if (n7 > 0) {
                n7 = Math.max(n7, 15);
            }
            boolean bl4 = bl = bl2 && bl3;
            if (bl) {
                if (tabbedSplitPane.verticalSplit) {
                    n6 = 19;
                    n5 = Math.max(7, 5);
                } else {
                    n6 = Math.max(7, 5);
                    n5 = 19;
                }
            } else {
                n5 = 7;
                n6 = 7;
            }
            if (n9 > 0 || n10 > 0) {
                n4 = n6 + n9 + n10;
                n3 = Math.max(n5, 20);
            } else {
                n4 = Math.max(n6, 20);
                n3 = n5 + n7 + n8;
            }
            Insets insets = tabbedSplitPane.getInsets();
            int n12 = insets.left;
            int n13 = insets.top;
            int n14 = tabbedSplitPane.getWidth() - n12 - insets.right;
            int n15 = tabbedSplitPane.getHeight() - n13 - insets.bottom;
            if (n14 < n4) {
                n14 = n4;
            }
            if (n15 < n3) {
                n15 = n3;
            }
            int n16 = n12 + n9;
            int n17 = n13 + n7;
            int n18 = n14 - n9 - n10;
            int n19 = n15 - n7 - n8;
            if (bl) {
                int n20;
                int n21;
                int n22;
                int n23;
                int n24;
                int n25;
                if (tabbedSplitPane.verticalSplit) {
                    n2 = tabbedSplitPane.tabPlacement != 1 ? 1 : 0;
                    n25 = n16;
                    n24 = n17;
                    double d = n2 != 0 ? tabbedSplitPane.verticalRatio : 1.0 - tabbedSplitPane.verticalRatio;
                    int n26 = (int)Math.rint((double)(n18 - 5) * d);
                    if (n26 < 7) {
                        n26 = 7;
                    }
                    n23 = n19;
                    tabbedSplitPane.separatorX = n25 + n26;
                    tabbedSplitPane.separatorY = n17;
                    tabbedSplitPane.separatorW = 5;
                    tabbedSplitPane.separatorH = n19;
                    n22 = tabbedSplitPane.separatorX + tabbedSplitPane.separatorW;
                    n21 = n17;
                    n = n18 - 5 - n26;
                    if (n < 7) {
                        n = 7;
                    }
                    n20 = n19;
                    if (n2 != 0) {
                        tabbedSplitPane.startFrameX = n25;
                        tabbedSplitPane.startFrameY = n24;
                        tabbedSplitPane.startFrameW = n26;
                        tabbedSplitPane.startFrameH = n23;
                        tabbedSplitPane.endFrameX = n22;
                        tabbedSplitPane.endFrameY = n21;
                        tabbedSplitPane.endFrameW = n;
                        tabbedSplitPane.endFrameH = n20;
                    } else {
                        tabbedSplitPane.startFrameX = n22;
                        tabbedSplitPane.startFrameY = n21;
                        tabbedSplitPane.startFrameW = n;
                        tabbedSplitPane.startFrameH = n20;
                        tabbedSplitPane.endFrameX = n25;
                        tabbedSplitPane.endFrameY = n24;
                        tabbedSplitPane.endFrameW = n26;
                        tabbedSplitPane.endFrameH = n23;
                    }
                } else {
                    n2 = tabbedSplitPane.tabPlacement != 2 ? 1 : 0;
                    n25 = n16;
                    n24 = n17;
                    int n27 = n18;
                    double d = n2 != 0 ? tabbedSplitPane.horizontalRatio : 1.0 - tabbedSplitPane.horizontalRatio;
                    n23 = (int)Math.rint((double)(n19 - 5) * d);
                    if (n23 < 7) {
                        n23 = 7;
                    }
                    tabbedSplitPane.separatorX = n16;
                    tabbedSplitPane.separatorY = n24 + n23;
                    tabbedSplitPane.separatorW = n18;
                    tabbedSplitPane.separatorH = 5;
                    n22 = n16;
                    n21 = tabbedSplitPane.separatorY + tabbedSplitPane.separatorH;
                    n = n18;
                    n20 = n19 - 5 - n23;
                    if (n20 < 7) {
                        n20 = 7;
                    }
                    if (n2 != 0) {
                        tabbedSplitPane.startFrameX = n25;
                        tabbedSplitPane.startFrameY = n24;
                        tabbedSplitPane.startFrameW = n27;
                        tabbedSplitPane.startFrameH = n23;
                        tabbedSplitPane.endFrameX = n22;
                        tabbedSplitPane.endFrameY = n21;
                        tabbedSplitPane.endFrameW = n;
                        tabbedSplitPane.endFrameH = n20;
                    } else {
                        tabbedSplitPane.startFrameX = n22;
                        tabbedSplitPane.startFrameY = n21;
                        tabbedSplitPane.startFrameW = n;
                        tabbedSplitPane.startFrameH = n20;
                        tabbedSplitPane.endFrameX = n25;
                        tabbedSplitPane.endFrameY = n24;
                        tabbedSplitPane.endFrameW = n27;
                        tabbedSplitPane.endFrameH = n23;
                    }
                }
            } else if (bl3) {
                tabbedSplitPane.endFrameX = n16;
                tabbedSplitPane.endFrameY = n17;
                tabbedSplitPane.endFrameW = n18;
                tabbedSplitPane.endFrameH = n19;
            } else {
                tabbedSplitPane.startFrameX = n16;
                tabbedSplitPane.startFrameY = n17;
                tabbedSplitPane.startFrameW = n18;
                tabbedSplitPane.startFrameH = n19;
            }
            n2 = 0;
            while (n2 < tabArray.length) {
                Tab tab = tabArray[n2];
                if (tab.atStart) {
                    tab.component.setBounds(tabbedSplitPane.startFrameX + 3, tabbedSplitPane.startFrameY + 3, tabbedSplitPane.startFrameW - 6, tabbedSplitPane.startFrameH - 6);
                } else {
                    tab.component.setBounds(tabbedSplitPane.endFrameX + 3, tabbedSplitPane.endFrameY + 3, tabbedSplitPane.endFrameW - 6, tabbedSplitPane.endFrameH - 6);
                }
                ++n2;
            }
            Tab tab = null;
            Tab tab2 = null;
            Tab tab3 = null;
            Tab tab4 = null;
            Tab tab5 = null;
            Tab tab6 = null;
            Tab tab7 = null;
            Tab tab8 = null;
            n = 0;
            while (n < tabArray.length) {
                Tab tab9 = tabArray[n];
                if (tab9.atStart) {
                    switch (tab9.side) {
                        case 1: {
                            if (tab2 == null) {
                                tabbedSplitPane.startTabAreaX = tabbedSplitPane.startFrameX + tabbedSplitPane.startFrameW;
                                tabbedSplitPane.startTabAreaY = tabbedSplitPane.startFrameY;
                                tabbedSplitPane.startTabAreaW = n10;
                                tabbedSplitPane.startTabAreaH = tabbedSplitPane.startFrameH;
                                tab9.y = tabbedSplitPane.startTabAreaY;
                            } else {
                                tab9.y = tab2.y + tab2.height;
                            }
                            tab9.x = tabbedSplitPane.startTabAreaX;
                            tab2 = tab9;
                            break;
                        }
                        case 3: {
                            if (tab4 == null) {
                                tabbedSplitPane.startTabAreaX = tabbedSplitPane.startFrameX - n9;
                                tabbedSplitPane.startTabAreaY = tabbedSplitPane.startFrameY;
                                tabbedSplitPane.startTabAreaW = n9;
                                tabbedSplitPane.startTabAreaH = tabbedSplitPane.startFrameH;
                                tab9.y = tabbedSplitPane.startTabAreaY;
                            } else {
                                tab9.y = tab4.y + tab4.height;
                            }
                            tab9.x = tabbedSplitPane.startFrameX - tab9.width;
                            tab4 = tab9;
                            break;
                        }
                        case 2: {
                            if (tab3 == null) {
                                tabbedSplitPane.startTabAreaX = tabbedSplitPane.startFrameX;
                                tabbedSplitPane.startTabAreaY = tabbedSplitPane.startFrameY + tabbedSplitPane.startFrameH;
                                tabbedSplitPane.startTabAreaW = tabbedSplitPane.startFrameW;
                                tabbedSplitPane.startTabAreaH = n8;
                                tab9.x = tabbedSplitPane.startTabAreaX;
                            } else {
                                tab9.x = tab3.x + tab3.width;
                            }
                            tab9.y = tabbedSplitPane.startTabAreaY;
                            tab3 = tab9;
                            break;
                        }
                        default: {
                            if (tab == null) {
                                tabbedSplitPane.startTabAreaX = tabbedSplitPane.startFrameX;
                                tabbedSplitPane.startTabAreaY = tabbedSplitPane.startFrameY - n7;
                                tabbedSplitPane.startTabAreaW = tabbedSplitPane.startFrameW;
                                tabbedSplitPane.startTabAreaH = n7;
                                tab9.x = tabbedSplitPane.startTabAreaX;
                            } else {
                                tab9.x = tab.x + tab.width;
                            }
                            tab9.y = tabbedSplitPane.startFrameY - tab9.height;
                            tab = tab9;
                            break;
                        }
                    }
                } else {
                    switch (tab9.side) {
                        case 1: {
                            if (tab6 == null) {
                                tabbedSplitPane.endTabAreaX = tabbedSplitPane.endFrameX + tabbedSplitPane.endFrameW;
                                tabbedSplitPane.endTabAreaY = tabbedSplitPane.endFrameY;
                                tabbedSplitPane.endTabAreaW = n10;
                                tabbedSplitPane.endTabAreaH = tabbedSplitPane.endFrameH;
                                tab9.y = tabbedSplitPane.endTabAreaY;
                            } else {
                                tab9.y = tab6.y + tab6.height;
                            }
                            tab9.x = tabbedSplitPane.endTabAreaX;
                            tab6 = tab9;
                            break;
                        }
                        case 3: {
                            if (tab8 == null) {
                                tabbedSplitPane.endTabAreaX = tabbedSplitPane.endFrameX - n9;
                                tabbedSplitPane.endTabAreaY = tabbedSplitPane.endFrameY;
                                tabbedSplitPane.endTabAreaW = n9;
                                tabbedSplitPane.endTabAreaH = tabbedSplitPane.endFrameH;
                                tab9.y = tabbedSplitPane.endTabAreaY;
                            } else {
                                tab9.y = tab8.y + tab8.height;
                            }
                            tab9.x = tabbedSplitPane.endFrameX - tab9.width;
                            tab8 = tab9;
                            break;
                        }
                        case 2: {
                            if (tab7 == null) {
                                tabbedSplitPane.endTabAreaX = tabbedSplitPane.endFrameX;
                                tabbedSplitPane.endTabAreaY = tabbedSplitPane.endFrameY + tabbedSplitPane.endFrameH;
                                tabbedSplitPane.endTabAreaW = tabbedSplitPane.endFrameW;
                                tabbedSplitPane.endTabAreaH = n8;
                                tab9.x = tabbedSplitPane.endTabAreaX;
                            } else {
                                tab9.x = tab7.x + tab7.width;
                            }
                            tab9.y = tabbedSplitPane.endTabAreaY;
                            tab7 = tab9;
                            break;
                        }
                        default: {
                            if (tab5 == null) {
                                tabbedSplitPane.endTabAreaX = tabbedSplitPane.endFrameX;
                                tabbedSplitPane.endTabAreaY = tabbedSplitPane.endFrameY - n7;
                                tabbedSplitPane.endTabAreaW = tabbedSplitPane.endFrameW;
                                tabbedSplitPane.endTabAreaH = n7;
                                tab9.x = tabbedSplitPane.endTabAreaX;
                            } else {
                                tab9.x = tab5.x + tab5.width;
                            }
                            tab9.y = tabbedSplitPane.endFrameY - tab9.height;
                            tab5 = tab9;
                        }
                    }
                }
                ++n;
            }
            if (bl2) {
                this.relayoutTabs(tabbedSplitPane, true);
            }
            if (bl3) {
                this.relayoutTabs(tabbedSplitPane, false);
            }
        }

        public void relayoutTabs(TabbedSplitPane tabbedSplitPane, boolean bl) {
            Tab tab;
            int n;
            boolean bl2;
            Dimension dimension;
            int n2;
            Tab tab2;
            int n3;
            int n4;
            Tab[] tabArray = tabbedSplitPane.tabs;
            Tab tab3 = null;
            boolean bl3 = tabbedSplitPane.isVerticalTabPlacement();
            if (bl3) {
                n4 = bl ? tabbedSplitPane.startTabAreaY : tabbedSplitPane.endTabAreaY;
                n3 = 0;
                while (n3 < tabArray.length) {
                    tab2 = tabArray[n3];
                    if (tab2.atStart == bl) {
                        if (tab2.selected) {
                            tab3 = tab2;
                        }
                        n2 = tab2.width;
                        dimension = tab2.getIntrinsicSize();
                        tab2.width = dimension.width;
                        tab2.height = dimension.height;
                        tab2.y = n4;
                        n4 += tab2.height;
                        if (tab2.side == 3) {
                            tab2.x -= dimension.width - n2;
                        }
                    }
                    ++n3;
                }
            } else {
                n4 = bl ? tabbedSplitPane.startTabAreaX : tabbedSplitPane.endTabAreaX;
                n3 = 0;
                while (n3 < tabArray.length) {
                    tab2 = tabArray[n3];
                    if (tab2.atStart == bl) {
                        if (tab2.selected) {
                            tab3 = tab2;
                        }
                        n2 = tab2.height;
                        dimension = tab2.getIntrinsicSize();
                        tab2.width = dimension.width;
                        tab2.height = dimension.height;
                        tab2.x = n4;
                        n4 += tab2.width;
                        if (tab2.side == 0) {
                            tab2.y -= tab2.height - n2;
                        }
                    }
                    ++n3;
                }
            }
            n4 = 0;
            n3 = 0;
            int n5 = 0;
            while (n5 < tabArray.length) {
                Tab tab4 = tabArray[n5];
                if (tab4.atStart == bl) {
                    ++n4;
                    if (tabbedSplitPane.isVisibleTab(tab4)) {
                        ++n3;
                    }
                }
                ++n5;
            }
            boolean bl4 = bl2 = n4 != n3;
            if (bl) {
                if (bl3) {
                    tabbedSplitPane.startTabAreaH = tabbedSplitPane.startFrameH;
                    if (bl2) {
                        tabbedSplitPane.startTabAreaH -= 20;
                    }
                } else {
                    tabbedSplitPane.startTabAreaW = tabbedSplitPane.startFrameW;
                    if (bl2) {
                        tabbedSplitPane.startTabAreaW -= 20;
                    }
                }
            } else if (bl3) {
                tabbedSplitPane.endTabAreaH = tabbedSplitPane.endFrameH;
                if (bl2) {
                    tabbedSplitPane.endTabAreaH -= 20;
                }
            } else {
                tabbedSplitPane.endTabAreaW = tabbedSplitPane.endFrameW;
                if (bl2) {
                    tabbedSplitPane.endTabAreaW -= 20;
                }
            }
            if (!bl2) {
                if (bl) {
                    tabbedSplitPane.startButtonX = (tabbedSplitPane.startButtonY = (tabbedSplitPane.startButtonW = (tabbedSplitPane.startButtonH = 0)));
                } else {
                    tabbedSplitPane.endButtonX = (tabbedSplitPane.endButtonY = (tabbedSplitPane.endButtonW = (tabbedSplitPane.endButtonH = 0)));
                }
                return;
            }
            int n6 = 0;
            while (n6 < tabArray.length && !tabbedSplitPane.isVisibleTab(tab3)) {
                if (tabArray[n6].atStart == tab3.atStart) {
                    int n7;
                    if (bl3) {
                        n7 = tabArray[n6].height;
                        n = n6;
                        while (n < tabArray.length) {
                            tab = tabArray[n];
                            if (tab.atStart == bl) {
                                tab.y -= n7;
                            }
                            ++n;
                        }
                    } else {
                        n7 = tabArray[n6].width;
                        n = n6;
                        while (n < tabArray.length) {
                            tab = tabArray[n];
                            if (tab.atStart == bl) {
                                tab.x -= n7;
                            }
                            ++n;
                        }
                    }
                }
                ++n6;
            }
            Tab tab5 = null;
            n = 0;
            while (n < tabArray.length) {
                tab = tabArray[n];
                if (tab.atStart == bl && tabbedSplitPane.isVisibleTab(tab)) {
                    tab5 = tab;
                }
                ++n;
            }
            if (bl) {
                tabbedSplitPane.startButtonW = 15;
                tabbedSplitPane.startButtonH = 15;
                if (bl3) {
                    if (tab5 == null) {
                        tabbedSplitPane.startButtonY = tabbedSplitPane.startTabAreaY;
                    } else {
                        tabbedSplitPane.startButtonY = tab5.y + tab5.height;
                    }
                    tabbedSplitPane.startButtonY += 5;
                    tabbedSplitPane.startButtonX = tabbedSplitPane.startTabAreaX + (tabbedSplitPane.startTabAreaW - 15) / 2;
                } else {
                    if (tab5 == null) {
                        tabbedSplitPane.startButtonX = tabbedSplitPane.startTabAreaX;
                    } else {
                        tabbedSplitPane.startButtonX = tab5.x + tab5.width;
                    }
                    tabbedSplitPane.startButtonX += 5;
                    tabbedSplitPane.startButtonY = tabbedSplitPane.startTabAreaY + (tabbedSplitPane.startTabAreaH - 15) / 2;
                }
            } else {
                tabbedSplitPane.endButtonW = 15;
                tabbedSplitPane.endButtonH = 15;
                if (bl3) {
                    if (tab5 == null) {
                        tabbedSplitPane.endButtonY = tabbedSplitPane.endTabAreaY;
                    } else {
                        tabbedSplitPane.endButtonY = tab5.y + tab5.height;
                    }
                    tabbedSplitPane.endButtonY += 5;
                    tabbedSplitPane.endButtonX = tabbedSplitPane.endTabAreaX + (tabbedSplitPane.endTabAreaW - 15) / 2;
                } else {
                    if (tab5 == null) {
                        tabbedSplitPane.endButtonX = tabbedSplitPane.endTabAreaX;
                    } else {
                        tabbedSplitPane.endButtonX = tab5.x + tab5.width;
                    }
                    tabbedSplitPane.endButtonX += 5;
                    tabbedSplitPane.endButtonY = tabbedSplitPane.endTabAreaY + (tabbedSplitPane.endTabAreaH - 15) / 2;
                }
            }
        }
    }
}

