/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.guiutil;

import com.xmlmind.xmledit.guiutil.Tab;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.swing.Icon;

public class TearOffTab
extends Tab {
    protected String label;
    protected Icon icon;
    protected boolean hideLabelUnlessSelected;
    protected boolean rotateIcon;
    protected static final int ICON_GAP = 4;
    protected static final int LABEL_MARGIN_WIDTH = 4;
    protected static final int LABEL_MARGIN_HEIGHT = 4;
    protected static final int TEAR_OFF_THICKNESS = 3;

    public TearOffTab(String string, Icon icon, Component component, boolean bl) {
        this(string, icon, component, bl, false, true);
    }

    public TearOffTab(String string, Icon icon, Component component, boolean bl, boolean bl2, boolean bl3) {
        super(component, bl);
        this.label = string;
        this.icon = icon;
        this.hideLabelUnlessSelected = bl2;
        this.rotateIcon = bl3;
    }

    public void setHidingLabelUnlessSelected(boolean bl) {
        this.hideLabelUnlessSelected = bl;
    }

    public boolean isHidingLabelUnlessSelected() {
        return this.hideLabelUnlessSelected;
    }

    public void setRotatingIcon(boolean bl) {
        this.rotateIcon = bl;
    }

    public boolean isRotatingIcon() {
        return this.rotateIcon;
    }

    public String getLabel() {
        return this.label;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getToolTip() {
        return this.showLabel() ? null : this.label;
    }

    protected boolean showLabel() {
        if (this.icon == null || !this.hideLabelUnlessSelected) {
            return true;
        }
        return this.selected;
    }

    public Dimension getIntrinsicSize() {
        int n;
        boolean bl;
        boolean bl2 = this.showLabel();
        FontMetrics fontMetrics = this.pane.getFontMetrics(this.pane.getFont());
        switch (this.side) {
            case 1: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        int n2 = 0;
        int n3 = 0;
        if (this.icon != null) {
            n2 = this.icon.getIconWidth();
            n3 = this.icon.getIconHeight();
            if (bl && !this.rotateIcon) {
                n = n2;
                n2 = n3;
                n3 = n;
            }
        }
        n = 8;
        if (this.icon != null) {
            n += n2 + 4;
        }
        if (bl2) {
            n += this.getLabelWidth(fontMetrics);
        }
        int n4 = Math.max(this.getLabelHeight(fontMetrics), n3);
        n4 += 8;
        n4 = this.selected ? (n4 += 3) : ++n4;
        if (bl) {
            int n5 = n;
            n = n4;
            n4 = n5;
        }
        return new Dimension(n, n4);
    }

    protected int getLabelWidth(FontMetrics fontMetrics) {
        return fontMetrics.stringWidth(this.label);
    }

    protected int getLabelHeight(FontMetrics fontMetrics) {
        return fontMetrics.getAscent() + fontMetrics.getDescent();
    }

    public void paint(Graphics graphics, Color color, Color color2, Color color3, Color color4, Color color5) {
        int n;
        int n2;
        Graphics2D graphics2D;
        int n3;
        this.paintSimpleTab(graphics, color, color2, color3, color4, color5);
        if (this.selected) {
            int n4 = this.x + this.width - 1;
            n3 = this.y + this.height - 1;
            graphics.setColor(color);
            switch (this.side) {
                case 1: {
                    this.paintTearOff(graphics, this.x, this.y + 3, this.x, n3 - 3);
                    break;
                }
                case 3: {
                    this.paintTearOff(graphics, n4 - 3, this.y + 3, n4 - 3, n3 - 3);
                    break;
                }
                case 2: {
                    this.paintTearOff(graphics, this.x + 3, this.y, n4 - 3, this.y);
                    break;
                }
                default: {
                    this.paintTearOff(graphics, this.x + 3, n3 - 3, n4 - 3, n3 - 3);
                }
            }
        }
        boolean bl = false;
        switch (this.side) {
            case 1: {
                graphics2D = (Graphics2D)graphics.create();
                graphics2D.translate(this.x + this.width - 1, this.y);
                graphics2D.rotate(1.5707963267948966);
                n3 = 4;
                n2 = 4;
                bl = !this.rotateIcon;
                break;
            }
            case 3: {
                graphics2D = (Graphics2D)graphics.create();
                graphics2D.translate(this.x, this.y + this.height - 1);
                graphics2D.rotate(-1.5707963267948966);
                n3 = 4;
                n2 = 4;
                bl = !this.rotateIcon;
                break;
            }
            case 2: {
                graphics2D = (Graphics2D)graphics;
                n3 = this.x + 4;
                n2 = this.y + 4;
                if (this.selected) {
                    n2 += 3;
                    break;
                }
                ++n2;
                break;
            }
            default: {
                graphics2D = (Graphics2D)graphics;
                n3 = this.x + 4;
                n2 = this.y + 4;
            }
        }
        boolean bl2 = this.showLabel();
        Font font = this.pane.getFont();
        FontMetrics fontMetrics = this.pane.getFontMetrics(font);
        int n5 = 0;
        int n6 = 0;
        if (this.icon != null) {
            n5 = this.icon.getIconWidth();
            n6 = this.icon.getIconHeight();
            if (bl) {
                n = n5;
                n5 = n6;
                n6 = n;
            }
        }
        n = this.getLabelHeight(fontMetrics);
        int n7 = n6;
        int n8 = Math.max(n, n7);
        if (this.icon != null) {
            if (bl) {
                if (this.side == 1) {
                    this.icon.paintIcon(this.pane, graphics, this.x + this.width - 4 - n6 - (n8 - n7) / 2, this.y + 4);
                    n3 += n5 + 4;
                } else {
                    this.icon.paintIcon(this.pane, graphics, this.x + 4 + (n8 - n7) / 2, this.y + 4);
                }
            } else {
                this.icon.paintIcon(this.pane, graphics2D, n3, n2 + (n8 - n7) / 2);
                n3 += n5 + 4;
            }
        }
        if (bl2) {
            this.paintLabel(graphics2D, n3, n2, n8, font, fontMetrics, color5);
        }
        if (graphics2D != graphics) {
            graphics2D.dispose();
        }
    }

    protected void paintLabel(Graphics graphics, int n, int n2, int n3, Font font, FontMetrics fontMetrics, Color color) {
        int n4 = fontMetrics.getAscent();
        int n5 = n4 + fontMetrics.getDescent();
        graphics.setFont(font);
        graphics.setColor(color);
        graphics.drawString(this.label, n, n2 + (n3 - n5) / 2 + n4);
    }

    protected void paintTearOff(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics = graphics.create();
        boolean bl = true;
        if (n == n3) {
            graphics.clipRect(n, n2, 4, n4 - n2 + 1);
            while (n2 < n4) {
                if (bl) {
                    graphics.draw3DRect(n, n2, 2, 5, false);
                    n2 += 6;
                } else {
                    n2 += 3;
                }
                boolean bl2 = bl = !bl;
            }
        } else {
            graphics.clipRect(n, n2, n3 - n + 1, 4);
            while (n < n3) {
                if (bl) {
                    graphics.draw3DRect(n, n2, 5, 2, false);
                    n += 6;
                } else {
                    n += 3;
                }
                boolean bl3 = bl = !bl;
            }
        }
        graphics.dispose();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.selected && this.insideTearOff(n, n2)) {
            this.pane.moveTab(this, !this.atStart);
            return;
        }
        super.mousePressed(mouseEvent);
    }

    protected boolean insideTearOff(int n, int n2) {
        boolean bl = false;
        switch (this.side) {
            case 1: {
                if (n >= this.x + 5) break;
                bl = true;
                break;
            }
            case 3: {
                if (n <= this.x + this.width - 5) break;
                bl = true;
                break;
            }
            case 2: {
                if (n2 >= this.y + 5) break;
                bl = true;
                break;
            }
            default: {
                if (n2 <= this.y + this.height - 5) break;
                bl = true;
            }
        }
        return bl;
    }
}

