/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.imagetoolkit;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.imagetoolkit.ImageConverter;
import com.xmlmind.xmledit.imagetoolkit.ImageRenderer;
import com.xmlmind.xmledit.imagetoolkit.ImageRendererAdapter;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkit;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkitUtil;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkits;
import com.xmlmind.xmledit.imagetoolkit.XMLImageUtil;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class ExternalImageToolkit
implements ImageToolkit {
    private String name;
    private String description;
    private Converter[] converters;
    private URL configURL;

    public ExternalImageToolkit(String string, String string2, Converter[] converterArray, URL uRL) {
        this.name = string;
        this.description = string2;
        this.converters = converterArray;
        this.configURL = uRL;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Converter[] getConverters() {
        return this.converters;
    }

    public URL getConfigurationURL() {
        return this.configURL;
    }

    public ImageRenderer getImageRenderer(URL uRL) {
        String string = URLPathUtil.extension(uRL.toExternalForm());
        if (string.length() == 0) {
            return null;
        }
        Converter converter = null;
        String string2 = null;
        int n = 0;
        block0: while (n < this.converters.length) {
            String[] stringArray = this.converters[n].inputFormat.extensions;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equalsIgnoreCase(string)) {
                    String[] stringArray2 = this.converters[n].outputFormat.extensions;
                    int n3 = 0;
                    while (n3 < stringArray2.length) {
                        String string3 = stringArray2[n3];
                        if ("png".equalsIgnoreCase(string3) || "jpg".equalsIgnoreCase(string3) || "jpeg".equalsIgnoreCase(string3) || "gif".equalsIgnoreCase(string3)) {
                            converter = this.converters[n];
                            string2 = string3;
                            break block0;
                        }
                        ++n3;
                    }
                    break;
                }
                ++n2;
            }
            ++n;
        }
        if (converter == null) {
            return null;
        }
        return new ImageRendererWrapper(converter.commandTemplate, this.configURL, string, string2);
    }

    private static final void executeCommand(String string, URL uRL, File file, File file2, String[] stringArray, Console console) throws RuntimeException {
        Object[] objectArray;
        Object object;
        CharSequence charSequence;
        String string2 = "";
        if (stringArray != null && stringArray.length > 0) {
            charSequence = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                object = stringArray[n];
                objectArray = stringArray[n + 1];
                ((StringBuffer)charSequence).append((String)object);
                if (objectArray.length() > 0) {
                    ((StringBuffer)charSequence).append(" \"");
                    ((StringBuffer)charSequence).append((String)objectArray);
                    ((StringBuffer)charSequence).append('\"');
                }
                n += 2;
            }
            string2 = ((StringBuffer)charSequence).toString();
        }
        charSequence = "";
        String string3 = "";
        if (uRL != null) {
            object = FileUtil.urlToFile(uRL);
            if (object != null) {
                charSequence = ((File)object).getParent();
            }
            if ((objectArray = URLUtil.getDirectory(uRL)) != null) {
                string3 = ExternalImageToolkit.dirToExternalForm((URL)objectArray);
            }
        }
        object = new char[]{'I', 'O', 'A', 'S', 'C', 'c'};
        objectArray = new String[]{file.getPath(), file2.getPath(), string2, File.separator, charSequence, string3};
        String string4 = StringUtil.substituteVars(string, (char[])object, objectArray);
        String[] stringArray2 = new String[2];
        int n = 0;
        try {
            n = PlatformUtil.shellExec(string4, stringArray2);
        }
        catch (Exception exception) {
            throw new RuntimeException("cannot execute command \"" + string4 + "\": " + MiscUtil.reason(exception));
        }
        if (console != null) {
            if (stringArray2[0] != null && stringArray2[0].length() > 0) {
                console.showMessage(stringArray2[0], 0);
            }
            if (stringArray2[1] != null && stringArray2[1].length() > 0) {
                console.showMessage(stringArray2[1], 2);
            }
        }
        if (n != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("command \"");
            stringBuffer.append(string4);
            stringBuffer.append("\" exited abnormally (status = ");
            stringBuffer.append(n);
            stringBuffer.append(')');
            if (console == null) {
                if (stringArray2[0] != null && stringArray2[0].length() > 0) {
                    stringBuffer.append('\n');
                    stringBuffer.append(stringArray2[0]);
                }
                if (stringArray2[1] != null && stringArray2[1].length() > 0) {
                    stringBuffer.append('\n');
                    stringBuffer.append(stringArray2[1]);
                }
            }
            throw new RuntimeException(stringBuffer.toString());
        }
    }

    private static final String dirToExternalForm(URL uRL) {
        String string = uRL.toExternalForm();
        if (string.endsWith("/") && !"/".equals(uRL.getPath())) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public ImageRenderer getImageRenderer(byte[] byArray) {
        Converter converter = null;
        String string = null;
        String string2 = null;
        int n = 0;
        block0: while (n < this.converters.length) {
            byte[][] byArray2 = this.converters[n].inputFormat.magicNumbers;
            int n2 = 0;
            while (n2 < byArray2.length) {
                if (ImageToolkitUtil.match(byArray2[n2], byArray)) {
                    String[] stringArray = this.converters[n].outputFormat.extensions;
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        String string3 = stringArray[n3];
                        if ("png".equalsIgnoreCase(string3) || "jpg".equalsIgnoreCase(string3) || "jpeg".equalsIgnoreCase(string3) || "gif".equalsIgnoreCase(string3)) {
                            converter = this.converters[n];
                            string = converter.inputFormat.extensions[0];
                            string2 = string3;
                            break block0;
                        }
                        ++n3;
                    }
                    break;
                }
                ++n2;
            }
            ++n;
        }
        if (converter == null) {
            return null;
        }
        return new ImageRendererWrapper(converter.commandTemplate, this.configURL, string, string2);
    }

    public ImageRenderer getImageRenderer(Element element) {
        Name name = element.getName();
        Converter converter = null;
        String string = null;
        String string2 = null;
        int n = 0;
        block0: while (n < this.converters.length) {
            Name[] nameArray = this.converters[n].inputFormat.rootNames;
            int n2 = 0;
            while (n2 < nameArray.length) {
                if (nameArray[n2] == name) {
                    String[] stringArray = this.converters[n].outputFormat.extensions;
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        String string3 = stringArray[n3];
                        if ("png".equalsIgnoreCase(string3) || "jpg".equalsIgnoreCase(string3) || "jpeg".equalsIgnoreCase(string3) || "gif".equalsIgnoreCase(string3)) {
                            converter = this.converters[n];
                            string = converter.inputFormat.extensions[0];
                            string2 = string3;
                            break block0;
                        }
                        ++n3;
                    }
                    break;
                }
                ++n2;
            }
            ++n;
        }
        if (converter == null) {
            return null;
        }
        return new ImageRendererWrapper(converter.commandTemplate, this.configURL, string, string2);
    }

    public ImageConverter getImageConverter(File file, File file2) {
        String[] stringArray;
        String string = FileUtil.fileExtension(file.getPath());
        if (string.length() == 0) {
            return null;
        }
        String string2 = FileUtil.fileExtension(file2.getPath());
        if (string2.length() == 0) {
            return null;
        }
        Converter converter = null;
        int n = 0;
        block0: while (n < this.converters.length) {
            stringArray = this.converters[n].inputFormat.extensions;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equalsIgnoreCase(string)) {
                    String[] stringArray2 = this.converters[n].outputFormat.extensions;
                    int n3 = 0;
                    while (n3 < stringArray2.length) {
                        if (stringArray2[n3].equalsIgnoreCase(string2)) {
                            converter = this.converters[n];
                            break block0;
                        }
                        ++n3;
                    }
                    break;
                }
                ++n2;
            }
            ++n;
        }
        if (converter == null) {
            return null;
        }
        stringArray = converter.commandTemplate;
        return new ImageConverter((String)stringArray){
            private final /* synthetic */ String val$commandTemplate;
            {
                this.val$commandTemplate = string;
            }

            public void convertImage(File file, File file2, String[] stringArray, Console console) throws Exception {
                ExternalImageToolkit.executeCommand(this.val$commandTemplate, ExternalImageToolkit.this.configURL, file, file2, stringArray, console);
            }
        };
    }

    private static final class ImageRendererWrapper
    extends ImageRendererAdapter {
        private String commandTemplate;
        private URL configURL;
        private String inExtension;
        private String outExtension;
        private File outFile;
        private URL outURL;
        private ImageRenderer renderer;
        private File inFile;
        private boolean inFileIsTemp;

        public ImageRendererWrapper(String string, URL uRL, String string2, String string3) {
            this.commandTemplate = string;
            this.configURL = uRL;
            this.inExtension = string2.toLowerCase();
            this.outExtension = string3.toLowerCase();
        }

        public Image createImage(URL uRL, double d, int n, double d2, int n2, boolean bl, boolean bl2, double d3) throws Exception {
            this.createOutFile();
            this.inFileIsTemp = false;
            this.inFile = FileUtil.urlToFile(uRL);
            if (this.inFile == null) {
                this.inFile = File.createTempFile("tmp", "." + this.inExtension);
                this.inFileIsTemp = true;
                try {
                    FileUtil.copyFile(uRL, this.inFile);
                }
                catch (Exception exception) {
                    this.inFile.delete();
                    this.outFile.delete();
                    throw exception;
                }
            }
            return this.createImage(d, n, d2, n2, bl, bl2, d3);
        }

        private void createOutFile() throws IOException, RuntimeException {
            this.outFile = File.createTempFile("tmp", "." + this.outExtension);
            this.outURL = FileUtil.fileToURL(this.outFile);
            this.renderer = ImageToolkits.getBuiltin().getImageRenderer(this.outURL);
            if (this.renderer == null) {
                this.outFile.delete();
                throw new RuntimeException("internal error: built-in image toolkit does not have an ImageRenderer for '" + URLUtil.toDisplayForm(this.outURL) + "'");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Image createImage(double d, int n, double d2, int n2, boolean bl, boolean bl2, double d3) throws Exception {
            Image image;
            block3: {
                try {
                    ExternalImageToolkit.executeCommand(this.commandTemplate, this.configURL, this.inFile, this.outFile, null, null);
                    image = this.renderer.createImage(this.outURL, d, n, d2, n2, bl, bl2, d3);
                    Object var13_9 = null;
                    if (!this.inFileIsTemp) break block3;
                    this.inFile.delete();
                }
                catch (Throwable throwable) {
                    Object var13_10 = null;
                    if (this.inFileIsTemp) {
                        this.inFile.delete();
                    }
                    this.outFile.delete();
                    throw throwable;
                }
                {
                }
            }
            this.outFile.delete();
            return image;
        }

        public Image createImage(byte[] byArray, URL uRL, double d, int n, double d2, int n2, boolean bl, boolean bl2, double d3) throws Exception {
            this.createOutFile();
            this.inFile = File.createTempFile("tmp", "." + this.inExtension);
            this.inFileIsTemp = true;
            try {
                FileUtil.saveBytes(byArray, this.inFile);
            }
            catch (Exception exception) {
                this.inFile.delete();
                this.outFile.delete();
                throw exception;
            }
            return this.createImage(d, n, d2, n2, bl, bl2, d3);
        }

        public Image createImage(Element element, double d, int n, double d2, int n2, boolean bl, boolean bl2, double d3) throws Exception {
            this.createOutFile();
            this.inFile = File.createTempFile("tmp", "." + this.inExtension);
            this.inFileIsTemp = true;
            try {
                Document document = XMLImageUtil.createImageDocument(element);
                XMLImageUtil.processImageDocument(document, document.getLocation());
                XMLImageUtil.saveImageDocument(document, this.inFile, false);
            }
            catch (Exception exception) {
                this.inFile.delete();
                this.outFile.delete();
                throw exception;
            }
            return this.createImage(d, n, d2, n2, bl, bl2, d3);
        }
    }

    public static final class Converter {
        private Format inputFormat;
        private Format outputFormat;
        private String commandTemplate;

        public Converter(Format format, Format format2, String string) {
            this.inputFormat = format;
            this.outputFormat = format2;
            this.commandTemplate = string;
        }

        public Format getInputFormat() {
            return this.inputFormat;
        }

        public Format getOutputFormat() {
            return this.outputFormat;
        }

        public String getCommandTemplate() {
            return this.commandTemplate;
        }
    }

    public static final class Format {
        private String[] extensions;
        private byte[][] magicNumbers;
        private Name[] rootNames;

        public Format(String[] stringArray, byte[][] object, Name[] nameArray) {
            if (stringArray == null || stringArray.length == 0) {
                throw new IllegalArgumentException("at least one extension must be specified");
            }
            if (object == null) {
                object = new byte[0][];
            }
            if (nameArray == null) {
                nameArray = new Name[]{};
            }
            this.extensions = stringArray;
            this.magicNumbers = object;
            this.rootNames = nameArray;
        }

        public String[] getExtensions() {
            return this.extensions;
        }

        public byte[][] getMagicNumbers() {
            return this.magicNumbers;
        }

        public Name[] getRootNames() {
            return this.rootNames;
        }
    }
}

