/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.imagetoolkit;

import com.xmlmind.xmledit.guiutil.AWTUtil;
import java.awt.Image;

public final class ImageToolkitUtil {
    private static final byte[][][] FORMAT_SIGNATURES = new byte[][][]{new byte[][]{{71, 73, 70}}, new byte[][]{{-1, -40, -1}}, new byte[][]{{-119, 80, 78, 71, 13, 10, 26, 10}}, new byte[][]{{66, 77}}, new byte[][]{{77, 77}, {73, 73}}};
    private static final String[][] FILE_EXTENSIONS = new String[][]{{"gif"}, {"jpeg", "jpg"}, {"png"}, {"bmp", "dib"}, {"tiff", "tif"}};

    public static String[] detectImageFormat(byte[] byArray) {
        int n = 0;
        while (n < FORMAT_SIGNATURES.length) {
            byte[][] byArray2 = FORMAT_SIGNATURES[n];
            int n2 = 0;
            while (n2 < byArray2.length) {
                if (ImageToolkitUtil.match(byArray2[n2], byArray)) {
                    return FILE_EXTENSIONS[n];
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public static boolean match(byte[] byArray, byte[] byArray2) {
        if (byArray2.length < byArray.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray2[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static Image scaleImage(Image image, double d, int n, double d2, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        if (n4 <= 0 || n5 <= 0) {
            return image;
        }
        double[] dArray = ImageToolkitUtil.computeScaledSize(n4, n5, d, n, d2, n2, bl);
        if (dArray == null) {
            return image;
        }
        int n6 = (int)Math.rint(dArray[0]);
        if (n6 <= 0) {
            n6 = 1;
        }
        if ((n3 = (int)Math.rint(dArray[1])) <= 0) {
            n3 = 1;
        }
        if (n6 == n4 && n3 == n5) {
            return image;
        }
        return AWTUtil.getScaledImage(image, n6, n3, bl2);
    }

    public static double[] computeScaledSize(double d, double d2, double d3, int n, double d4, int n2, boolean bl) {
        double d5 = -1.0;
        double d6 = -1.0;
        if (d3 > 0.0) {
            switch (n) {
                case 0: {
                    d5 = d3;
                    break;
                }
                case 1: {
                    d5 = d * d3 / 100.0;
                    break;
                }
                case 2: {
                    d5 = d3;
                    break;
                }
                case 3: {
                    d5 = Math.min(d, d3);
                }
            }
        }
        if (d4 > 0.0) {
            switch (n2) {
                case 0: {
                    d6 = d4;
                    break;
                }
                case 1: {
                    d6 = d2 * d4 / 100.0;
                    break;
                }
                case 2: {
                    d6 = d4;
                    break;
                }
                case 3: {
                    d6 = Math.min(d2, d4);
                }
            }
        }
        double d7 = -1.0;
        double d8 = -1.0;
        if (d5 <= 0.0) {
            if (d6 <= 0.0) {
                return null;
            }
            double d9 = d6 / d2;
            d7 = Math.rint(d * d9);
            d8 = Math.rint(d2 * d9);
        } else if (d6 <= 0.0) {
            double d10 = d5 / d;
            d7 = Math.rint(d * d10);
            d8 = Math.rint(d2 * d10);
        } else if ((n == 2 && n2 == 2 || n == 3 && n2 == 3) && bl) {
            double d11 = d5 / d;
            double d12 = d6 / d2;
            double d13 = Math.min(d11, d12);
            d7 = Math.rint(d * d13);
            d8 = Math.rint(d2 * d13);
        } else {
            d7 = d5;
            d8 = d6;
        }
        return new double[]{d7, d8};
    }
}

