/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.imagetoolkit;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.imagetoolkit.ExternalImageToolkit;
import com.xmlmind.xmledit.imagetoolkit.ImageConverter;
import com.xmlmind.xmledit.imagetoolkit.ImageRenderer;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkit;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkitUtil;
import com.xmlmind.xmledit.imagetoolkit.JavaImageToolkit;
import com.xmlmind.xmledit.util.Console;
import java.awt.Image;
import java.io.File;
import java.net.URL;

public final class ImageToolkits {
    private static ImageToolkit[] toolkits = new ImageToolkit[]{new JavaImageToolkit()};

    public static void register(ImageToolkit imageToolkit) {
        int n = -1;
        String string = imageToolkit.getName();
        int n2 = 0;
        while (n2 < toolkits.length) {
            ImageToolkit imageToolkit2 = toolkits[n2];
            if (imageToolkit2.getName().equals(string)) {
                ImageToolkits.toolkits[n2] = imageToolkit;
                return;
            }
            if (n < 0 && imageToolkit2 instanceof ExternalImageToolkit) {
                n = n2;
            }
            ++n2;
        }
        if (imageToolkit instanceof ExternalImageToolkit || n == -1) {
            ImageToolkits.insertToolkit(toolkits.length, imageToolkit);
        } else {
            ImageToolkits.insertToolkit(n, imageToolkit);
        }
    }

    private static void insertToolkit(int n, ImageToolkit imageToolkit) {
        int n2;
        ImageToolkit[] imageToolkitArray = new ImageToolkit[toolkits.length + 1];
        if (n > 0) {
            System.arraycopy(toolkits, 0, imageToolkitArray, 0, n);
        }
        if ((n2 = toolkits.length - n) > 0) {
            System.arraycopy(toolkits, n, imageToolkitArray, n + 1, n2);
        }
        imageToolkitArray[n] = imageToolkit;
        toolkits = imageToolkitArray;
    }

    public static ImageToolkit getBuiltin() {
        return toolkits[0];
    }

    public static ImageToolkit[] getAll() {
        return toolkits;
    }

    public static void unregisterAllExternal() {
        ImageToolkit[] imageToolkitArray = new ImageToolkit[toolkits.length];
        int n = 0;
        int n2 = 0;
        while (n2 < toolkits.length) {
            if (!(toolkits[n2] instanceof ExternalImageToolkit)) {
                imageToolkitArray[n++] = toolkits[n2];
            }
            ++n2;
        }
        if (n != imageToolkitArray.length) {
            toolkits = new ImageToolkit[n];
            System.arraycopy(imageToolkitArray, 0, toolkits, 0, n);
        } else {
            toolkits = imageToolkitArray;
        }
    }

    public static String[] detectImageFormat(byte[] byArray) {
        String[] stringArray = ImageToolkitUtil.detectImageFormat(byArray);
        if (stringArray != null) {
            return stringArray;
        }
        int n = 0;
        block0: while (n < toolkits.length) {
            if (toolkits[n] instanceof ExternalImageToolkit) {
                ExternalImageToolkit.Converter[] converterArray = ((ExternalImageToolkit)toolkits[n]).getConverters();
                int n2 = 0;
                while (n2 < converterArray.length) {
                    ExternalImageToolkit.Format format = converterArray[n2].getInputFormat();
                    byte[][] byArray2 = format.getMagicNumbers();
                    int n3 = 0;
                    while (n3 < byArray2.length) {
                        if (ImageToolkitUtil.match(byArray2[n3], byArray)) {
                            stringArray = format.getExtensions();
                            break block0;
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return stringArray;
    }

    public static Image createImage(URL uRL) throws Exception {
        return ImageToolkits.createImage(uRL, 0.0, -1, 0.0, -1, false, false, -1.0);
    }

    public static Image createImage(URL uRL, double d, int n, double d2, int n2, boolean bl, boolean bl2, double d3) throws Exception {
        ImageRenderer imageRenderer = null;
        int n3 = 0;
        while (n3 < toolkits.length) {
            ImageRenderer imageRenderer2 = toolkits[n3].getImageRenderer(uRL);
            if (imageRenderer2 != null) {
                imageRenderer = imageRenderer2;
                break;
            }
            ++n3;
        }
        if (imageRenderer == null) {
            return null;
        }
        return imageRenderer.createImage(uRL, d, n, d2, n2, bl, bl2, d3);
    }

    public static Image createImage(byte[] byArray, URL uRL) throws Exception {
        return ImageToolkits.createImage(byArray, uRL, 0.0, -1, 0.0, -1, false, false, -1.0);
    }

    public static Image createImage(byte[] byArray, URL uRL, double d, int n, double d2, int n2, boolean bl, boolean bl2, double d3) throws Exception {
        ImageRenderer imageRenderer = null;
        int n3 = 0;
        while (n3 < toolkits.length) {
            ImageRenderer imageRenderer2 = toolkits[n3].getImageRenderer(byArray);
            if (imageRenderer2 != null) {
                imageRenderer = imageRenderer2;
                break;
            }
            ++n3;
        }
        if (imageRenderer == null) {
            return null;
        }
        return imageRenderer.createImage(byArray, uRL, d, n, d2, n2, bl, bl2, d3);
    }

    public static Image createImage(Element element) throws Exception {
        return ImageToolkits.createImage(element, 0.0, -1, 0.0, -1, false, false, -1.0);
    }

    public static Image createImage(Element element, double d, int n, double d2, int n2, boolean bl, boolean bl2, double d3) throws Exception {
        ImageRenderer imageRenderer = null;
        int n3 = 0;
        while (n3 < toolkits.length) {
            ImageRenderer imageRenderer2 = toolkits[n3].getImageRenderer(element);
            if (imageRenderer2 != null) {
                imageRenderer = imageRenderer2;
                break;
            }
            ++n3;
        }
        if (imageRenderer == null) {
            return null;
        }
        return imageRenderer.createImage(element, d, n, d2, n2, bl, bl2, d3);
    }

    public static boolean convertImage(File file, File file2, String[] stringArray, Console console) throws Exception {
        ImageConverter imageConverter = null;
        int n = 0;
        while (n < toolkits.length) {
            ImageConverter imageConverter2 = toolkits[n].getImageConverter(file, file2);
            if (imageConverter2 != null) {
                imageConverter = imageConverter2;
                break;
            }
            ++n;
        }
        if (imageConverter == null) {
            return false;
        }
        imageConverter.convertImage(file, file2, stringArray, console);
        return true;
    }
}

