/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.imagetoolkit;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.imagetoolkit.ImageConverter;
import com.xmlmind.xmledit.imagetoolkit.ImageRenderer;
import com.xmlmind.xmledit.imagetoolkit.ImageRendererAdapter;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkit;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkitUtil;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class JavaImageToolkit
implements ImageToolkit {
    private HashSet excludedExtensions = new HashSet();
    private String description;
    static /* synthetic */ Class class$javax$imageio$spi$ImageReaderSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageWriterSpi;

    public JavaImageToolkit() {
        String string = System.getProperty("XXE_JAVA_IMAGE_TOOLKIT_EXCLUDE");
        if (string != null) {
            String[] stringArray = StringUtil.split(string, ';');
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n].trim();
                if (string2.startsWith(".")) {
                    string2 = string2.substring(1);
                }
                if (string2.length() > 0) {
                    this.excludedExtensions.add(string2.toLowerCase());
                }
                ++n;
            }
        }
    }

    public String getName() {
        return "Java";
    }

    public String getDescription() {
        if (this.description == null) {
            this.initDescription();
        }
        return this.description;
    }

    private void initDescription() {
        Object object;
        Object object2;
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = null;
        try {
            iterator = iIORegistry.getServiceProviders(class$javax$imageio$spi$ImageReaderSpi == null ? (class$javax$imageio$spi$ImageReaderSpi = JavaImageToolkit.class$("javax.imageio.spi.ImageReaderSpi")) : class$javax$imageio$spi$ImageReaderSpi, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                object2 = (ImageReaderSpi)iterator.next();
                object = ((ImageReaderWriterSpi)object2).getFileSuffixes();
                int n = 0;
                while (n < ((String[])object).length) {
                    String string = ((String)object[n]).toLowerCase();
                    if (!this.excludedExtensions.contains(string)) {
                        hashSet.add(string);
                    }
                    ++n;
                }
            }
        }
        object2 = new HashSet();
        iterator = null;
        try {
            iterator = iIORegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = JavaImageToolkit.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                object = (ImageWriterSpi)iterator.next();
                String[] stringArray = ((ImageReaderWriterSpi)object).getFileSuffixes();
                int n = 0;
                while (n < stringArray.length) {
                    String string = stringArray[n].toLowerCase();
                    if (!this.excludedExtensions.contains(string)) {
                        ((HashSet)object2).add(string);
                    }
                    ++n;
                }
            }
        }
        object = new StringBuffer();
        ((StringBuffer)object).append("Built-in javax.imageio ");
        String string = System.getProperty("java.version");
        if (string == null) {
            string = "java.version???";
        }
        ((StringBuffer)object).append(string);
        ((StringBuffer)object).append(".\n");
        ((StringBuffer)object).append("Can read: ");
        Object[] objectArray = new String[hashSet.size()];
        hashSet.toArray(objectArray);
        Arrays.sort(objectArray);
        ((StringBuffer)object).append(StringUtil.join((String[])objectArray, ", "));
        ((StringBuffer)object).append(".\n");
        ((StringBuffer)object).append("Can write: ");
        objectArray = new String[((HashSet)object2).size()];
        ((HashSet)object2).toArray(objectArray);
        Arrays.sort(objectArray);
        ((StringBuffer)object).append(StringUtil.join((String[])objectArray, ", "));
        ((StringBuffer)object).append(".\n");
        this.description = ((StringBuffer)object).toString();
    }

    public ImageRenderer getImageRenderer(URL uRL) {
        String string = URLPathUtil.extension(uRL.toExternalForm());
        if (string.length() == 0) {
            return null;
        }
        final ImageReader imageReader = this.getImageReader(string.toLowerCase());
        if (imageReader == null) {
            return null;
        }
        return new ImageRendererAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Image createImage(URL uRL, double d, int n, double d2, int n2, boolean bl, boolean bl2, double d3) throws Exception {
                BufferedImage bufferedImage = null;
                InputStream inputStream = uRL.openStream();
                try {
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
                    if (imageInputStream == null) {
                        throw new IIOException("cannot create an ImageInputStream for a java.io.InputStream");
                    }
                    ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                    imageReader.setInput(imageInputStream, true, true);
                    bufferedImage = imageReader.read(0, imageReadParam);
                    Object var17_13 = null;
                    imageReader.dispose();
                }
                catch (Throwable throwable) {
                    Object var17_14 = null;
                    imageReader.dispose();
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return ImageToolkitUtil.scaleImage(bufferedImage, d, n, d2, n2, bl, bl2);
            }
        };
    }

    public ImageRenderer getImageRenderer(byte[] byArray) {
        String[] stringArray = ImageToolkitUtil.detectImageFormat(byArray);
        if (stringArray == null) {
            return null;
        }
        final ImageReader imageReader = this.getImageReader(stringArray[0]);
        if (imageReader == null) {
            return null;
        }
        return new ImageRendererAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Image createImage(byte[] byArray, URL uRL, double d, int n, double d2, int n2, boolean bl, boolean bl2, double d3) throws Exception {
                BufferedImage bufferedImage = null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                try {
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                    if (imageInputStream == null) {
                        throw new IIOException("cannot create an ImageInputStream for a java.io.InputStream");
                    }
                    ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                    imageReader.setInput(imageInputStream, true, true);
                    bufferedImage = imageReader.read(0, imageReadParam);
                    Object var18_14 = null;
                    imageReader.dispose();
                }
                catch (Throwable throwable) {
                    Object var18_15 = null;
                    imageReader.dispose();
                    byteArrayInputStream.close();
                    throw throwable;
                }
                byteArrayInputStream.close();
                return ImageToolkitUtil.scaleImage(bufferedImage, d, n, d2, n2, bl, bl2);
            }
        };
    }

    private ImageReader getImageReader(String string) {
        if (this.excludedExtensions.contains(string)) {
            return null;
        }
        ImageReader imageReader = null;
        Iterator<ImageReader> iterator = ImageIO.getImageReadersBySuffix(string);
        if (iterator.hasNext()) {
            imageReader = iterator.next();
        }
        return imageReader;
    }

    private ImageWriter getImageWriter(String string) {
        if (this.excludedExtensions.contains(string)) {
            return null;
        }
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix(string);
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        return imageWriter;
    }

    public ImageRenderer getImageRenderer(Element element) {
        return null;
    }

    public ImageConverter getImageConverter(File file, File file2) {
        String string = FileUtil.fileExtension(file.getPath());
        if (string.length() == 0) {
            return null;
        }
        final String string2 = FileUtil.fileExtension(file2.getPath());
        if (string2.length() == 0) {
            return null;
        }
        if (this.getImageReader(string) == null) {
            return null;
        }
        if (this.getImageWriter(string2) == null) {
            return null;
        }
        return new ImageConverter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void convertImage(File file, File file2, String[] stringArray, Console console) throws Exception {
                BufferedImage bufferedImage = ImageIO.read(file);
                ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(bufferedImage);
                ImageWriter imageWriter = JavaImageToolkit.getImageWriter(imageTypeSpecifier, string2);
                if (imageWriter == null) {
                    throw new IIOException("don't know how to convert the image read from " + file + " to " + string2.toUpperCase());
                }
                file2.delete();
                ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file2);
                if (imageOutputStream == null) {
                    imageWriter.dispose();
                    throw new IIOException("cannot create an ImageOutputStream for a java.io.File");
                }
                imageWriter.setOutput(imageOutputStream);
                try {
                    ImageWriteParam imageWriteParam = JavaImageToolkit.getImageWriteParam(imageWriter, string2, stringArray);
                    imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
                    imageOutputStream.flush();
                    Object var11_10 = null;
                    imageWriter.dispose();
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    imageWriter.dispose();
                    throw throwable;
                }
            }
        };
    }

    private static ImageWriteParam getImageWriteParam(ImageWriter imageWriter, String string, String[] stringArray) throws RuntimeException {
        ImageWriteParam imageWriteParam = null;
        if (stringArray != null && stringArray.length > 0) {
            imageWriteParam = imageWriter.getDefaultWriteParam();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                String string3 = stringArray[n + 1];
                if ("compression".equals(string2)) {
                    String[] stringArray2;
                    if (!imageWriteParam.canWriteCompressed() || (stringArray2 = imageWriteParam.getCompressionTypes()) == null) {
                        throw new RuntimeException("parameter 'compression' is not supported for " + string.toUpperCase() + " files");
                    }
                    if (!StringUtil.contains(stringArray2, string3)) {
                        throw new RuntimeException("invalid value '" + string3 + "' for parameter" + " 'compression': should be " + StringUtil.join(stringArray2, " or "));
                    }
                    imageWriteParam.setCompressionMode(2);
                    imageWriteParam.setCompressionType(string3);
                } else if ("quality".equals(string2)) {
                    if (!imageWriteParam.canWriteCompressed()) {
                        throw new RuntimeException("parameter 'quality' is not supported for " + string.toUpperCase() + " files");
                    }
                    float f = -1.0f;
                    try {
                        f = Float.parseFloat(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (f < 0.0f || f > 1.0f) {
                        throw new RuntimeException("invalid value '" + string3 + "' for parameter" + " 'quality': should be a float between 0 and 1");
                    }
                    imageWriteParam.setCompressionMode(2);
                    if (imageWriteParam.getCompressionTypes() != null && imageWriteParam.getCompressionType() == null) {
                        throw new RuntimeException("parameter 'compression' must be specified before parameter 'quality'");
                    }
                    imageWriteParam.setCompressionQuality(f);
                } else if ("progressive".equals(string2)) {
                    boolean bl;
                    if (!imageWriteParam.canWriteProgressive()) {
                        throw new RuntimeException("parameter 'progressive' is not supported for " + string.toUpperCase() + " files");
                    }
                    if ("true".equals(string3)) {
                        bl = true;
                    } else if ("false".equals(string3)) {
                        bl = false;
                    } else {
                        throw new RuntimeException("invalid value '" + string3 + "' for parameter" + " 'progressive': should be 'true' or 'false'");
                    }
                    imageWriteParam.setProgressiveMode(bl ? 1 : 0);
                } else {
                    throw new RuntimeException("unknown parameter '" + string2 + "': should be" + "'compression', 'quality' or 'progressive'");
                }
                n += 2;
            }
        }
        return imageWriteParam;
    }

    private static ImageWriter getImageWriter(final ImageTypeSpecifier imageTypeSpecifier, final String string) throws IOException {
        ImageWriter imageWriter = null;
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        Iterator iterator = null;
        try {
            iterator = iIORegistry.getServiceProviders(class$javax$imageio$spi$ImageWriterSpi == null ? (class$javax$imageio$spi$ImageWriterSpi = JavaImageToolkit.class$("javax.imageio.spi.ImageWriterSpi")) : class$javax$imageio$spi$ImageWriterSpi, new ServiceRegistry.Filter(){

                public boolean filter(Object object) {
                    ImageWriterSpi imageWriterSpi = (ImageWriterSpi)object;
                    if (!imageWriterSpi.canEncodeImage(imageTypeSpecifier)) {
                        return false;
                    }
                    String[] stringArray = imageWriterSpi.getFileSuffixes();
                    int n = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n].equalsIgnoreCase(string)) {
                            return true;
                        }
                        ++n;
                    }
                    return false;
                }
            }, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (iterator != null && iterator.hasNext()) {
            ImageWriterSpi imageWriterSpi = (ImageWriterSpi)iterator.next();
            imageWriter = imageWriterSpi.createWriterInstance();
        }
        return imageWriter;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

