/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.imagetoolkit;

import com.jclark.xml.parse.OpenEntity;
import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentWriter;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.doc.XPath;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.imagetoolkit.XMLImageLoader;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespacePrefixMap;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.StringType;
import com.xmlmind.xmledit.xsd.datatype.Value;
import com.xmlmind.xmledit.xsd.dtdtoxsd.DTD;
import com.xmlmind.xmledit.xsd.validate.AttributeDeclaration;
import com.xmlmind.xmledit.xsd.validate.ComplexType;
import com.xmlmind.xmledit.xsd.validate.ElementDeclaration;
import com.xmlmind.xmledit.xsd.validate.Type;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class XMLImageUtil {
    private static XMLImageLoader imageLoader;
    private static XPath resourcesXPath;

    public static XMLImageLoader getImageLoader() {
        if (imageLoader == null) {
            imageLoader = new XMLImageLoader();
        }
        return imageLoader;
    }

    public static XPath getResourcesXPath() {
        if (resourcesXPath == null) {
            resourcesXPath = XPath.fromString("//@xlink:href", new PrefixToNamespace(){

                public Namespace prefixToNamespace(String string) {
                    if ("xlink".equals(string)) {
                        return Namespace.XLINK;
                    }
                    if ("xml".equals(string)) {
                        return Namespace.XML;
                    }
                    return null;
                }
            });
        }
        return resourcesXPath;
    }

    public static boolean isXMLImage(URL uRL) {
        String string = URLUtil.getRawExtension(uRL);
        return string.equalsIgnoreCase("svg") || string.equalsIgnoreCase("svgz");
    }

    public static File createCopiableImageFile(URL uRL, URL uRL2, ArrayList arrayList) throws IOException {
        Document document = XMLImageUtil.loadImageDocument(uRL);
        if (!XMLImageUtil.processImageDocument(document, uRL, uRL2, arrayList)) {
            return null;
        }
        String string = URLUtil.getRawBaseName(uRL);
        String string2 = URLPathUtil.extension(string);
        boolean bl = string2.equalsIgnoreCase("svgz");
        string = URLPathUtil.trimExtension(string);
        string2 = URIUtil.unescape(string2);
        string = URIUtil.unescape(string);
        while (string.length() < 3) {
            string = string + '_';
        }
        File file = File.createTempFile(string, string2.length() > 0 ? "." + string2 : ".tmp");
        try {
            XMLImageUtil.saveImageDocument(document, file, bl);
        }
        catch (IOException iOException) {
            file.delete();
            throw iOException;
        }
        arrayList.add(FileUtil.fileToURL(file));
        arrayList.add(uRL2);
        return file;
    }

    public static Document loadImageDocument(URL uRL) throws IOException {
        String string = URLUtil.getRawExtension(uRL);
        boolean bl = string.equalsIgnoreCase("svgz");
        InputStream inputStream = uRL.openStream();
        if (bl) {
            inputStream = new GZIPInputStream(inputStream);
        }
        OpenEntity openEntity = new OpenEntity(inputStream, uRL.toExternalForm(), uRL);
        return XMLImageUtil.getImageLoader().load(openEntity);
    }

    public static boolean processImageDocument(Document document, URL uRL) {
        return XMLImageUtil.processImageDocument(document, uRL, null, null);
    }

    public static boolean processImageDocument(Document document, URL uRL, URL uRL2, ArrayList arrayList) {
        XNode[] xNodeArray = XMLImageUtil.getResourcesXPath().select(document);
        if (xNodeArray == null || xNodeArray.length == 0) {
            return false;
        }
        String string = null;
        if (uRL2 != null) {
            string = URLUtil.getRawBaseName(uRL2);
            string = URLPathUtil.trimExtension(string) + "_resources";
        }
        boolean bl = false;
        int n = 0;
        while (n < xNodeArray.length) {
            XNode xNode = xNodeArray[n];
            Attribute attribute = null;
            Element element = null;
            URL uRL3 = null;
            String string2 = null;
            if (xNode instanceof Attribute) {
                attribute = (Attribute)xNode;
                string2 = attribute.value;
                uRL3 = attribute.element.getLocation();
                if (uRL3 == null) {
                    uRL3 = uRL;
                }
            } else if (xNode instanceof Element) {
                element = (Element)xNode;
                string2 = element.getText();
                uRL3 = element.getLocation();
                if (uRL3 == null) {
                    uRL3 = uRL;
                }
            }
            if (string2 != null && ((string2 = string2.trim()).length() == 0 || string2.equals("???"))) {
                string2 = null;
            }
            if (string2 != null) {
                URL uRL4 = null;
                boolean bl2 = false;
                try {
                    uRL4 = new URL(string2);
                    bl2 = true;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (!bl2 || "file".equals(uRL4.getProtocol())) {
                    if (uRL4 == null) {
                        try {
                            uRL4 = new URL(uRL3, string2);
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                    if (uRL4 != null && !(uRL4 = URLUtil.trimFragment(uRL4)).equals(uRL)) {
                        if (uRL2 == null) {
                            if (attribute != null) {
                                attribute.element.putAttribute(attribute.name, uRL4.toExternalForm());
                            } else {
                                element.setText(uRL4.toExternalForm());
                            }
                            bl = true;
                        } else {
                            String string3 = string + '/' + URLUtil.getRawBaseName(uRL4);
                            if (attribute != null) {
                                attribute.element.putAttribute(attribute.name, string3);
                            } else {
                                element.setText(string3);
                            }
                            URL uRL5 = null;
                            try {
                                uRL5 = new URL(uRL2, string3);
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                            if (uRL5 != null && !uRL4.equals(uRL5)) {
                                XMLImageUtil.addURLs(arrayList, uRL4, uRL5);
                                bl = true;
                            }
                        }
                    }
                }
            }
            ++n;
        }
        return bl;
    }

    private static void addURLs(ArrayList arrayList, URL uRL, URL uRL2) {
        boolean bl = false;
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            URL uRL3 = (URL)arrayList.get(n2);
            if (uRL3.equals(uRL)) {
                bl = true;
                break;
            }
            n2 += 2;
        }
        if (!bl) {
            arrayList.add(uRL);
            arrayList.add(uRL2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveImageDocument(Document document, File file, boolean bl) throws IOException {
        OutputStream outputStream = new FileOutputStream(file);
        if (bl) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        DocumentWriter documentWriter = new DocumentWriter();
        documentWriter.setPreferredPrefixes(document.getPreferredPrefixes(true));
        try {
            documentWriter.writeDocument(document, outputStream);
            outputStream.flush();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            outputStream.close();
            throw throwable;
        }
        outputStream.close();
    }

    public static Element createEmbeddableImageElement(URL uRL, Document document, URL uRL2, ArrayList arrayList) throws IOException, RuntimeException {
        DocumentType documentType;
        Document document2 = XMLImageUtil.loadImageDocument(uRL);
        URL uRL3 = null;
        try {
            uRL3 = new URL(uRL2, URLUtil.getRawBaseName(uRL));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL3 != null) {
            XMLImageUtil.processImageDocument(document2, uRL, uRL3, arrayList);
        }
        if ((documentType = (DocumentType)document.getProperty("DOCUMENT_TYPE")) != null && documentType instanceof DTD) {
            Element element = document2.getRootElement();
            boolean bl = element.getName() == Name.get(Namespace.SVG, "svg");
            PreferredPrefix preferredPrefix = XMLImageUtil.createNamespacePrefixMap((DTD)documentType);
            return XMLImageUtil.copyImageElement(element, preferredPrefix, bl);
        }
        document2.removeProperties(1);
        Element element = document2.getRootElement();
        document2.removeChild(element);
        return element;
    }

    private static PreferredPrefix createNamespacePrefixMap(DTD dTD) {
        PreferredPrefix preferredPrefix = new PreferredPrefix();
        Enumeration enumeration = dTD.getElementDeclarations();
        while (enumeration.hasMoreElements()) {
            Type type = ((ElementDeclaration)enumeration.nextElement()).getType();
            if (!(type instanceof ComplexType)) continue;
            Enumeration enumeration2 = ((ComplexType)type).getAttributeDeclarations();
            while (enumeration2.hasMoreElements()) {
                DataType dataType;
                Value value;
                AttributeDeclaration attributeDeclaration = (AttributeDeclaration)enumeration2.nextElement();
                String string = attributeDeclaration.getName().getLocalPart();
                if (!string.startsWith("xmlns") || (value = attributeDeclaration.getDefaultValue()) == null || !((dataType = attributeDeclaration.getDataType()) instanceof StringType)) continue;
                Namespace namespace = Namespace.get(value.toString());
                if (string.startsWith("xmlns:")) {
                    String string2 = string.substring(6);
                    if (string2.length() <= 0) continue;
                    preferredPrefix.add(namespace, string2);
                    continue;
                }
                preferredPrefix.add(namespace, "ns");
                if (preferredPrefix.getDefaultNamespace() != null) continue;
                preferredPrefix.setDefaultNamespace(namespace);
            }
        }
        return preferredPrefix;
    }

    private static Element copyImageElement(Element element, PreferredPrefix preferredPrefix, boolean bl) throws RuntimeException {
        Object object;
        XNode xNode;
        Element element2 = new Element(XMLImageUtil.prefixedName(element.getName(), false, preferredPrefix));
        Enumeration enumeration = element.getAttributes();
        while (enumeration.hasMoreElements()) {
            xNode = (Attribute)enumeration.nextElement();
            if (bl && (object = ((Attribute)xNode).name.getNamespace()) != Namespace.NONE && object != Namespace.XLINK) continue;
            element2.putAttribute(XMLImageUtil.prefixedName(((Attribute)xNode).name, true, preferredPrefix), ((Attribute)xNode).value);
        }
        xNode = element.getFirstChild();
        while (xNode != null) {
            switch (((Node)xNode).getNodeType()) {
                case 0: 
                case 1: 
                case 2: {
                    element2.appendChild(((Node)xNode).copy());
                    break;
                }
                case 4: {
                    Namespace namespace;
                    object = (Element)xNode;
                    if (bl && (namespace = ((Element)object).getNamespace()) != Namespace.SVG) break;
                    element2.appendChild(XMLImageUtil.copyImageElement((Element)object, preferredPrefix, bl));
                }
            }
            xNode = ((Node)xNode).getNextSibling();
        }
        return element2;
    }

    private static Name prefixedName(Name name, boolean bl, PreferredPrefix preferredPrefix) throws RuntimeException {
        String string;
        Namespace namespace = name.getNamespace();
        if (namespace == Namespace.NONE || namespace == Namespace.XML) {
            return name;
        }
        String string2 = bl ? preferredPrefix.get(namespace) : (namespace == preferredPrefix.getDefaultNamespace() ? "" : preferredPrefix.get(namespace));
        if (string2 == null) {
            throw new RuntimeException("don't find in the DTD a prefix corresponding to namespace '" + namespace + "'");
        }
        if (string2.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            stringBuffer.append(':');
            stringBuffer.append(name.getLocalPart());
            string = stringBuffer.toString();
        } else {
            string = name.getLocalPart();
        }
        return Name.get(Namespace.NONE, string);
    }

    public static Document createImageDocument(Element element) throws RuntimeException {
        URL uRL;
        Element element2;
        NamespacePrefixMap namespacePrefixMap;
        Document document = element.getDocument();
        DocumentType documentType = (DocumentType)document.getProperty("DOCUMENT_TYPE");
        if (documentType != null && documentType instanceof DTD) {
            namespacePrefixMap = XMLImageUtil.createNamespacePrefixMap((DTD)documentType);
            element2 = XMLImageUtil.copyImageElement2(element, (PreferredPrefix)namespacePrefixMap);
        } else {
            namespacePrefixMap = (NamespacePrefixMap)document.getProperty("NAMESPACE_PREFIX_MAP");
            element2 = (Element)element.copy();
        }
        Document document2 = new Document();
        if (namespacePrefixMap != null) {
            document2.putProperty("NAMESPACE_PREFIX_MAP", namespacePrefixMap);
        }
        if ((uRL = element.getLocation()) != null) {
            document2.putLocationInfo(uRL.toExternalForm(), false);
        }
        document2.appendChild(element2);
        return document2;
    }

    private static Element copyImageElement2(Element element, PreferredPrefix preferredPrefix) throws RuntimeException {
        XNode xNode;
        Element element2 = new Element(XMLImageUtil.unprefixedName(element.getName(), false, preferredPrefix));
        Enumeration enumeration = element.getAttributes();
        while (enumeration.hasMoreElements()) {
            xNode = (Attribute)enumeration.nextElement();
            if (((Attribute)xNode).name.getLocalPart().startsWith("xmlns")) continue;
            element2.putAttribute(XMLImageUtil.unprefixedName(((Attribute)xNode).name, true, preferredPrefix), ((Attribute)xNode).value);
        }
        xNode = element.getFirstChild();
        while (xNode != null) {
            switch (((Node)xNode).getNodeType()) {
                case 0: 
                case 1: 
                case 2: {
                    element2.appendChild(((Node)xNode).copy());
                    break;
                }
                case 4: {
                    element2.appendChild(XMLImageUtil.copyImageElement2((Element)xNode, preferredPrefix));
                }
            }
            xNode = ((Node)xNode).getNextSibling();
        }
        return element2;
    }

    private static Name unprefixedName(Name name, boolean bl, PreferredPrefix preferredPrefix) throws RuntimeException {
        String string;
        Namespace namespace = name.getNamespace();
        if (namespace == Namespace.XML) {
            return name;
        }
        String string2 = name.getLocalPart();
        int n = string2.indexOf(58);
        if (n < 0) {
            string = null;
        } else {
            string = string2.substring(0, n);
            string2 = string2.substring(n + 1);
        }
        if (string == null) {
            if (bl) {
                namespace = Namespace.NONE;
            } else {
                namespace = preferredPrefix.getDefaultNamespace();
                if (namespace == null) {
                    namespace = Namespace.NONE;
                }
            }
        } else {
            namespace = preferredPrefix.get(string);
        }
        if (namespace == null) {
            throw new RuntimeException("don't find in the DTD a namespace corresponding to prefix '" + (string == null ? "" : string) + "'");
        }
        return Name.get(namespace, string2);
    }
}

