/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.rng.datatype;

import com.xmlmind.xmledit.rng.datatype.Msg;
import com.xmlmind.xmledit.rng.datatype.TypeImpl;
import com.xmlmind.xmledit.rng.datatype.ValidationContextWrapper;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.InvalidTypeException;
import com.xmlmind.xmledit.xsd.datatype.Pattern;
import com.xmlmind.xmledit.xsd.datatype.Restriction;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public class BuilderImpl
extends ValidationContextWrapper
implements DatatypeBuilder {
    private Restriction restrict;
    private StringBuffer regexp;

    public BuilderImpl(DataType dataType) {
        this.restrict = new Restriction(dataType);
        this.regexp = null;
    }

    public void addParameter(String string, String string2, ValidationContext validationContext) throws DatatypeException {
        this.context = validationContext;
        if ("length".equals(string)) {
            try {
                this.restrict.setLength(BuilderImpl.parseNonNegativeInt(string2, "length"), false);
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new DatatypeException(invalidTypeException.getMessage());
            }
        } else if ("minLength".equals(string)) {
            try {
                this.restrict.setMinLength(BuilderImpl.parseNonNegativeInt(string2, "minLength"), false);
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new DatatypeException(invalidTypeException.getMessage());
            }
        } else if ("maxLength".equals(string)) {
            try {
                this.restrict.setMaxLength(BuilderImpl.parseNonNegativeInt(string2, "maxLength"), false);
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new DatatypeException(invalidTypeException.getMessage());
            }
        } else if ("pattern".equals(string)) {
            int n = string2.length();
            if (n > 0) {
                if (this.regexp == null) {
                    this.regexp = new StringBuffer();
                } else {
                    this.regexp.append('|');
                }
                this.regexp.append('(');
                this.regexp.append(string2);
                this.regexp.append(')');
            }
        } else if ("maxInclusive".equals(string)) {
            try {
                this.restrict.setMaxInclusive(string2, this, this, false);
            }
            catch (InvalidDataException invalidDataException) {
                throw new DatatypeException(invalidDataException.getMessage());
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new DatatypeException(invalidTypeException.getMessage());
            }
        } else if ("maxExclusive".equals(string)) {
            try {
                this.restrict.setMaxExclusive(string2, this, this, false);
            }
            catch (InvalidDataException invalidDataException) {
                throw new DatatypeException(invalidDataException.getMessage());
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new DatatypeException(invalidTypeException.getMessage());
            }
        } else if ("minExclusive".equals(string)) {
            try {
                this.restrict.setMinExclusive(string2, this, this, false);
            }
            catch (InvalidDataException invalidDataException) {
                throw new DatatypeException(invalidDataException.getMessage());
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new DatatypeException(invalidTypeException.getMessage());
            }
        } else if ("minInclusive".equals(string)) {
            try {
                this.restrict.setMinInclusive(string2, this, this, false);
            }
            catch (InvalidDataException invalidDataException) {
                throw new DatatypeException(invalidDataException.getMessage());
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new DatatypeException(invalidTypeException.getMessage());
            }
        } else if ("totalDigits".equals(string)) {
            try {
                this.restrict.setTotalDigits(BuilderImpl.parseNonNegativeInt(string2, "totalDigits"), false);
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new DatatypeException(invalidTypeException.getMessage());
            }
        } else if ("fractionDigits".equals(string)) {
            try {
                this.restrict.setFractionDigits(BuilderImpl.parseNonNegativeInt(string2, "fractionDigits"), false);
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new DatatypeException(invalidTypeException.getMessage());
            }
        } else {
            if ("whiteSpace".equals(string)) {
                throw new DatatypeException(Msg.msg("whiteSpaceParam"));
            }
            if ("enumeration".equals(string)) {
                throw new DatatypeException(Msg.msg("enumerationParam"));
            }
            throw new DatatypeException(Msg.msg("unknownParam", string));
        }
    }

    private static final int parseNonNegativeInt(String string, String string2) throws DatatypeException {
        int n;
        string = string.trim();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n < 0) {
            throw new DatatypeException(Msg.msg("expectedNonNegativeInt", string2, string));
        }
        return n;
    }

    public Datatype createDatatype() throws DatatypeException {
        Object object;
        if (this.regexp != null) {
            Pattern pattern;
            object = this.regexp.toString();
            try {
                pattern = new Pattern((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DatatypeException(Msg.msg("invalidRegexp", object, illegalArgumentException.getMessage()));
            }
            try {
                this.restrict.setPattern(pattern);
            }
            catch (InvalidTypeException invalidTypeException) {
                throw new DatatypeException(invalidTypeException.getMessage());
            }
        }
        try {
            object = this.restrict.derive();
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new DatatypeException(invalidTypeException.getMessage());
        }
        return new TypeImpl((DataType)object);
    }
}

