/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.rng.doctype;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doctype.AttributeType;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DataFormatException;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.doctype.UncheckedUnparsedEntities;
import com.xmlmind.xmledit.rng.doctype.Builder;
import com.xmlmind.xmledit.rng.doctype.ChoicePattern;
import com.xmlmind.xmledit.rng.doctype.EmptyPattern;
import com.xmlmind.xmledit.rng.doctype.FieldBase;
import com.xmlmind.xmledit.rng.doctype.ItemList;
import com.xmlmind.xmledit.rng.doctype.NameClassBase;
import com.xmlmind.xmledit.rng.doctype.NotAllowedPattern;
import com.xmlmind.xmledit.rng.doctype.Pattern;
import com.xmlmind.xmledit.rng.doctype.PatternStack;
import com.xmlmind.xmledit.rng.doctype.SingleNameClass;
import com.xmlmind.xmledit.rng.doctype.TextPattern;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xsd.datatype.StringType;
import java.util.IdentityHashMap;

final class AttributeField
extends FieldBase
implements AttributeType {
    String defaultValueAnnotation;
    public Data defaultValue;

    public AttributeField(NameClassBase nameClassBase, Pattern pattern, String string, Builder builder) {
        block4: {
            super(nameClassBase, pattern, builder);
            this.defaultValueAnnotation = string;
            if (pattern == TextPattern.INSTANCE) {
                this.dataType = StringType.BASE;
            } else {
                this.initDataType();
            }
            if (string == null) break block4;
            try {
                this.defaultValue = this.dataType.parseData(string, null, UncheckedUnparsedEntities.INSTANCE);
            }
            catch (DataFormatException dataFormatException) {}
        }
    }

    AttributeField() {
    }

    public int hashCode() {
        int n = this.nameClass.hashCode() ^ System.identityHashCode(this.pattern);
        if (this.defaultValueAnnotation != null) {
            n ^= this.defaultValueAnnotation.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AttributeField)) {
            return false;
        }
        AttributeField attributeField = (AttributeField)object;
        return this.nameClass.equals(attributeField.nameClass) && this.pattern == attributeField.pattern && (this.defaultValueAnnotation == null && attributeField.defaultValueAnnotation == null || this.defaultValueAnnotation != null && this.defaultValueAnnotation.equals(attributeField.defaultValueAnnotation));
    }

    public void toString(int n, NamespaceToPrefixes namespaceToPrefixes, StringBuffer stringBuffer) {
        stringBuffer.append("attribute ");
        this.nameClass.toLabel(true, namespaceToPrefixes, stringBuffer);
        stringBuffer.append(" {");
        if (n >= 0) {
            stringBuffer.append('\n');
            Pattern.indent(n + 2, stringBuffer);
        }
        this.pattern.toString(n >= 0 ? n + 2 : -1, namespaceToPrefixes, stringBuffer);
        if (n >= 0) {
            stringBuffer.append('\n');
            Pattern.indent(n, stringBuffer);
        }
        stringBuffer.append("}");
    }

    public Pattern attributeDeriv(AttributeField attributeField, Builder builder) {
        if (attributeField == this) {
            return EmptyPattern.INSTANCE;
        }
        return NotAllowedPattern.INSTANCE;
    }

    public Pattern attributeDeriv(Attribute attribute, IdentityHashMap identityHashMap, FieldBase[] fieldBaseArray, Builder builder) {
        if (this.nameClass.containsName(attribute.name)) {
            if (identityHashMap != null) {
                Object v = identityHashMap.get(this);
                if (v == Boolean.FALSE) {
                    return NotAllowedPattern.INSTANCE;
                }
                if (v == Boolean.TRUE) {
                    Data data = null;
                    try {
                        data = this.dataType.parseData(attribute.value, attribute.element, UncheckedUnparsedEntities.INSTANCE);
                    }
                    catch (DataFormatException dataFormatException) {
                        // empty catch block
                    }
                    if (!this.fixedValue.equals(data)) {
                        return NotAllowedPattern.INSTANCE;
                    }
                }
            }
            fieldBaseArray[0] = this;
            return EmptyPattern.INSTANCE;
        }
        return NotAllowedPattern.INSTANCE;
    }

    protected int scan(PatternStack patternStack, IdentityHashMap identityHashMap, IdentityHashMap identityHashMap2) {
        Object object;
        boolean bl = true;
        int n = patternStack.size - 1;
        while (n >= 0) {
            object = patternStack.list[n];
            if (object instanceof ChoicePattern) {
                bl = false;
                break;
            }
            --n;
        }
        object = (Boolean)identityHashMap.get(this);
        boolean bl2 = object != null && ((Boolean)object).booleanValue();
        bl = bl2 || bl;
        identityHashMap.put(this, bl ? Boolean.TRUE : Boolean.FALSE);
        return 0;
    }

    protected int attributesSeparatedFromElements() {
        return 1;
    }

    protected Pattern withoutAttributes(Builder builder) {
        return EmptyPattern.INSTANCE;
    }

    protected int getComplexity(boolean bl) {
        int n = 100;
        if (this.nameClass instanceof SingleNameClass) {
            Name name = ((SingleNameClass)this.nameClass).name;
            n += name.getLocalPart().length();
            if (name.getNamespace() != Namespace.NONE) {
                n += 20;
            }
        } else {
            n += 1000;
        }
        return n;
    }

    protected boolean expand(int n, ItemList itemList) {
        if ((n & 1) != 0) {
            itemList.add(this);
        }
        return true;
    }

    public DataType getAttributeDataType() {
        return this.dataType;
    }

    public Data getAttributeFixedValue() {
        return this.fixedValue;
    }

    public Data getAttributeDefaultValue() {
        return this.defaultValue;
    }
}

