/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.rng.doctype;

import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DataFormatException;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.doctype.UnparsedEntities;
import com.xmlmind.xmledit.rng.doctype.Builder;
import com.xmlmind.xmledit.rng.doctype.DataExceptPattern;
import com.xmlmind.xmledit.rng.doctype.DataPattern;
import com.xmlmind.xmledit.rng.doctype.Pattern;
import com.xmlmind.xmledit.rng.doctype.PatternTraversal;
import com.xmlmind.xmledit.rng.doctype.ValuePattern;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.datatype.StringValue;

final class ComplexDataType
implements DataType {
    private Pattern pattern;
    private Builder builder;
    private byte contextDependent;

    public ComplexDataType(Pattern pattern, Builder builder) {
        this.pattern = pattern;
        this.builder = builder;
        this.contextDependent = (byte)-1;
    }

    public int hashCode() {
        return System.identityHashCode(this.pattern);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ComplexDataType)) {
            return false;
        }
        return this.pattern == ((ComplexDataType)object).pattern;
    }

    public String toString() {
        return this.getDataTypeLabel(null);
    }

    public String normalizeWhiteSpace(String string) {
        return string;
    }

    public Data parseData(String string, PrefixToNamespace prefixToNamespace, UnparsedEntities unparsedEntities) throws DataFormatException {
        Pattern pattern = this.pattern.textDeriv(string, prefixToNamespace, unparsedEntities, this.builder);
        if (!pattern.nullable) {
            throw new DataFormatException("'" + string + "' does not match " + this.getDataTypeLabel(null));
        }
        return new StringValue(string);
    }

    public boolean isContextDependentDataType() {
        if (this.contextDependent < 0) {
            Object object = PatternTraversal.traverse(this.pattern, new PatternTraversal.HandlerBase(){

                public Object dataPattern(DataPattern dataPattern) {
                    if (dataPattern.dataType.isContextDependentDataType()) {
                        return Boolean.TRUE;
                    }
                    return null;
                }

                public Object valuePattern(ValuePattern valuePattern) {
                    if (valuePattern.dataType.isContextDependentDataType()) {
                        return Boolean.TRUE;
                    }
                    return null;
                }

                public Object dataExceptPattern(DataExceptPattern dataExceptPattern) {
                    if (dataExceptPattern.dataType.isContextDependentDataType()) {
                        return Boolean.TRUE;
                    }
                    return null;
                }
            });
            this.contextDependent = (byte)(object != null ? 1 : 0);
        }
        return this.contextDependent == 1;
    }

    public Data[] getEnumeratedValues() {
        return null;
    }

    public String getDataTypeLabel(NamespaceToPrefixes namespaceToPrefixes) {
        return XMLUtil.collapseWhiteSpace(this.pattern.toString(namespaceToPrefixes));
    }
}

