/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.rng.doctype;

import com.thaiopensource.relaxng.impl.RngProperty;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.AttributeDefaultValue;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.Diagnostic;
import com.xmlmind.xmledit.doctype.DiagnosticImpl;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.Structure;
import com.xmlmind.xmledit.rng.doctype.Builder;
import com.xmlmind.xmledit.rng.doctype.ElementField;
import com.xmlmind.xmledit.rng.doctype.IdCollector;
import com.xmlmind.xmledit.rng.doctype.IdFinder;
import com.xmlmind.xmledit.rng.doctype.Pattern;
import com.xmlmind.xmledit.rng.doctype.SAXTraversal;
import com.xmlmind.xmledit.rng.doctype.SAXTraversalException;
import com.xmlmind.xmledit.rng.doctype.SingleNameClass;
import com.xmlmind.xmledit.rng.doctype.Translator;
import com.xmlmind.xmledit.rng.doctype.TranslatorException;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DocumentTypeImpl
implements DocumentType,
ErrorHandler {
    private Schema schema;
    private Validator validator;
    private SAXTraversal traversal;
    private ArrayList errors;
    private Builder builder;
    private ElementField startField;
    private URL[] sourceURLs;
    private PrefixEntry[] preferredPrefixes;
    private ArrayList ancestorList = new ArrayList();
    private Structure structure = new Structure();
    private Node[] nodes1 = new Node[1];
    private static final Attribute[] NO_ATTRIBUTES = new Attribute[0];
    private static Entry[] entries = new Entry[]{new Entry("missing_id", 3), new Entry("duplicate_id", 3), new Entry("first_id", 3), new Entry("bad_attribute_value", 4), new Entry("string_not_allowed", 4), new Entry("id_no_tokens", 4), new Entry("id_multiple_tokens", 4), new Entry("idref_no_tokens", 4), new Entry("idref_multiple_tokens", 4), new Entry("idrefs_no_tokens", 4)};
    private static boolean initialized = false;

    public DocumentTypeImpl(Schema schema) throws TranslatorException {
        this.schema = schema;
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, (ErrorHandler)this);
        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
        this.validator = schema.createValidator(propertyMapBuilder.toPropertyMap());
        this.traversal = new SAXTraversal();
        this.traversal.setContentHandler(this.validator.getContentHandler());
        this.errors = new ArrayList();
        this.builder = new Builder();
        Translator translator = new Translator();
        Pattern pattern = translator.translate(schema, this.builder);
        this.startField = new ElementField(new SingleNameClass(Name.get("__start__")), pattern, this.builder);
        this.sourceURLs = translator.getSourceURLs();
        this.preferredPrefixes = translator.getPreferredPrefixes();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public ElementField getStartField() {
        return this.startField;
    }

    public URL[] getSourceURLs() {
        return this.sourceURLs;
    }

    public PrefixEntry[] getPreferredPrefixes() {
        return this.preferredPrefixes;
    }

    public boolean isDTD() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Diagnostic[] checkDocument(Document document) {
        block6: {
            this.errors.clear();
            try {
                try {
                    this.traversal.traverse(document);
                }
                catch (SAXTraversalException sAXTraversalException) {
                    Element element = this.traversal.getElementAt(sAXTraversalException.getLineNumber());
                    if (element != null) {
                        this.errors.add(new DiagnosticImpl(element, sAXTraversalException.getMessage(), 2));
                    }
                    Object var5_3 = null;
                    this.validator.reset();
                    break block6;
                }
                catch (SAXException sAXException) {
                    Object var5_4 = null;
                    this.validator.reset();
                    break block6;
                }
                Object var5_2 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.validator.reset();
                throw throwable;
            }
            this.validator.reset();
        }
        Diagnostic[] diagnosticArray = new Diagnostic[this.errors.size()];
        this.errors.toArray(diagnosticArray);
        return diagnosticArray;
    }

    public ElementType getElementType(Element element) {
        this.ancestorList.clear();
        Element element2 = element;
        while (element2 != null) {
            this.ancestorList.add(element2);
            element2 = element2.getParentElement();
        }
        int n = this.ancestorList.size() - 1;
        element2 = (Element)this.ancestorList.get(n);
        this.nodes1[0] = element2;
        if (!this.startField.getStructure(NO_ATTRIBUTES, 0, this.nodes1, 1, false, this.structure)) {
            return null;
        }
        ElementField elementField = (ElementField)this.structure.childNodeItems[0];
        int n2 = n;
        while (n2 >= 1) {
            if (!elementField.getStructure(element2, true, this.structure)) {
                return null;
            }
            Element element3 = (Element)this.ancestorList.get(n2 - 1);
            elementField = (ElementField)this.structure.childNodeItems[element2.indexOfChild(element3)];
            element2 = element3;
            --n2;
        }
        return elementField;
    }

    public String getElementAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        Data data;
        ElementType elementType;
        String string = element.getAttribute(name, attributeDefaultValue);
        if (string == null && (elementType = this.getElementType(element)) != null && (data = elementType.getAttributeDefaultValue(name)) != null) {
            string = data.formatData(element);
        }
        return string;
    }

    public String lookupElementAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        String string;
        String string2 = element.getAttribute(name, attributeDefaultValue);
        if (string2 != null) {
            return string2;
        }
        this.ancestorList.clear();
        Element element2 = element;
        while (element2 != null) {
            this.ancestorList.add(element2);
            element2 = element2.getParentElement();
        }
        int n = this.ancestorList.size() - 1;
        element2 = (Element)this.ancestorList.get(n);
        this.nodes1[0] = element2;
        ElementField elementField = this.startField.getStructure(NO_ATTRIBUTES, 0, this.nodes1, 1, false, this.structure) ? (ElementField)this.structure.childNodeItems[0] : null;
        int n2 = n;
        while (n2 >= 1) {
            string = DocumentTypeImpl.getAttributeDefaulted(element2, name, attributeDefaultValue, elementField);
            if (string != null) {
                string2 = string;
            }
            Element element3 = (Element)this.ancestorList.get(n2 - 1);
            if (elementField != null) {
                elementField = elementField.getStructure(element2, true, this.structure) ? (ElementField)this.structure.childNodeItems[element2.indexOfChild(element3)] : null;
            }
            element2 = element3;
            --n2;
        }
        string = DocumentTypeImpl.getAttributeDefaulted(element2, name, attributeDefaultValue, elementField);
        if (string != null) {
            string2 = string;
        }
        return string2;
    }

    private static final String getAttributeDefaulted(Element element, Name name, AttributeDefaultValue attributeDefaultValue, ElementType elementType) {
        Data data;
        String string = element.getAttribute(name, attributeDefaultValue);
        if (string == null && elementType != null && (data = elementType.getAttributeDefaultValue(name)) != null) {
            string = data.formatData(element);
        }
        return string;
    }

    public Element findElementById(Element element, String string, boolean bl) {
        return new IdFinder().find(element, string);
    }

    public void collectIds(Element element, Map map) {
        if (!map.isEmpty()) {
            map.clear();
        }
        new IdCollector().collect(element, map, null);
    }

    public void collectIdRefs(Element element, List list) {
        if (!list.isEmpty()) {
            list.clear();
        }
        new IdCollector().collect(element, null, list);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.addError(sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.addError(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.addError(sAXParseException);
        throw sAXParseException;
    }

    private void addError(SAXParseException sAXParseException) {
        Element element = this.traversal.getElementAt(sAXParseException.getLineNumber());
        if (element != null) {
            String string = sAXParseException.getMessage();
            int n = DocumentTypeImpl.findSeverity(string);
            this.errors.add(new DiagnosticImpl(element, string, n));
        }
    }

    private static int findSeverity(String string) {
        Object object;
        if (!initialized) {
            initialized = true;
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle("com.thaiopensource.relaxng.impl.resources.Messages");
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (resourceBundle != null) {
                Object object2;
                String[] stringArray;
                object = new HashMap();
                int n = 0;
                while (n < entries.length) {
                    Entry entry = entries[n];
                    ((HashMap)object).put(entry.id, entry);
                    ++n;
                }
                char c = '\ueeee';
                Character c2 = new Character(c);
                Object[] objectArray = new Object[]{c2, c2, c2, c2, c2, c2, c2, c2, c2, c2};
                ArrayList<String> arrayList = new ArrayList<String>();
                Enumeration<String> enumeration = resourceBundle.getKeys();
                while (enumeration.hasMoreElements()) {
                    stringArray = enumeration.nextElement();
                    String string2 = resourceBundle.getString((String)stringArray);
                    object2 = MessageFormat.format(string2, objectArray);
                    if (((String)object2).length() == 0) {
                        object2 = null;
                    }
                    if (object2 == null) continue;
                    object2 = ((String)object2).intern();
                    arrayList.add((String)object2);
                    Entry entry = (Entry)((HashMap)object).get(stringArray);
                    if (entry == null) continue;
                    entry.format = object2;
                }
                object = null;
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                arrayList = null;
                int n2 = 0;
                while (n2 < entries.length) {
                    object2 = entries[n2];
                    if (((Entry)object2).format != null) {
                        int n3;
                        int n4 = ((Entry)object2).format.length();
                        int n5 = 1;
                        while (n5 <= n4) {
                            String string3 = ((Entry)object2).format.substring(0, n5);
                            if (string3.indexOf(c) >= 0) break;
                            boolean bl = false;
                            n3 = 0;
                            while (n3 < stringArray.length) {
                                String string4 = stringArray[n3];
                                if (string4 != ((Entry)object2).format && string4.startsWith(string3)) {
                                    bl = true;
                                    break;
                                }
                                ++n3;
                            }
                            if (!bl) {
                                ((Entry)object2).prefix = string3;
                                break;
                            }
                            ++n5;
                        }
                        if (((Entry)object2).prefix == null) {
                            int n6 = n4 - 1;
                            while (n6 >= 0) {
                                String string5 = ((Entry)object2).format.substring(n6);
                                if (string5.indexOf(c) >= 0) break;
                                n3 = 0;
                                int n7 = 0;
                                while (n7 < stringArray.length) {
                                    String string6 = stringArray[n7];
                                    if (string6 != ((Entry)object2).format && string6.endsWith(string5)) {
                                        n3 = 1;
                                        break;
                                    }
                                    ++n7;
                                }
                                if (n3 == 0) {
                                    ((Entry)object2).suffix = string5;
                                    break;
                                }
                                --n6;
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
        int n = 0;
        while (n < entries.length) {
            object = entries[n];
            if (((Entry)object).prefix != null && string.startsWith(((Entry)object).prefix) || ((Entry)object).suffix != null && string.endsWith(((Entry)object).suffix)) {
                return ((Entry)object).severity;
            }
            ++n;
        }
        return 5;
    }

    private static final class Entry {
        public String id;
        public int severity;
        public String format;
        public String prefix;
        public String suffix;

        public Entry(String string, int n) {
            this.id = string;
            this.severity = n;
        }
    }
}

