/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.rng.doctype;

import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentationGeneratorBase;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.rng.doctype.AnyDataPattern;
import com.xmlmind.xmledit.rng.doctype.AttributeField;
import com.xmlmind.xmledit.rng.doctype.ChoicePattern;
import com.xmlmind.xmledit.rng.doctype.DocGenUtil;
import com.xmlmind.xmledit.rng.doctype.DocumentTypeImpl;
import com.xmlmind.xmledit.rng.doctype.DocumentTypeLoaderImpl;
import com.xmlmind.xmledit.rng.doctype.ElementField;
import com.xmlmind.xmledit.rng.doctype.EmptyPattern;
import com.xmlmind.xmledit.rng.doctype.FieldBase;
import com.xmlmind.xmledit.rng.doctype.GroupPattern;
import com.xmlmind.xmledit.rng.doctype.InterleavePattern;
import com.xmlmind.xmledit.rng.doctype.Msg;
import com.xmlmind.xmledit.rng.doctype.NotAllowedPattern;
import com.xmlmind.xmledit.rng.doctype.Occurrence;
import com.xmlmind.xmledit.rng.doctype.Pattern;
import com.xmlmind.xmledit.rng.doctype.TextPattern;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;

public final class DocumentationGenerator
extends DocumentationGeneratorBase {
    private static final FieldInfoComparator compareFieldInfo = new FieldInfoComparator();
    private DocumentTypeImpl docType;
    private boolean annotate = false;
    private Namespace[] targetNamespaces;
    private IdentityHashMap elementFieldToInfo;
    private HashMap pageNameToElementField;

    public DocumentationGenerator(DocumentTypeImpl documentTypeImpl) {
        ElementFieldInfo[] elementFieldInfoArray;
        Object object;
        Object object2;
        Iterator iterator;
        Object object3;
        this.docType = documentTypeImpl;
        ElementField elementField = documentTypeImpl.getStartField();
        ElementField[] elementFieldArray = elementField.childElementFields;
        ArrayList<Namespace> arrayList = new ArrayList<Namespace>();
        int n = 0;
        while (n < elementFieldArray.length) {
            ElementField elementField2 = elementFieldArray[n];
            object3 = elementField2.getFieldName();
            if (object3 != null && !arrayList.contains(iterator = ((Name)object3).getNamespace())) {
                arrayList.add((Namespace)((Object)iterator));
            }
            ++n;
        }
        this.targetNamespaces = new Namespace[arrayList.size()];
        arrayList.toArray(this.targetNamespaces);
        this.elementFieldToInfo = new IdentityHashMap();
        this.collectInfo(elementField);
        int n2 = 0;
        while (n2 < elementFieldArray.length) {
            object3 = elementFieldArray[n2];
            iterator = (ElementFieldInfo)this.elementFieldToInfo.get(object3);
            ((ElementFieldInfo)((Object)iterator)).markAsStart(elementField);
            ++n2;
        }
        object3 = new HashMap();
        iterator = this.elementFieldToInfo.values().iterator();
        while (iterator.hasNext()) {
            object2 = (ElementFieldInfo)iterator.next();
            String string = ((ElementFieldInfo)object2).field.getFieldLabel(false, this);
            object = (ElementFieldInfo[])((HashMap)object3).get(string);
            if (object == null) {
                object = new ElementFieldInfo[]{object2};
            } else {
                elementFieldInfoArray = new ElementFieldInfo[((ElementFieldInfo[])object).length + 1];
                System.arraycopy(object, 0, elementFieldInfoArray, 0, ((Object)object).length);
                elementFieldInfoArray[((Object)object).length] = object2;
                object = elementFieldInfoArray;
            }
            ((HashMap)object3).put(string, object);
        }
        object2 = new Comparator(){

            public int compare(Object object, Object object2) {
                ElementFieldInfo elementFieldInfo = (ElementFieldInfo)object;
                ElementFieldInfo elementFieldInfo2 = (ElementFieldInfo)object2;
                return elementFieldInfo2.parents.length - elementFieldInfo.parents.length;
            }
        };
        int n3 = 0;
        iterator = ((HashMap)object3).entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            elementFieldInfoArray = (ElementFieldInfo[])object.getKey();
            ElementFieldInfo[] elementFieldInfoArray2 = (ElementFieldInfo[])object.getValue();
            if (elementFieldInfoArray2.length > 1) {
                Arrays.sort(elementFieldInfoArray2, object2);
            }
            int n4 = 0;
            while (n4 < elementFieldInfoArray2.length) {
                StringBuffer stringBuffer;
                ElementFieldInfo elementFieldInfo = elementFieldInfoArray2[n4];
                if (n4 == 0) {
                    elementFieldInfo.label = elementFieldInfoArray;
                } else {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append((String)elementFieldInfoArray);
                    stringBuffer.append('#');
                    stringBuffer.append(Integer.toString(1 + n4));
                    elementFieldInfo.label = stringBuffer.toString();
                }
                stringBuffer = new StringBuffer();
                if (elementFieldInfo.field.getFieldNameClass() != null) {
                    stringBuffer.append("__wc__");
                } else {
                    String string = elementFieldInfo.label;
                    int n5 = string.length();
                    int n6 = 0;
                    while (n6 < n5) {
                        char c = string.charAt(n6);
                        if (Character.isLetterOrDigit(c)) {
                            stringBuffer.append(c);
                        } else {
                            stringBuffer.append('_');
                        }
                        ++n6;
                    }
                }
                stringBuffer.append('_');
                stringBuffer.append(Integer.toString(n3, 36));
                ++n3;
                stringBuffer.append(".html");
                elementFieldInfo.pageName = stringBuffer.toString();
                ++n4;
            }
        }
        this.pageNameToElementField = new HashMap();
        iterator = this.elementFieldToInfo.values().iterator();
        while (iterator.hasNext()) {
            object = (ElementFieldInfo)((Object)iterator.next());
            this.pageNameToElementField.put(((ElementFieldInfo)object).pageName, ((ElementFieldInfo)object).field);
        }
    }

    private void collectInfo(ElementField elementField) {
        ElementField[] elementFieldArray = elementField.childElementFields;
        int n = 0;
        while (n < elementFieldArray.length) {
            ElementField elementField2 = elementFieldArray[n];
            ElementFieldInfo elementFieldInfo = (ElementFieldInfo)this.elementFieldToInfo.get(elementField2);
            if (elementFieldInfo == null) {
                elementFieldInfo = new ElementFieldInfo(elementField2, elementField);
                this.elementFieldToInfo.put(elementField2, elementFieldInfo);
                this.collectInfo(elementField2);
            } else {
                elementFieldInfo.addParent(elementField);
            }
            ++n;
        }
    }

    public DocumentType getDocumentType() {
        return this.docType;
    }

    public void setAnnotated(boolean bl) {
        this.annotate = bl;
    }

    public boolean isAnnotated() {
        return this.annotate;
    }

    protected Namespace[] getTargetNamespaces() {
        return this.targetNamespaces;
    }

    public void generateAll(File file) throws IOException {
        DocumentationGeneratorBase.PageInfo pageInfo = new DocumentationGeneratorBase.PageInfo();
        Iterator iterator = this.elementFieldToInfo.values().iterator();
        while (iterator.hasNext()) {
            ElementFieldInfo elementFieldInfo = (ElementFieldInfo)iterator.next();
            this.generateElementPage(elementFieldInfo, pageInfo);
            FileUtil.saveString(pageInfo.html, new File(file, pageInfo.name), this.charset);
        }
        this.generateIndexPage(pageInfo);
        FileUtil.saveString(pageInfo.html, new File(file, pageInfo.name), this.charset);
        this.generateNamespacesPage(pageInfo);
        FileUtil.saveString(pageInfo.html, new File(file, pageInfo.name), this.charset);
    }

    public void generateIndexPage(DocumentationGeneratorBase.PageInfo pageInfo) {
        ElementFieldInfo[] elementFieldInfoArray = new ElementFieldInfo[this.elementFieldToInfo.size()];
        this.elementFieldToInfo.values().toArray(elementFieldInfoArray);
        Arrays.sort(elementFieldInfoArray, compareFieldInfo);
        StringBuffer stringBuffer = new StringBuffer();
        this.appendPageStart(stringBuffer);
        stringBuffer.append("<title>");
        String string = DocumentationGeneratorBase.indexPageTitle;
        XMLUtil.escapeXML(string, stringBuffer);
        stringBuffer.append("</title>\n");
        this.appendPageMiddle(false, true, stringBuffer);
        stringBuffer.append("<h1>");
        XMLUtil.escapeXML(string, stringBuffer);
        stringBuffer.append("</h1>\n");
        boolean bl = true;
        Namespace namespace = Namespace.XML;
        String string2 = "\u0000";
        int n = 0;
        while (n < elementFieldInfoArray.length) {
            ElementFieldInfo elementFieldInfo = elementFieldInfoArray[n];
            Name name = elementFieldInfo.field.getFieldName();
            if (name == null) {
                if (!bl) {
                    stringBuffer.append("<h2>");
                    XMLUtil.escapeXML(Msg.msg("DG.wildcardsHead"), stringBuffer);
                    stringBuffer.append("</h2>\n");
                }
            } else {
                Namespace namespace2 = name.getNamespace();
                if (namespace2 != namespace) {
                    stringBuffer.append("<h2>");
                    if (namespace2 == Namespace.NONE) {
                        XMLUtil.escapeXML(Msg.msg("DG.noNamespaceHead"), stringBuffer);
                    } else {
                        XMLUtil.escapeXML(Msg.msg("DG.namespaceHead", namespace2), stringBuffer);
                    }
                    stringBuffer.append("</h2>\n");
                }
                char c = Character.toUpperCase(name.getLocalPart().charAt(0));
                char c2 = Character.toUpperCase(string2.charAt(0));
                if (!Character.isLetter(c)) {
                    c = '_';
                }
                if (c != c2) {
                    stringBuffer.append("<h3>");
                    if (Character.isLetter(c)) {
                        XMLUtil.escapeXML(Character.toString(c), stringBuffer);
                    } else {
                        stringBuffer.append("&#160;");
                    }
                    stringBuffer.append("</h3>\n");
                }
            }
            DocumentationGenerator.appendLink(elementFieldInfo, stringBuffer);
            if (elementFieldInfo.isStart) {
                stringBuffer.append("&#160;&#160;&#160;&#160;<small");
                if (this.css != null) {
                    stringBuffer.append(" class=\"startElement\"");
                } else {
                    stringBuffer.append(" style=\"background-color: #98FB98;\"");
                }
                stringBuffer.append(">(");
                XMLUtil.escapeXML(Msg.msg("DG.startAnnotation"), stringBuffer);
                stringBuffer.append(")</small>");
            }
            stringBuffer.append("<br>\n");
            bl = name == null;
            namespace = name == null ? Namespace.XML : name.getNamespace();
            string2 = name == null ? "\u0000" : name.getLocalPart();
            ++n;
        }
        this.appendPageEnd(false, true, stringBuffer);
        pageInfo.html = stringBuffer.toString();
        pageInfo.name = "index.html";
        pageInfo.title = string;
    }

    private static final void appendLink(ElementFieldInfo elementFieldInfo, StringBuffer stringBuffer) {
        stringBuffer.append("<a href='");
        XMLUtil.escapeXML(elementFieldInfo.pageName, stringBuffer);
        stringBuffer.append("'>");
        XMLUtil.escapeXML(elementFieldInfo.label, stringBuffer);
        stringBuffer.append("</a>");
    }

    public void generateNamespacesPage(DocumentationGeneratorBase.PageInfo pageInfo) {
        this.generateNamespacesPage(null, pageInfo);
    }

    public ElementType getElementType(String string) {
        return (ElementType)this.pageNameToElementField.get(string);
    }

    public boolean generateElementPage(ElementType elementType, DocumentationGeneratorBase.PageInfo pageInfo) {
        ElementFieldInfo elementFieldInfo = (ElementFieldInfo)this.elementFieldToInfo.get(elementType);
        if (elementFieldInfo == null) {
            return false;
        }
        this.generateElementPage(elementFieldInfo, pageInfo);
        return true;
    }

    private void generateElementPage(ElementFieldInfo elementFieldInfo, DocumentationGeneratorBase.PageInfo pageInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendPageStart(stringBuffer);
        stringBuffer.append("<title>");
        String string = Msg.msg("DG.elementPageTitle", elementFieldInfo.label);
        XMLUtil.escapeXML(string, stringBuffer);
        stringBuffer.append("</title>\n");
        this.appendPageMiddle(true, true, stringBuffer);
        stringBuffer.append("<h1>");
        XMLUtil.escapeXML(string, stringBuffer);
        stringBuffer.append("</h1>\n");
        ElementField elementField = (ElementField)elementFieldInfo.field;
        AttributeField[] attributeFieldArray = elementField.attributeFields;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        IdentityHashMap<AttributeField, AttributeFieldInfo> identityHashMap = new IdentityHashMap<AttributeField, AttributeFieldInfo>();
        int n = 0;
        while (n < attributeFieldArray.length) {
            AttributeField attributeField = attributeFieldArray[n];
            String string2 = attributeField.getFieldLabel(true, this);
            Integer n2 = (Integer)hashMap.get(string2);
            n2 = n2 == null ? new Integer(0) : new Integer(n2 + 1);
            hashMap.put(string2, n2);
            if (n2 > 0) {
                string2 = string2 + "#" + Integer.toString(1 + n2);
            }
            String string3 = "__a__" + Integer.toString(System.identityHashCode(attributeField), 36);
            identityHashMap.put(attributeField, new AttributeFieldInfo(attributeField, string2, string3));
            ++n;
        }
        this.appendContentModelSection(elementField, identityHashMap, stringBuffer);
        this.appendAttributesSection(elementField, identityHashMap, stringBuffer);
        this.appendParentsSection(elementFieldInfo, stringBuffer);
        this.appendChildrenSection(elementFieldInfo, stringBuffer);
        this.appendPageEnd(true, true, stringBuffer);
        pageInfo.html = stringBuffer.toString();
        pageInfo.name = elementFieldInfo.pageName;
        pageInfo.title = string;
    }

    private void appendChildrenSection(ElementFieldInfo elementFieldInfo, StringBuffer stringBuffer) {
        ElementField elementField = (ElementField)elementFieldInfo.field;
        ElementField[] elementFieldArray = elementField.childElementFields;
        if (elementFieldArray.length == 0) {
            return;
        }
        stringBuffer.append("<h2>");
        XMLUtil.escapeXML(Msg.msg("DG.childrenHead"), stringBuffer);
        stringBuffer.append("</h2>\n");
        stringBuffer.append("<p>");
        XMLUtil.escapeXML(Msg.msg("DG.childrenBlurb", elementFieldInfo.label), stringBuffer);
        stringBuffer.append(": ");
        ElementFieldInfo[] elementFieldInfoArray = this.sortElementFieldInfo(elementFieldArray);
        int n = 0;
        while (n < elementFieldInfoArray.length) {
            if (n > 0) {
                stringBuffer.append(",\n");
            }
            DocumentationGenerator.appendLink(elementFieldInfoArray[n], stringBuffer);
            ++n;
        }
        stringBuffer.append(".</p>\n");
    }

    private ElementFieldInfo[] sortElementFieldInfo(ElementField[] elementFieldArray) {
        ElementFieldInfo[] elementFieldInfoArray = new ElementFieldInfo[elementFieldArray.length];
        int n = 0;
        while (n < elementFieldArray.length) {
            elementFieldInfoArray[n] = (ElementFieldInfo)this.elementFieldToInfo.get(elementFieldArray[n]);
            ++n;
        }
        if (elementFieldInfoArray.length > 1) {
            Arrays.sort(elementFieldInfoArray, compareFieldInfo);
        }
        return elementFieldInfoArray;
    }

    private void appendParentsSection(ElementFieldInfo elementFieldInfo, StringBuffer stringBuffer) {
        ElementField[] elementFieldArray = elementFieldInfo.parents;
        if (elementFieldArray.length == 0) {
            return;
        }
        stringBuffer.append("<h2>");
        XMLUtil.escapeXML(Msg.msg("DG.parentsHead"), stringBuffer);
        stringBuffer.append("</h2>\n");
        stringBuffer.append("<p>");
        XMLUtil.escapeXML(Msg.msg("DG.parentsBlurb", elementFieldInfo.label), stringBuffer);
        stringBuffer.append(": ");
        ElementFieldInfo[] elementFieldInfoArray = this.sortElementFieldInfo(elementFieldArray);
        int n = 0;
        while (n < elementFieldInfoArray.length) {
            if (n > 0) {
                stringBuffer.append(",\n");
            }
            DocumentationGenerator.appendLink(elementFieldInfoArray[n], stringBuffer);
            ++n;
        }
        stringBuffer.append(".</p>\n");
    }

    private void appendAttributesSection(ElementField elementField, IdentityHashMap identityHashMap, StringBuffer stringBuffer) {
        if (identityHashMap.size() == 0) {
            return;
        }
        stringBuffer.append("<h2>");
        XMLUtil.escapeXML(Msg.msg("DG.attributesHead"), stringBuffer);
        stringBuffer.append("</h2>\n");
        stringBuffer.append("<table border='1'>\n");
        stringBuffer.append("<tr align='center'>\n");
        stringBuffer.append("<th>");
        XMLUtil.escapeXML(Msg.msg("DG.attributeName"), stringBuffer);
        stringBuffer.append("</th>\n");
        stringBuffer.append("<th>");
        XMLUtil.escapeXML(Msg.msg("DG.attributeDataType"), stringBuffer);
        stringBuffer.append("</th>\n");
        stringBuffer.append("<th>");
        XMLUtil.escapeXML(Msg.msg("DG.attributeValue"), stringBuffer);
        stringBuffer.append("</th>\n");
        stringBuffer.append("</tr>\n");
        AttributeFieldInfo[] attributeFieldInfoArray = new AttributeFieldInfo[identityHashMap.size()];
        identityHashMap.values().toArray(attributeFieldInfoArray);
        if (attributeFieldInfoArray.length > 1) {
            Arrays.sort(attributeFieldInfoArray, compareFieldInfo);
        }
        int n = 0;
        while (n < attributeFieldInfoArray.length) {
            AttributeFieldInfo attributeFieldInfo = attributeFieldInfoArray[n];
            AttributeField attributeField = (AttributeField)attributeFieldInfo.field;
            com.xmlmind.xmledit.doctype.DataType dataType = attributeField.getAttributeDataType();
            Data data = attributeField.getAttributeFixedValue();
            Data data2 = attributeField.getAttributeDefaultValue();
            boolean bl = elementField.isRequiredAttribute(attributeField);
            stringBuffer.append("<tr valign='top'>\n");
            stringBuffer.append("<td>");
            if (bl) {
                if (data != null) {
                    stringBuffer.append("<b><i>");
                } else {
                    stringBuffer.append("<b>");
                }
            } else if (data != null) {
                stringBuffer.append("<i>");
            }
            stringBuffer.append("<a name='");
            XMLUtil.escapeXML(attributeFieldInfo.id, stringBuffer);
            stringBuffer.append("' id='");
            XMLUtil.escapeXML(attributeFieldInfo.id, stringBuffer);
            stringBuffer.append("'>");
            this.appendFieldLabel(attributeFieldInfo, elementField, stringBuffer);
            stringBuffer.append("</a>");
            if (bl) {
                if (data != null) {
                    stringBuffer.append("</i></b>");
                } else {
                    stringBuffer.append("</b>");
                }
            } else if (data != null) {
                stringBuffer.append("</i>");
            }
            stringBuffer.append("</td>\n");
            stringBuffer.append("<td>");
            this.appendDataType(dataType, stringBuffer);
            stringBuffer.append("</td>\n");
            stringBuffer.append("<td>");
            this.appendValue(data == null ? data2 : data, data != null, data2 != null, bl, stringBuffer);
            stringBuffer.append("</td>\n");
            stringBuffer.append("</tr>\n");
            ++n;
        }
        stringBuffer.append("</table>\n");
    }

    private void appendDataType(com.xmlmind.xmledit.doctype.DataType dataType, StringBuffer stringBuffer) {
        if (dataType instanceof DataType) {
            DocGenUtil.appendDataType((DataType)dataType, this, stringBuffer);
        } else {
            String string = dataType.getDataTypeLabel(this);
            XMLUtil.escapeXML(string, stringBuffer);
        }
    }

    private void appendValue(Data data, boolean bl, boolean bl2, boolean bl3, StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (bl3) {
            XMLUtil.escapeXML(Msg.msg("DG.requiredValue"), stringBuffer);
        }
        if (bl) {
            if (stringBuffer.length() > n) {
                stringBuffer.append(' ');
            }
            XMLUtil.escapeXML(Msg.msg("DG.fixedValue"), stringBuffer);
        }
        if (bl2) {
            if (stringBuffer.length() > n) {
                stringBuffer.append(' ');
            }
            XMLUtil.escapeXML(Msg.msg("DG.defaultValue"), stringBuffer);
        }
        if (data != null) {
            if (stringBuffer.length() > n) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('\"');
            DocGenUtil.appendLongLine(data.formatData(this), stringBuffer);
            stringBuffer.append('\"');
        } else {
            stringBuffer.append("&#160;");
        }
    }

    private void appendFieldLabel(FieldInfo fieldInfo, ElementField elementField, StringBuffer stringBuffer) {
        if (!this.annotate) {
            XMLUtil.escapeXML(fieldInfo.label, stringBuffer);
            return;
        }
        int n = elementField.isAmbiguousField(fieldInfo.field);
        switch (n) {
            case 1: 
            case 2: {
                stringBuffer.append("<span");
                this.appendAmbiguousAttribute(n == 1, stringBuffer);
                stringBuffer.append('>');
            }
        }
        XMLUtil.escapeXML(fieldInfo.label, stringBuffer);
        switch (n) {
            case 1: 
            case 2: {
                stringBuffer.append("</span>");
            }
        }
    }

    private void appendAmbiguousAttribute(boolean bl, StringBuffer stringBuffer) {
        if (this.css != null) {
            stringBuffer.append(" class=\"");
            stringBuffer.append(bl ? "mayBeAmbiguousField" : "ambiguousField");
            stringBuffer.append("\"");
        } else {
            stringBuffer.append(" style=\"background-color: ");
            stringBuffer.append(bl ? "#FFFF00" : "#FFA500");
            stringBuffer.append(";\"");
        }
    }

    private void appendContentModelSection(ElementField elementField, IdentityHashMap identityHashMap, StringBuffer stringBuffer) {
        stringBuffer.append("<h2>");
        XMLUtil.escapeXML(Msg.msg("DG.contentModelHead"), stringBuffer);
        stringBuffer.append("</h2>\n");
        int n = elementField.getElementContentType();
        if (n != 5) {
            stringBuffer.append("<p><small>");
            switch (n) {
                case 0: {
                    XMLUtil.escapeXML(Msg.msg("DG.emptyContentBlurb"), stringBuffer);
                    break;
                }
                case 1: {
                    XMLUtil.escapeXML(Msg.msg("DG.dataContentBlurb"), stringBuffer);
                    break;
                }
                case 2: {
                    XMLUtil.escapeXML(Msg.msg("DG.elementOnlyContentBlurb"), stringBuffer);
                    break;
                }
                case 3: {
                    XMLUtil.escapeXML(Msg.msg("DG.mixed1ContentBlurb"), stringBuffer);
                    break;
                }
                case 4: {
                    XMLUtil.escapeXML(Msg.msg("DG.mixed2ContentBlurb"), stringBuffer);
                }
            }
            stringBuffer.append("</small></p>\n");
        }
        Particle particle = this.translatePattern(elementField.pattern);
        stringBuffer.append("<pre>");
        particle.append(0, identityHashMap, elementField, stringBuffer);
        stringBuffer.append("</pre>\n");
        if (this.annotate && elementField.hasAmbiguousFields()) {
            stringBuffer.append("<p>&#160;</p>\n<hr align='left' width='10%'>\n");
            stringBuffer.append("<table border='0' width='80%'>\n");
            stringBuffer.append("<tr>\n");
            stringBuffer.append("<th valign='top'><small");
            this.appendAmbiguousAttribute(true, stringBuffer);
            stringBuffer.append(">&#160;&#160;&#160;&#160;</small></th>\n");
            stringBuffer.append("<td><small>\n");
            XMLUtil.escapeXML(Msg.msg("DG.mayBeAmbiguousBlurb"), stringBuffer);
            stringBuffer.append("</small></td>\n");
            stringBuffer.append("</tr>\n");
            stringBuffer.append("<tr>\n");
            stringBuffer.append("<th valign='top'><small");
            this.appendAmbiguousAttribute(false, stringBuffer);
            stringBuffer.append(">&#160;&#160;&#160;&#160;</small></th>\n");
            stringBuffer.append("<td><small>\n");
            XMLUtil.escapeXML(Msg.msg("DG.ambiguousBlurb"), stringBuffer);
            stringBuffer.append("</small></td>\n");
            stringBuffer.append("</tr>\n");
            stringBuffer.append("</table>\n");
        }
    }

    private Particle translatePattern(Pattern pattern) {
        Particle particle;
        Occurrence occurrence = Occurrence.which(pattern);
        int n = occurrence.occurrence;
        pattern = occurrence.pattern;
        if (pattern instanceof GroupPattern) {
            GroupPattern groupPattern = (GroupPattern)pattern;
            Particle particle2 = this.translatePattern(groupPattern.pattern1);
            Particle particle3 = this.translatePattern(groupPattern.pattern2);
            particle = new GroupParticle(particle2, particle3);
        } else if (pattern instanceof ChoicePattern) {
            ChoicePattern choicePattern = (ChoicePattern)pattern;
            Particle particle4 = this.translatePattern(choicePattern.pattern1);
            Particle particle5 = this.translatePattern(choicePattern.pattern2);
            particle = new ChoiceParticle(particle4, particle5);
        } else if (pattern instanceof InterleavePattern) {
            InterleavePattern interleavePattern = (InterleavePattern)pattern;
            Particle particle6 = this.translatePattern(interleavePattern.pattern1);
            Particle particle7 = this.translatePattern(interleavePattern.pattern2);
            particle = new InterleaveParticle(particle6, particle7);
        } else if (pattern instanceof ElementField) {
            particle = new ElementParticle((ElementField)pattern);
        } else if (pattern instanceof AttributeField) {
            particle = new AttributeParticle((AttributeField)pattern);
        } else if (pattern instanceof AnyDataPattern) {
            particle = new AnyDataParticle((AnyDataPattern)pattern);
        } else if (pattern == TextPattern.INSTANCE) {
            particle = new TextParticle();
        } else if (pattern == EmptyPattern.INSTANCE) {
            particle = new EmptyParticle();
        } else if (pattern == NotAllowedPattern.INSTANCE) {
            particle = new NotAllowedParticle();
        } else {
            throw new RuntimeException("unexpected pattern " + pattern.getClass().getName());
        }
        particle.occurrence = n;
        return particle;
    }

    public static void main(String[] stringArray) {
        Object object;
        URL uRL = null;
        String string = null;
        String string2 = null;
        File file = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            if ("-rnc".equals(object)) {
                string = "application/x-rnc";
            } else if ("-rncencoding".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    bl2 = true;
                    break;
                }
                string2 = stringArray[++n];
            } else if ("-css".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    bl2 = true;
                    break;
                }
                string3 = stringArray[++n];
            } else if ("-charset".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    bl2 = true;
                    break;
                }
                string4 = stringArray[++n];
            } else if ("-xxe".equals(object)) {
                bl = true;
            } else {
                if (!((String)object).startsWith("-")) break;
                bl2 = true;
                break;
            }
            ++n;
        }
        if (!bl2) {
            if (n + 2 == stringArray.length) {
                try {
                    uRL = new URL(stringArray[n]);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (uRL == null && ((File)(object = new File(stringArray[n]))).isFile()) {
                    uRL = FileUtil.fileToURL((File)object);
                }
                if (!(file = new File(stringArray[n + 1])).isDirectory()) {
                    file = null;
                }
            }
            if (uRL == null || file == null) {
                bl2 = true;
            }
        }
        if (bl2) {
            System.err.println("usage: rngdoc [options] relax_ng_schema out_dir\nOptions:\n-rnc Specifies that relax_ng_schema uses\n    the compact syntax.\n    Default: XML syntax.\n-rncencoding rnc_charset Specifies the character encoding\n    of the schema using the compact syntax.\n    Default: platform default encoding.\n-css CSS_URL Specifies which CSS style sheet to use\n    in the generated HTML.\n    Default: no CSS.\n-charset html_charset Specifies the character encoding\n    of the generated HTML.\n    Default: platform default encoding.\n-xxe Add annotations which are useful when the RELAX NG\n    schema is used by XMLmind XML Editor.\n    Default: don't annotate.");
            System.exit(1);
        }
        object = new DocumentTypeLoaderImpl();
        DocumentTypeImpl documentTypeImpl = null;
        try {
            documentTypeImpl = (DocumentTypeImpl)((DocumentTypeLoaderImpl)object).loadDocumentType(uRL, string, string2);
        }
        catch (IOException iOException) {
            System.err.println("cannot load RELAX NG schema\n'" + uRL + "':\n" + MiscUtil.reason(iOException));
            System.exit(2);
        }
        if (documentTypeImpl == null) {
            System.err.println("RELAX NG schema\n'" + uRL + "'\nhas errors. Please check it using jing or rngvalid.");
            System.exit(3);
        }
        DocumentationGenerator documentationGenerator = new DocumentationGenerator(documentTypeImpl);
        documentationGenerator.setCSS(string3);
        documentationGenerator.setCharset(string4);
        documentationGenerator.setAnnotated(bl);
        try {
            documentationGenerator.generateAll(file);
        }
        catch (IOException iOException) {
            System.err.println("cannot generate documentation for RELAX NG schema\n'" + uRL + "':\n" + MiscUtil.reason(iOException));
            System.exit(4);
        }
    }

    private final class NotAllowedParticle
    extends Particle {
        private NotAllowedParticle() {
        }

        public void append(int n, IdentityHashMap identityHashMap, ElementField elementField, StringBuffer stringBuffer) {
            stringBuffer.append("<b>notAllowed</b>");
            stringBuffer.append(Occurrence.toString(this.occurrence));
        }
    }

    private final class EmptyParticle
    extends Particle {
        private EmptyParticle() {
        }

        public void append(int n, IdentityHashMap identityHashMap, ElementField elementField, StringBuffer stringBuffer) {
            stringBuffer.append("<b>empty</b>");
            stringBuffer.append(Occurrence.toString(this.occurrence));
        }
    }

    private final class TextParticle
    extends Particle {
        private TextParticle() {
        }

        public void append(int n, IdentityHashMap identityHashMap, ElementField elementField, StringBuffer stringBuffer) {
            stringBuffer.append("<b><i>text</i></b>");
            stringBuffer.append(Occurrence.toString(this.occurrence));
        }
    }

    private final class AnyDataParticle
    extends Particle {
        public AnyDataPattern pattern;

        public AnyDataParticle(AnyDataPattern anyDataPattern) {
            this.pattern = anyDataPattern;
        }

        public void append(int n, IdentityHashMap identityHashMap, ElementField elementField, StringBuffer stringBuffer) {
            boolean bl;
            String string;
            StringBuffer stringBuffer2 = new StringBuffer();
            if (elementField.dataType != null) {
                DocumentationGenerator.this.appendDataType(elementField.dataType, stringBuffer2);
                if (elementField.fixedValue != null) {
                    stringBuffer2.append(' ');
                    DocumentationGenerator.this.appendValue(elementField.fixedValue, true, false, false, stringBuffer2);
                }
                string = stringBuffer2.toString();
            } else {
                this.pattern.toString(-1, DocumentationGenerator.this, stringBuffer2);
                string = XMLUtil.escapeXML(stringBuffer2.toString());
            }
            string = StringUtil.replaceAll(string, "<br>", " ");
            string = XMLUtil.collapseWhiteSpace(string);
            stringBuffer.append("<b><i>");
            boolean bl2 = bl = !string.startsWith("(") && !string.endsWith(")");
            if (bl) {
                stringBuffer.append('(');
            }
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append(')');
            }
            stringBuffer.append("</i></b>");
            stringBuffer.append(Occurrence.toString(this.occurrence));
        }
    }

    private final class AttributeParticle
    extends Particle {
        public AttributeField field;

        public AttributeParticle(AttributeField attributeField) {
            this.field = attributeField;
        }

        public void append(int n, IdentityHashMap identityHashMap, ElementField elementField, StringBuffer stringBuffer) {
            AttributeFieldInfo attributeFieldInfo = (AttributeFieldInfo)identityHashMap.get(this.field);
            stringBuffer.append("@");
            stringBuffer.append("<a href='#");
            XMLUtil.escapeXML(attributeFieldInfo.id, stringBuffer);
            stringBuffer.append("'>");
            DocumentationGenerator.this.appendFieldLabel(attributeFieldInfo, elementField, stringBuffer);
            stringBuffer.append("</a>");
            stringBuffer.append(Occurrence.toString(this.occurrence));
        }
    }

    private final class ElementParticle
    extends Particle {
        public ElementField field;

        public ElementParticle(ElementField elementField) {
            this.field = elementField;
        }

        public void append(int n, IdentityHashMap identityHashMap, ElementField elementField, StringBuffer stringBuffer) {
            ElementFieldInfo elementFieldInfo = (ElementFieldInfo)DocumentationGenerator.this.elementFieldToInfo.get(this.field);
            stringBuffer.append("<a href='");
            XMLUtil.escapeXML(elementFieldInfo.pageName, stringBuffer);
            stringBuffer.append("'>");
            DocumentationGenerator.this.appendFieldLabel(elementFieldInfo, elementField, stringBuffer);
            stringBuffer.append("</a>");
            stringBuffer.append(Occurrence.toString(this.occurrence));
        }
    }

    private final class InterleaveParticle
    extends BinaryParticle {
        public InterleaveParticle(Particle particle, Particle particle2) {
            super('&', particle, particle2);
        }
    }

    private final class ChoiceParticle
    extends BinaryParticle {
        public ChoiceParticle(Particle particle, Particle particle2) {
            super('|', particle, particle2);
        }

        public void append(int n, IdentityHashMap identityHashMap, ElementField elementField, StringBuffer stringBuffer) {
            if (elementField.dataType != null) {
                boolean bl = true;
                int n2 = 0;
                while (n2 < this.particles.length) {
                    if (!(this.particles[n2] instanceof AnyDataParticle)) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    AnyDataParticle anyDataParticle = new AnyDataParticle(null);
                    anyDataParticle.occurrence = this.occurrence;
                    anyDataParticle.append(n, identityHashMap, elementField, stringBuffer);
                    return;
                }
            }
            super.append(n, identityHashMap, elementField, stringBuffer);
        }
    }

    private final class GroupParticle
    extends BinaryParticle {
        public GroupParticle(Particle particle, Particle particle2) {
            super(',', particle, particle2);
        }
    }

    private abstract class BinaryParticle
    extends Particle {
        public char op;
        public Particle[] particles;

        protected BinaryParticle(char c, Particle particle, Particle particle2) {
            BinaryParticle binaryParticle;
            this.op = c;
            boolean bl = particle.getClass() == this.getClass() && particle.occurrence == 0;
            boolean bl2 = particle2.getClass() == this.getClass() && particle2.occurrence == 0;
            this.particles = new Particle[(bl ? ((BinaryParticle)particle).particles.length : 1) + (bl2 ? ((BinaryParticle)particle2).particles.length : 1)];
            int n = 0;
            if (bl) {
                binaryParticle = (BinaryParticle)particle;
                System.arraycopy(binaryParticle.particles, 0, this.particles, n, binaryParticle.particles.length);
                n += binaryParticle.particles.length;
            } else {
                this.particles[n++] = particle;
            }
            if (bl2) {
                binaryParticle = (BinaryParticle)particle2;
                System.arraycopy(binaryParticle.particles, 0, this.particles, n, binaryParticle.particles.length);
                n += binaryParticle.particles.length;
            } else {
                this.particles[n++] = particle2;
            }
        }

        public void append(int n, IdentityHashMap identityHashMap, ElementField elementField, StringBuffer stringBuffer) {
            boolean bl = true;
            int n2 = 0;
            while (n2 < this.particles.length) {
                if (this.particles[n2] instanceof BinaryParticle) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            stringBuffer.append('(');
            int n3 = 0;
            while (n3 < this.particles.length) {
                if (n3 > 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(this.op);
                    stringBuffer.append(' ');
                    if (bl && n3 % 5 == 0 || !bl) {
                        stringBuffer.append('\n');
                        this.appendIndent(n + 1, stringBuffer);
                    }
                }
                this.particles[n3].append(n + 1, identityHashMap, elementField, stringBuffer);
                ++n3;
            }
            stringBuffer.append(')');
            stringBuffer.append(Occurrence.toString(this.occurrence));
        }

        protected void appendIndent(int n, StringBuffer stringBuffer) {
            while (n > 0) {
                stringBuffer.append(' ');
                --n;
            }
        }
    }

    private abstract class Particle {
        public int occurrence;

        private Particle() {
        }

        public abstract void append(int var1, IdentityHashMap var2, ElementField var3, StringBuffer var4);
    }

    private static final class FieldInfoComparator
    implements Comparator {
        private FieldInfoComparator() {
        }

        public int compare(Object object, Object object2) {
            FieldInfo fieldInfo = (FieldInfo)object;
            FieldInfo fieldInfo2 = (FieldInfo)object2;
            Name name = fieldInfo.field.getFieldName();
            Name name2 = fieldInfo2.field.getFieldName();
            if (name != null) {
                if (name2 != null) {
                    Namespace namespace;
                    Namespace namespace2 = name.getNamespace();
                    if (namespace2 == (namespace = name2.getNamespace())) {
                        String string;
                        String string2 = name.getLocalPart().toUpperCase();
                        int n = string2.compareTo(string = name2.getLocalPart().toUpperCase());
                        if (n == 0 && fieldInfo instanceof ElementFieldInfo && fieldInfo2 instanceof ElementFieldInfo) {
                            n = ((ElementFieldInfo)fieldInfo2).parents.length - ((ElementFieldInfo)fieldInfo).parents.length;
                        }
                        return n;
                    }
                    return namespace2.compareTo(namespace);
                }
                return Integer.MIN_VALUE;
            }
            if (name2 != null) {
                return Integer.MAX_VALUE;
            }
            return fieldInfo.label.compareTo(fieldInfo2.label);
        }
    }

    private static final class AttributeFieldInfo
    extends FieldInfo {
        public String id;

        public AttributeFieldInfo(AttributeField attributeField, String string, String string2) {
            super(attributeField, string);
            this.id = string2;
        }
    }

    private static final class ElementFieldInfo
    extends FieldInfo {
        public ElementField[] parents;
        public boolean isStart;
        public String pageName;

        public ElementFieldInfo(ElementField elementField, ElementField elementField2) {
            super(elementField, null);
            this.parents = new ElementField[]{elementField2};
        }

        public void addParent(ElementField elementField) {
            int n = this.parents.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.parents[n2] == elementField) {
                    return;
                }
                ++n2;
            }
            ElementField[] elementFieldArray = new ElementField[n + 1];
            System.arraycopy(this.parents, 0, elementFieldArray, 0, n);
            elementFieldArray[n] = elementField;
            this.parents = elementFieldArray;
        }

        public void markAsStart(ElementField elementField) {
            this.isStart = true;
            ElementField[] elementFieldArray = new ElementField[this.parents.length - 1];
            int n = 0;
            int n2 = 0;
            while (n2 < this.parents.length) {
                if (this.parents[n2] != elementField) {
                    elementFieldArray[n++] = this.parents[n2];
                }
                ++n2;
            }
            this.parents = elementFieldArray;
        }
    }

    private static class FieldInfo {
        public FieldBase field;
        public String label;

        protected FieldInfo(FieldBase fieldBase, String string) {
            this.field = fieldBase;
            this.label = string;
        }
    }
}

